<?php
/**
 * OrphanRecording
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * OrphanRecording Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OrphanRecording implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'OrphanRecording';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'created_time' => '\DateTime',
        'recovered_time' => '\DateTime',
        'provider_type' => 'string',
        'media_size_bytes' => 'int',
        'media_type' => 'string',
        'file_state' => 'string',
        'provider_endpoint' => '\PureCloudSDK\Endpoint',
        'recording' => '\PureCloudSDK\Recording',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'created_time' => 'createdTime',
        'recovered_time' => 'recoveredTime',
        'provider_type' => 'providerType',
        'media_size_bytes' => 'mediaSizeBytes',
        'media_type' => 'mediaType',
        'file_state' => 'fileState',
        'provider_endpoint' => 'providerEndpoint',
        'recording' => 'recording',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'created_time' => 'setCreatedTime',
        'recovered_time' => 'setRecoveredTime',
        'provider_type' => 'setProviderType',
        'media_size_bytes' => 'setMediaSizeBytes',
        'media_type' => 'setMediaType',
        'file_state' => 'setFileState',
        'provider_endpoint' => 'setProviderEndpoint',
        'recording' => 'setRecording',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'created_time' => 'getCreatedTime',
        'recovered_time' => 'getRecoveredTime',
        'provider_type' => 'getProviderType',
        'media_size_bytes' => 'getMediaSizeBytes',
        'media_type' => 'getMediaType',
        'file_state' => 'getFileState',
        'provider_endpoint' => 'getProviderEndpoint',
        'recording' => 'getRecording',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const PROVIDER_TYPE_EDGE = 'EDGE';
    const PROVIDER_TYPE_CHAT = 'CHAT';
    const PROVIDER_TYPE_EMAIL = 'EMAIL';
    const MEDIA_TYPE_CALL = 'CALL';
    const MEDIA_TYPE_CHAT = 'CHAT';
    const MEDIA_TYPE_EMAIL = 'EMAIL';
    const FILE_STATE_ARCHIVED = 'ARCHIVED';
    const FILE_STATE_AVAILABLE = 'AVAILABLE';
    const FILE_STATE_DELETED = 'DELETED';
    const FILE_STATE_RESTORED = 'RESTORED';
    const FILE_STATE_RESTORING = 'RESTORING';
    const FILE_STATE_UPLOADING = 'UPLOADING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getProviderTypeAllowableValues()
    {
        return [
            self::PROVIDER_TYPE_EDGE,
            self::PROVIDER_TYPE_CHAT,
            self::PROVIDER_TYPE_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_CALL,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFileStateAllowableValues()
    {
        return [
            self::FILE_STATE_ARCHIVED,
            self::FILE_STATE_AVAILABLE,
            self::FILE_STATE_DELETED,
            self::FILE_STATE_RESTORED,
            self::FILE_STATE_RESTORING,
            self::FILE_STATE_UPLOADING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['created_time'] = isset($data['created_time']) ? $data['created_time'] : null;
        $this->container['recovered_time'] = isset($data['recovered_time']) ? $data['recovered_time'] : null;
        $this->container['provider_type'] = isset($data['provider_type']) ? $data['provider_type'] : null;
        $this->container['media_size_bytes'] = isset($data['media_size_bytes']) ? $data['media_size_bytes'] : null;
        $this->container['media_type'] = isset($data['media_type']) ? $data['media_type'] : null;
        $this->container['file_state'] = isset($data['file_state']) ? $data['file_state'] : null;
        $this->container['provider_endpoint'] = isset($data['provider_endpoint']) ? $data['provider_endpoint'] : null;
        $this->container['recording'] = isset($data['recording']) ? $data['recording'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("EDGE", "CHAT", "EMAIL");
        if (!in_array($this->container['provider_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'provider_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CALL", "CHAT", "EMAIL");
        if (!in_array($this->container['media_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'media_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING");
        if (!in_array($this->container['file_state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'file_state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("EDGE", "CHAT", "EMAIL");
        if (!in_array($this->container['provider_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CALL", "CHAT", "EMAIL");
        if (!in_array($this->container['media_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING");
        if (!in_array($this->container['file_state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets created_time
     * @return \DateTime
     */
    public function getCreatedTime()
    {
        return $this->container['created_time'];
    }

    /**
     * Sets created_time
     * @param \DateTime $created_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedTime($created_time)
    {
        $this->container['created_time'] = $created_time;

        return $this;
    }

    /**
     * Gets recovered_time
     * @return \DateTime
     */
    public function getRecoveredTime()
    {
        return $this->container['recovered_time'];
    }

    /**
     * Sets recovered_time
     * @param \DateTime $recovered_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRecoveredTime($recovered_time)
    {
        $this->container['recovered_time'] = $recovered_time;

        return $this;
    }

    /**
     * Gets provider_type
     * @return string
     */
    public function getProviderType()
    {
        return $this->container['provider_type'];
    }

    /**
     * Sets provider_type
     * @param string $provider_type
     * @return $this
     */
    public function setProviderType($provider_type)
    {
        $allowed_values = array('EDGE', 'CHAT', 'EMAIL');
        if (!in_array($provider_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'provider_type', must be one of 'EDGE', 'CHAT', 'EMAIL'");
        }
        $this->container['provider_type'] = $provider_type;

        return $this;
    }

    /**
     * Gets media_size_bytes
     * @return int
     */
    public function getMediaSizeBytes()
    {
        return $this->container['media_size_bytes'];
    }

    /**
     * Sets media_size_bytes
     * @param int $media_size_bytes
     * @return $this
     */
    public function setMediaSizeBytes($media_size_bytes)
    {
        $this->container['media_size_bytes'] = $media_size_bytes;

        return $this;
    }

    /**
     * Gets media_type
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['media_type'];
    }

    /**
     * Sets media_type
     * @param string $media_type
     * @return $this
     */
    public function setMediaType($media_type)
    {
        $allowed_values = array('CALL', 'CHAT', 'EMAIL');
        if (!in_array($media_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'media_type', must be one of 'CALL', 'CHAT', 'EMAIL'");
        }
        $this->container['media_type'] = $media_type;

        return $this;
    }

    /**
     * Gets file_state
     * @return string
     */
    public function getFileState()
    {
        return $this->container['file_state'];
    }

    /**
     * Sets file_state
     * @param string $file_state
     * @return $this
     */
    public function setFileState($file_state)
    {
        $allowed_values = array('ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING');
        if (!in_array($file_state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'file_state', must be one of 'ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING'");
        }
        $this->container['file_state'] = $file_state;

        return $this;
    }

    /**
     * Gets provider_endpoint
     * @return \PureCloudSDK\Endpoint
     */
    public function getProviderEndpoint()
    {
        return $this->container['provider_endpoint'];
    }

    /**
     * Sets provider_endpoint
     * @param \PureCloudSDK\Endpoint $provider_endpoint
     * @return $this
     */
    public function setProviderEndpoint($provider_endpoint)
    {
        $this->container['provider_endpoint'] = $provider_endpoint;

        return $this;
    }

    /**
     * Gets recording
     * @return \PureCloudSDK\Recording
     */
    public function getRecording()
    {
        return $this->container['recording'];
    }

    /**
     * Sets recording
     * @param \PureCloudSDK\Recording $recording
     * @return $this
     */
    public function setRecording($recording)
    {
        $this->container['recording'] = $recording;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


