<?php
/**
 * Participant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Participant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Participant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Participant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'start_time' => '\DateTime',
        'end_time' => '\DateTime',
        'connected_time' => '\DateTime',
        'name' => 'string',
        'user_uri' => 'string',
        'user_id' => 'string',
        'external_contact_id' => 'string',
        'external_organization_id' => 'string',
        'queue_id' => 'string',
        'group_id' => 'string',
        'queue_name' => 'string',
        'purpose' => 'string',
        'participant_type' => 'string',
        'consult_participant_id' => 'string',
        'address' => 'string',
        'ani' => 'string',
        'dnis' => 'string',
        'locale' => 'string',
        'wrapup_required' => 'bool',
        'wrapup_prompt' => 'string',
        'wrapup_timeout_ms' => 'int',
        'wrapup_skipped' => 'bool',
        'wrapup' => '\PureCloudSDK\Wrapup',
        'monitored_participant_id' => 'string',
        'attributes' => 'map[string,string]',
        'calls' => '\PureCloudSDK\Call[]',
        'callbacks' => '\PureCloudSDK\Callback[]',
        'chats' => '\PureCloudSDK\ConversationChat[]',
        'cobrowsesessions' => '\PureCloudSDK\Cobrowsesession[]',
        'emails' => '\PureCloudSDK\Email[]',
        'screenshares' => '\PureCloudSDK\Screenshare[]',
        'social_expressions' => '\PureCloudSDK\SocialExpression[]',
        'videos' => '\PureCloudSDK\Video[]',
        'evaluations' => '\PureCloudSDK\Evaluation[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'start_time' => 'startTime',
        'end_time' => 'endTime',
        'connected_time' => 'connectedTime',
        'name' => 'name',
        'user_uri' => 'userUri',
        'user_id' => 'userId',
        'external_contact_id' => 'externalContactId',
        'external_organization_id' => 'externalOrganizationId',
        'queue_id' => 'queueId',
        'group_id' => 'groupId',
        'queue_name' => 'queueName',
        'purpose' => 'purpose',
        'participant_type' => 'participantType',
        'consult_participant_id' => 'consultParticipantId',
        'address' => 'address',
        'ani' => 'ani',
        'dnis' => 'dnis',
        'locale' => 'locale',
        'wrapup_required' => 'wrapupRequired',
        'wrapup_prompt' => 'wrapupPrompt',
        'wrapup_timeout_ms' => 'wrapupTimeoutMs',
        'wrapup_skipped' => 'wrapupSkipped',
        'wrapup' => 'wrapup',
        'monitored_participant_id' => 'monitoredParticipantId',
        'attributes' => 'attributes',
        'calls' => 'calls',
        'callbacks' => 'callbacks',
        'chats' => 'chats',
        'cobrowsesessions' => 'cobrowsesessions',
        'emails' => 'emails',
        'screenshares' => 'screenshares',
        'social_expressions' => 'socialExpressions',
        'videos' => 'videos',
        'evaluations' => 'evaluations'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'start_time' => 'setStartTime',
        'end_time' => 'setEndTime',
        'connected_time' => 'setConnectedTime',
        'name' => 'setName',
        'user_uri' => 'setUserUri',
        'user_id' => 'setUserId',
        'external_contact_id' => 'setExternalContactId',
        'external_organization_id' => 'setExternalOrganizationId',
        'queue_id' => 'setQueueId',
        'group_id' => 'setGroupId',
        'queue_name' => 'setQueueName',
        'purpose' => 'setPurpose',
        'participant_type' => 'setParticipantType',
        'consult_participant_id' => 'setConsultParticipantId',
        'address' => 'setAddress',
        'ani' => 'setAni',
        'dnis' => 'setDnis',
        'locale' => 'setLocale',
        'wrapup_required' => 'setWrapupRequired',
        'wrapup_prompt' => 'setWrapupPrompt',
        'wrapup_timeout_ms' => 'setWrapupTimeoutMs',
        'wrapup_skipped' => 'setWrapupSkipped',
        'wrapup' => 'setWrapup',
        'monitored_participant_id' => 'setMonitoredParticipantId',
        'attributes' => 'setAttributes',
        'calls' => 'setCalls',
        'callbacks' => 'setCallbacks',
        'chats' => 'setChats',
        'cobrowsesessions' => 'setCobrowsesessions',
        'emails' => 'setEmails',
        'screenshares' => 'setScreenshares',
        'social_expressions' => 'setSocialExpressions',
        'videos' => 'setVideos',
        'evaluations' => 'setEvaluations'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'start_time' => 'getStartTime',
        'end_time' => 'getEndTime',
        'connected_time' => 'getConnectedTime',
        'name' => 'getName',
        'user_uri' => 'getUserUri',
        'user_id' => 'getUserId',
        'external_contact_id' => 'getExternalContactId',
        'external_organization_id' => 'getExternalOrganizationId',
        'queue_id' => 'getQueueId',
        'group_id' => 'getGroupId',
        'queue_name' => 'getQueueName',
        'purpose' => 'getPurpose',
        'participant_type' => 'getParticipantType',
        'consult_participant_id' => 'getConsultParticipantId',
        'address' => 'getAddress',
        'ani' => 'getAni',
        'dnis' => 'getDnis',
        'locale' => 'getLocale',
        'wrapup_required' => 'getWrapupRequired',
        'wrapup_prompt' => 'getWrapupPrompt',
        'wrapup_timeout_ms' => 'getWrapupTimeoutMs',
        'wrapup_skipped' => 'getWrapupSkipped',
        'wrapup' => 'getWrapup',
        'monitored_participant_id' => 'getMonitoredParticipantId',
        'attributes' => 'getAttributes',
        'calls' => 'getCalls',
        'callbacks' => 'getCallbacks',
        'chats' => 'getChats',
        'cobrowsesessions' => 'getCobrowsesessions',
        'emails' => 'getEmails',
        'screenshares' => 'getScreenshares',
        'social_expressions' => 'getSocialExpressions',
        'videos' => 'getVideos',
        'evaluations' => 'getEvaluations'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const WRAPUP_PROMPT_MANDATORY = 'MANDATORY';
    const WRAPUP_PROMPT_OPTIONAL = 'OPTIONAL';
    const WRAPUP_PROMPT_TIMEOUT = 'TIMEOUT';
    const WRAPUP_PROMPT_FORCED_TIMEOUT = 'FORCED_TIMEOUT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWrapupPromptAllowableValues()
    {
        return [
            self::WRAPUP_PROMPT_MANDATORY,
            self::WRAPUP_PROMPT_OPTIONAL,
            self::WRAPUP_PROMPT_TIMEOUT,
            self::WRAPUP_PROMPT_FORCED_TIMEOUT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['start_time'] = isset($data['start_time']) ? $data['start_time'] : null;
        $this->container['end_time'] = isset($data['end_time']) ? $data['end_time'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['user_uri'] = isset($data['user_uri']) ? $data['user_uri'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
        $this->container['external_contact_id'] = isset($data['external_contact_id']) ? $data['external_contact_id'] : null;
        $this->container['external_organization_id'] = isset($data['external_organization_id']) ? $data['external_organization_id'] : null;
        $this->container['queue_id'] = isset($data['queue_id']) ? $data['queue_id'] : null;
        $this->container['group_id'] = isset($data['group_id']) ? $data['group_id'] : null;
        $this->container['queue_name'] = isset($data['queue_name']) ? $data['queue_name'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['participant_type'] = isset($data['participant_type']) ? $data['participant_type'] : null;
        $this->container['consult_participant_id'] = isset($data['consult_participant_id']) ? $data['consult_participant_id'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['wrapup_required'] = isset($data['wrapup_required']) ? $data['wrapup_required'] : false;
        $this->container['wrapup_prompt'] = isset($data['wrapup_prompt']) ? $data['wrapup_prompt'] : null;
        $this->container['wrapup_timeout_ms'] = isset($data['wrapup_timeout_ms']) ? $data['wrapup_timeout_ms'] : null;
        $this->container['wrapup_skipped'] = isset($data['wrapup_skipped']) ? $data['wrapup_skipped'] : false;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['monitored_participant_id'] = isset($data['monitored_participant_id']) ? $data['monitored_participant_id'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['calls'] = isset($data['calls']) ? $data['calls'] : null;
        $this->container['callbacks'] = isset($data['callbacks']) ? $data['callbacks'] : null;
        $this->container['chats'] = isset($data['chats']) ? $data['chats'] : null;
        $this->container['cobrowsesessions'] = isset($data['cobrowsesessions']) ? $data['cobrowsesessions'] : null;
        $this->container['emails'] = isset($data['emails']) ? $data['emails'] : null;
        $this->container['screenshares'] = isset($data['screenshares']) ? $data['screenshares'] : null;
        $this->container['social_expressions'] = isset($data['social_expressions']) ? $data['social_expressions'] : null;
        $this->container['videos'] = isset($data['videos']) ? $data['videos'] : null;
        $this->container['evaluations'] = isset($data['evaluations']) ? $data['evaluations'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("MANDATORY", "OPTIONAL", "TIMEOUT", "FORCED_TIMEOUT");
        if (!in_array($this->container['wrapup_prompt'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'wrapup_prompt', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("MANDATORY", "OPTIONAL", "TIMEOUT", "FORCED_TIMEOUT");
        if (!in_array($this->container['wrapup_prompt'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this conversation.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets start_time
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     * @param \DateTime $start_time The timestamp when this participant joined the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets end_time
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     * @param \DateTime $end_time The timestamp when this participant disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time The timestamp when this participant was connected to the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name A human readable name identifying the participant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets user_uri
     * @return string
     */
    public function getUserUri()
    {
        return $this->container['user_uri'];
    }

    /**
     * Sets user_uri
     * @param string $user_uri If this participant represents a user, then this will be an URI that can be used to fetch the user.
     * @return $this
     */
    public function setUserUri($user_uri)
    {
        $this->container['user_uri'] = $user_uri;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id If this participant represents a user, then this will be the globally unique identifier for the user.
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets external_contact_id
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['external_contact_id'];
    }

    /**
     * Sets external_contact_id
     * @param string $external_contact_id If this participant represents an external contact, then this will be the globally unique identifier for the external contact.
     * @return $this
     */
    public function setExternalContactId($external_contact_id)
    {
        $this->container['external_contact_id'] = $external_contact_id;

        return $this;
    }

    /**
     * Gets external_organization_id
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['external_organization_id'];
    }

    /**
     * Sets external_organization_id
     * @param string $external_organization_id If this participant represents an external org, then this will be the globally unique identifier for the external org.
     * @return $this
     */
    public function setExternalOrganizationId($external_organization_id)
    {
        $this->container['external_organization_id'] = $external_organization_id;

        return $this;
    }

    /**
     * Gets queue_id
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queue_id'];
    }

    /**
     * Sets queue_id
     * @param string $queue_id If present, the queue id that the communication channel came in on.
     * @return $this
     */
    public function setQueueId($queue_id)
    {
        $this->container['queue_id'] = $queue_id;

        return $this;
    }

    /**
     * Gets group_id
     * @return string
     */
    public function getGroupId()
    {
        return $this->container['group_id'];
    }

    /**
     * Sets group_id
     * @param string $group_id If present, group of users the participant represents.
     * @return $this
     */
    public function setGroupId($group_id)
    {
        $this->container['group_id'] = $group_id;

        return $this;
    }

    /**
     * Gets queue_name
     * @return string
     */
    public function getQueueName()
    {
        return $this->container['queue_name'];
    }

    /**
     * Sets queue_name
     * @param string $queue_name If present, the queue name that the communication channel came in on.
     * @return $this
     */
    public function setQueueName($queue_name)
    {
        $this->container['queue_name'] = $queue_name;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose A well known string that specifies the purpose of this participant.
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets participant_type
     * @return string
     */
    public function getParticipantType()
    {
        return $this->container['participant_type'];
    }

    /**
     * Sets participant_type
     * @param string $participant_type A well known string that specifies the type of this participant.
     * @return $this
     */
    public function setParticipantType($participant_type)
    {
        $this->container['participant_type'] = $participant_type;

        return $this;
    }

    /**
     * Gets consult_participant_id
     * @return string
     */
    public function getConsultParticipantId()
    {
        return $this->container['consult_participant_id'];
    }

    /**
     * Sets consult_participant_id
     * @param string $consult_participant_id If this participant is part of a consult transfer, then this will be the participant id of the participant being transferred.
     * @return $this
     */
    public function setConsultParticipantId($consult_participant_id)
    {
        $this->container['consult_participant_id'] = $consult_participant_id;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The address for the this participant. For a phone call this will be the ANI.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani The address for the this participant. For a phone call this will be the ANI.
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis The address for the this participant. For a phone call this will be the ANI.
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale An ISO 639 language code specifying the locale for this participant
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets wrapup_required
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapup_required'];
    }

    /**
     * Sets wrapup_required
     * @param bool $wrapup_required True iff this participant is required to enter wrapup for this conversation.
     * @return $this
     */
    public function setWrapupRequired($wrapup_required)
    {
        $this->container['wrapup_required'] = $wrapup_required;

        return $this;
    }

    /**
     * Gets wrapup_prompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapup_prompt'];
    }

    /**
     * Sets wrapup_prompt
     * @param string $wrapup_prompt This field controls how the UI prompts the agent for a wrapup.
     * @return $this
     */
    public function setWrapupPrompt($wrapup_prompt)
    {
        $allowed_values = array('MANDATORY', 'OPTIONAL', 'TIMEOUT', 'FORCED_TIMEOUT');
        if (!in_array($wrapup_prompt, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'wrapup_prompt', must be one of 'MANDATORY', 'OPTIONAL', 'TIMEOUT', 'FORCED_TIMEOUT'");
        }
        $this->container['wrapup_prompt'] = $wrapup_prompt;

        return $this;
    }

    /**
     * Gets wrapup_timeout_ms
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapup_timeout_ms'];
    }

    /**
     * Sets wrapup_timeout_ms
     * @param int $wrapup_timeout_ms Specifies how long a timed ACW session will last.
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapup_timeout_ms)
    {
        $this->container['wrapup_timeout_ms'] = $wrapup_timeout_ms;

        return $this;
    }

    /**
     * Gets wrapup_skipped
     * @return bool
     */
    public function getWrapupSkipped()
    {
        return $this->container['wrapup_skipped'];
    }

    /**
     * Sets wrapup_skipped
     * @param bool $wrapup_skipped The UI sets this field when the agent chooses to skip entering a wrapup for this participant.
     * @return $this
     */
    public function setWrapupSkipped($wrapup_skipped)
    {
        $this->container['wrapup_skipped'] = $wrapup_skipped;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\Wrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\Wrapup $wrapup Call wrap up or disposition data.
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets monitored_participant_id
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitored_participant_id'];
    }

    /**
     * Sets monitored_participant_id
     * @param string $monitored_participant_id If this participant is a monitor, then this will be the id of the participant that is being monitored.
     * @return $this
     */
    public function setMonitoredParticipantId($monitored_participant_id)
    {
        $this->container['monitored_participant_id'] = $monitored_participant_id;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes Additional participant attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets calls
     * @return \PureCloudSDK\Call[]
     */
    public function getCalls()
    {
        return $this->container['calls'];
    }

    /**
     * Sets calls
     * @param \PureCloudSDK\Call[] $calls
     * @return $this
     */
    public function setCalls($calls)
    {
        $this->container['calls'] = $calls;

        return $this;
    }

    /**
     * Gets callbacks
     * @return \PureCloudSDK\Callback[]
     */
    public function getCallbacks()
    {
        return $this->container['callbacks'];
    }

    /**
     * Sets callbacks
     * @param \PureCloudSDK\Callback[] $callbacks
     * @return $this
     */
    public function setCallbacks($callbacks)
    {
        $this->container['callbacks'] = $callbacks;

        return $this;
    }

    /**
     * Gets chats
     * @return \PureCloudSDK\ConversationChat[]
     */
    public function getChats()
    {
        return $this->container['chats'];
    }

    /**
     * Sets chats
     * @param \PureCloudSDK\ConversationChat[] $chats
     * @return $this
     */
    public function setChats($chats)
    {
        $this->container['chats'] = $chats;

        return $this;
    }

    /**
     * Gets cobrowsesessions
     * @return \PureCloudSDK\Cobrowsesession[]
     */
    public function getCobrowsesessions()
    {
        return $this->container['cobrowsesessions'];
    }

    /**
     * Sets cobrowsesessions
     * @param \PureCloudSDK\Cobrowsesession[] $cobrowsesessions
     * @return $this
     */
    public function setCobrowsesessions($cobrowsesessions)
    {
        $this->container['cobrowsesessions'] = $cobrowsesessions;

        return $this;
    }

    /**
     * Gets emails
     * @return \PureCloudSDK\Email[]
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     * @param \PureCloudSDK\Email[] $emails
     * @return $this
     */
    public function setEmails($emails)
    {
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets screenshares
     * @return \PureCloudSDK\Screenshare[]
     */
    public function getScreenshares()
    {
        return $this->container['screenshares'];
    }

    /**
     * Sets screenshares
     * @param \PureCloudSDK\Screenshare[] $screenshares
     * @return $this
     */
    public function setScreenshares($screenshares)
    {
        $this->container['screenshares'] = $screenshares;

        return $this;
    }

    /**
     * Gets social_expressions
     * @return \PureCloudSDK\SocialExpression[]
     */
    public function getSocialExpressions()
    {
        return $this->container['social_expressions'];
    }

    /**
     * Sets social_expressions
     * @param \PureCloudSDK\SocialExpression[] $social_expressions
     * @return $this
     */
    public function setSocialExpressions($social_expressions)
    {
        $this->container['social_expressions'] = $social_expressions;

        return $this;
    }

    /**
     * Gets videos
     * @return \PureCloudSDK\Video[]
     */
    public function getVideos()
    {
        return $this->container['videos'];
    }

    /**
     * Sets videos
     * @param \PureCloudSDK\Video[] $videos
     * @return $this
     */
    public function setVideos($videos)
    {
        $this->container['videos'] = $videos;

        return $this;
    }

    /**
     * Gets evaluations
     * @return \PureCloudSDK\Evaluation[]
     */
    public function getEvaluations()
    {
        return $this->container['evaluations'];
    }

    /**
     * Sets evaluations
     * @param \PureCloudSDK\Evaluation[] $evaluations
     * @return $this
     */
    public function setEvaluations($evaluations)
    {
        $this->container['evaluations'] = $evaluations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


