<?php
/**
 * Phone
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Phone Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Phone implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Phone';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'modified_by' => 'string',
        'created_by' => 'string',
        'state' => 'string',
        'modified_by_app' => 'string',
        'created_by_app' => 'string',
        'site' => '\PureCloudSDK\UriReference',
        'phone_base_settings' => '\PureCloudSDK\UriReference',
        'line_base_settings' => '\PureCloudSDK\UriReference',
        'phone_meta_base' => '\PureCloudSDK\UriReference',
        'lines' => '\PureCloudSDK\Line[]',
        'status' => '\PureCloudSDK\PhoneStatus',
        'secondary_status' => '\PureCloudSDK\PhoneStatus',
        'user_agent_info' => '\PureCloudSDK\UserAgentInfo',
        'properties' => 'map[string,object]',
        'capabilities' => '\PureCloudSDK\PhoneCapabilities',
        'web_rtc_user' => '\PureCloudSDK\UriReference',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'modified_by' => 'modifiedBy',
        'created_by' => 'createdBy',
        'state' => 'state',
        'modified_by_app' => 'modifiedByApp',
        'created_by_app' => 'createdByApp',
        'site' => 'site',
        'phone_base_settings' => 'phoneBaseSettings',
        'line_base_settings' => 'lineBaseSettings',
        'phone_meta_base' => 'phoneMetaBase',
        'lines' => 'lines',
        'status' => 'status',
        'secondary_status' => 'secondaryStatus',
        'user_agent_info' => 'userAgentInfo',
        'properties' => 'properties',
        'capabilities' => 'capabilities',
        'web_rtc_user' => 'webRtcUser',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'modified_by' => 'setModifiedBy',
        'created_by' => 'setCreatedBy',
        'state' => 'setState',
        'modified_by_app' => 'setModifiedByApp',
        'created_by_app' => 'setCreatedByApp',
        'site' => 'setSite',
        'phone_base_settings' => 'setPhoneBaseSettings',
        'line_base_settings' => 'setLineBaseSettings',
        'phone_meta_base' => 'setPhoneMetaBase',
        'lines' => 'setLines',
        'status' => 'setStatus',
        'secondary_status' => 'setSecondaryStatus',
        'user_agent_info' => 'setUserAgentInfo',
        'properties' => 'setProperties',
        'capabilities' => 'setCapabilities',
        'web_rtc_user' => 'setWebRtcUser',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'modified_by' => 'getModifiedBy',
        'created_by' => 'getCreatedBy',
        'state' => 'getState',
        'modified_by_app' => 'getModifiedByApp',
        'created_by_app' => 'getCreatedByApp',
        'site' => 'getSite',
        'phone_base_settings' => 'getPhoneBaseSettings',
        'line_base_settings' => 'getLineBaseSettings',
        'phone_meta_base' => 'getPhoneMetaBase',
        'lines' => 'getLines',
        'status' => 'getStatus',
        'secondary_status' => 'getSecondaryStatus',
        'user_agent_info' => 'getUserAgentInfo',
        'properties' => 'getProperties',
        'capabilities' => 'getCapabilities',
        'web_rtc_user' => 'getWebRtcUser',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modified_by_app'] = isset($data['modified_by_app']) ? $data['modified_by_app'] : null;
        $this->container['created_by_app'] = isset($data['created_by_app']) ? $data['created_by_app'] : null;
        $this->container['site'] = isset($data['site']) ? $data['site'] : null;
        $this->container['phone_base_settings'] = isset($data['phone_base_settings']) ? $data['phone_base_settings'] : null;
        $this->container['line_base_settings'] = isset($data['line_base_settings']) ? $data['line_base_settings'] : null;
        $this->container['phone_meta_base'] = isset($data['phone_meta_base']) ? $data['phone_meta_base'] : null;
        $this->container['lines'] = isset($data['lines']) ? $data['lines'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['secondary_status'] = isset($data['secondary_status']) ? $data['secondary_status'] : null;
        $this->container['user_agent_info'] = isset($data['user_agent_info']) ? $data['user_agent_info'] : null;
        $this->container['properties'] = isset($data['properties']) ? $data['properties'] : null;
        $this->container['capabilities'] = isset($data['capabilities']) ? $data['capabilities'] : null;
        $this->container['web_rtc_user'] = isset($data['web_rtc_user']) ? $data['web_rtc_user'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['site'] === null) {
            $invalid_properties[] = "'site' can't be null";
        }
        if ($this->container['phone_base_settings'] === null) {
            $invalid_properties[] = "'phone_base_settings' can't be null";
        }
        if ($this->container['lines'] === null) {
            $invalid_properties[] = "'lines' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['site'] === null) {
            return false;
        }
        if ($this->container['phone_base_settings'] === null) {
            return false;
        }
        if ($this->container['lines'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets modified_by
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     * @param string $modified_by
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets created_by
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param string $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modified_by_app
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modified_by_app'];
    }

    /**
     * Sets modified_by_app
     * @param string $modified_by_app
     * @return $this
     */
    public function setModifiedByApp($modified_by_app)
    {
        $this->container['modified_by_app'] = $modified_by_app;

        return $this;
    }

    /**
     * Gets created_by_app
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['created_by_app'];
    }

    /**
     * Sets created_by_app
     * @param string $created_by_app
     * @return $this
     */
    public function setCreatedByApp($created_by_app)
    {
        $this->container['created_by_app'] = $created_by_app;

        return $this;
    }

    /**
     * Gets site
     * @return \PureCloudSDK\UriReference
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site
     * @param \PureCloudSDK\UriReference $site The site associated to the phone.
     * @return $this
     */
    public function setSite($site)
    {
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets phone_base_settings
     * @return \PureCloudSDK\UriReference
     */
    public function getPhoneBaseSettings()
    {
        return $this->container['phone_base_settings'];
    }

    /**
     * Sets phone_base_settings
     * @param \PureCloudSDK\UriReference $phone_base_settings Phone Base Settings
     * @return $this
     */
    public function setPhoneBaseSettings($phone_base_settings)
    {
        $this->container['phone_base_settings'] = $phone_base_settings;

        return $this;
    }

    /**
     * Gets line_base_settings
     * @return \PureCloudSDK\UriReference
     */
    public function getLineBaseSettings()
    {
        return $this->container['line_base_settings'];
    }

    /**
     * Sets line_base_settings
     * @param \PureCloudSDK\UriReference $line_base_settings
     * @return $this
     */
    public function setLineBaseSettings($line_base_settings)
    {
        $this->container['line_base_settings'] = $line_base_settings;

        return $this;
    }

    /**
     * Gets phone_meta_base
     * @return \PureCloudSDK\UriReference
     */
    public function getPhoneMetaBase()
    {
        return $this->container['phone_meta_base'];
    }

    /**
     * Sets phone_meta_base
     * @param \PureCloudSDK\UriReference $phone_meta_base
     * @return $this
     */
    public function setPhoneMetaBase($phone_meta_base)
    {
        $this->container['phone_meta_base'] = $phone_meta_base;

        return $this;
    }

    /**
     * Gets lines
     * @return \PureCloudSDK\Line[]
     */
    public function getLines()
    {
        return $this->container['lines'];
    }

    /**
     * Sets lines
     * @param \PureCloudSDK\Line[] $lines Lines
     * @return $this
     */
    public function setLines($lines)
    {
        $this->container['lines'] = $lines;

        return $this;
    }

    /**
     * Gets status
     * @return \PureCloudSDK\PhoneStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param \PureCloudSDK\PhoneStatus $status The status of the phone and lines from the primary Edge.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets secondary_status
     * @return \PureCloudSDK\PhoneStatus
     */
    public function getSecondaryStatus()
    {
        return $this->container['secondary_status'];
    }

    /**
     * Sets secondary_status
     * @param \PureCloudSDK\PhoneStatus $secondary_status The status of the phone and lines from the secondary Edge.
     * @return $this
     */
    public function setSecondaryStatus($secondary_status)
    {
        $this->container['secondary_status'] = $secondary_status;

        return $this;
    }

    /**
     * Gets user_agent_info
     * @return \PureCloudSDK\UserAgentInfo
     */
    public function getUserAgentInfo()
    {
        return $this->container['user_agent_info'];
    }

    /**
     * Sets user_agent_info
     * @param \PureCloudSDK\UserAgentInfo $user_agent_info User Agent Information for this phone. This includes model, firmware version, and manufacturer.
     * @return $this
     */
    public function setUserAgentInfo($user_agent_info)
    {
        $this->container['user_agent_info'] = $user_agent_info;

        return $this;
    }

    /**
     * Gets properties
     * @return map[string,object]
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     * @param map[string,object] $properties
     * @return $this
     */
    public function setProperties($properties)
    {
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets capabilities
     * @return \PureCloudSDK\PhoneCapabilities
     */
    public function getCapabilities()
    {
        return $this->container['capabilities'];
    }

    /**
     * Sets capabilities
     * @param \PureCloudSDK\PhoneCapabilities $capabilities
     * @return $this
     */
    public function setCapabilities($capabilities)
    {
        $this->container['capabilities'] = $capabilities;

        return $this;
    }

    /**
     * Gets web_rtc_user
     * @return \PureCloudSDK\UriReference
     */
    public function getWebRtcUser()
    {
        return $this->container['web_rtc_user'];
    }

    /**
     * Sets web_rtc_user
     * @param \PureCloudSDK\UriReference $web_rtc_user This is the user associated with a WebRTC type phone.  It is required for all WebRTC phones.
     * @return $this
     */
    public function setWebRtcUser($web_rtc_user)
    {
        $this->container['web_rtc_user'] = $web_rtc_user;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


