<?php
/**
 * PhoneCapabilities
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PhoneCapabilities Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PhoneCapabilities implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PhoneCapabilities';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'provisions' => 'bool',
        'registers' => 'bool',
        'dual_registers' => 'bool',
        'hardware_id_type' => 'string',
        'allow_reboot' => 'bool',
        'no_rebalance' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'provisions' => 'provisions',
        'registers' => 'registers',
        'dual_registers' => 'dualRegisters',
        'hardware_id_type' => 'hardwareIdType',
        'allow_reboot' => 'allowReboot',
        'no_rebalance' => 'noRebalance'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'provisions' => 'setProvisions',
        'registers' => 'setRegisters',
        'dual_registers' => 'setDualRegisters',
        'hardware_id_type' => 'setHardwareIdType',
        'allow_reboot' => 'setAllowReboot',
        'no_rebalance' => 'setNoRebalance'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'provisions' => 'getProvisions',
        'registers' => 'getRegisters',
        'dual_registers' => 'getDualRegisters',
        'hardware_id_type' => 'getHardwareIdType',
        'allow_reboot' => 'getAllowReboot',
        'no_rebalance' => 'getNoRebalance'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['provisions'] = isset($data['provisions']) ? $data['provisions'] : false;
        $this->container['registers'] = isset($data['registers']) ? $data['registers'] : false;
        $this->container['dual_registers'] = isset($data['dual_registers']) ? $data['dual_registers'] : false;
        $this->container['hardware_id_type'] = isset($data['hardware_id_type']) ? $data['hardware_id_type'] : null;
        $this->container['allow_reboot'] = isset($data['allow_reboot']) ? $data['allow_reboot'] : false;
        $this->container['no_rebalance'] = isset($data['no_rebalance']) ? $data['no_rebalance'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets provisions
     * @return bool
     */
    public function getProvisions()
    {
        return $this->container['provisions'];
    }

    /**
     * Sets provisions
     * @param bool $provisions
     * @return $this
     */
    public function setProvisions($provisions)
    {
        $this->container['provisions'] = $provisions;

        return $this;
    }

    /**
     * Gets registers
     * @return bool
     */
    public function getRegisters()
    {
        return $this->container['registers'];
    }

    /**
     * Sets registers
     * @param bool $registers
     * @return $this
     */
    public function setRegisters($registers)
    {
        $this->container['registers'] = $registers;

        return $this;
    }

    /**
     * Gets dual_registers
     * @return bool
     */
    public function getDualRegisters()
    {
        return $this->container['dual_registers'];
    }

    /**
     * Sets dual_registers
     * @param bool $dual_registers
     * @return $this
     */
    public function setDualRegisters($dual_registers)
    {
        $this->container['dual_registers'] = $dual_registers;

        return $this;
    }

    /**
     * Gets hardware_id_type
     * @return string
     */
    public function getHardwareIdType()
    {
        return $this->container['hardware_id_type'];
    }

    /**
     * Sets hardware_id_type
     * @param string $hardware_id_type
     * @return $this
     */
    public function setHardwareIdType($hardware_id_type)
    {
        $this->container['hardware_id_type'] = $hardware_id_type;

        return $this;
    }

    /**
     * Gets allow_reboot
     * @return bool
     */
    public function getAllowReboot()
    {
        return $this->container['allow_reboot'];
    }

    /**
     * Sets allow_reboot
     * @param bool $allow_reboot
     * @return $this
     */
    public function setAllowReboot($allow_reboot)
    {
        $this->container['allow_reboot'] = $allow_reboot;

        return $this;
    }

    /**
     * Gets no_rebalance
     * @return bool
     */
    public function getNoRebalance()
    {
        return $this->container['no_rebalance'];
    }

    /**
     * Sets no_rebalance
     * @param bool $no_rebalance
     * @return $this
     */
    public function setNoRebalance($no_rebalance)
    {
        $this->container['no_rebalance'] = $no_rebalance;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


