<?php
/**
 * PhoneStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PhoneStatus Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PhoneStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PhoneStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'operational_status' => 'string',
        'edges_status' => 'string',
        'event_creation_time' => 'string',
        'provision' => '\PureCloudSDK\ProvisionInfo',
        'line_statuses' => '\PureCloudSDK\LineStatus[]',
        'phone_assignment_to_edge_type' => 'string',
        'edge' => '\PureCloudSDK\UriReference',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'operational_status' => 'operationalStatus',
        'edges_status' => 'edgesStatus',
        'event_creation_time' => 'eventCreationTime',
        'provision' => 'provision',
        'line_statuses' => 'lineStatuses',
        'phone_assignment_to_edge_type' => 'phoneAssignmentToEdgeType',
        'edge' => 'edge',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'operational_status' => 'setOperationalStatus',
        'edges_status' => 'setEdgesStatus',
        'event_creation_time' => 'setEventCreationTime',
        'provision' => 'setProvision',
        'line_statuses' => 'setLineStatuses',
        'phone_assignment_to_edge_type' => 'setPhoneAssignmentToEdgeType',
        'edge' => 'setEdge',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'operational_status' => 'getOperationalStatus',
        'edges_status' => 'getEdgesStatus',
        'event_creation_time' => 'getEventCreationTime',
        'provision' => 'getProvision',
        'line_statuses' => 'getLineStatuses',
        'phone_assignment_to_edge_type' => 'getPhoneAssignmentToEdgeType',
        'edge' => 'getEdge',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const OPERATIONAL_STATUS_OPERATIONAL = 'OPERATIONAL';
    const OPERATIONAL_STATUS_DEGRADED = 'DEGRADED';
    const OPERATIONAL_STATUS_OFFLINE = 'OFFLINE';
    const EDGES_STATUS_IN_SERVICE = 'IN_SERVICE';
    const EDGES_STATUS_MIXED_SERVICE = 'MIXED_SERVICE';
    const EDGES_STATUS_OUT_OF_SERVICE = 'OUT_OF_SERVICE';
    const EDGES_STATUS_NO_EDGES = 'NO_EDGES';
    const PHONE_ASSIGNMENT_TO_EDGE_TYPE_PRIMARY = 'PRIMARY';
    const PHONE_ASSIGNMENT_TO_EDGE_TYPE_SECONDARY = 'SECONDARY';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperationalStatusAllowableValues()
    {
        return [
            self::OPERATIONAL_STATUS_OPERATIONAL,
            self::OPERATIONAL_STATUS_DEGRADED,
            self::OPERATIONAL_STATUS_OFFLINE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getEdgesStatusAllowableValues()
    {
        return [
            self::EDGES_STATUS_IN_SERVICE,
            self::EDGES_STATUS_MIXED_SERVICE,
            self::EDGES_STATUS_OUT_OF_SERVICE,
            self::EDGES_STATUS_NO_EDGES,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPhoneAssignmentToEdgeTypeAllowableValues()
    {
        return [
            self::PHONE_ASSIGNMENT_TO_EDGE_TYPE_PRIMARY,
            self::PHONE_ASSIGNMENT_TO_EDGE_TYPE_SECONDARY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['operational_status'] = isset($data['operational_status']) ? $data['operational_status'] : null;
        $this->container['edges_status'] = isset($data['edges_status']) ? $data['edges_status'] : null;
        $this->container['event_creation_time'] = isset($data['event_creation_time']) ? $data['event_creation_time'] : null;
        $this->container['provision'] = isset($data['provision']) ? $data['provision'] : null;
        $this->container['line_statuses'] = isset($data['line_statuses']) ? $data['line_statuses'] : null;
        $this->container['phone_assignment_to_edge_type'] = isset($data['phone_assignment_to_edge_type']) ? $data['phone_assignment_to_edge_type'] : null;
        $this->container['edge'] = isset($data['edge']) ? $data['edge'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OPERATIONAL", "DEGRADED", "OFFLINE");
        if (!in_array($this->container['operational_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operational_status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("IN_SERVICE", "MIXED_SERVICE", "OUT_OF_SERVICE", "NO_EDGES");
        if (!in_array($this->container['edges_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'edges_status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("PRIMARY", "SECONDARY");
        if (!in_array($this->container['phone_assignment_to_edge_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'phone_assignment_to_edge_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OPERATIONAL", "DEGRADED", "OFFLINE");
        if (!in_array($this->container['operational_status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("IN_SERVICE", "MIXED_SERVICE", "OUT_OF_SERVICE", "NO_EDGES");
        if (!in_array($this->container['edges_status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("PRIMARY", "SECONDARY");
        if (!in_array($this->container['phone_assignment_to_edge_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets operational_status
     * @return string
     */
    public function getOperationalStatus()
    {
        return $this->container['operational_status'];
    }

    /**
     * Sets operational_status
     * @param string $operational_status The Operational Status of this phone
     * @return $this
     */
    public function setOperationalStatus($operational_status)
    {
        $allowed_values = array('OPERATIONAL', 'DEGRADED', 'OFFLINE');
        if (!in_array($operational_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operational_status', must be one of 'OPERATIONAL', 'DEGRADED', 'OFFLINE'");
        }
        $this->container['operational_status'] = $operational_status;

        return $this;
    }

    /**
     * Gets edges_status
     * @return string
     */
    public function getEdgesStatus()
    {
        return $this->container['edges_status'];
    }

    /**
     * Sets edges_status
     * @param string $edges_status The status of the primary or secondary Edges assigned to the phone lines.
     * @return $this
     */
    public function setEdgesStatus($edges_status)
    {
        $allowed_values = array('IN_SERVICE', 'MIXED_SERVICE', 'OUT_OF_SERVICE', 'NO_EDGES');
        if (!in_array($edges_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'edges_status', must be one of 'IN_SERVICE', 'MIXED_SERVICE', 'OUT_OF_SERVICE', 'NO_EDGES'");
        }
        $this->container['edges_status'] = $edges_status;

        return $this;
    }

    /**
     * Gets event_creation_time
     * @return string
     */
    public function getEventCreationTime()
    {
        return $this->container['event_creation_time'];
    }

    /**
     * Sets event_creation_time
     * @param string $event_creation_time Event Creation Time represents an ISO-8601 string. For example: UTC, UTC+01:00, or Europe/London
     * @return $this
     */
    public function setEventCreationTime($event_creation_time)
    {
        $this->container['event_creation_time'] = $event_creation_time;

        return $this;
    }

    /**
     * Gets provision
     * @return \PureCloudSDK\ProvisionInfo
     */
    public function getProvision()
    {
        return $this->container['provision'];
    }

    /**
     * Sets provision
     * @param \PureCloudSDK\ProvisionInfo $provision Provision information for this phone
     * @return $this
     */
    public function setProvision($provision)
    {
        $this->container['provision'] = $provision;

        return $this;
    }

    /**
     * Gets line_statuses
     * @return \PureCloudSDK\LineStatus[]
     */
    public function getLineStatuses()
    {
        return $this->container['line_statuses'];
    }

    /**
     * Sets line_statuses
     * @param \PureCloudSDK\LineStatus[] $line_statuses A list of LineStatus information for each of the lines of this phone
     * @return $this
     */
    public function setLineStatuses($line_statuses)
    {
        $this->container['line_statuses'] = $line_statuses;

        return $this;
    }

    /**
     * Gets phone_assignment_to_edge_type
     * @return string
     */
    public function getPhoneAssignmentToEdgeType()
    {
        return $this->container['phone_assignment_to_edge_type'];
    }

    /**
     * Sets phone_assignment_to_edge_type
     * @param string $phone_assignment_to_edge_type The phone status's edge assignment type.
     * @return $this
     */
    public function setPhoneAssignmentToEdgeType($phone_assignment_to_edge_type)
    {
        $allowed_values = array('PRIMARY', 'SECONDARY');
        if (!in_array($phone_assignment_to_edge_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'phone_assignment_to_edge_type', must be one of 'PRIMARY', 'SECONDARY'");
        }
        $this->container['phone_assignment_to_edge_type'] = $phone_assignment_to_edge_type;

        return $this;
    }

    /**
     * Gets edge
     * @return \PureCloudSDK\UriReference
     */
    public function getEdge()
    {
        return $this->container['edge'];
    }

    /**
     * Sets edge
     * @param \PureCloudSDK\UriReference $edge The URI of the edge that provided this status information.
     * @return $this
     */
    public function setEdge($edge)
    {
        $this->container['edge'] = $edge;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


