<?php
/**
 * PolicyActions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PolicyActions Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PolicyActions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PolicyActions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'retain_recording' => 'bool',
        'delete_recording' => 'bool',
        'always_delete' => 'bool',
        'assign_evaluations' => '\PureCloudSDK\EvaluationAssignment[]',
        'assign_metered_evaluations' => '\PureCloudSDK\MeteredEvaluationAssignment[]',
        'assign_calibrations' => '\PureCloudSDK\CalibrationAssignment[]',
        'retention_duration' => '\PureCloudSDK\RetentionDuration',
        'initiate_screen_recording' => '\PureCloudSDK\InitiateScreenRecording'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'retain_recording' => 'retainRecording',
        'delete_recording' => 'deleteRecording',
        'always_delete' => 'alwaysDelete',
        'assign_evaluations' => 'assignEvaluations',
        'assign_metered_evaluations' => 'assignMeteredEvaluations',
        'assign_calibrations' => 'assignCalibrations',
        'retention_duration' => 'retentionDuration',
        'initiate_screen_recording' => 'initiateScreenRecording'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'retain_recording' => 'setRetainRecording',
        'delete_recording' => 'setDeleteRecording',
        'always_delete' => 'setAlwaysDelete',
        'assign_evaluations' => 'setAssignEvaluations',
        'assign_metered_evaluations' => 'setAssignMeteredEvaluations',
        'assign_calibrations' => 'setAssignCalibrations',
        'retention_duration' => 'setRetentionDuration',
        'initiate_screen_recording' => 'setInitiateScreenRecording'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'retain_recording' => 'getRetainRecording',
        'delete_recording' => 'getDeleteRecording',
        'always_delete' => 'getAlwaysDelete',
        'assign_evaluations' => 'getAssignEvaluations',
        'assign_metered_evaluations' => 'getAssignMeteredEvaluations',
        'assign_calibrations' => 'getAssignCalibrations',
        'retention_duration' => 'getRetentionDuration',
        'initiate_screen_recording' => 'getInitiateScreenRecording'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['retain_recording'] = isset($data['retain_recording']) ? $data['retain_recording'] : false;
        $this->container['delete_recording'] = isset($data['delete_recording']) ? $data['delete_recording'] : false;
        $this->container['always_delete'] = isset($data['always_delete']) ? $data['always_delete'] : false;
        $this->container['assign_evaluations'] = isset($data['assign_evaluations']) ? $data['assign_evaluations'] : null;
        $this->container['assign_metered_evaluations'] = isset($data['assign_metered_evaluations']) ? $data['assign_metered_evaluations'] : null;
        $this->container['assign_calibrations'] = isset($data['assign_calibrations']) ? $data['assign_calibrations'] : null;
        $this->container['retention_duration'] = isset($data['retention_duration']) ? $data['retention_duration'] : null;
        $this->container['initiate_screen_recording'] = isset($data['initiate_screen_recording']) ? $data['initiate_screen_recording'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets retain_recording
     * @return bool
     */
    public function getRetainRecording()
    {
        return $this->container['retain_recording'];
    }

    /**
     * Sets retain_recording
     * @param bool $retain_recording true to retain the recording associated with the conversation. Default = true
     * @return $this
     */
    public function setRetainRecording($retain_recording)
    {
        $this->container['retain_recording'] = $retain_recording;

        return $this;
    }

    /**
     * Gets delete_recording
     * @return bool
     */
    public function getDeleteRecording()
    {
        return $this->container['delete_recording'];
    }

    /**
     * Sets delete_recording
     * @param bool $delete_recording true to delete the recording associated with the conversation. If retainRecording = true, this will be ignored. Default = false
     * @return $this
     */
    public function setDeleteRecording($delete_recording)
    {
        $this->container['delete_recording'] = $delete_recording;

        return $this;
    }

    /**
     * Gets always_delete
     * @return bool
     */
    public function getAlwaysDelete()
    {
        return $this->container['always_delete'];
    }

    /**
     * Sets always_delete
     * @param bool $always_delete true to delete the recording associated with the conversation regardless of the values of retainRecording or deleteRecording. Default = false
     * @return $this
     */
    public function setAlwaysDelete($always_delete)
    {
        $this->container['always_delete'] = $always_delete;

        return $this;
    }

    /**
     * Gets assign_evaluations
     * @return \PureCloudSDK\EvaluationAssignment[]
     */
    public function getAssignEvaluations()
    {
        return $this->container['assign_evaluations'];
    }

    /**
     * Sets assign_evaluations
     * @param \PureCloudSDK\EvaluationAssignment[] $assign_evaluations
     * @return $this
     */
    public function setAssignEvaluations($assign_evaluations)
    {
        $this->container['assign_evaluations'] = $assign_evaluations;

        return $this;
    }

    /**
     * Gets assign_metered_evaluations
     * @return \PureCloudSDK\MeteredEvaluationAssignment[]
     */
    public function getAssignMeteredEvaluations()
    {
        return $this->container['assign_metered_evaluations'];
    }

    /**
     * Sets assign_metered_evaluations
     * @param \PureCloudSDK\MeteredEvaluationAssignment[] $assign_metered_evaluations
     * @return $this
     */
    public function setAssignMeteredEvaluations($assign_metered_evaluations)
    {
        $this->container['assign_metered_evaluations'] = $assign_metered_evaluations;

        return $this;
    }

    /**
     * Gets assign_calibrations
     * @return \PureCloudSDK\CalibrationAssignment[]
     */
    public function getAssignCalibrations()
    {
        return $this->container['assign_calibrations'];
    }

    /**
     * Sets assign_calibrations
     * @param \PureCloudSDK\CalibrationAssignment[] $assign_calibrations
     * @return $this
     */
    public function setAssignCalibrations($assign_calibrations)
    {
        $this->container['assign_calibrations'] = $assign_calibrations;

        return $this;
    }

    /**
     * Gets retention_duration
     * @return \PureCloudSDK\RetentionDuration
     */
    public function getRetentionDuration()
    {
        return $this->container['retention_duration'];
    }

    /**
     * Sets retention_duration
     * @param \PureCloudSDK\RetentionDuration $retention_duration
     * @return $this
     */
    public function setRetentionDuration($retention_duration)
    {
        $this->container['retention_duration'] = $retention_duration;

        return $this;
    }

    /**
     * Gets initiate_screen_recording
     * @return \PureCloudSDK\InitiateScreenRecording
     */
    public function getInitiateScreenRecording()
    {
        return $this->container['initiate_screen_recording'];
    }

    /**
     * Sets initiate_screen_recording
     * @param \PureCloudSDK\InitiateScreenRecording $initiate_screen_recording
     * @return $this
     */
    public function setInitiateScreenRecording($initiate_screen_recording)
    {
        $this->container['initiate_screen_recording'] = $initiate_screen_recording;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


