<?php
/**
 * PolicyConditions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PolicyConditions Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PolicyConditions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PolicyConditions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'for_users' => '\PureCloudSDK\User[]',
        'directions' => 'string[]',
        'date_ranges' => 'string[]',
        'media_types' => 'string[]',
        'for_queues' => '\PureCloudSDK\Queue[]',
        'duration' => '\PureCloudSDK\DurationCondition',
        'wrapup_codes' => '\PureCloudSDK\WrapupCode[]',
        'time_allowed' => '\PureCloudSDK\TimeAllowed'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'for_users' => 'forUsers',
        'directions' => 'directions',
        'date_ranges' => 'dateRanges',
        'media_types' => 'mediaTypes',
        'for_queues' => 'forQueues',
        'duration' => 'duration',
        'wrapup_codes' => 'wrapupCodes',
        'time_allowed' => 'timeAllowed'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'for_users' => 'setForUsers',
        'directions' => 'setDirections',
        'date_ranges' => 'setDateRanges',
        'media_types' => 'setMediaTypes',
        'for_queues' => 'setForQueues',
        'duration' => 'setDuration',
        'wrapup_codes' => 'setWrapupCodes',
        'time_allowed' => 'setTimeAllowed'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'for_users' => 'getForUsers',
        'directions' => 'getDirections',
        'date_ranges' => 'getDateRanges',
        'media_types' => 'getMediaTypes',
        'for_queues' => 'getForQueues',
        'duration' => 'getDuration',
        'wrapup_codes' => 'getWrapupCodes',
        'time_allowed' => 'getTimeAllowed'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIRECTIONS_INBOUND = 'INBOUND';
    const DIRECTIONS_OUTBOUND = 'OUTBOUND';
    const MEDIA_TYPES_CALL = 'CALL';
    const MEDIA_TYPES_CHAT = 'CHAT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionsAllowableValues()
    {
        return [
            self::DIRECTIONS_INBOUND,
            self::DIRECTIONS_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypesAllowableValues()
    {
        return [
            self::MEDIA_TYPES_CALL,
            self::MEDIA_TYPES_CHAT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['for_users'] = isset($data['for_users']) ? $data['for_users'] : null;
        $this->container['directions'] = isset($data['directions']) ? $data['directions'] : null;
        $this->container['date_ranges'] = isset($data['date_ranges']) ? $data['date_ranges'] : null;
        $this->container['media_types'] = isset($data['media_types']) ? $data['media_types'] : null;
        $this->container['for_queues'] = isset($data['for_queues']) ? $data['for_queues'] : null;
        $this->container['duration'] = isset($data['duration']) ? $data['duration'] : null;
        $this->container['wrapup_codes'] = isset($data['wrapup_codes']) ? $data['wrapup_codes'] : null;
        $this->container['time_allowed'] = isset($data['time_allowed']) ? $data['time_allowed'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets for_users
     * @return \PureCloudSDK\User[]
     */
    public function getForUsers()
    {
        return $this->container['for_users'];
    }

    /**
     * Sets for_users
     * @param \PureCloudSDK\User[] $for_users
     * @return $this
     */
    public function setForUsers($for_users)
    {
        $this->container['for_users'] = $for_users;

        return $this;
    }

    /**
     * Gets directions
     * @return string[]
     */
    public function getDirections()
    {
        return $this->container['directions'];
    }

    /**
     * Sets directions
     * @param string[] $directions
     * @return $this
     */
    public function setDirections($directions)
    {
        $allowed_values = array('INBOUND', 'OUTBOUND');
        if (!in_array($directions, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'directions', must be one of 'INBOUND', 'OUTBOUND'");
        }
        $this->container['directions'] = $directions;

        return $this;
    }

    /**
     * Gets date_ranges
     * @return string[]
     */
    public function getDateRanges()
    {
        return $this->container['date_ranges'];
    }

    /**
     * Sets date_ranges
     * @param string[] $date_ranges
     * @return $this
     */
    public function setDateRanges($date_ranges)
    {
        $this->container['date_ranges'] = $date_ranges;

        return $this;
    }

    /**
     * Gets media_types
     * @return string[]
     */
    public function getMediaTypes()
    {
        return $this->container['media_types'];
    }

    /**
     * Sets media_types
     * @param string[] $media_types
     * @return $this
     */
    public function setMediaTypes($media_types)
    {
        $allowed_values = array('CALL', 'CHAT');
        if (!in_array($media_types, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'media_types', must be one of 'CALL', 'CHAT'");
        }
        $this->container['media_types'] = $media_types;

        return $this;
    }

    /**
     * Gets for_queues
     * @return \PureCloudSDK\Queue[]
     */
    public function getForQueues()
    {
        return $this->container['for_queues'];
    }

    /**
     * Sets for_queues
     * @param \PureCloudSDK\Queue[] $for_queues
     * @return $this
     */
    public function setForQueues($for_queues)
    {
        $this->container['for_queues'] = $for_queues;

        return $this;
    }

    /**
     * Gets duration
     * @return \PureCloudSDK\DurationCondition
     */
    public function getDuration()
    {
        return $this->container['duration'];
    }

    /**
     * Sets duration
     * @param \PureCloudSDK\DurationCondition $duration
     * @return $this
     */
    public function setDuration($duration)
    {
        $this->container['duration'] = $duration;

        return $this;
    }

    /**
     * Gets wrapup_codes
     * @return \PureCloudSDK\WrapupCode[]
     */
    public function getWrapupCodes()
    {
        return $this->container['wrapup_codes'];
    }

    /**
     * Sets wrapup_codes
     * @param \PureCloudSDK\WrapupCode[] $wrapup_codes
     * @return $this
     */
    public function setWrapupCodes($wrapup_codes)
    {
        $this->container['wrapup_codes'] = $wrapup_codes;

        return $this;
    }

    /**
     * Gets time_allowed
     * @return \PureCloudSDK\TimeAllowed
     */
    public function getTimeAllowed()
    {
        return $this->container['time_allowed'];
    }

    /**
     * Sets time_allowed
     * @param \PureCloudSDK\TimeAllowed $time_allowed
     * @return $this
     */
    public function setTimeAllowed($time_allowed)
    {
        $this->container['time_allowed'] = $time_allowed;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


