<?php
/**
 * PolicyErrorMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PolicyErrorMessage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PolicyErrorMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PolicyErrorMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'status_code' => 'int',
        'user_message' => 'object',
        'user_params_message' => 'string',
        'error_code' => 'string',
        'correlation_id' => 'string',
        'user_params' => '\PureCloudSDK\UserParam[]',
        'insert_date' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'status_code' => 'statusCode',
        'user_message' => 'userMessage',
        'user_params_message' => 'userParamsMessage',
        'error_code' => 'errorCode',
        'correlation_id' => 'correlationId',
        'user_params' => 'userParams',
        'insert_date' => 'insertDate'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'status_code' => 'setStatusCode',
        'user_message' => 'setUserMessage',
        'user_params_message' => 'setUserParamsMessage',
        'error_code' => 'setErrorCode',
        'correlation_id' => 'setCorrelationId',
        'user_params' => 'setUserParams',
        'insert_date' => 'setInsertDate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'status_code' => 'getStatusCode',
        'user_message' => 'getUserMessage',
        'user_params_message' => 'getUserParamsMessage',
        'error_code' => 'getErrorCode',
        'correlation_id' => 'getCorrelationId',
        'user_params' => 'getUserParams',
        'insert_date' => 'getInsertDate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['status_code'] = isset($data['status_code']) ? $data['status_code'] : null;
        $this->container['user_message'] = isset($data['user_message']) ? $data['user_message'] : null;
        $this->container['user_params_message'] = isset($data['user_params_message']) ? $data['user_params_message'] : null;
        $this->container['error_code'] = isset($data['error_code']) ? $data['error_code'] : null;
        $this->container['correlation_id'] = isset($data['correlation_id']) ? $data['correlation_id'] : null;
        $this->container['user_params'] = isset($data['user_params']) ? $data['user_params'] : null;
        $this->container['insert_date'] = isset($data['insert_date']) ? $data['insert_date'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets status_code
     * @return int
     */
    public function getStatusCode()
    {
        return $this->container['status_code'];
    }

    /**
     * Sets status_code
     * @param int $status_code
     * @return $this
     */
    public function setStatusCode($status_code)
    {
        $this->container['status_code'] = $status_code;

        return $this;
    }

    /**
     * Gets user_message
     * @return object
     */
    public function getUserMessage()
    {
        return $this->container['user_message'];
    }

    /**
     * Sets user_message
     * @param object $user_message
     * @return $this
     */
    public function setUserMessage($user_message)
    {
        $this->container['user_message'] = $user_message;

        return $this;
    }

    /**
     * Gets user_params_message
     * @return string
     */
    public function getUserParamsMessage()
    {
        return $this->container['user_params_message'];
    }

    /**
     * Sets user_params_message
     * @param string $user_params_message
     * @return $this
     */
    public function setUserParamsMessage($user_params_message)
    {
        $this->container['user_params_message'] = $user_params_message;

        return $this;
    }

    /**
     * Gets error_code
     * @return string
     */
    public function getErrorCode()
    {
        return $this->container['error_code'];
    }

    /**
     * Sets error_code
     * @param string $error_code
     * @return $this
     */
    public function setErrorCode($error_code)
    {
        $this->container['error_code'] = $error_code;

        return $this;
    }

    /**
     * Gets correlation_id
     * @return string
     */
    public function getCorrelationId()
    {
        return $this->container['correlation_id'];
    }

    /**
     * Sets correlation_id
     * @param string $correlation_id
     * @return $this
     */
    public function setCorrelationId($correlation_id)
    {
        $this->container['correlation_id'] = $correlation_id;

        return $this;
    }

    /**
     * Gets user_params
     * @return \PureCloudSDK\UserParam[]
     */
    public function getUserParams()
    {
        return $this->container['user_params'];
    }

    /**
     * Sets user_params
     * @param \PureCloudSDK\UserParam[] $user_params
     * @return $this
     */
    public function setUserParams($user_params)
    {
        $this->container['user_params'] = $user_params;

        return $this;
    }

    /**
     * Gets insert_date
     * @return \DateTime
     */
    public function getInsertDate()
    {
        return $this->container['insert_date'];
    }

    /**
     * Sets insert_date
     * @param \DateTime $insert_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setInsertDate($insert_date)
    {
        $this->container['insert_date'] = $insert_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


