<?php
/**
 * QueryRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * QueryRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class QueryRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'QueryRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'query_phrase' => 'string',
        'page_number' => 'int',
        'page_size' => 'int',
        'facet_name_requests' => 'string[]',
        'sort' => '\PureCloudSDK\SortItem[]',
        'filters' => '\PureCloudSDK\ContentFilterItem[]',
        'attribute_filters' => '\PureCloudSDK\AttributeFilterItem[]',
        'include_shares' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'query_phrase' => 'queryPhrase',
        'page_number' => 'pageNumber',
        'page_size' => 'pageSize',
        'facet_name_requests' => 'facetNameRequests',
        'sort' => 'sort',
        'filters' => 'filters',
        'attribute_filters' => 'attributeFilters',
        'include_shares' => 'includeShares'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'query_phrase' => 'setQueryPhrase',
        'page_number' => 'setPageNumber',
        'page_size' => 'setPageSize',
        'facet_name_requests' => 'setFacetNameRequests',
        'sort' => 'setSort',
        'filters' => 'setFilters',
        'attribute_filters' => 'setAttributeFilters',
        'include_shares' => 'setIncludeShares'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'query_phrase' => 'getQueryPhrase',
        'page_number' => 'getPageNumber',
        'page_size' => 'getPageSize',
        'facet_name_requests' => 'getFacetNameRequests',
        'sort' => 'getSort',
        'filters' => 'getFilters',
        'attribute_filters' => 'getAttributeFilters',
        'include_shares' => 'getIncludeShares'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['query_phrase'] = isset($data['query_phrase']) ? $data['query_phrase'] : null;
        $this->container['page_number'] = isset($data['page_number']) ? $data['page_number'] : null;
        $this->container['page_size'] = isset($data['page_size']) ? $data['page_size'] : null;
        $this->container['facet_name_requests'] = isset($data['facet_name_requests']) ? $data['facet_name_requests'] : null;
        $this->container['sort'] = isset($data['sort']) ? $data['sort'] : null;
        $this->container['filters'] = isset($data['filters']) ? $data['filters'] : null;
        $this->container['attribute_filters'] = isset($data['attribute_filters']) ? $data['attribute_filters'] : null;
        $this->container['include_shares'] = isset($data['include_shares']) ? $data['include_shares'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets query_phrase
     * @return string
     */
    public function getQueryPhrase()
    {
        return $this->container['query_phrase'];
    }

    /**
     * Sets query_phrase
     * @param string $query_phrase
     * @return $this
     */
    public function setQueryPhrase($query_phrase)
    {
        $this->container['query_phrase'] = $query_phrase;

        return $this;
    }

    /**
     * Gets page_number
     * @return int
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     * @param int $page_number
     * @return $this
     */
    public function setPageNumber($page_number)
    {
        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets page_size
     * @return int
     */
    public function getPageSize()
    {
        return $this->container['page_size'];
    }

    /**
     * Sets page_size
     * @param int $page_size
     * @return $this
     */
    public function setPageSize($page_size)
    {
        $this->container['page_size'] = $page_size;

        return $this;
    }

    /**
     * Gets facet_name_requests
     * @return string[]
     */
    public function getFacetNameRequests()
    {
        return $this->container['facet_name_requests'];
    }

    /**
     * Sets facet_name_requests
     * @param string[] $facet_name_requests
     * @return $this
     */
    public function setFacetNameRequests($facet_name_requests)
    {
        $this->container['facet_name_requests'] = $facet_name_requests;

        return $this;
    }

    /**
     * Gets sort
     * @return \PureCloudSDK\SortItem[]
     */
    public function getSort()
    {
        return $this->container['sort'];
    }

    /**
     * Sets sort
     * @param \PureCloudSDK\SortItem[] $sort
     * @return $this
     */
    public function setSort($sort)
    {
        $this->container['sort'] = $sort;

        return $this;
    }

    /**
     * Gets filters
     * @return \PureCloudSDK\ContentFilterItem[]
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     * @param \PureCloudSDK\ContentFilterItem[] $filters
     * @return $this
     */
    public function setFilters($filters)
    {
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets attribute_filters
     * @return \PureCloudSDK\AttributeFilterItem[]
     */
    public function getAttributeFilters()
    {
        return $this->container['attribute_filters'];
    }

    /**
     * Sets attribute_filters
     * @param \PureCloudSDK\AttributeFilterItem[] $attribute_filters
     * @return $this
     */
    public function setAttributeFilters($attribute_filters)
    {
        $this->container['attribute_filters'] = $attribute_filters;

        return $this;
    }

    /**
     * Gets include_shares
     * @return bool
     */
    public function getIncludeShares()
    {
        return $this->container['include_shares'];
    }

    /**
     * Sets include_shares
     * @param bool $include_shares
     * @return $this
     */
    public function setIncludeShares($include_shares)
    {
        $this->container['include_shares'] = $include_shares;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


