<?php
/**
 * QuestionGroup
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * QuestionGroup Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class QuestionGroup implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'QuestionGroup';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'type' => 'string',
        'default_answers_to_highest' => 'bool',
        'default_answers_to_na' => 'bool',
        'na_enabled' => 'bool',
        'weight' => 'float',
        'manual_weight' => 'bool',
        'questions' => 'map[string,object][]',
        'visibility_condition' => '\PureCloudSDK\VisibilityCondition'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'type' => 'type',
        'default_answers_to_highest' => 'defaultAnswersToHighest',
        'default_answers_to_na' => 'defaultAnswersToNA',
        'na_enabled' => 'naEnabled',
        'weight' => 'weight',
        'manual_weight' => 'manualWeight',
        'questions' => 'questions',
        'visibility_condition' => 'visibilityCondition'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'type' => 'setType',
        'default_answers_to_highest' => 'setDefaultAnswersToHighest',
        'default_answers_to_na' => 'setDefaultAnswersToNa',
        'na_enabled' => 'setNaEnabled',
        'weight' => 'setWeight',
        'manual_weight' => 'setManualWeight',
        'questions' => 'setQuestions',
        'visibility_condition' => 'setVisibilityCondition'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'type' => 'getType',
        'default_answers_to_highest' => 'getDefaultAnswersToHighest',
        'default_answers_to_na' => 'getDefaultAnswersToNa',
        'na_enabled' => 'getNaEnabled',
        'weight' => 'getWeight',
        'manual_weight' => 'getManualWeight',
        'questions' => 'getQuestions',
        'visibility_condition' => 'getVisibilityCondition'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['default_answers_to_highest'] = isset($data['default_answers_to_highest']) ? $data['default_answers_to_highest'] : false;
        $this->container['default_answers_to_na'] = isset($data['default_answers_to_na']) ? $data['default_answers_to_na'] : false;
        $this->container['na_enabled'] = isset($data['na_enabled']) ? $data['na_enabled'] : false;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['manual_weight'] = isset($data['manual_weight']) ? $data['manual_weight'] : false;
        $this->container['questions'] = isset($data['questions']) ? $data['questions'] : null;
        $this->container['visibility_condition'] = isset($data['visibility_condition']) ? $data['visibility_condition'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets default_answers_to_highest
     * @return bool
     */
    public function getDefaultAnswersToHighest()
    {
        return $this->container['default_answers_to_highest'];
    }

    /**
     * Sets default_answers_to_highest
     * @param bool $default_answers_to_highest
     * @return $this
     */
    public function setDefaultAnswersToHighest($default_answers_to_highest)
    {
        $this->container['default_answers_to_highest'] = $default_answers_to_highest;

        return $this;
    }

    /**
     * Gets default_answers_to_na
     * @return bool
     */
    public function getDefaultAnswersToNa()
    {
        return $this->container['default_answers_to_na'];
    }

    /**
     * Sets default_answers_to_na
     * @param bool $default_answers_to_na
     * @return $this
     */
    public function setDefaultAnswersToNa($default_answers_to_na)
    {
        $this->container['default_answers_to_na'] = $default_answers_to_na;

        return $this;
    }

    /**
     * Gets na_enabled
     * @return bool
     */
    public function getNaEnabled()
    {
        return $this->container['na_enabled'];
    }

    /**
     * Sets na_enabled
     * @param bool $na_enabled
     * @return $this
     */
    public function setNaEnabled($na_enabled)
    {
        $this->container['na_enabled'] = $na_enabled;

        return $this;
    }

    /**
     * Gets weight
     * @return float
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     * @param float $weight
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets manual_weight
     * @return bool
     */
    public function getManualWeight()
    {
        return $this->container['manual_weight'];
    }

    /**
     * Sets manual_weight
     * @param bool $manual_weight
     * @return $this
     */
    public function setManualWeight($manual_weight)
    {
        $this->container['manual_weight'] = $manual_weight;

        return $this;
    }

    /**
     * Gets questions
     * @return map[string,object][]
     */
    public function getQuestions()
    {
        return $this->container['questions'];
    }

    /**
     * Sets questions
     * @param map[string,object][] $questions
     * @return $this
     */
    public function setQuestions($questions)
    {
        $this->container['questions'] = $questions;

        return $this;
    }

    /**
     * Gets visibility_condition
     * @return \PureCloudSDK\VisibilityCondition
     */
    public function getVisibilityCondition()
    {
        return $this->container['visibility_condition'];
    }

    /**
     * Sets visibility_condition
     * @param \PureCloudSDK\VisibilityCondition $visibility_condition
     * @return $this
     */
    public function setVisibilityCondition($visibility_condition)
    {
        $this->container['visibility_condition'] = $visibility_condition;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


