<?php
/**
 * QuestionGroupScore
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * QuestionGroupScore Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class QuestionGroupScore implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'QuestionGroupScore';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'question_group_id' => 'string',
        'total_score' => 'float',
        'max_total_score' => 'float',
        'total_critical_score' => 'float',
        'max_total_critical_score' => 'float',
        'total_score_unweighted' => 'float',
        'max_total_score_unweighted' => 'float',
        'total_critical_score_unweighted' => 'float',
        'max_total_critical_score_unweighted' => 'float',
        'marked_na' => 'bool',
        'question_scores' => '\PureCloudSDK\QuestionScore[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'question_group_id' => 'questionGroupId',
        'total_score' => 'totalScore',
        'max_total_score' => 'maxTotalScore',
        'total_critical_score' => 'totalCriticalScore',
        'max_total_critical_score' => 'maxTotalCriticalScore',
        'total_score_unweighted' => 'totalScoreUnweighted',
        'max_total_score_unweighted' => 'maxTotalScoreUnweighted',
        'total_critical_score_unweighted' => 'totalCriticalScoreUnweighted',
        'max_total_critical_score_unweighted' => 'maxTotalCriticalScoreUnweighted',
        'marked_na' => 'markedNA',
        'question_scores' => 'questionScores'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'question_group_id' => 'setQuestionGroupId',
        'total_score' => 'setTotalScore',
        'max_total_score' => 'setMaxTotalScore',
        'total_critical_score' => 'setTotalCriticalScore',
        'max_total_critical_score' => 'setMaxTotalCriticalScore',
        'total_score_unweighted' => 'setTotalScoreUnweighted',
        'max_total_score_unweighted' => 'setMaxTotalScoreUnweighted',
        'total_critical_score_unweighted' => 'setTotalCriticalScoreUnweighted',
        'max_total_critical_score_unweighted' => 'setMaxTotalCriticalScoreUnweighted',
        'marked_na' => 'setMarkedNa',
        'question_scores' => 'setQuestionScores'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'question_group_id' => 'getQuestionGroupId',
        'total_score' => 'getTotalScore',
        'max_total_score' => 'getMaxTotalScore',
        'total_critical_score' => 'getTotalCriticalScore',
        'max_total_critical_score' => 'getMaxTotalCriticalScore',
        'total_score_unweighted' => 'getTotalScoreUnweighted',
        'max_total_score_unweighted' => 'getMaxTotalScoreUnweighted',
        'total_critical_score_unweighted' => 'getTotalCriticalScoreUnweighted',
        'max_total_critical_score_unweighted' => 'getMaxTotalCriticalScoreUnweighted',
        'marked_na' => 'getMarkedNa',
        'question_scores' => 'getQuestionScores'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['question_group_id'] = isset($data['question_group_id']) ? $data['question_group_id'] : null;
        $this->container['total_score'] = isset($data['total_score']) ? $data['total_score'] : null;
        $this->container['max_total_score'] = isset($data['max_total_score']) ? $data['max_total_score'] : null;
        $this->container['total_critical_score'] = isset($data['total_critical_score']) ? $data['total_critical_score'] : null;
        $this->container['max_total_critical_score'] = isset($data['max_total_critical_score']) ? $data['max_total_critical_score'] : null;
        $this->container['total_score_unweighted'] = isset($data['total_score_unweighted']) ? $data['total_score_unweighted'] : null;
        $this->container['max_total_score_unweighted'] = isset($data['max_total_score_unweighted']) ? $data['max_total_score_unweighted'] : null;
        $this->container['total_critical_score_unweighted'] = isset($data['total_critical_score_unweighted']) ? $data['total_critical_score_unweighted'] : null;
        $this->container['max_total_critical_score_unweighted'] = isset($data['max_total_critical_score_unweighted']) ? $data['max_total_critical_score_unweighted'] : null;
        $this->container['marked_na'] = isset($data['marked_na']) ? $data['marked_na'] : false;
        $this->container['question_scores'] = isset($data['question_scores']) ? $data['question_scores'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets question_group_id
     * @return string
     */
    public function getQuestionGroupId()
    {
        return $this->container['question_group_id'];
    }

    /**
     * Sets question_group_id
     * @param string $question_group_id
     * @return $this
     */
    public function setQuestionGroupId($question_group_id)
    {
        $this->container['question_group_id'] = $question_group_id;

        return $this;
    }

    /**
     * Gets total_score
     * @return float
     */
    public function getTotalScore()
    {
        return $this->container['total_score'];
    }

    /**
     * Sets total_score
     * @param float $total_score
     * @return $this
     */
    public function setTotalScore($total_score)
    {
        $this->container['total_score'] = $total_score;

        return $this;
    }

    /**
     * Gets max_total_score
     * @return float
     */
    public function getMaxTotalScore()
    {
        return $this->container['max_total_score'];
    }

    /**
     * Sets max_total_score
     * @param float $max_total_score
     * @return $this
     */
    public function setMaxTotalScore($max_total_score)
    {
        $this->container['max_total_score'] = $max_total_score;

        return $this;
    }

    /**
     * Gets total_critical_score
     * @return float
     */
    public function getTotalCriticalScore()
    {
        return $this->container['total_critical_score'];
    }

    /**
     * Sets total_critical_score
     * @param float $total_critical_score
     * @return $this
     */
    public function setTotalCriticalScore($total_critical_score)
    {
        $this->container['total_critical_score'] = $total_critical_score;

        return $this;
    }

    /**
     * Gets max_total_critical_score
     * @return float
     */
    public function getMaxTotalCriticalScore()
    {
        return $this->container['max_total_critical_score'];
    }

    /**
     * Sets max_total_critical_score
     * @param float $max_total_critical_score
     * @return $this
     */
    public function setMaxTotalCriticalScore($max_total_critical_score)
    {
        $this->container['max_total_critical_score'] = $max_total_critical_score;

        return $this;
    }

    /**
     * Gets total_score_unweighted
     * @return float
     */
    public function getTotalScoreUnweighted()
    {
        return $this->container['total_score_unweighted'];
    }

    /**
     * Sets total_score_unweighted
     * @param float $total_score_unweighted
     * @return $this
     */
    public function setTotalScoreUnweighted($total_score_unweighted)
    {
        $this->container['total_score_unweighted'] = $total_score_unweighted;

        return $this;
    }

    /**
     * Gets max_total_score_unweighted
     * @return float
     */
    public function getMaxTotalScoreUnweighted()
    {
        return $this->container['max_total_score_unweighted'];
    }

    /**
     * Sets max_total_score_unweighted
     * @param float $max_total_score_unweighted
     * @return $this
     */
    public function setMaxTotalScoreUnweighted($max_total_score_unweighted)
    {
        $this->container['max_total_score_unweighted'] = $max_total_score_unweighted;

        return $this;
    }

    /**
     * Gets total_critical_score_unweighted
     * @return float
     */
    public function getTotalCriticalScoreUnweighted()
    {
        return $this->container['total_critical_score_unweighted'];
    }

    /**
     * Sets total_critical_score_unweighted
     * @param float $total_critical_score_unweighted
     * @return $this
     */
    public function setTotalCriticalScoreUnweighted($total_critical_score_unweighted)
    {
        $this->container['total_critical_score_unweighted'] = $total_critical_score_unweighted;

        return $this;
    }

    /**
     * Gets max_total_critical_score_unweighted
     * @return float
     */
    public function getMaxTotalCriticalScoreUnweighted()
    {
        return $this->container['max_total_critical_score_unweighted'];
    }

    /**
     * Sets max_total_critical_score_unweighted
     * @param float $max_total_critical_score_unweighted
     * @return $this
     */
    public function setMaxTotalCriticalScoreUnweighted($max_total_critical_score_unweighted)
    {
        $this->container['max_total_critical_score_unweighted'] = $max_total_critical_score_unweighted;

        return $this;
    }

    /**
     * Gets marked_na
     * @return bool
     */
    public function getMarkedNa()
    {
        return $this->container['marked_na'];
    }

    /**
     * Sets marked_na
     * @param bool $marked_na
     * @return $this
     */
    public function setMarkedNa($marked_na)
    {
        $this->container['marked_na'] = $marked_na;

        return $this;
    }

    /**
     * Gets question_scores
     * @return \PureCloudSDK\QuestionScore[]
     */
    public function getQuestionScores()
    {
        return $this->container['question_scores'];
    }

    /**
     * Sets question_scores
     * @param \PureCloudSDK\QuestionScore[] $question_scores
     * @return $this
     */
    public function setQuestionScores($question_scores)
    {
        $this->container['question_scores'] = $question_scores;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


