<?php
/**
 * QueueUtilizationDiagnostic
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * QueueUtilizationDiagnostic Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class QueueUtilizationDiagnostic implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'QueueUtilizationDiagnostic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'queue' => '\PureCloudSDK\UriReference',
        'users_in_queue' => 'int',
        'active_users_in_queue' => 'int',
        'users_on_queue' => 'int',
        'users_not_utilized' => 'int',
        'users_on_queue_with_station' => 'int',
        'users_on_a_campaign_call' => 'int',
        'users_on_different_edge_group' => 'int',
        'users_on_a_non_campaign_call' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'queue' => 'queue',
        'users_in_queue' => 'usersInQueue',
        'active_users_in_queue' => 'activeUsersInQueue',
        'users_on_queue' => 'usersOnQueue',
        'users_not_utilized' => 'usersNotUtilized',
        'users_on_queue_with_station' => 'usersOnQueueWithStation',
        'users_on_a_campaign_call' => 'usersOnACampaignCall',
        'users_on_different_edge_group' => 'usersOnDifferentEdgeGroup',
        'users_on_a_non_campaign_call' => 'usersOnANonCampaignCall'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'queue' => 'setQueue',
        'users_in_queue' => 'setUsersInQueue',
        'active_users_in_queue' => 'setActiveUsersInQueue',
        'users_on_queue' => 'setUsersOnQueue',
        'users_not_utilized' => 'setUsersNotUtilized',
        'users_on_queue_with_station' => 'setUsersOnQueueWithStation',
        'users_on_a_campaign_call' => 'setUsersOnACampaignCall',
        'users_on_different_edge_group' => 'setUsersOnDifferentEdgeGroup',
        'users_on_a_non_campaign_call' => 'setUsersOnANonCampaignCall'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'queue' => 'getQueue',
        'users_in_queue' => 'getUsersInQueue',
        'active_users_in_queue' => 'getActiveUsersInQueue',
        'users_on_queue' => 'getUsersOnQueue',
        'users_not_utilized' => 'getUsersNotUtilized',
        'users_on_queue_with_station' => 'getUsersOnQueueWithStation',
        'users_on_a_campaign_call' => 'getUsersOnACampaignCall',
        'users_on_different_edge_group' => 'getUsersOnDifferentEdgeGroup',
        'users_on_a_non_campaign_call' => 'getUsersOnANonCampaignCall'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['users_in_queue'] = isset($data['users_in_queue']) ? $data['users_in_queue'] : null;
        $this->container['active_users_in_queue'] = isset($data['active_users_in_queue']) ? $data['active_users_in_queue'] : null;
        $this->container['users_on_queue'] = isset($data['users_on_queue']) ? $data['users_on_queue'] : null;
        $this->container['users_not_utilized'] = isset($data['users_not_utilized']) ? $data['users_not_utilized'] : null;
        $this->container['users_on_queue_with_station'] = isset($data['users_on_queue_with_station']) ? $data['users_on_queue_with_station'] : null;
        $this->container['users_on_a_campaign_call'] = isset($data['users_on_a_campaign_call']) ? $data['users_on_a_campaign_call'] : null;
        $this->container['users_on_different_edge_group'] = isset($data['users_on_different_edge_group']) ? $data['users_on_different_edge_group'] : null;
        $this->container['users_on_a_non_campaign_call'] = isset($data['users_on_a_non_campaign_call']) ? $data['users_on_a_non_campaign_call'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue Identifier of the queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets users_in_queue
     * @return int
     */
    public function getUsersInQueue()
    {
        return $this->container['users_in_queue'];
    }

    /**
     * Sets users_in_queue
     * @param int $users_in_queue The number of users joined to the queue
     * @return $this
     */
    public function setUsersInQueue($users_in_queue)
    {
        $this->container['users_in_queue'] = $users_in_queue;

        return $this;
    }

    /**
     * Gets active_users_in_queue
     * @return int
     */
    public function getActiveUsersInQueue()
    {
        return $this->container['active_users_in_queue'];
    }

    /**
     * Sets active_users_in_queue
     * @param int $active_users_in_queue The number of users active on the queue
     * @return $this
     */
    public function setActiveUsersInQueue($active_users_in_queue)
    {
        $this->container['active_users_in_queue'] = $active_users_in_queue;

        return $this;
    }

    /**
     * Gets users_on_queue
     * @return int
     */
    public function getUsersOnQueue()
    {
        return $this->container['users_on_queue'];
    }

    /**
     * Sets users_on_queue
     * @param int $users_on_queue The number of users with a status of on-queue
     * @return $this
     */
    public function setUsersOnQueue($users_on_queue)
    {
        $this->container['users_on_queue'] = $users_on_queue;

        return $this;
    }

    /**
     * Gets users_not_utilized
     * @return int
     */
    public function getUsersNotUtilized()
    {
        return $this->container['users_not_utilized'];
    }

    /**
     * Sets users_not_utilized
     * @param int $users_not_utilized The number of users in the queue currently not engaged
     * @return $this
     */
    public function setUsersNotUtilized($users_not_utilized)
    {
        $this->container['users_not_utilized'] = $users_not_utilized;

        return $this;
    }

    /**
     * Gets users_on_queue_with_station
     * @return int
     */
    public function getUsersOnQueueWithStation()
    {
        return $this->container['users_on_queue_with_station'];
    }

    /**
     * Sets users_on_queue_with_station
     * @param int $users_on_queue_with_station The number of users in the queue with a station
     * @return $this
     */
    public function setUsersOnQueueWithStation($users_on_queue_with_station)
    {
        $this->container['users_on_queue_with_station'] = $users_on_queue_with_station;

        return $this;
    }

    /**
     * Gets users_on_a_campaign_call
     * @return int
     */
    public function getUsersOnACampaignCall()
    {
        return $this->container['users_on_a_campaign_call'];
    }

    /**
     * Sets users_on_a_campaign_call
     * @param int $users_on_a_campaign_call The number of users currently engaged in a campaign call
     * @return $this
     */
    public function setUsersOnACampaignCall($users_on_a_campaign_call)
    {
        $this->container['users_on_a_campaign_call'] = $users_on_a_campaign_call;

        return $this;
    }

    /**
     * Gets users_on_different_edge_group
     * @return int
     */
    public function getUsersOnDifferentEdgeGroup()
    {
        return $this->container['users_on_different_edge_group'];
    }

    /**
     * Sets users_on_different_edge_group
     * @param int $users_on_different_edge_group The number of users whose station is homed to an edge different from the campaign
     * @return $this
     */
    public function setUsersOnDifferentEdgeGroup($users_on_different_edge_group)
    {
        $this->container['users_on_different_edge_group'] = $users_on_different_edge_group;

        return $this;
    }

    /**
     * Gets users_on_a_non_campaign_call
     * @return int
     */
    public function getUsersOnANonCampaignCall()
    {
        return $this->container['users_on_a_non_campaign_call'];
    }

    /**
     * Sets users_on_a_non_campaign_call
     * @param int $users_on_a_non_campaign_call The number of users currently engaged in a communication that is not part of the campaign
     * @return $this
     */
    public function setUsersOnANonCampaignCall($users_on_a_non_campaign_call)
    {
        $this->container['users_on_a_non_campaign_call'] = $users_on_a_non_campaign_call;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


