<?php
/**
 * Recording
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Recording Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Recording implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Recording';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'conversation_id' => 'string',
        'path' => 'string',
        'start_time' => 'string',
        'end_time' => 'string',
        'media' => 'string',
        'annotations' => '\PureCloudSDK\Annotation[]',
        'transcript' => '\PureCloudSDK\ChatMessage[]',
        'email_transcript' => '\PureCloudSDK\RecordingEmailMessage[]',
        'file_state' => 'string',
        'restore_expiration_time' => '\DateTime',
        'media_uris' => 'map[string,\PureCloudSDK\MediaResult]',
        'estimated_transcode_time_ms' => 'int',
        'actual_transcode_time_ms' => 'int',
        'archive_date' => '\DateTime',
        'archive_medium' => 'string',
        'delete_date' => '\DateTime',
        'max_allowed_restorations_for_org' => 'int',
        'remaining_restorations_allowed_for_org' => 'int',
        'session_id' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'conversation_id' => 'conversationId',
        'path' => 'path',
        'start_time' => 'startTime',
        'end_time' => 'endTime',
        'media' => 'media',
        'annotations' => 'annotations',
        'transcript' => 'transcript',
        'email_transcript' => 'emailTranscript',
        'file_state' => 'fileState',
        'restore_expiration_time' => 'restoreExpirationTime',
        'media_uris' => 'mediaUris',
        'estimated_transcode_time_ms' => 'estimatedTranscodeTimeMs',
        'actual_transcode_time_ms' => 'actualTranscodeTimeMs',
        'archive_date' => 'archiveDate',
        'archive_medium' => 'archiveMedium',
        'delete_date' => 'deleteDate',
        'max_allowed_restorations_for_org' => 'maxAllowedRestorationsForOrg',
        'remaining_restorations_allowed_for_org' => 'remainingRestorationsAllowedForOrg',
        'session_id' => 'sessionId',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'conversation_id' => 'setConversationId',
        'path' => 'setPath',
        'start_time' => 'setStartTime',
        'end_time' => 'setEndTime',
        'media' => 'setMedia',
        'annotations' => 'setAnnotations',
        'transcript' => 'setTranscript',
        'email_transcript' => 'setEmailTranscript',
        'file_state' => 'setFileState',
        'restore_expiration_time' => 'setRestoreExpirationTime',
        'media_uris' => 'setMediaUris',
        'estimated_transcode_time_ms' => 'setEstimatedTranscodeTimeMs',
        'actual_transcode_time_ms' => 'setActualTranscodeTimeMs',
        'archive_date' => 'setArchiveDate',
        'archive_medium' => 'setArchiveMedium',
        'delete_date' => 'setDeleteDate',
        'max_allowed_restorations_for_org' => 'setMaxAllowedRestorationsForOrg',
        'remaining_restorations_allowed_for_org' => 'setRemainingRestorationsAllowedForOrg',
        'session_id' => 'setSessionId',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'conversation_id' => 'getConversationId',
        'path' => 'getPath',
        'start_time' => 'getStartTime',
        'end_time' => 'getEndTime',
        'media' => 'getMedia',
        'annotations' => 'getAnnotations',
        'transcript' => 'getTranscript',
        'email_transcript' => 'getEmailTranscript',
        'file_state' => 'getFileState',
        'restore_expiration_time' => 'getRestoreExpirationTime',
        'media_uris' => 'getMediaUris',
        'estimated_transcode_time_ms' => 'getEstimatedTranscodeTimeMs',
        'actual_transcode_time_ms' => 'getActualTranscodeTimeMs',
        'archive_date' => 'getArchiveDate',
        'archive_medium' => 'getArchiveMedium',
        'delete_date' => 'getDeleteDate',
        'max_allowed_restorations_for_org' => 'getMaxAllowedRestorationsForOrg',
        'remaining_restorations_allowed_for_org' => 'getRemainingRestorationsAllowedForOrg',
        'session_id' => 'getSessionId',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const FILE_STATE_ARCHIVED = 'ARCHIVED';
    const FILE_STATE_AVAILABLE = 'AVAILABLE';
    const FILE_STATE_DELETED = 'DELETED';
    const FILE_STATE_RESTORED = 'RESTORED';
    const FILE_STATE_RESTORING = 'RESTORING';
    const FILE_STATE_UPLOADING = 'UPLOADING';
    const ARCHIVE_MEDIUM_CLOUDARCHIVE = 'CLOUDARCHIVE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFileStateAllowableValues()
    {
        return [
            self::FILE_STATE_ARCHIVED,
            self::FILE_STATE_AVAILABLE,
            self::FILE_STATE_DELETED,
            self::FILE_STATE_RESTORED,
            self::FILE_STATE_RESTORING,
            self::FILE_STATE_UPLOADING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getArchiveMediumAllowableValues()
    {
        return [
            self::ARCHIVE_MEDIUM_CLOUDARCHIVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['conversation_id'] = isset($data['conversation_id']) ? $data['conversation_id'] : null;
        $this->container['path'] = isset($data['path']) ? $data['path'] : null;
        $this->container['start_time'] = isset($data['start_time']) ? $data['start_time'] : null;
        $this->container['end_time'] = isset($data['end_time']) ? $data['end_time'] : null;
        $this->container['media'] = isset($data['media']) ? $data['media'] : null;
        $this->container['annotations'] = isset($data['annotations']) ? $data['annotations'] : null;
        $this->container['transcript'] = isset($data['transcript']) ? $data['transcript'] : null;
        $this->container['email_transcript'] = isset($data['email_transcript']) ? $data['email_transcript'] : null;
        $this->container['file_state'] = isset($data['file_state']) ? $data['file_state'] : null;
        $this->container['restore_expiration_time'] = isset($data['restore_expiration_time']) ? $data['restore_expiration_time'] : null;
        $this->container['media_uris'] = isset($data['media_uris']) ? $data['media_uris'] : null;
        $this->container['estimated_transcode_time_ms'] = isset($data['estimated_transcode_time_ms']) ? $data['estimated_transcode_time_ms'] : null;
        $this->container['actual_transcode_time_ms'] = isset($data['actual_transcode_time_ms']) ? $data['actual_transcode_time_ms'] : null;
        $this->container['archive_date'] = isset($data['archive_date']) ? $data['archive_date'] : null;
        $this->container['archive_medium'] = isset($data['archive_medium']) ? $data['archive_medium'] : null;
        $this->container['delete_date'] = isset($data['delete_date']) ? $data['delete_date'] : null;
        $this->container['max_allowed_restorations_for_org'] = isset($data['max_allowed_restorations_for_org']) ? $data['max_allowed_restorations_for_org'] : null;
        $this->container['remaining_restorations_allowed_for_org'] = isset($data['remaining_restorations_allowed_for_org']) ? $data['remaining_restorations_allowed_for_org'] : null;
        $this->container['session_id'] = isset($data['session_id']) ? $data['session_id'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING");
        if (!in_array($this->container['file_state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'file_state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CLOUDARCHIVE");
        if (!in_array($this->container['archive_medium'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'archive_medium', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING");
        if (!in_array($this->container['file_state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CLOUDARCHIVE");
        if (!in_array($this->container['archive_medium'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets conversation_id
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversation_id'];
    }

    /**
     * Sets conversation_id
     * @param string $conversation_id
     * @return $this
     */
    public function setConversationId($conversation_id)
    {
        $this->container['conversation_id'] = $conversation_id;

        return $this;
    }

    /**
     * Gets path
     * @return string
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     * @param string $path
     * @return $this
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets start_time
     * @return string
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     * @param string $start_time
     * @return $this
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets end_time
     * @return string
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     * @param string $end_time
     * @return $this
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets media
     * @return string
     */
    public function getMedia()
    {
        return $this->container['media'];
    }

    /**
     * Sets media
     * @param string $media The type of media that the recording is. At the moment that could be audio, chat, or email.
     * @return $this
     */
    public function setMedia($media)
    {
        $this->container['media'] = $media;

        return $this;
    }

    /**
     * Gets annotations
     * @return \PureCloudSDK\Annotation[]
     */
    public function getAnnotations()
    {
        return $this->container['annotations'];
    }

    /**
     * Sets annotations
     * @param \PureCloudSDK\Annotation[] $annotations Annotations that belong to the recording.
     * @return $this
     */
    public function setAnnotations($annotations)
    {
        $this->container['annotations'] = $annotations;

        return $this;
    }

    /**
     * Gets transcript
     * @return \PureCloudSDK\ChatMessage[]
     */
    public function getTranscript()
    {
        return $this->container['transcript'];
    }

    /**
     * Sets transcript
     * @param \PureCloudSDK\ChatMessage[] $transcript Represents a chat transcript
     * @return $this
     */
    public function setTranscript($transcript)
    {
        $this->container['transcript'] = $transcript;

        return $this;
    }

    /**
     * Gets email_transcript
     * @return \PureCloudSDK\RecordingEmailMessage[]
     */
    public function getEmailTranscript()
    {
        return $this->container['email_transcript'];
    }

    /**
     * Sets email_transcript
     * @param \PureCloudSDK\RecordingEmailMessage[] $email_transcript Represents an email transcript
     * @return $this
     */
    public function setEmailTranscript($email_transcript)
    {
        $this->container['email_transcript'] = $email_transcript;

        return $this;
    }

    /**
     * Gets file_state
     * @return string
     */
    public function getFileState()
    {
        return $this->container['file_state'];
    }

    /**
     * Sets file_state
     * @param string $file_state Represents the current file state for a recording. Examples: Uploading, Archived, etc
     * @return $this
     */
    public function setFileState($file_state)
    {
        $allowed_values = array('ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING');
        if (!in_array($file_state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'file_state', must be one of 'ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING'");
        }
        $this->container['file_state'] = $file_state;

        return $this;
    }

    /**
     * Gets restore_expiration_time
     * @return \DateTime
     */
    public function getRestoreExpirationTime()
    {
        return $this->container['restore_expiration_time'];
    }

    /**
     * Sets restore_expiration_time
     * @param \DateTime $restore_expiration_time The amount of time a restored recording will remain restored before being archived again. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRestoreExpirationTime($restore_expiration_time)
    {
        $this->container['restore_expiration_time'] = $restore_expiration_time;

        return $this;
    }

    /**
     * Gets media_uris
     * @return map[string,\PureCloudSDK\MediaResult]
     */
    public function getMediaUris()
    {
        return $this->container['media_uris'];
    }

    /**
     * Sets media_uris
     * @param map[string,\PureCloudSDK\MediaResult] $media_uris The different mediaUris for the recording.
     * @return $this
     */
    public function setMediaUris($media_uris)
    {
        $this->container['media_uris'] = $media_uris;

        return $this;
    }

    /**
     * Gets estimated_transcode_time_ms
     * @return int
     */
    public function getEstimatedTranscodeTimeMs()
    {
        return $this->container['estimated_transcode_time_ms'];
    }

    /**
     * Sets estimated_transcode_time_ms
     * @param int $estimated_transcode_time_ms
     * @return $this
     */
    public function setEstimatedTranscodeTimeMs($estimated_transcode_time_ms)
    {
        $this->container['estimated_transcode_time_ms'] = $estimated_transcode_time_ms;

        return $this;
    }

    /**
     * Gets actual_transcode_time_ms
     * @return int
     */
    public function getActualTranscodeTimeMs()
    {
        return $this->container['actual_transcode_time_ms'];
    }

    /**
     * Sets actual_transcode_time_ms
     * @param int $actual_transcode_time_ms
     * @return $this
     */
    public function setActualTranscodeTimeMs($actual_transcode_time_ms)
    {
        $this->container['actual_transcode_time_ms'] = $actual_transcode_time_ms;

        return $this;
    }

    /**
     * Gets archive_date
     * @return \DateTime
     */
    public function getArchiveDate()
    {
        return $this->container['archive_date'];
    }

    /**
     * Sets archive_date
     * @param \DateTime $archive_date The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setArchiveDate($archive_date)
    {
        $this->container['archive_date'] = $archive_date;

        return $this;
    }

    /**
     * Gets archive_medium
     * @return string
     */
    public function getArchiveMedium()
    {
        return $this->container['archive_medium'];
    }

    /**
     * Sets archive_medium
     * @param string $archive_medium The type of archive medium used. Example: CloudArchive
     * @return $this
     */
    public function setArchiveMedium($archive_medium)
    {
        $allowed_values = array('CLOUDARCHIVE');
        if (!in_array($archive_medium, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'archive_medium', must be one of 'CLOUDARCHIVE'");
        }
        $this->container['archive_medium'] = $archive_medium;

        return $this;
    }

    /**
     * Gets delete_date
     * @return \DateTime
     */
    public function getDeleteDate()
    {
        return $this->container['delete_date'];
    }

    /**
     * Sets delete_date
     * @param \DateTime $delete_date The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDeleteDate($delete_date)
    {
        $this->container['delete_date'] = $delete_date;

        return $this;
    }

    /**
     * Gets max_allowed_restorations_for_org
     * @return int
     */
    public function getMaxAllowedRestorationsForOrg()
    {
        return $this->container['max_allowed_restorations_for_org'];
    }

    /**
     * Sets max_allowed_restorations_for_org
     * @param int $max_allowed_restorations_for_org How many archive restorations the organization is allowed to have.
     * @return $this
     */
    public function setMaxAllowedRestorationsForOrg($max_allowed_restorations_for_org)
    {
        $this->container['max_allowed_restorations_for_org'] = $max_allowed_restorations_for_org;

        return $this;
    }

    /**
     * Gets remaining_restorations_allowed_for_org
     * @return int
     */
    public function getRemainingRestorationsAllowedForOrg()
    {
        return $this->container['remaining_restorations_allowed_for_org'];
    }

    /**
     * Sets remaining_restorations_allowed_for_org
     * @param int $remaining_restorations_allowed_for_org The remaining archive restorations the organization has.
     * @return $this
     */
    public function setRemainingRestorationsAllowedForOrg($remaining_restorations_allowed_for_org)
    {
        $this->container['remaining_restorations_allowed_for_org'] = $remaining_restorations_allowed_for_org;

        return $this;
    }

    /**
     * Gets session_id
     * @return string
     */
    public function getSessionId()
    {
        return $this->container['session_id'];
    }

    /**
     * Sets session_id
     * @param string $session_id The session id represents an external resource id, such as email, call, chat, etc
     * @return $this
     */
    public function setSessionId($session_id)
    {
        $this->container['session_id'] = $session_id;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


