<?php
/**
 * ReplaceResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ReplaceResponse Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReplaceResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReplaceResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'change_number' => 'int',
        'upload_status' => '\PureCloudSDK\UriReference',
        'upload_destination_uri' => 'string',
        'upload_method' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'change_number' => 'changeNumber',
        'upload_status' => 'uploadStatus',
        'upload_destination_uri' => 'uploadDestinationUri',
        'upload_method' => 'uploadMethod'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'change_number' => 'setChangeNumber',
        'upload_status' => 'setUploadStatus',
        'upload_destination_uri' => 'setUploadDestinationUri',
        'upload_method' => 'setUploadMethod'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'change_number' => 'getChangeNumber',
        'upload_status' => 'getUploadStatus',
        'upload_destination_uri' => 'getUploadDestinationUri',
        'upload_method' => 'getUploadMethod'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const UPLOAD_METHOD_SINGLE_PUT = 'SINGLE_PUT';
    const UPLOAD_METHOD_MULTIPART_POST = 'MULTIPART_POST';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUploadMethodAllowableValues()
    {
        return [
            self::UPLOAD_METHOD_SINGLE_PUT,
            self::UPLOAD_METHOD_MULTIPART_POST,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['change_number'] = isset($data['change_number']) ? $data['change_number'] : null;
        $this->container['upload_status'] = isset($data['upload_status']) ? $data['upload_status'] : null;
        $this->container['upload_destination_uri'] = isset($data['upload_destination_uri']) ? $data['upload_destination_uri'] : null;
        $this->container['upload_method'] = isset($data['upload_method']) ? $data['upload_method'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['upload_method'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'upload_method', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['upload_method'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets change_number
     * @return int
     */
    public function getChangeNumber()
    {
        return $this->container['change_number'];
    }

    /**
     * Sets change_number
     * @param int $change_number
     * @return $this
     */
    public function setChangeNumber($change_number)
    {
        $this->container['change_number'] = $change_number;

        return $this;
    }

    /**
     * Gets upload_status
     * @return \PureCloudSDK\UriReference
     */
    public function getUploadStatus()
    {
        return $this->container['upload_status'];
    }

    /**
     * Sets upload_status
     * @param \PureCloudSDK\UriReference $upload_status
     * @return $this
     */
    public function setUploadStatus($upload_status)
    {
        $this->container['upload_status'] = $upload_status;

        return $this;
    }

    /**
     * Gets upload_destination_uri
     * @return string
     */
    public function getUploadDestinationUri()
    {
        return $this->container['upload_destination_uri'];
    }

    /**
     * Sets upload_destination_uri
     * @param string $upload_destination_uri
     * @return $this
     */
    public function setUploadDestinationUri($upload_destination_uri)
    {
        $this->container['upload_destination_uri'] = $upload_destination_uri;

        return $this;
    }

    /**
     * Gets upload_method
     * @return string
     */
    public function getUploadMethod()
    {
        return $this->container['upload_method'];
    }

    /**
     * Sets upload_method
     * @param string $upload_method
     * @return $this
     */
    public function setUploadMethod($upload_method)
    {
        $allowed_values = array('SINGLE_PUT', 'MULTIPART_POST');
        if (!in_array($upload_method, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'upload_method', must be one of 'SINGLE_PUT', 'MULTIPART_POST'");
        }
        $this->container['upload_method'] = $upload_method;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


