<?php
/**
 * ReportRunEntry
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ReportRunEntry Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReportRunEntry implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReportRunEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'report_id' => 'string',
        'run_time' => '\DateTime',
        'run_status' => 'string',
        'error_message' => 'string',
        'run_duration_msec' => 'int',
        'report_url' => 'string',
        'report_format' => 'string',
        'schedule_uri' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'report_id' => 'reportId',
        'run_time' => 'runTime',
        'run_status' => 'runStatus',
        'error_message' => 'errorMessage',
        'run_duration_msec' => 'runDurationMsec',
        'report_url' => 'reportUrl',
        'report_format' => 'reportFormat',
        'schedule_uri' => 'scheduleUri',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'report_id' => 'setReportId',
        'run_time' => 'setRunTime',
        'run_status' => 'setRunStatus',
        'error_message' => 'setErrorMessage',
        'run_duration_msec' => 'setRunDurationMsec',
        'report_url' => 'setReportUrl',
        'report_format' => 'setReportFormat',
        'schedule_uri' => 'setScheduleUri',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'report_id' => 'getReportId',
        'run_time' => 'getRunTime',
        'run_status' => 'getRunStatus',
        'error_message' => 'getErrorMessage',
        'run_duration_msec' => 'getRunDurationMsec',
        'report_url' => 'getReportUrl',
        'report_format' => 'getReportFormat',
        'schedule_uri' => 'getScheduleUri',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const RUN_STATUS_RUNNING = 'RUNNING';
    const RUN_STATUS_COMPLETED = 'COMPLETED';
    const RUN_STATUS_COMPLETED_WITH_ERRORS = 'COMPLETED_WITH_ERRORS';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRunStatusAllowableValues()
    {
        return [
            self::RUN_STATUS_RUNNING,
            self::RUN_STATUS_COMPLETED,
            self::RUN_STATUS_COMPLETED_WITH_ERRORS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['report_id'] = isset($data['report_id']) ? $data['report_id'] : null;
        $this->container['run_time'] = isset($data['run_time']) ? $data['run_time'] : null;
        $this->container['run_status'] = isset($data['run_status']) ? $data['run_status'] : null;
        $this->container['error_message'] = isset($data['error_message']) ? $data['error_message'] : null;
        $this->container['run_duration_msec'] = isset($data['run_duration_msec']) ? $data['run_duration_msec'] : null;
        $this->container['report_url'] = isset($data['report_url']) ? $data['report_url'] : null;
        $this->container['report_format'] = isset($data['report_format']) ? $data['report_format'] : null;
        $this->container['schedule_uri'] = isset($data['schedule_uri']) ? $data['schedule_uri'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("RUNNING", "COMPLETED", "COMPLETED_WITH_ERRORS");
        if (!in_array($this->container['run_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'run_status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("RUNNING", "COMPLETED", "COMPLETED_WITH_ERRORS");
        if (!in_array($this->container['run_status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets report_id
     * @return string
     */
    public function getReportId()
    {
        return $this->container['report_id'];
    }

    /**
     * Sets report_id
     * @param string $report_id
     * @return $this
     */
    public function setReportId($report_id)
    {
        $this->container['report_id'] = $report_id;

        return $this;
    }

    /**
     * Gets run_time
     * @return \DateTime
     */
    public function getRunTime()
    {
        return $this->container['run_time'];
    }

    /**
     * Sets run_time
     * @param \DateTime $run_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRunTime($run_time)
    {
        $this->container['run_time'] = $run_time;

        return $this;
    }

    /**
     * Gets run_status
     * @return string
     */
    public function getRunStatus()
    {
        return $this->container['run_status'];
    }

    /**
     * Sets run_status
     * @param string $run_status
     * @return $this
     */
    public function setRunStatus($run_status)
    {
        $allowed_values = array('RUNNING', 'COMPLETED', 'COMPLETED_WITH_ERRORS');
        if (!in_array($run_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'run_status', must be one of 'RUNNING', 'COMPLETED', 'COMPLETED_WITH_ERRORS'");
        }
        $this->container['run_status'] = $run_status;

        return $this;
    }

    /**
     * Gets error_message
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['error_message'];
    }

    /**
     * Sets error_message
     * @param string $error_message
     * @return $this
     */
    public function setErrorMessage($error_message)
    {
        $this->container['error_message'] = $error_message;

        return $this;
    }

    /**
     * Gets run_duration_msec
     * @return int
     */
    public function getRunDurationMsec()
    {
        return $this->container['run_duration_msec'];
    }

    /**
     * Sets run_duration_msec
     * @param int $run_duration_msec
     * @return $this
     */
    public function setRunDurationMsec($run_duration_msec)
    {
        $this->container['run_duration_msec'] = $run_duration_msec;

        return $this;
    }

    /**
     * Gets report_url
     * @return string
     */
    public function getReportUrl()
    {
        return $this->container['report_url'];
    }

    /**
     * Sets report_url
     * @param string $report_url
     * @return $this
     */
    public function setReportUrl($report_url)
    {
        $this->container['report_url'] = $report_url;

        return $this;
    }

    /**
     * Gets report_format
     * @return string
     */
    public function getReportFormat()
    {
        return $this->container['report_format'];
    }

    /**
     * Sets report_format
     * @param string $report_format
     * @return $this
     */
    public function setReportFormat($report_format)
    {
        $this->container['report_format'] = $report_format;

        return $this;
    }

    /**
     * Gets schedule_uri
     * @return string
     */
    public function getScheduleUri()
    {
        return $this->container['schedule_uri'];
    }

    /**
     * Sets schedule_uri
     * @param string $schedule_uri
     * @return $this
     */
    public function setScheduleUri($schedule_uri)
    {
        $this->container['schedule_uri'] = $schedule_uri;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


