<?php
/**
 * ReportSchedule
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ReportSchedule Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReportSchedule implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReportSchedule';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'quartz_cron_expression' => 'string',
        'next_fire_time' => '\DateTime',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'description' => 'string',
        'time_zone' => 'string',
        'time_period' => 'string',
        'interval' => 'string',
        'report_format' => 'string',
        'locale' => 'string',
        'enabled' => 'bool',
        'report_id' => 'string',
        'parameters' => 'map[string,object]',
        'last_run' => '\PureCloudSDK\ReportRunEntry',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'quartz_cron_expression' => 'quartzCronExpression',
        'next_fire_time' => 'nextFireTime',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'description' => 'description',
        'time_zone' => 'timeZone',
        'time_period' => 'timePeriod',
        'interval' => 'interval',
        'report_format' => 'reportFormat',
        'locale' => 'locale',
        'enabled' => 'enabled',
        'report_id' => 'reportId',
        'parameters' => 'parameters',
        'last_run' => 'lastRun',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'quartz_cron_expression' => 'setQuartzCronExpression',
        'next_fire_time' => 'setNextFireTime',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'description' => 'setDescription',
        'time_zone' => 'setTimeZone',
        'time_period' => 'setTimePeriod',
        'interval' => 'setInterval',
        'report_format' => 'setReportFormat',
        'locale' => 'setLocale',
        'enabled' => 'setEnabled',
        'report_id' => 'setReportId',
        'parameters' => 'setParameters',
        'last_run' => 'setLastRun',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'quartz_cron_expression' => 'getQuartzCronExpression',
        'next_fire_time' => 'getNextFireTime',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'description' => 'getDescription',
        'time_zone' => 'getTimeZone',
        'time_period' => 'getTimePeriod',
        'interval' => 'getInterval',
        'report_format' => 'getReportFormat',
        'locale' => 'getLocale',
        'enabled' => 'getEnabled',
        'report_id' => 'getReportId',
        'parameters' => 'getParameters',
        'last_run' => 'getLastRun',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['quartz_cron_expression'] = isset($data['quartz_cron_expression']) ? $data['quartz_cron_expression'] : null;
        $this->container['next_fire_time'] = isset($data['next_fire_time']) ? $data['next_fire_time'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['time_zone'] = isset($data['time_zone']) ? $data['time_zone'] : null;
        $this->container['time_period'] = isset($data['time_period']) ? $data['time_period'] : null;
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['report_format'] = isset($data['report_format']) ? $data['report_format'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['report_id'] = isset($data['report_id']) ? $data['report_id'] : null;
        $this->container['parameters'] = isset($data['parameters']) ? $data['parameters'] : null;
        $this->container['last_run'] = isset($data['last_run']) ? $data['last_run'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['quartz_cron_expression'] === null) {
            $invalid_properties[] = "'quartz_cron_expression' can't be null";
        }
        if ($this->container['report_id'] === null) {
            $invalid_properties[] = "'report_id' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['quartz_cron_expression'] === null) {
            return false;
        }
        if ($this->container['report_id'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets quartz_cron_expression
     * @return string
     */
    public function getQuartzCronExpression()
    {
        return $this->container['quartz_cron_expression'];
    }

    /**
     * Sets quartz_cron_expression
     * @param string $quartz_cron_expression Quartz Cron Expression
     * @return $this
     */
    public function setQuartzCronExpression($quartz_cron_expression)
    {
        $this->container['quartz_cron_expression'] = $quartz_cron_expression;

        return $this;
    }

    /**
     * Gets next_fire_time
     * @return \DateTime
     */
    public function getNextFireTime()
    {
        return $this->container['next_fire_time'];
    }

    /**
     * Sets next_fire_time
     * @param \DateTime $next_fire_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setNextFireTime($next_fire_time)
    {
        $this->container['next_fire_time'] = $next_fire_time;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets time_zone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['time_zone'];
    }

    /**
     * Sets time_zone
     * @param string $time_zone
     * @return $this
     */
    public function setTimeZone($time_zone)
    {
        $this->container['time_zone'] = $time_zone;

        return $this;
    }

    /**
     * Gets time_period
     * @return string
     */
    public function getTimePeriod()
    {
        return $this->container['time_period'];
    }

    /**
     * Sets time_period
     * @param string $time_period
     * @return $this
     */
    public function setTimePeriod($time_period)
    {
        $this->container['time_period'] = $time_period;

        return $this;
    }

    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets report_format
     * @return string
     */
    public function getReportFormat()
    {
        return $this->container['report_format'];
    }

    /**
     * Sets report_format
     * @param string $report_format
     * @return $this
     */
    public function setReportFormat($report_format)
    {
        $this->container['report_format'] = $report_format;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets report_id
     * @return string
     */
    public function getReportId()
    {
        return $this->container['report_id'];
    }

    /**
     * Sets report_id
     * @param string $report_id Report ID
     * @return $this
     */
    public function setReportId($report_id)
    {
        $this->container['report_id'] = $report_id;

        return $this;
    }

    /**
     * Gets parameters
     * @return map[string,object]
     */
    public function getParameters()
    {
        return $this->container['parameters'];
    }

    /**
     * Sets parameters
     * @param map[string,object] $parameters
     * @return $this
     */
    public function setParameters($parameters)
    {
        $this->container['parameters'] = $parameters;

        return $this;
    }

    /**
     * Gets last_run
     * @return \PureCloudSDK\ReportRunEntry
     */
    public function getLastRun()
    {
        return $this->container['last_run'];
    }

    /**
     * Sets last_run
     * @param \PureCloudSDK\ReportRunEntry $last_run
     * @return $this
     */
    public function setLastRun($last_run)
    {
        $this->container['last_run'] = $last_run;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


