<?php
/**
 * ResourcePermissionPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ResourcePermissionPolicy Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ResourcePermissionPolicy implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ResourcePermissionPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'domain' => 'string',
        'entity_name' => 'string',
        'policy_name' => 'string',
        'policy_description' => 'string',
        'action_set_key' => 'string',
        'allow_conditions' => 'bool',
        'resource_condition_node' => '\PureCloudSDK\ResourceConditionNode',
        'named_resources' => 'string[]',
        'resource_condition' => 'string',
        'action_set' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'domain' => 'domain',
        'entity_name' => 'entityName',
        'policy_name' => 'policyName',
        'policy_description' => 'policyDescription',
        'action_set_key' => 'actionSetKey',
        'allow_conditions' => 'allowConditions',
        'resource_condition_node' => 'resourceConditionNode',
        'named_resources' => 'namedResources',
        'resource_condition' => 'resourceCondition',
        'action_set' => 'actionSet'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'domain' => 'setDomain',
        'entity_name' => 'setEntityName',
        'policy_name' => 'setPolicyName',
        'policy_description' => 'setPolicyDescription',
        'action_set_key' => 'setActionSetKey',
        'allow_conditions' => 'setAllowConditions',
        'resource_condition_node' => 'setResourceConditionNode',
        'named_resources' => 'setNamedResources',
        'resource_condition' => 'setResourceCondition',
        'action_set' => 'setActionSet'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'domain' => 'getDomain',
        'entity_name' => 'getEntityName',
        'policy_name' => 'getPolicyName',
        'policy_description' => 'getPolicyDescription',
        'action_set_key' => 'getActionSetKey',
        'allow_conditions' => 'getAllowConditions',
        'resource_condition_node' => 'getResourceConditionNode',
        'named_resources' => 'getNamedResources',
        'resource_condition' => 'getResourceCondition',
        'action_set' => 'getActionSet'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['entity_name'] = isset($data['entity_name']) ? $data['entity_name'] : null;
        $this->container['policy_name'] = isset($data['policy_name']) ? $data['policy_name'] : null;
        $this->container['policy_description'] = isset($data['policy_description']) ? $data['policy_description'] : null;
        $this->container['action_set_key'] = isset($data['action_set_key']) ? $data['action_set_key'] : null;
        $this->container['allow_conditions'] = isset($data['allow_conditions']) ? $data['allow_conditions'] : false;
        $this->container['resource_condition_node'] = isset($data['resource_condition_node']) ? $data['resource_condition_node'] : null;
        $this->container['named_resources'] = isset($data['named_resources']) ? $data['named_resources'] : null;
        $this->container['resource_condition'] = isset($data['resource_condition']) ? $data['resource_condition'] : null;
        $this->container['action_set'] = isset($data['action_set']) ? $data['action_set'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets domain
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param string $domain
     * @return $this
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets entity_name
     * @return string
     */
    public function getEntityName()
    {
        return $this->container['entity_name'];
    }

    /**
     * Sets entity_name
     * @param string $entity_name
     * @return $this
     */
    public function setEntityName($entity_name)
    {
        $this->container['entity_name'] = $entity_name;

        return $this;
    }

    /**
     * Gets policy_name
     * @return string
     */
    public function getPolicyName()
    {
        return $this->container['policy_name'];
    }

    /**
     * Sets policy_name
     * @param string $policy_name
     * @return $this
     */
    public function setPolicyName($policy_name)
    {
        $this->container['policy_name'] = $policy_name;

        return $this;
    }

    /**
     * Gets policy_description
     * @return string
     */
    public function getPolicyDescription()
    {
        return $this->container['policy_description'];
    }

    /**
     * Sets policy_description
     * @param string $policy_description
     * @return $this
     */
    public function setPolicyDescription($policy_description)
    {
        $this->container['policy_description'] = $policy_description;

        return $this;
    }

    /**
     * Gets action_set_key
     * @return string
     */
    public function getActionSetKey()
    {
        return $this->container['action_set_key'];
    }

    /**
     * Sets action_set_key
     * @param string $action_set_key
     * @return $this
     */
    public function setActionSetKey($action_set_key)
    {
        $this->container['action_set_key'] = $action_set_key;

        return $this;
    }

    /**
     * Gets allow_conditions
     * @return bool
     */
    public function getAllowConditions()
    {
        return $this->container['allow_conditions'];
    }

    /**
     * Sets allow_conditions
     * @param bool $allow_conditions
     * @return $this
     */
    public function setAllowConditions($allow_conditions)
    {
        $this->container['allow_conditions'] = $allow_conditions;

        return $this;
    }

    /**
     * Gets resource_condition_node
     * @return \PureCloudSDK\ResourceConditionNode
     */
    public function getResourceConditionNode()
    {
        return $this->container['resource_condition_node'];
    }

    /**
     * Sets resource_condition_node
     * @param \PureCloudSDK\ResourceConditionNode $resource_condition_node
     * @return $this
     */
    public function setResourceConditionNode($resource_condition_node)
    {
        $this->container['resource_condition_node'] = $resource_condition_node;

        return $this;
    }

    /**
     * Gets named_resources
     * @return string[]
     */
    public function getNamedResources()
    {
        return $this->container['named_resources'];
    }

    /**
     * Sets named_resources
     * @param string[] $named_resources
     * @return $this
     */
    public function setNamedResources($named_resources)
    {
        $this->container['named_resources'] = $named_resources;

        return $this;
    }

    /**
     * Gets resource_condition
     * @return string
     */
    public function getResourceCondition()
    {
        return $this->container['resource_condition'];
    }

    /**
     * Sets resource_condition
     * @param string $resource_condition
     * @return $this
     */
    public function setResourceCondition($resource_condition)
    {
        $this->container['resource_condition'] = $resource_condition;

        return $this;
    }

    /**
     * Gets action_set
     * @return string[]
     */
    public function getActionSet()
    {
        return $this->container['action_set'];
    }

    /**
     * Sets action_set
     * @param string[] $action_set
     * @return $this
     */
    public function setActionSet($action_set)
    {
        $this->container['action_set'] = $action_set;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


