<?php
/**
 * Share
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Share Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Share implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Share';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'shared_entity_type' => 'string',
        'shared_entity' => '\PureCloudSDK\UriReference',
        'member_type' => 'string',
        'member' => '\PureCloudSDK\UriReference',
        'shared_by' => '\PureCloudSDK\UriReference',
        'workspace' => '\PureCloudSDK\UriReference',
        'user' => '\PureCloudSDK\User',
        'group' => '\PureCloudSDK\Group',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'shared_entity_type' => 'sharedEntityType',
        'shared_entity' => 'sharedEntity',
        'member_type' => 'memberType',
        'member' => 'member',
        'shared_by' => 'sharedBy',
        'workspace' => 'workspace',
        'user' => 'user',
        'group' => 'group',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'shared_entity_type' => 'setSharedEntityType',
        'shared_entity' => 'setSharedEntity',
        'member_type' => 'setMemberType',
        'member' => 'setMember',
        'shared_by' => 'setSharedBy',
        'workspace' => 'setWorkspace',
        'user' => 'setUser',
        'group' => 'setGroup',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'shared_entity_type' => 'getSharedEntityType',
        'shared_entity' => 'getSharedEntity',
        'member_type' => 'getMemberType',
        'member' => 'getMember',
        'shared_by' => 'getSharedBy',
        'workspace' => 'getWorkspace',
        'user' => 'getUser',
        'group' => 'getGroup',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const SHARED_ENTITY_TYPE_DOCUMENT = 'DOCUMENT';
    const MEMBER_TYPE_USER = 'USER';
    const MEMBER_TYPE_GROUP = 'GROUP';
    const MEMBER_TYPE_PUBLIC = 'PUBLIC';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSharedEntityTypeAllowableValues()
    {
        return [
            self::SHARED_ENTITY_TYPE_DOCUMENT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMemberTypeAllowableValues()
    {
        return [
            self::MEMBER_TYPE_USER,
            self::MEMBER_TYPE_GROUP,
            self::MEMBER_TYPE_PUBLIC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['shared_entity_type'] = isset($data['shared_entity_type']) ? $data['shared_entity_type'] : null;
        $this->container['shared_entity'] = isset($data['shared_entity']) ? $data['shared_entity'] : null;
        $this->container['member_type'] = isset($data['member_type']) ? $data['member_type'] : null;
        $this->container['member'] = isset($data['member']) ? $data['member'] : null;
        $this->container['shared_by'] = isset($data['shared_by']) ? $data['shared_by'] : null;
        $this->container['workspace'] = isset($data['workspace']) ? $data['workspace'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['group'] = isset($data['group']) ? $data['group'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("DOCUMENT");
        if (!in_array($this->container['shared_entity_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'shared_entity_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("USER", "GROUP", "PUBLIC");
        if (!in_array($this->container['member_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'member_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("DOCUMENT");
        if (!in_array($this->container['shared_entity_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("USER", "GROUP", "PUBLIC");
        if (!in_array($this->container['member_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets shared_entity_type
     * @return string
     */
    public function getSharedEntityType()
    {
        return $this->container['shared_entity_type'];
    }

    /**
     * Sets shared_entity_type
     * @param string $shared_entity_type
     * @return $this
     */
    public function setSharedEntityType($shared_entity_type)
    {
        $allowed_values = array('DOCUMENT');
        if (!in_array($shared_entity_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'shared_entity_type', must be one of 'DOCUMENT'");
        }
        $this->container['shared_entity_type'] = $shared_entity_type;

        return $this;
    }

    /**
     * Gets shared_entity
     * @return \PureCloudSDK\UriReference
     */
    public function getSharedEntity()
    {
        return $this->container['shared_entity'];
    }

    /**
     * Sets shared_entity
     * @param \PureCloudSDK\UriReference $shared_entity
     * @return $this
     */
    public function setSharedEntity($shared_entity)
    {
        $this->container['shared_entity'] = $shared_entity;

        return $this;
    }

    /**
     * Gets member_type
     * @return string
     */
    public function getMemberType()
    {
        return $this->container['member_type'];
    }

    /**
     * Sets member_type
     * @param string $member_type
     * @return $this
     */
    public function setMemberType($member_type)
    {
        $allowed_values = array('USER', 'GROUP', 'PUBLIC');
        if (!in_array($member_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'member_type', must be one of 'USER', 'GROUP', 'PUBLIC'");
        }
        $this->container['member_type'] = $member_type;

        return $this;
    }

    /**
     * Gets member
     * @return \PureCloudSDK\UriReference
     */
    public function getMember()
    {
        return $this->container['member'];
    }

    /**
     * Sets member
     * @param \PureCloudSDK\UriReference $member
     * @return $this
     */
    public function setMember($member)
    {
        $this->container['member'] = $member;

        return $this;
    }

    /**
     * Gets shared_by
     * @return \PureCloudSDK\UriReference
     */
    public function getSharedBy()
    {
        return $this->container['shared_by'];
    }

    /**
     * Sets shared_by
     * @param \PureCloudSDK\UriReference $shared_by
     * @return $this
     */
    public function setSharedBy($shared_by)
    {
        $this->container['shared_by'] = $shared_by;

        return $this;
    }

    /**
     * Gets workspace
     * @return \PureCloudSDK\UriReference
     */
    public function getWorkspace()
    {
        return $this->container['workspace'];
    }

    /**
     * Sets workspace
     * @param \PureCloudSDK\UriReference $workspace
     * @return $this
     */
    public function setWorkspace($workspace)
    {
        $this->container['workspace'] = $workspace;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets group
     * @return \PureCloudSDK\Group
     */
    public function getGroup()
    {
        return $this->container['group'];
    }

    /**
     * Sets group
     * @param \PureCloudSDK\Group $group
     * @return $this
     */
    public function setGroup($group)
    {
        $this->container['group'] = $group;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


