<?php
/**
 * StreetAddress
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * StreetAddress Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class StreetAddress implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'StreetAddress';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'country' => 'string',
        'a1' => 'string',
        'a3' => 'string',
        'rd' => 'string',
        'hno' => 'string',
        'loc' => 'string',
        'nam' => 'string',
        'pc' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'country' => 'country',
        'a1' => 'A1',
        'a3' => 'A3',
        'rd' => 'RD',
        'hno' => 'HNO',
        'loc' => 'LOC',
        'nam' => 'NAM',
        'pc' => 'PC'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'country' => 'setCountry',
        'a1' => 'setA1',
        'a3' => 'setA3',
        'rd' => 'setRd',
        'hno' => 'setHno',
        'loc' => 'setLoc',
        'nam' => 'setNam',
        'pc' => 'setPc'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'country' => 'getCountry',
        'a1' => 'getA1',
        'a3' => 'getA3',
        'rd' => 'getRd',
        'hno' => 'getHno',
        'loc' => 'getLoc',
        'nam' => 'getNam',
        'pc' => 'getPc'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['country'] = isset($data['country']) ? $data['country'] : null;
        $this->container['a1'] = isset($data['a1']) ? $data['a1'] : null;
        $this->container['a3'] = isset($data['a3']) ? $data['a3'] : null;
        $this->container['rd'] = isset($data['rd']) ? $data['rd'] : null;
        $this->container['hno'] = isset($data['hno']) ? $data['hno'] : null;
        $this->container['loc'] = isset($data['loc']) ? $data['loc'] : null;
        $this->container['nam'] = isset($data['nam']) ? $data['nam'] : null;
        $this->container['pc'] = isset($data['pc']) ? $data['pc'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['country'] === null) {
            $invalid_properties[] = "'country' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['country'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets country
     * @return string
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     * @param string $country 2 Letter Country code, like US or GB
     * @return $this
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets a1
     * @return string
     */
    public function getA1()
    {
        return $this->container['a1'];
    }

    /**
     * Sets a1
     * @param string $a1
     * @return $this
     */
    public function setA1($a1)
    {
        $this->container['a1'] = $a1;

        return $this;
    }

    /**
     * Gets a3
     * @return string
     */
    public function getA3()
    {
        return $this->container['a3'];
    }

    /**
     * Sets a3
     * @param string $a3
     * @return $this
     */
    public function setA3($a3)
    {
        $this->container['a3'] = $a3;

        return $this;
    }

    /**
     * Gets rd
     * @return string
     */
    public function getRd()
    {
        return $this->container['rd'];
    }

    /**
     * Sets rd
     * @param string $rd
     * @return $this
     */
    public function setRd($rd)
    {
        $this->container['rd'] = $rd;

        return $this;
    }

    /**
     * Gets hno
     * @return string
     */
    public function getHno()
    {
        return $this->container['hno'];
    }

    /**
     * Sets hno
     * @param string $hno
     * @return $this
     */
    public function setHno($hno)
    {
        $this->container['hno'] = $hno;

        return $this;
    }

    /**
     * Gets loc
     * @return string
     */
    public function getLoc()
    {
        return $this->container['loc'];
    }

    /**
     * Sets loc
     * @param string $loc
     * @return $this
     */
    public function setLoc($loc)
    {
        $this->container['loc'] = $loc;

        return $this;
    }

    /**
     * Gets nam
     * @return string
     */
    public function getNam()
    {
        return $this->container['nam'];
    }

    /**
     * Sets nam
     * @param string $nam
     * @return $this
     */
    public function setNam($nam)
    {
        $this->container['nam'] = $nam;

        return $this;
    }

    /**
     * Gets pc
     * @return string
     */
    public function getPc()
    {
        return $this->container['pc'];
    }

    /**
     * Sets pc
     * @param string $pc
     * @return $this
     */
    public function setPc($pc)
    {
        $this->container['pc'] = $pc;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


