<?php
/**
 * TrunkBase
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * TrunkBase Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TrunkBase implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TrunkBase';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'modified_by' => 'string',
        'created_by' => 'string',
        'state' => 'string',
        'modified_by_app' => 'string',
        'created_by_app' => 'string',
        'trunk_metabase' => '\PureCloudSDK\UriReference',
        'properties' => 'map[string,object]',
        'trunk_type' => 'string',
        'managed' => 'bool',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'modified_by' => 'modifiedBy',
        'created_by' => 'createdBy',
        'state' => 'state',
        'modified_by_app' => 'modifiedByApp',
        'created_by_app' => 'createdByApp',
        'trunk_metabase' => 'trunkMetabase',
        'properties' => 'properties',
        'trunk_type' => 'trunkType',
        'managed' => 'managed',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'modified_by' => 'setModifiedBy',
        'created_by' => 'setCreatedBy',
        'state' => 'setState',
        'modified_by_app' => 'setModifiedByApp',
        'created_by_app' => 'setCreatedByApp',
        'trunk_metabase' => 'setTrunkMetabase',
        'properties' => 'setProperties',
        'trunk_type' => 'setTrunkType',
        'managed' => 'setManaged',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'modified_by' => 'getModifiedBy',
        'created_by' => 'getCreatedBy',
        'state' => 'getState',
        'modified_by_app' => 'getModifiedByApp',
        'created_by_app' => 'getCreatedByApp',
        'trunk_metabase' => 'getTrunkMetabase',
        'properties' => 'getProperties',
        'trunk_type' => 'getTrunkType',
        'managed' => 'getManaged',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const TRUNK_TYPE_EXTERNAL = 'EXTERNAL';
    const TRUNK_TYPE_PHONE = 'PHONE';
    const TRUNK_TYPE_EDGE = 'EDGE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTrunkTypeAllowableValues()
    {
        return [
            self::TRUNK_TYPE_EXTERNAL,
            self::TRUNK_TYPE_PHONE,
            self::TRUNK_TYPE_EDGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modified_by_app'] = isset($data['modified_by_app']) ? $data['modified_by_app'] : null;
        $this->container['created_by_app'] = isset($data['created_by_app']) ? $data['created_by_app'] : null;
        $this->container['trunk_metabase'] = isset($data['trunk_metabase']) ? $data['trunk_metabase'] : null;
        $this->container['properties'] = isset($data['properties']) ? $data['properties'] : null;
        $this->container['trunk_type'] = isset($data['trunk_type']) ? $data['trunk_type'] : null;
        $this->container['managed'] = isset($data['managed']) ? $data['managed'] : false;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['trunk_metabase'] === null) {
            $invalid_properties[] = "'trunk_metabase' can't be null";
        }
        if ($this->container['trunk_type'] === null) {
            $invalid_properties[] = "'trunk_type' can't be null";
        }
        $allowed_values = array("EXTERNAL", "PHONE", "EDGE");
        if (!in_array($this->container['trunk_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'trunk_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['trunk_metabase'] === null) {
            return false;
        }
        if ($this->container['trunk_type'] === null) {
            return false;
        }
        $allowed_values = array("EXTERNAL", "PHONE", "EDGE");
        if (!in_array($this->container['trunk_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets modified_by
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     * @param string $modified_by
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets created_by
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param string $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modified_by_app
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modified_by_app'];
    }

    /**
     * Sets modified_by_app
     * @param string $modified_by_app
     * @return $this
     */
    public function setModifiedByApp($modified_by_app)
    {
        $this->container['modified_by_app'] = $modified_by_app;

        return $this;
    }

    /**
     * Gets created_by_app
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['created_by_app'];
    }

    /**
     * Sets created_by_app
     * @param string $created_by_app
     * @return $this
     */
    public function setCreatedByApp($created_by_app)
    {
        $this->container['created_by_app'] = $created_by_app;

        return $this;
    }

    /**
     * Gets trunk_metabase
     * @return \PureCloudSDK\UriReference
     */
    public function getTrunkMetabase()
    {
        return $this->container['trunk_metabase'];
    }

    /**
     * Sets trunk_metabase
     * @param \PureCloudSDK\UriReference $trunk_metabase The meta-base this trunk is based on.
     * @return $this
     */
    public function setTrunkMetabase($trunk_metabase)
    {
        $this->container['trunk_metabase'] = $trunk_metabase;

        return $this;
    }

    /**
     * Gets properties
     * @return map[string,object]
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     * @param map[string,object] $properties
     * @return $this
     */
    public function setProperties($properties)
    {
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets trunk_type
     * @return string
     */
    public function getTrunkType()
    {
        return $this->container['trunk_type'];
    }

    /**
     * Sets trunk_type
     * @param string $trunk_type The type of this trunk base.
     * @return $this
     */
    public function setTrunkType($trunk_type)
    {
        $allowed_values = array('EXTERNAL', 'PHONE', 'EDGE');
        if (!in_array($trunk_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'trunk_type', must be one of 'EXTERNAL', 'PHONE', 'EDGE'");
        }
        $this->container['trunk_type'] = $trunk_type;

        return $this;
    }

    /**
     * Gets managed
     * @return bool
     */
    public function getManaged()
    {
        return $this->container['managed'];
    }

    /**
     * Sets managed
     * @param bool $managed Is this trunk being managed remotely.
     * @return $this
     */
    public function setManaged($managed)
    {
        $this->container['managed'] = $managed;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


