<?php
/**
 * UserMe
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserMe Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserMe implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserMe';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'chat' => '\PureCloudSDK\Chat',
        'department' => 'string',
        'email' => 'string',
        'primary_contact_info' => '\PureCloudSDK\Contact[]',
        'addresses' => '\PureCloudSDK\Contact[]',
        'state' => 'string',
        'title' => 'string',
        'username' => 'string',
        'manager' => '\PureCloudSDK\User',
        'images' => '\PureCloudSDK\UserImage[]',
        'version' => 'int',
        'routing_status' => '\PureCloudSDK\RoutingStatus',
        'presence' => '\PureCloudSDK\UserPresence',
        'conversation_summary' => '\PureCloudSDK\UserConversationSummary',
        'out_of_office' => '\PureCloudSDK\OutOfOffice',
        'geolocation' => '\PureCloudSDK\Geolocation',
        'station' => '\PureCloudSDK\UserStations',
        'authorization' => '\PureCloudSDK\UserAuthorization',
        'profile_skills' => 'string[]',
        'date' => '\PureCloudSDK\ServerDate',
        'geolocation_settings' => '\PureCloudSDK\GeolocationSettings',
        'organization' => '\PureCloudSDK\Organization',
        'presence_definitions' => '\PureCloudSDK\OrganizationPresence[]',
        'locations' => '\PureCloudSDK\Location[]',
        'org_authorization' => '\PureCloudSDK\DomainOrganizationRole[]',
        'favorites' => '\PureCloudSDK\User[]',
        'superiors' => '\PureCloudSDK\User[]',
        'direct_reports' => '\PureCloudSDK\User[]',
        'adjacents' => '\PureCloudSDK\Adjacents',
        'routing_skills' => '\PureCloudSDK\RoutingSkill[]',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'chat' => 'chat',
        'department' => 'department',
        'email' => 'email',
        'primary_contact_info' => 'primaryContactInfo',
        'addresses' => 'addresses',
        'state' => 'state',
        'title' => 'title',
        'username' => 'username',
        'manager' => 'manager',
        'images' => 'images',
        'version' => 'version',
        'routing_status' => 'routingStatus',
        'presence' => 'presence',
        'conversation_summary' => 'conversationSummary',
        'out_of_office' => 'outOfOffice',
        'geolocation' => 'geolocation',
        'station' => 'station',
        'authorization' => 'authorization',
        'profile_skills' => 'profileSkills',
        'date' => 'date',
        'geolocation_settings' => 'geolocationSettings',
        'organization' => 'organization',
        'presence_definitions' => 'presenceDefinitions',
        'locations' => 'locations',
        'org_authorization' => 'orgAuthorization',
        'favorites' => 'favorites',
        'superiors' => 'superiors',
        'direct_reports' => 'directReports',
        'adjacents' => 'adjacents',
        'routing_skills' => 'routingSkills',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'chat' => 'setChat',
        'department' => 'setDepartment',
        'email' => 'setEmail',
        'primary_contact_info' => 'setPrimaryContactInfo',
        'addresses' => 'setAddresses',
        'state' => 'setState',
        'title' => 'setTitle',
        'username' => 'setUsername',
        'manager' => 'setManager',
        'images' => 'setImages',
        'version' => 'setVersion',
        'routing_status' => 'setRoutingStatus',
        'presence' => 'setPresence',
        'conversation_summary' => 'setConversationSummary',
        'out_of_office' => 'setOutOfOffice',
        'geolocation' => 'setGeolocation',
        'station' => 'setStation',
        'authorization' => 'setAuthorization',
        'profile_skills' => 'setProfileSkills',
        'date' => 'setDate',
        'geolocation_settings' => 'setGeolocationSettings',
        'organization' => 'setOrganization',
        'presence_definitions' => 'setPresenceDefinitions',
        'locations' => 'setLocations',
        'org_authorization' => 'setOrgAuthorization',
        'favorites' => 'setFavorites',
        'superiors' => 'setSuperiors',
        'direct_reports' => 'setDirectReports',
        'adjacents' => 'setAdjacents',
        'routing_skills' => 'setRoutingSkills',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'chat' => 'getChat',
        'department' => 'getDepartment',
        'email' => 'getEmail',
        'primary_contact_info' => 'getPrimaryContactInfo',
        'addresses' => 'getAddresses',
        'state' => 'getState',
        'title' => 'getTitle',
        'username' => 'getUsername',
        'manager' => 'getManager',
        'images' => 'getImages',
        'version' => 'getVersion',
        'routing_status' => 'getRoutingStatus',
        'presence' => 'getPresence',
        'conversation_summary' => 'getConversationSummary',
        'out_of_office' => 'getOutOfOffice',
        'geolocation' => 'getGeolocation',
        'station' => 'getStation',
        'authorization' => 'getAuthorization',
        'profile_skills' => 'getProfileSkills',
        'date' => 'getDate',
        'geolocation_settings' => 'getGeolocationSettings',
        'organization' => 'getOrganization',
        'presence_definitions' => 'getPresenceDefinitions',
        'locations' => 'getLocations',
        'org_authorization' => 'getOrgAuthorization',
        'favorites' => 'getFavorites',
        'superiors' => 'getSuperiors',
        'direct_reports' => 'getDirectReports',
        'adjacents' => 'getAdjacents',
        'routing_skills' => 'getRoutingSkills',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['chat'] = isset($data['chat']) ? $data['chat'] : null;
        $this->container['department'] = isset($data['department']) ? $data['department'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['primary_contact_info'] = isset($data['primary_contact_info']) ? $data['primary_contact_info'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['username'] = isset($data['username']) ? $data['username'] : null;
        $this->container['manager'] = isset($data['manager']) ? $data['manager'] : null;
        $this->container['images'] = isset($data['images']) ? $data['images'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['routing_status'] = isset($data['routing_status']) ? $data['routing_status'] : null;
        $this->container['presence'] = isset($data['presence']) ? $data['presence'] : null;
        $this->container['conversation_summary'] = isset($data['conversation_summary']) ? $data['conversation_summary'] : null;
        $this->container['out_of_office'] = isset($data['out_of_office']) ? $data['out_of_office'] : null;
        $this->container['geolocation'] = isset($data['geolocation']) ? $data['geolocation'] : null;
        $this->container['station'] = isset($data['station']) ? $data['station'] : null;
        $this->container['authorization'] = isset($data['authorization']) ? $data['authorization'] : null;
        $this->container['profile_skills'] = isset($data['profile_skills']) ? $data['profile_skills'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['geolocation_settings'] = isset($data['geolocation_settings']) ? $data['geolocation_settings'] : null;
        $this->container['organization'] = isset($data['organization']) ? $data['organization'] : null;
        $this->container['presence_definitions'] = isset($data['presence_definitions']) ? $data['presence_definitions'] : null;
        $this->container['locations'] = isset($data['locations']) ? $data['locations'] : null;
        $this->container['org_authorization'] = isset($data['org_authorization']) ? $data['org_authorization'] : null;
        $this->container['favorites'] = isset($data['favorites']) ? $data['favorites'] : null;
        $this->container['superiors'] = isset($data['superiors']) ? $data['superiors'] : null;
        $this->container['direct_reports'] = isset($data['direct_reports']) ? $data['direct_reports'] : null;
        $this->container['adjacents'] = isset($data['adjacents']) ? $data['adjacents'] : null;
        $this->container['routing_skills'] = isset($data['routing_skills']) ? $data['routing_skills'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['version'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets chat
     * @return \PureCloudSDK\Chat
     */
    public function getChat()
    {
        return $this->container['chat'];
    }

    /**
     * Sets chat
     * @param \PureCloudSDK\Chat $chat
     * @return $this
     */
    public function setChat($chat)
    {
        $this->container['chat'] = $chat;

        return $this;
    }

    /**
     * Gets department
     * @return string
     */
    public function getDepartment()
    {
        return $this->container['department'];
    }

    /**
     * Sets department
     * @param string $department
     * @return $this
     */
    public function setDepartment($department)
    {
        $this->container['department'] = $department;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets primary_contact_info
     * @return \PureCloudSDK\Contact[]
     */
    public function getPrimaryContactInfo()
    {
        return $this->container['primary_contact_info'];
    }

    /**
     * Sets primary_contact_info
     * @param \PureCloudSDK\Contact[] $primary_contact_info Auto populated from addresses.
     * @return $this
     */
    public function setPrimaryContactInfo($primary_contact_info)
    {
        $this->container['primary_contact_info'] = $primary_contact_info;

        return $this;
    }

    /**
     * Gets addresses
     * @return \PureCloudSDK\Contact[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param \PureCloudSDK\Contact[] $addresses Email addresses and phone numbers for this user
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The current state for this user.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets username
     * @return string
     */
    public function getUsername()
    {
        return $this->container['username'];
    }

    /**
     * Sets username
     * @param string $username
     * @return $this
     */
    public function setUsername($username)
    {
        $this->container['username'] = $username;

        return $this;
    }

    /**
     * Gets manager
     * @return \PureCloudSDK\User
     */
    public function getManager()
    {
        return $this->container['manager'];
    }

    /**
     * Sets manager
     * @param \PureCloudSDK\User $manager
     * @return $this
     */
    public function setManager($manager)
    {
        $this->container['manager'] = $manager;

        return $this;
    }

    /**
     * Gets images
     * @return \PureCloudSDK\UserImage[]
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     * @param \PureCloudSDK\UserImage[] $images
     * @return $this
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required when updating a user, this value should be the current version of the user.  The current version can be obtained with a GET on the user before doing a PATCH.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets routing_status
     * @return \PureCloudSDK\RoutingStatus
     */
    public function getRoutingStatus()
    {
        return $this->container['routing_status'];
    }

    /**
     * Sets routing_status
     * @param \PureCloudSDK\RoutingStatus $routing_status ACD routing status
     * @return $this
     */
    public function setRoutingStatus($routing_status)
    {
        $this->container['routing_status'] = $routing_status;

        return $this;
    }

    /**
     * Gets presence
     * @return \PureCloudSDK\UserPresence
     */
    public function getPresence()
    {
        return $this->container['presence'];
    }

    /**
     * Sets presence
     * @param \PureCloudSDK\UserPresence $presence Active presence
     * @return $this
     */
    public function setPresence($presence)
    {
        $this->container['presence'] = $presence;

        return $this;
    }

    /**
     * Gets conversation_summary
     * @return \PureCloudSDK\UserConversationSummary
     */
    public function getConversationSummary()
    {
        return $this->container['conversation_summary'];
    }

    /**
     * Sets conversation_summary
     * @param \PureCloudSDK\UserConversationSummary $conversation_summary Summary of conversion statistics for conversation types.
     * @return $this
     */
    public function setConversationSummary($conversation_summary)
    {
        $this->container['conversation_summary'] = $conversation_summary;

        return $this;
    }

    /**
     * Gets out_of_office
     * @return \PureCloudSDK\OutOfOffice
     */
    public function getOutOfOffice()
    {
        return $this->container['out_of_office'];
    }

    /**
     * Sets out_of_office
     * @param \PureCloudSDK\OutOfOffice $out_of_office Determine if out of office is enabled
     * @return $this
     */
    public function setOutOfOffice($out_of_office)
    {
        $this->container['out_of_office'] = $out_of_office;

        return $this;
    }

    /**
     * Gets geolocation
     * @return \PureCloudSDK\Geolocation
     */
    public function getGeolocation()
    {
        return $this->container['geolocation'];
    }

    /**
     * Sets geolocation
     * @param \PureCloudSDK\Geolocation $geolocation Current geolocation position
     * @return $this
     */
    public function setGeolocation($geolocation)
    {
        $this->container['geolocation'] = $geolocation;

        return $this;
    }

    /**
     * Gets station
     * @return \PureCloudSDK\UserStations
     */
    public function getStation()
    {
        return $this->container['station'];
    }

    /**
     * Sets station
     * @param \PureCloudSDK\UserStations $station Effective, default, and last station information
     * @return $this
     */
    public function setStation($station)
    {
        $this->container['station'] = $station;

        return $this;
    }

    /**
     * Gets authorization
     * @return \PureCloudSDK\UserAuthorization
     */
    public function getAuthorization()
    {
        return $this->container['authorization'];
    }

    /**
     * Sets authorization
     * @param \PureCloudSDK\UserAuthorization $authorization Roles and permissions assigned to the user
     * @return $this
     */
    public function setAuthorization($authorization)
    {
        $this->container['authorization'] = $authorization;

        return $this;
    }

    /**
     * Gets profile_skills
     * @return string[]
     */
    public function getProfileSkills()
    {
        return $this->container['profile_skills'];
    }

    /**
     * Sets profile_skills
     * @param string[] $profile_skills Skills possessed by the user
     * @return $this
     */
    public function setProfileSkills($profile_skills)
    {
        $this->container['profile_skills'] = $profile_skills;

        return $this;
    }

    /**
     * Gets date
     * @return \PureCloudSDK\ServerDate
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     * @param \PureCloudSDK\ServerDate $date The PureCloud system date time.
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets geolocation_settings
     * @return \PureCloudSDK\GeolocationSettings
     */
    public function getGeolocationSettings()
    {
        return $this->container['geolocation_settings'];
    }

    /**
     * Sets geolocation_settings
     * @param \PureCloudSDK\GeolocationSettings $geolocation_settings Geolocation settings for user's organization.
     * @return $this
     */
    public function setGeolocationSettings($geolocation_settings)
    {
        $this->container['geolocation_settings'] = $geolocation_settings;

        return $this;
    }

    /**
     * Gets organization
     * @return \PureCloudSDK\Organization
     */
    public function getOrganization()
    {
        return $this->container['organization'];
    }

    /**
     * Sets organization
     * @param \PureCloudSDK\Organization $organization Organization details for this user.
     * @return $this
     */
    public function setOrganization($organization)
    {
        $this->container['organization'] = $organization;

        return $this;
    }

    /**
     * Gets presence_definitions
     * @return \PureCloudSDK\OrganizationPresence[]
     */
    public function getPresenceDefinitions()
    {
        return $this->container['presence_definitions'];
    }

    /**
     * Sets presence_definitions
     * @param \PureCloudSDK\OrganizationPresence[] $presence_definitions The first 100 presence definitions for user's organization.
     * @return $this
     */
    public function setPresenceDefinitions($presence_definitions)
    {
        $this->container['presence_definitions'] = $presence_definitions;

        return $this;
    }

    /**
     * Gets locations
     * @return \PureCloudSDK\Location[]
     */
    public function getLocations()
    {
        return $this->container['locations'];
    }

    /**
     * Sets locations
     * @param \PureCloudSDK\Location[] $locations The first 100 locations for user's organization
     * @return $this
     */
    public function setLocations($locations)
    {
        $this->container['locations'] = $locations;

        return $this;
    }

    /**
     * Gets org_authorization
     * @return \PureCloudSDK\DomainOrganizationRole[]
     */
    public function getOrgAuthorization()
    {
        return $this->container['org_authorization'];
    }

    /**
     * Sets org_authorization
     * @param \PureCloudSDK\DomainOrganizationRole[] $org_authorization The first 100 organization roles, with applicable permission policies, for user's organization.
     * @return $this
     */
    public function setOrgAuthorization($org_authorization)
    {
        $this->container['org_authorization'] = $org_authorization;

        return $this;
    }

    /**
     * Gets favorites
     * @return \PureCloudSDK\User[]
     */
    public function getFavorites()
    {
        return $this->container['favorites'];
    }

    /**
     * Sets favorites
     * @param \PureCloudSDK\User[] $favorites The first 50 favorited users.
     * @return $this
     */
    public function setFavorites($favorites)
    {
        $this->container['favorites'] = $favorites;

        return $this;
    }

    /**
     * Gets superiors
     * @return \PureCloudSDK\User[]
     */
    public function getSuperiors()
    {
        return $this->container['superiors'];
    }

    /**
     * Sets superiors
     * @param \PureCloudSDK\User[] $superiors The first 50 superiors of this user.
     * @return $this
     */
    public function setSuperiors($superiors)
    {
        $this->container['superiors'] = $superiors;

        return $this;
    }

    /**
     * Gets direct_reports
     * @return \PureCloudSDK\User[]
     */
    public function getDirectReports()
    {
        return $this->container['direct_reports'];
    }

    /**
     * Sets direct_reports
     * @param \PureCloudSDK\User[] $direct_reports The first 50 direct reports to this user.
     * @return $this
     */
    public function setDirectReports($direct_reports)
    {
        $this->container['direct_reports'] = $direct_reports;

        return $this;
    }

    /**
     * Gets adjacents
     * @return \PureCloudSDK\Adjacents
     */
    public function getAdjacents()
    {
        return $this->container['adjacents'];
    }

    /**
     * Sets adjacents
     * @param \PureCloudSDK\Adjacents $adjacents The first 50 superiors, direct reports, and siblings of this user. Mutually exclusive with superiors and direct reports expands.
     * @return $this
     */
    public function setAdjacents($adjacents)
    {
        $this->container['adjacents'] = $adjacents;

        return $this;
    }

    /**
     * Gets routing_skills
     * @return \PureCloudSDK\RoutingSkill[]
     */
    public function getRoutingSkills()
    {
        return $this->container['routing_skills'];
    }

    /**
     * Sets routing_skills
     * @param \PureCloudSDK\RoutingSkill[] $routing_skills The first 50 routing skills for user's organizations
     * @return $this
     */
    public function setRoutingSkills($routing_skills)
    {
        $this->container['routing_skills'] = $routing_skills;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


