<?php
/**
 * UserQueue
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserQueue Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserQueue implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserQueue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'modified_by' => 'string',
        'created_by' => 'string',
        'state' => 'string',
        'modified_by_app' => 'string',
        'created_by_app' => 'string',
        'media_settings' => 'map[string,\PureCloudSDK\MediaSetting]',
        'bullseye' => '\PureCloudSDK\Bullseye',
        'acw_settings' => '\PureCloudSDK\AcwSettings',
        'skill_evaluation_method' => 'string',
        'queue_flow' => '\PureCloudSDK\UriReference',
        'calling_party_name' => 'string',
        'calling_party_number' => 'string',
        'joined' => 'bool',
        'member_count' => 'int',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'modified_by' => 'modifiedBy',
        'created_by' => 'createdBy',
        'state' => 'state',
        'modified_by_app' => 'modifiedByApp',
        'created_by_app' => 'createdByApp',
        'media_settings' => 'mediaSettings',
        'bullseye' => 'bullseye',
        'acw_settings' => 'acwSettings',
        'skill_evaluation_method' => 'skillEvaluationMethod',
        'queue_flow' => 'queueFlow',
        'calling_party_name' => 'callingPartyName',
        'calling_party_number' => 'callingPartyNumber',
        'joined' => 'joined',
        'member_count' => 'memberCount',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'modified_by' => 'setModifiedBy',
        'created_by' => 'setCreatedBy',
        'state' => 'setState',
        'modified_by_app' => 'setModifiedByApp',
        'created_by_app' => 'setCreatedByApp',
        'media_settings' => 'setMediaSettings',
        'bullseye' => 'setBullseye',
        'acw_settings' => 'setAcwSettings',
        'skill_evaluation_method' => 'setSkillEvaluationMethod',
        'queue_flow' => 'setQueueFlow',
        'calling_party_name' => 'setCallingPartyName',
        'calling_party_number' => 'setCallingPartyNumber',
        'joined' => 'setJoined',
        'member_count' => 'setMemberCount',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'modified_by' => 'getModifiedBy',
        'created_by' => 'getCreatedBy',
        'state' => 'getState',
        'modified_by_app' => 'getModifiedByApp',
        'created_by_app' => 'getCreatedByApp',
        'media_settings' => 'getMediaSettings',
        'bullseye' => 'getBullseye',
        'acw_settings' => 'getAcwSettings',
        'skill_evaluation_method' => 'getSkillEvaluationMethod',
        'queue_flow' => 'getQueueFlow',
        'calling_party_name' => 'getCallingPartyName',
        'calling_party_number' => 'getCallingPartyNumber',
        'joined' => 'getJoined',
        'member_count' => 'getMemberCount',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const SKILL_EVALUATION_METHOD_NONE = 'NONE';
    const SKILL_EVALUATION_METHOD_BEST = 'BEST';
    const SKILL_EVALUATION_METHOD_ALL = 'ALL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSkillEvaluationMethodAllowableValues()
    {
        return [
            self::SKILL_EVALUATION_METHOD_NONE,
            self::SKILL_EVALUATION_METHOD_BEST,
            self::SKILL_EVALUATION_METHOD_ALL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modified_by_app'] = isset($data['modified_by_app']) ? $data['modified_by_app'] : null;
        $this->container['created_by_app'] = isset($data['created_by_app']) ? $data['created_by_app'] : null;
        $this->container['media_settings'] = isset($data['media_settings']) ? $data['media_settings'] : null;
        $this->container['bullseye'] = isset($data['bullseye']) ? $data['bullseye'] : null;
        $this->container['acw_settings'] = isset($data['acw_settings']) ? $data['acw_settings'] : null;
        $this->container['skill_evaluation_method'] = isset($data['skill_evaluation_method']) ? $data['skill_evaluation_method'] : null;
        $this->container['queue_flow'] = isset($data['queue_flow']) ? $data['queue_flow'] : null;
        $this->container['calling_party_name'] = isset($data['calling_party_name']) ? $data['calling_party_name'] : null;
        $this->container['calling_party_number'] = isset($data['calling_party_number']) ? $data['calling_party_number'] : null;
        $this->container['joined'] = isset($data['joined']) ? $data['joined'] : false;
        $this->container['member_count'] = isset($data['member_count']) ? $data['member_count'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['media_settings'] === null) {
            $invalid_properties[] = "'media_settings' can't be null";
        }
        if ($this->container['acw_settings'] === null) {
            $invalid_properties[] = "'acw_settings' can't be null";
        }
        if ($this->container['skill_evaluation_method'] === null) {
            $invalid_properties[] = "'skill_evaluation_method' can't be null";
        }
        $allowed_values = array("NONE", "BEST", "ALL");
        if (!in_array($this->container['skill_evaluation_method'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'skill_evaluation_method', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['media_settings'] === null) {
            return false;
        }
        if ($this->container['acw_settings'] === null) {
            return false;
        }
        if ($this->container['skill_evaluation_method'] === null) {
            return false;
        }
        $allowed_values = array("NONE", "BEST", "ALL");
        if (!in_array($this->container['skill_evaluation_method'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets modified_by
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     * @param string $modified_by
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets created_by
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param string $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modified_by_app
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modified_by_app'];
    }

    /**
     * Sets modified_by_app
     * @param string $modified_by_app
     * @return $this
     */
    public function setModifiedByApp($modified_by_app)
    {
        $this->container['modified_by_app'] = $modified_by_app;

        return $this;
    }

    /**
     * Gets created_by_app
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['created_by_app'];
    }

    /**
     * Sets created_by_app
     * @param string $created_by_app
     * @return $this
     */
    public function setCreatedByApp($created_by_app)
    {
        $this->container['created_by_app'] = $created_by_app;

        return $this;
    }

    /**
     * Gets media_settings
     * @return map[string,\PureCloudSDK\MediaSetting]
     */
    public function getMediaSettings()
    {
        return $this->container['media_settings'];
    }

    /**
     * Sets media_settings
     * @param map[string,\PureCloudSDK\MediaSetting] $media_settings The media settings for the queue.
     * @return $this
     */
    public function setMediaSettings($media_settings)
    {
        $this->container['media_settings'] = $media_settings;

        return $this;
    }

    /**
     * Gets bullseye
     * @return \PureCloudSDK\Bullseye
     */
    public function getBullseye()
    {
        return $this->container['bullseye'];
    }

    /**
     * Sets bullseye
     * @param \PureCloudSDK\Bullseye $bullseye The bulls-eye settings for the queue.
     * @return $this
     */
    public function setBullseye($bullseye)
    {
        $this->container['bullseye'] = $bullseye;

        return $this;
    }

    /**
     * Gets acw_settings
     * @return \PureCloudSDK\AcwSettings
     */
    public function getAcwSettings()
    {
        return $this->container['acw_settings'];
    }

    /**
     * Sets acw_settings
     * @param \PureCloudSDK\AcwSettings $acw_settings The ACW settings for the queue.
     * @return $this
     */
    public function setAcwSettings($acw_settings)
    {
        $this->container['acw_settings'] = $acw_settings;

        return $this;
    }

    /**
     * Gets skill_evaluation_method
     * @return string
     */
    public function getSkillEvaluationMethod()
    {
        return $this->container['skill_evaluation_method'];
    }

    /**
     * Sets skill_evaluation_method
     * @param string $skill_evaluation_method The skill evaluation method to use when routing conversations.
     * @return $this
     */
    public function setSkillEvaluationMethod($skill_evaluation_method)
    {
        $allowed_values = array('NONE', 'BEST', 'ALL');
        if (!in_array($skill_evaluation_method, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'skill_evaluation_method', must be one of 'NONE', 'BEST', 'ALL'");
        }
        $this->container['skill_evaluation_method'] = $skill_evaluation_method;

        return $this;
    }

    /**
     * Gets queue_flow
     * @return \PureCloudSDK\UriReference
     */
    public function getQueueFlow()
    {
        return $this->container['queue_flow'];
    }

    /**
     * Sets queue_flow
     * @param \PureCloudSDK\UriReference $queue_flow The in-queue flow to use for conversations waiting in queue.
     * @return $this
     */
    public function setQueueFlow($queue_flow)
    {
        $this->container['queue_flow'] = $queue_flow;

        return $this;
    }

    /**
     * Gets calling_party_name
     * @return string
     */
    public function getCallingPartyName()
    {
        return $this->container['calling_party_name'];
    }

    /**
     * Sets calling_party_name
     * @param string $calling_party_name The name to use for caller identification for outbound calls from this queue.
     * @return $this
     */
    public function setCallingPartyName($calling_party_name)
    {
        $this->container['calling_party_name'] = $calling_party_name;

        return $this;
    }

    /**
     * Gets calling_party_number
     * @return string
     */
    public function getCallingPartyNumber()
    {
        return $this->container['calling_party_number'];
    }

    /**
     * Sets calling_party_number
     * @param string $calling_party_number The phone number to use for caller identification for outbound calls from this queue.
     * @return $this
     */
    public function setCallingPartyNumber($calling_party_number)
    {
        $this->container['calling_party_number'] = $calling_party_number;

        return $this;
    }

    /**
     * Gets joined
     * @return bool
     */
    public function getJoined()
    {
        return $this->container['joined'];
    }

    /**
     * Sets joined
     * @param bool $joined
     * @return $this
     */
    public function setJoined($joined)
    {
        $this->container['joined'] = $joined;

        return $this;
    }

    /**
     * Gets member_count
     * @return int
     */
    public function getMemberCount()
    {
        return $this->container['member_count'];
    }

    /**
     * Sets member_count
     * @param int $member_count
     * @return $this
     */
    public function setMemberCount($member_count)
    {
        $this->container['member_count'] = $member_count;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


