<?php
/**
 * UserScheduleAdherence
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserScheduleAdherence Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserScheduleAdherence implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserScheduleAdherence';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'user' => '\PureCloudSDK\User',
        'management_unit' => '\PureCloudSDK\ManagementUnit',
        'scheduled_activity_category' => 'string',
        'system_presence' => 'string',
        'organization_secondary_presence_id' => 'string',
        'routing_status' => 'string',
        'actual_activity_category' => 'string',
        'is_out_of_office' => 'bool',
        'adherence_state' => 'string',
        'impact' => 'string',
        'time_of_adherence_change' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'user' => 'user',
        'management_unit' => 'managementUnit',
        'scheduled_activity_category' => 'scheduledActivityCategory',
        'system_presence' => 'systemPresence',
        'organization_secondary_presence_id' => 'organizationSecondaryPresenceId',
        'routing_status' => 'routingStatus',
        'actual_activity_category' => 'actualActivityCategory',
        'is_out_of_office' => 'isOutOfOffice',
        'adherence_state' => 'adherenceState',
        'impact' => 'impact',
        'time_of_adherence_change' => 'timeOfAdherenceChange',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'user' => 'setUser',
        'management_unit' => 'setManagementUnit',
        'scheduled_activity_category' => 'setScheduledActivityCategory',
        'system_presence' => 'setSystemPresence',
        'organization_secondary_presence_id' => 'setOrganizationSecondaryPresenceId',
        'routing_status' => 'setRoutingStatus',
        'actual_activity_category' => 'setActualActivityCategory',
        'is_out_of_office' => 'setIsOutOfOffice',
        'adherence_state' => 'setAdherenceState',
        'impact' => 'setImpact',
        'time_of_adherence_change' => 'setTimeOfAdherenceChange',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'user' => 'getUser',
        'management_unit' => 'getManagementUnit',
        'scheduled_activity_category' => 'getScheduledActivityCategory',
        'system_presence' => 'getSystemPresence',
        'organization_secondary_presence_id' => 'getOrganizationSecondaryPresenceId',
        'routing_status' => 'getRoutingStatus',
        'actual_activity_category' => 'getActualActivityCategory',
        'is_out_of_office' => 'getIsOutOfOffice',
        'adherence_state' => 'getAdherenceState',
        'impact' => 'getImpact',
        'time_of_adherence_change' => 'getTimeOfAdherenceChange',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const SCHEDULED_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    const SCHEDULED_ACTIVITY_CATEGORY_BREAK = 'Break';
    const SCHEDULED_ACTIVITY_CATEGORY_MEAL = 'Meal';
    const SCHEDULED_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    const SCHEDULED_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    const SCHEDULED_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    const SCHEDULED_ACTIVITY_CATEGORY_TRAINING = 'Training';
    const SCHEDULED_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    const SCHEDULED_ACTIVITY_CATEGORY_BLANK = 'BLANK';
    const SYSTEM_PRESENCE_AVAILABLE = 'Available';
    const SYSTEM_PRESENCE_AWAY = 'Away';
    const SYSTEM_PRESENCE_BUSY = 'Busy';
    const SYSTEM_PRESENCE_OFFLINE = 'Offline';
    const SYSTEM_PRESENCE_IDLE = 'Idle';
    const SYSTEM_PRESENCE_ON_QUEUE = 'OnQueue';
    const SYSTEM_PRESENCE_MEAL = 'Meal';
    const SYSTEM_PRESENCE_TRAINING = 'Training';
    const SYSTEM_PRESENCE_MEETING = 'Meeting';
    const SYSTEM_PRESENCE_BREAK = 'Break';
    const SYSTEM_PRESENCE_BLANK = 'BLANK';
    const ROUTING_STATUS_OFF_QUEUE = 'OFF_QUEUE';
    const ROUTING_STATUS_IDLE = 'IDLE';
    const ROUTING_STATUS_INTERACTING = 'INTERACTING';
    const ROUTING_STATUS_NOT_RESPONDING = 'NOT_RESPONDING';
    const ROUTING_STATUS_COMMUNICATING = 'COMMUNICATING';
    const ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    const ACTUAL_ACTIVITY_CATEGORY_BREAK = 'Break';
    const ACTUAL_ACTIVITY_CATEGORY_MEAL = 'Meal';
    const ACTUAL_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    const ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    const ACTUAL_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    const ACTUAL_ACTIVITY_CATEGORY_TRAINING = 'Training';
    const ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    const ACTUAL_ACTIVITY_CATEGORY_BLANK = 'BLANK';
    const ADHERENCE_STATE_IN_ADHERENCE = 'InAdherence';
    const ADHERENCE_STATE_OUT_OF_ADHERENCE = 'OutOfAdherence';
    const ADHERENCE_STATE_UNSCHEDULED = 'Unscheduled';
    const ADHERENCE_STATE_UNKNOWN = 'Unknown';
    const IMPACT_POSITIVE = 'Positive';
    const IMPACT_NEGATIVE = 'Negative';
    const IMPACT_NEUTRAL = 'Neutral';
    const IMPACT_UNKNOWN = 'Unknown';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getScheduledActivityCategoryAllowableValues()
    {
        return [
            self::SCHEDULED_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::SCHEDULED_ACTIVITY_CATEGORY_BREAK,
            self::SCHEDULED_ACTIVITY_CATEGORY_MEAL,
            self::SCHEDULED_ACTIVITY_CATEGORY_MEETING,
            self::SCHEDULED_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::SCHEDULED_ACTIVITY_CATEGORY_TIME_OFF,
            self::SCHEDULED_ACTIVITY_CATEGORY_TRAINING,
            self::SCHEDULED_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::SCHEDULED_ACTIVITY_CATEGORY_BLANK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSystemPresenceAllowableValues()
    {
        return [
            self::SYSTEM_PRESENCE_AVAILABLE,
            self::SYSTEM_PRESENCE_AWAY,
            self::SYSTEM_PRESENCE_BUSY,
            self::SYSTEM_PRESENCE_OFFLINE,
            self::SYSTEM_PRESENCE_IDLE,
            self::SYSTEM_PRESENCE_ON_QUEUE,
            self::SYSTEM_PRESENCE_MEAL,
            self::SYSTEM_PRESENCE_TRAINING,
            self::SYSTEM_PRESENCE_MEETING,
            self::SYSTEM_PRESENCE_BREAK,
            self::SYSTEM_PRESENCE_BLANK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRoutingStatusAllowableValues()
    {
        return [
            self::ROUTING_STATUS_OFF_QUEUE,
            self::ROUTING_STATUS_IDLE,
            self::ROUTING_STATUS_INTERACTING,
            self::ROUTING_STATUS_NOT_RESPONDING,
            self::ROUTING_STATUS_COMMUNICATING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActualActivityCategoryAllowableValues()
    {
        return [
            self::ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_BREAK,
            self::ACTUAL_ACTIVITY_CATEGORY_MEAL,
            self::ACTUAL_ACTIVITY_CATEGORY_MEETING,
            self::ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_TIME_OFF,
            self::ACTUAL_ACTIVITY_CATEGORY_TRAINING,
            self::ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::ACTUAL_ACTIVITY_CATEGORY_BLANK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAdherenceStateAllowableValues()
    {
        return [
            self::ADHERENCE_STATE_IN_ADHERENCE,
            self::ADHERENCE_STATE_OUT_OF_ADHERENCE,
            self::ADHERENCE_STATE_UNSCHEDULED,
            self::ADHERENCE_STATE_UNKNOWN,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getImpactAllowableValues()
    {
        return [
            self::IMPACT_POSITIVE,
            self::IMPACT_NEGATIVE,
            self::IMPACT_NEUTRAL,
            self::IMPACT_UNKNOWN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['management_unit'] = isset($data['management_unit']) ? $data['management_unit'] : null;
        $this->container['scheduled_activity_category'] = isset($data['scheduled_activity_category']) ? $data['scheduled_activity_category'] : null;
        $this->container['system_presence'] = isset($data['system_presence']) ? $data['system_presence'] : null;
        $this->container['organization_secondary_presence_id'] = isset($data['organization_secondary_presence_id']) ? $data['organization_secondary_presence_id'] : null;
        $this->container['routing_status'] = isset($data['routing_status']) ? $data['routing_status'] : null;
        $this->container['actual_activity_category'] = isset($data['actual_activity_category']) ? $data['actual_activity_category'] : null;
        $this->container['is_out_of_office'] = isset($data['is_out_of_office']) ? $data['is_out_of_office'] : false;
        $this->container['adherence_state'] = isset($data['adherence_state']) ? $data['adherence_state'] : null;
        $this->container['impact'] = isset($data['impact']) ? $data['impact'] : null;
        $this->container['time_of_adherence_change'] = isset($data['time_of_adherence_change']) ? $data['time_of_adherence_change'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "BLANK");
        if (!in_array($this->container['scheduled_activity_category'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'scheduled_activity_category', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break", "BLANK");
        if (!in_array($this->container['system_presence'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'system_presence', must be one of #{allowed_values}.";
        }

        $allowed_values = array("OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING");
        if (!in_array($this->container['routing_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'routing_status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "BLANK");
        if (!in_array($this->container['actual_activity_category'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actual_activity_category', must be one of #{allowed_values}.";
        }

        $allowed_values = array("InAdherence", "OutOfAdherence", "Unscheduled", "Unknown");
        if (!in_array($this->container['adherence_state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'adherence_state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Positive", "Negative", "Neutral", "Unknown");
        if (!in_array($this->container['impact'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'impact', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "BLANK");
        if (!in_array($this->container['scheduled_activity_category'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break", "BLANK");
        if (!in_array($this->container['system_presence'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING");
        if (!in_array($this->container['routing_status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "BLANK");
        if (!in_array($this->container['actual_activity_category'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("InAdherence", "OutOfAdherence", "Unscheduled", "Unknown");
        if (!in_array($this->container['adherence_state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Positive", "Negative", "Neutral", "Unknown");
        if (!in_array($this->container['impact'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user The user for whom this status applies
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets management_unit
     * @return \PureCloudSDK\ManagementUnit
     */
    public function getManagementUnit()
    {
        return $this->container['management_unit'];
    }

    /**
     * Sets management_unit
     * @param \PureCloudSDK\ManagementUnit $management_unit The management unit to which this user belongs
     * @return $this
     */
    public function setManagementUnit($management_unit)
    {
        $this->container['management_unit'] = $management_unit;

        return $this;
    }

    /**
     * Gets scheduled_activity_category
     * @return string
     */
    public function getScheduledActivityCategory()
    {
        return $this->container['scheduled_activity_category'];
    }

    /**
     * Sets scheduled_activity_category
     * @param string $scheduled_activity_category Activity for which the user is scheduled
     * @return $this
     */
    public function setScheduledActivityCategory($scheduled_activity_category)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'BLANK');
        if (!in_array($scheduled_activity_category, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'scheduled_activity_category', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'BLANK'");
        }
        $this->container['scheduled_activity_category'] = $scheduled_activity_category;

        return $this;
    }

    /**
     * Gets system_presence
     * @return string
     */
    public function getSystemPresence()
    {
        return $this->container['system_presence'];
    }

    /**
     * Sets system_presence
     * @param string $system_presence Actual underlying system presence value
     * @return $this
     */
    public function setSystemPresence($system_presence)
    {
        $allowed_values = array('Available', 'Away', 'Busy', 'Offline', 'Idle', 'OnQueue', 'Meal', 'Training', 'Meeting', 'Break', 'BLANK');
        if (!in_array($system_presence, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'system_presence', must be one of 'Available', 'Away', 'Busy', 'Offline', 'Idle', 'OnQueue', 'Meal', 'Training', 'Meeting', 'Break', 'BLANK'");
        }
        $this->container['system_presence'] = $system_presence;

        return $this;
    }

    /**
     * Gets organization_secondary_presence_id
     * @return string
     */
    public function getOrganizationSecondaryPresenceId()
    {
        return $this->container['organization_secondary_presence_id'];
    }

    /**
     * Sets organization_secondary_presence_id
     * @param string $organization_secondary_presence_id Organization Secondary Presence Id.
     * @return $this
     */
    public function setOrganizationSecondaryPresenceId($organization_secondary_presence_id)
    {
        $this->container['organization_secondary_presence_id'] = $organization_secondary_presence_id;

        return $this;
    }

    /**
     * Gets routing_status
     * @return string
     */
    public function getRoutingStatus()
    {
        return $this->container['routing_status'];
    }

    /**
     * Sets routing_status
     * @param string $routing_status Actual underlying routing status, used to determine whether a user is actually in adherence when OnQueue
     * @return $this
     */
    public function setRoutingStatus($routing_status)
    {
        $allowed_values = array('OFF_QUEUE', 'IDLE', 'INTERACTING', 'NOT_RESPONDING', 'COMMUNICATING');
        if (!in_array($routing_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'routing_status', must be one of 'OFF_QUEUE', 'IDLE', 'INTERACTING', 'NOT_RESPONDING', 'COMMUNICATING'");
        }
        $this->container['routing_status'] = $routing_status;

        return $this;
    }

    /**
     * Gets actual_activity_category
     * @return string
     */
    public function getActualActivityCategory()
    {
        return $this->container['actual_activity_category'];
    }

    /**
     * Sets actual_activity_category
     * @param string $actual_activity_category Activity in which the user is actually engaged
     * @return $this
     */
    public function setActualActivityCategory($actual_activity_category)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'BLANK');
        if (!in_array($actual_activity_category, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actual_activity_category', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'BLANK'");
        }
        $this->container['actual_activity_category'] = $actual_activity_category;

        return $this;
    }

    /**
     * Gets is_out_of_office
     * @return bool
     */
    public function getIsOutOfOffice()
    {
        return $this->container['is_out_of_office'];
    }

    /**
     * Sets is_out_of_office
     * @param bool $is_out_of_office Whether the user is marked OutOfOffice
     * @return $this
     */
    public function setIsOutOfOffice($is_out_of_office)
    {
        $this->container['is_out_of_office'] = $is_out_of_office;

        return $this;
    }

    /**
     * Gets adherence_state
     * @return string
     */
    public function getAdherenceState()
    {
        return $this->container['adherence_state'];
    }

    /**
     * Sets adherence_state
     * @param string $adherence_state The user's current adherence state
     * @return $this
     */
    public function setAdherenceState($adherence_state)
    {
        $allowed_values = array('InAdherence', 'OutOfAdherence', 'Unscheduled', 'Unknown');
        if (!in_array($adherence_state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'adherence_state', must be one of 'InAdherence', 'OutOfAdherence', 'Unscheduled', 'Unknown'");
        }
        $this->container['adherence_state'] = $adherence_state;

        return $this;
    }

    /**
     * Gets impact
     * @return string
     */
    public function getImpact()
    {
        return $this->container['impact'];
    }

    /**
     * Sets impact
     * @param string $impact The impact of the user's current adherenceState
     * @return $this
     */
    public function setImpact($impact)
    {
        $allowed_values = array('Positive', 'Negative', 'Neutral', 'Unknown');
        if (!in_array($impact, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'impact', must be one of 'Positive', 'Negative', 'Neutral', 'Unknown'");
        }
        $this->container['impact'] = $impact;

        return $this;
    }

    /**
     * Gets time_of_adherence_change
     * @return string
     */
    public function getTimeOfAdherenceChange()
    {
        return $this->container['time_of_adherence_change'];
    }

    /**
     * Sets time_of_adherence_change
     * @param string $time_of_adherence_change Time when the user entered the current adherenceState in ISO-8601 format
     * @return $this
     */
    public function setTimeOfAdherenceChange($time_of_adherence_change)
    {
        $this->container['time_of_adherence_change'] = $time_of_adherence_change;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


