<?php
/**
 * UserStations
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserStations Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserStations implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserStations';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'associated_station' => '\PureCloudSDK\UserStation',
        'effective_station' => '\PureCloudSDK\UserStation',
        'default_station' => '\PureCloudSDK\UserStation',
        'last_associated_station' => '\PureCloudSDK\UserStation'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'associated_station' => 'associatedStation',
        'effective_station' => 'effectiveStation',
        'default_station' => 'defaultStation',
        'last_associated_station' => 'lastAssociatedStation'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'associated_station' => 'setAssociatedStation',
        'effective_station' => 'setEffectiveStation',
        'default_station' => 'setDefaultStation',
        'last_associated_station' => 'setLastAssociatedStation'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'associated_station' => 'getAssociatedStation',
        'effective_station' => 'getEffectiveStation',
        'default_station' => 'getDefaultStation',
        'last_associated_station' => 'getLastAssociatedStation'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['associated_station'] = isset($data['associated_station']) ? $data['associated_station'] : null;
        $this->container['effective_station'] = isset($data['effective_station']) ? $data['effective_station'] : null;
        $this->container['default_station'] = isset($data['default_station']) ? $data['default_station'] : null;
        $this->container['last_associated_station'] = isset($data['last_associated_station']) ? $data['last_associated_station'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets associated_station
     * @return \PureCloudSDK\UserStation
     */
    public function getAssociatedStation()
    {
        return $this->container['associated_station'];
    }

    /**
     * Sets associated_station
     * @param \PureCloudSDK\UserStation $associated_station Current associated station for this user.
     * @return $this
     */
    public function setAssociatedStation($associated_station)
    {
        $this->container['associated_station'] = $associated_station;

        return $this;
    }

    /**
     * Gets effective_station
     * @return \PureCloudSDK\UserStation
     */
    public function getEffectiveStation()
    {
        return $this->container['effective_station'];
    }

    /**
     * Sets effective_station
     * @param \PureCloudSDK\UserStation $effective_station The station where the user can be reached based on their default and associated station.
     * @return $this
     */
    public function setEffectiveStation($effective_station)
    {
        $this->container['effective_station'] = $effective_station;

        return $this;
    }

    /**
     * Gets default_station
     * @return \PureCloudSDK\UserStation
     */
    public function getDefaultStation()
    {
        return $this->container['default_station'];
    }

    /**
     * Sets default_station
     * @param \PureCloudSDK\UserStation $default_station Default station to be used if not associated with a station.
     * @return $this
     */
    public function setDefaultStation($default_station)
    {
        $this->container['default_station'] = $default_station;

        return $this;
    }

    /**
     * Gets last_associated_station
     * @return \PureCloudSDK\UserStation
     */
    public function getLastAssociatedStation()
    {
        return $this->container['last_associated_station'];
    }

    /**
     * Sets last_associated_station
     * @param \PureCloudSDK\UserStation $last_associated_station Last associated station for this user.
     * @return $this
     */
    public function setLastAssociatedStation($last_associated_station)
    {
        $this->container['last_associated_station'] = $last_associated_station;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


