<?php
/**
 * VideoConversationNotificationParticipants
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VideoConversationNotificationParticipants Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VideoConversationNotificationParticipants implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VideoConversationNotification_participants';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'address' => 'string',
        'start_time' => '\DateTime',
        'connected_time' => '\DateTime',
        'end_time' => '\DateTime',
        'start_hold_time' => '\DateTime',
        'purpose' => 'string',
        'state' => 'string',
        'direction' => 'string',
        'disconnect_type' => 'string',
        'held' => 'bool',
        'wrapup_required' => 'bool',
        'wrapup_prompt' => 'string',
        'user' => '\PureCloudSDK\CallbackConversationNotificationUser',
        'queue' => '\PureCloudSDK\VideoConversationNotificationUriReference',
        'attributes' => 'map[string,string]',
        'error_info' => '\PureCloudSDK\VideoConversationNotificationErrorInfo',
        'script' => '\PureCloudSDK\VideoConversationNotificationUriReference',
        'wrapup_timeout_ms' => 'int',
        'wrapup_skipped' => 'bool',
        'provider' => 'string',
        'external_contact' => '\PureCloudSDK\VideoConversationNotificationUriReference',
        'external_organization' => '\PureCloudSDK\VideoConversationNotificationUriReference',
        'audio_muted' => 'bool',
        'video_muted' => 'bool',
        'sharing_screen' => 'bool',
        'peer_count' => 'int',
        'context' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'address' => 'address',
        'start_time' => 'startTime',
        'connected_time' => 'connectedTime',
        'end_time' => 'endTime',
        'start_hold_time' => 'startHoldTime',
        'purpose' => 'purpose',
        'state' => 'state',
        'direction' => 'direction',
        'disconnect_type' => 'disconnectType',
        'held' => 'held',
        'wrapup_required' => 'wrapupRequired',
        'wrapup_prompt' => 'wrapupPrompt',
        'user' => 'user',
        'queue' => 'queue',
        'attributes' => 'attributes',
        'error_info' => 'errorInfo',
        'script' => 'script',
        'wrapup_timeout_ms' => 'wrapupTimeoutMs',
        'wrapup_skipped' => 'wrapupSkipped',
        'provider' => 'provider',
        'external_contact' => 'externalContact',
        'external_organization' => 'externalOrganization',
        'audio_muted' => 'audioMuted',
        'video_muted' => 'videoMuted',
        'sharing_screen' => 'sharingScreen',
        'peer_count' => 'peerCount',
        'context' => 'context'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'address' => 'setAddress',
        'start_time' => 'setStartTime',
        'connected_time' => 'setConnectedTime',
        'end_time' => 'setEndTime',
        'start_hold_time' => 'setStartHoldTime',
        'purpose' => 'setPurpose',
        'state' => 'setState',
        'direction' => 'setDirection',
        'disconnect_type' => 'setDisconnectType',
        'held' => 'setHeld',
        'wrapup_required' => 'setWrapupRequired',
        'wrapup_prompt' => 'setWrapupPrompt',
        'user' => 'setUser',
        'queue' => 'setQueue',
        'attributes' => 'setAttributes',
        'error_info' => 'setErrorInfo',
        'script' => 'setScript',
        'wrapup_timeout_ms' => 'setWrapupTimeoutMs',
        'wrapup_skipped' => 'setWrapupSkipped',
        'provider' => 'setProvider',
        'external_contact' => 'setExternalContact',
        'external_organization' => 'setExternalOrganization',
        'audio_muted' => 'setAudioMuted',
        'video_muted' => 'setVideoMuted',
        'sharing_screen' => 'setSharingScreen',
        'peer_count' => 'setPeerCount',
        'context' => 'setContext'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'address' => 'getAddress',
        'start_time' => 'getStartTime',
        'connected_time' => 'getConnectedTime',
        'end_time' => 'getEndTime',
        'start_hold_time' => 'getStartHoldTime',
        'purpose' => 'getPurpose',
        'state' => 'getState',
        'direction' => 'getDirection',
        'disconnect_type' => 'getDisconnectType',
        'held' => 'getHeld',
        'wrapup_required' => 'getWrapupRequired',
        'wrapup_prompt' => 'getWrapupPrompt',
        'user' => 'getUser',
        'queue' => 'getQueue',
        'attributes' => 'getAttributes',
        'error_info' => 'getErrorInfo',
        'script' => 'getScript',
        'wrapup_timeout_ms' => 'getWrapupTimeoutMs',
        'wrapup_skipped' => 'getWrapupSkipped',
        'provider' => 'getProvider',
        'external_contact' => 'getExternalContact',
        'external_organization' => 'getExternalOrganization',
        'audio_muted' => 'getAudioMuted',
        'video_muted' => 'getVideoMuted',
        'sharing_screen' => 'getSharingScreen',
        'peer_count' => 'getPeerCount',
        'context' => 'getContext'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'alerting';
    const STATE_DIALING = 'dialing';
    const STATE_CONTACTING = 'contacting';
    const STATE_OFFERING = 'offering';
    const STATE_CONNECTED = 'connected';
    const STATE_DISCONNECTED = 'disconnected';
    const STATE_TERMINATED = 'terminated';
    const STATE_CONVERTING = 'converting';
    const STATE_UPLOADING = 'uploading';
    const STATE_TRANSMITTING = 'transmitting';
    const STATE_SCHEDULED = 'scheduled';
    const STATE_NONE = 'none';
    const DIRECTION_INBOUND = 'inbound';
    const DIRECTION_OUTBOUND = 'outbound';
    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_TIMEOUT = 'timeout';
    const DISCONNECT_TYPE_TRANSFERCONFERENCE = 'transfer.conference';
    const DISCONNECT_TYPE_TRANSFERCONSULT = 'transfer.consult';
    const DISCONNECT_TYPE_TRANSFERFORWARD = 'transfer.forward';
    const DISCONNECT_TYPE_TRANSFERNOANSWER = 'transfer.noanswer';
    const DISCONNECT_TYPE_TRANSFERNOTAVAILABLE = 'transfer.notavailable';
    const DISCONNECT_TYPE_TRANSPORTFAILURE = 'transport.failure';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_SCHEDULED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFERCONFERENCE,
            self::DISCONNECT_TYPE_TRANSFERCONSULT,
            self::DISCONNECT_TYPE_TRANSFERFORWARD,
            self::DISCONNECT_TYPE_TRANSFERNOANSWER,
            self::DISCONNECT_TYPE_TRANSFERNOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORTFAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['start_time'] = isset($data['start_time']) ? $data['start_time'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['end_time'] = isset($data['end_time']) ? $data['end_time'] : null;
        $this->container['start_hold_time'] = isset($data['start_hold_time']) ? $data['start_hold_time'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : null;
        $this->container['wrapup_required'] = isset($data['wrapup_required']) ? $data['wrapup_required'] : null;
        $this->container['wrapup_prompt'] = isset($data['wrapup_prompt']) ? $data['wrapup_prompt'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['error_info'] = isset($data['error_info']) ? $data['error_info'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['wrapup_timeout_ms'] = isset($data['wrapup_timeout_ms']) ? $data['wrapup_timeout_ms'] : null;
        $this->container['wrapup_skipped'] = isset($data['wrapup_skipped']) ? $data['wrapup_skipped'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['external_contact'] = isset($data['external_contact']) ? $data['external_contact'] : null;
        $this->container['external_organization'] = isset($data['external_organization']) ? $data['external_organization'] : null;
        $this->container['audio_muted'] = isset($data['audio_muted']) ? $data['audio_muted'] : null;
        $this->container['video_muted'] = isset($data['video_muted']) ? $data['video_muted'] : null;
        $this->container['sharing_screen'] = isset($data['sharing_screen']) ? $data['sharing_screen'] : null;
        $this->container['peer_count'] = isset($data['peer_count']) ? $data['peer_count'] : null;
        $this->container['context'] = isset($data['context']) ? $data['context'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "scheduled", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "transfer", "timeout", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "scheduled", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "transfer", "timeout", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets start_time
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     * @param \DateTime $start_time
     * @return $this
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets end_time
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     * @param \DateTime $end_time
     * @return $this
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets start_hold_time
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['start_hold_time'];
    }

    /**
     * Sets start_hold_time
     * @param \DateTime $start_hold_time
     * @return $this
     */
    public function setStartHoldTime($start_hold_time)
    {
        $this->container['start_hold_time'] = $start_hold_time;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'scheduled', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'scheduled', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'transfer', 'timeout', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'endpoint', 'client', 'system', 'transfer', 'timeout', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets wrapup_required
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapup_required'];
    }

    /**
     * Sets wrapup_required
     * @param bool $wrapup_required
     * @return $this
     */
    public function setWrapupRequired($wrapup_required)
    {
        $this->container['wrapup_required'] = $wrapup_required;

        return $this;
    }

    /**
     * Gets wrapup_prompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapup_prompt'];
    }

    /**
     * Sets wrapup_prompt
     * @param string $wrapup_prompt
     * @return $this
     */
    public function setWrapupPrompt($wrapup_prompt)
    {
        $this->container['wrapup_prompt'] = $wrapup_prompt;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\CallbackConversationNotificationUser
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\CallbackConversationNotificationUser $user
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\VideoConversationNotificationUriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\VideoConversationNotificationUriReference $queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets error_info
     * @return \PureCloudSDK\VideoConversationNotificationErrorInfo
     */
    public function getErrorInfo()
    {
        return $this->container['error_info'];
    }

    /**
     * Sets error_info
     * @param \PureCloudSDK\VideoConversationNotificationErrorInfo $error_info
     * @return $this
     */
    public function setErrorInfo($error_info)
    {
        $this->container['error_info'] = $error_info;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\VideoConversationNotificationUriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\VideoConversationNotificationUriReference $script
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets wrapup_timeout_ms
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapup_timeout_ms'];
    }

    /**
     * Sets wrapup_timeout_ms
     * @param int $wrapup_timeout_ms
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapup_timeout_ms)
    {
        $this->container['wrapup_timeout_ms'] = $wrapup_timeout_ms;

        return $this;
    }

    /**
     * Gets wrapup_skipped
     * @return bool
     */
    public function getWrapupSkipped()
    {
        return $this->container['wrapup_skipped'];
    }

    /**
     * Sets wrapup_skipped
     * @param bool $wrapup_skipped
     * @return $this
     */
    public function setWrapupSkipped($wrapup_skipped)
    {
        $this->container['wrapup_skipped'] = $wrapup_skipped;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets external_contact
     * @return \PureCloudSDK\VideoConversationNotificationUriReference
     */
    public function getExternalContact()
    {
        return $this->container['external_contact'];
    }

    /**
     * Sets external_contact
     * @param \PureCloudSDK\VideoConversationNotificationUriReference $external_contact
     * @return $this
     */
    public function setExternalContact($external_contact)
    {
        $this->container['external_contact'] = $external_contact;

        return $this;
    }

    /**
     * Gets external_organization
     * @return \PureCloudSDK\VideoConversationNotificationUriReference
     */
    public function getExternalOrganization()
    {
        return $this->container['external_organization'];
    }

    /**
     * Sets external_organization
     * @param \PureCloudSDK\VideoConversationNotificationUriReference $external_organization
     * @return $this
     */
    public function setExternalOrganization($external_organization)
    {
        $this->container['external_organization'] = $external_organization;

        return $this;
    }

    /**
     * Gets audio_muted
     * @return bool
     */
    public function getAudioMuted()
    {
        return $this->container['audio_muted'];
    }

    /**
     * Sets audio_muted
     * @param bool $audio_muted
     * @return $this
     */
    public function setAudioMuted($audio_muted)
    {
        $this->container['audio_muted'] = $audio_muted;

        return $this;
    }

    /**
     * Gets video_muted
     * @return bool
     */
    public function getVideoMuted()
    {
        return $this->container['video_muted'];
    }

    /**
     * Sets video_muted
     * @param bool $video_muted
     * @return $this
     */
    public function setVideoMuted($video_muted)
    {
        $this->container['video_muted'] = $video_muted;

        return $this;
    }

    /**
     * Gets sharing_screen
     * @return bool
     */
    public function getSharingScreen()
    {
        return $this->container['sharing_screen'];
    }

    /**
     * Sets sharing_screen
     * @param bool $sharing_screen
     * @return $this
     */
    public function setSharingScreen($sharing_screen)
    {
        $this->container['sharing_screen'] = $sharing_screen;

        return $this;
    }

    /**
     * Gets peer_count
     * @return int
     */
    public function getPeerCount()
    {
        return $this->container['peer_count'];
    }

    /**
     * Sets peer_count
     * @param int $peer_count
     * @return $this
     */
    public function setPeerCount($peer_count)
    {
        $this->container['peer_count'] = $peer_count;

        return $this;
    }

    /**
     * Gets context
     * @return string
     */
    public function getContext()
    {
        return $this->container['context'];
    }

    /**
     * Sets context
     * @param string $context
     * @return $this
     */
    public function setContext($context)
    {
        $this->container['context'] = $context;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


