<?php
/**
 * VoicemailMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoicemailMessage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoicemailMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoicemailMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'conversation' => '\PureCloudSDK\Conversation',
        'read' => 'bool',
        'audio_recording_duration_seconds' => 'int',
        'audio_recording_size_bytes' => 'int',
        'created_date' => '\DateTime',
        'modified_date' => '\DateTime',
        'caller_address' => 'string',
        'caller_name' => 'string',
        'caller_user' => '\PureCloudSDK\User',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'conversation' => 'conversation',
        'read' => 'read',
        'audio_recording_duration_seconds' => 'audioRecordingDurationSeconds',
        'audio_recording_size_bytes' => 'audioRecordingSizeBytes',
        'created_date' => 'createdDate',
        'modified_date' => 'modifiedDate',
        'caller_address' => 'callerAddress',
        'caller_name' => 'callerName',
        'caller_user' => 'callerUser',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'conversation' => 'setConversation',
        'read' => 'setRead',
        'audio_recording_duration_seconds' => 'setAudioRecordingDurationSeconds',
        'audio_recording_size_bytes' => 'setAudioRecordingSizeBytes',
        'created_date' => 'setCreatedDate',
        'modified_date' => 'setModifiedDate',
        'caller_address' => 'setCallerAddress',
        'caller_name' => 'setCallerName',
        'caller_user' => 'setCallerUser',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'conversation' => 'getConversation',
        'read' => 'getRead',
        'audio_recording_duration_seconds' => 'getAudioRecordingDurationSeconds',
        'audio_recording_size_bytes' => 'getAudioRecordingSizeBytes',
        'created_date' => 'getCreatedDate',
        'modified_date' => 'getModifiedDate',
        'caller_address' => 'getCallerAddress',
        'caller_name' => 'getCallerName',
        'caller_user' => 'getCallerUser',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : false;
        $this->container['audio_recording_duration_seconds'] = isset($data['audio_recording_duration_seconds']) ? $data['audio_recording_duration_seconds'] : null;
        $this->container['audio_recording_size_bytes'] = isset($data['audio_recording_size_bytes']) ? $data['audio_recording_size_bytes'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['caller_address'] = isset($data['caller_address']) ? $data['caller_address'] : null;
        $this->container['caller_name'] = isset($data['caller_name']) ? $data['caller_name'] : null;
        $this->container['caller_user'] = isset($data['caller_user']) ? $data['caller_user'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets audio_recording_duration_seconds
     * @return int
     */
    public function getAudioRecordingDurationSeconds()
    {
        return $this->container['audio_recording_duration_seconds'];
    }

    /**
     * Sets audio_recording_duration_seconds
     * @param int $audio_recording_duration_seconds
     * @return $this
     */
    public function setAudioRecordingDurationSeconds($audio_recording_duration_seconds)
    {
        $this->container['audio_recording_duration_seconds'] = $audio_recording_duration_seconds;

        return $this;
    }

    /**
     * Gets audio_recording_size_bytes
     * @return int
     */
    public function getAudioRecordingSizeBytes()
    {
        return $this->container['audio_recording_size_bytes'];
    }

    /**
     * Sets audio_recording_size_bytes
     * @param int $audio_recording_size_bytes
     * @return $this
     */
    public function setAudioRecordingSizeBytes($audio_recording_size_bytes)
    {
        $this->container['audio_recording_size_bytes'] = $audio_recording_size_bytes;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets caller_address
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['caller_address'];
    }

    /**
     * Sets caller_address
     * @param string $caller_address
     * @return $this
     */
    public function setCallerAddress($caller_address)
    {
        $this->container['caller_address'] = $caller_address;

        return $this;
    }

    /**
     * Gets caller_name
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['caller_name'];
    }

    /**
     * Sets caller_name
     * @param string $caller_name
     * @return $this
     */
    public function setCallerName($caller_name)
    {
        $this->container['caller_name'] = $caller_name;

        return $this;
    }

    /**
     * Gets caller_user
     * @return \PureCloudSDK\User
     */
    public function getCallerUser()
    {
        return $this->container['caller_user'];
    }

    /**
     * Sets caller_user
     * @param \PureCloudSDK\User $caller_user
     * @return $this
     */
    public function setCallerUser($caller_user)
    {
        $this->container['caller_user'] = $caller_user;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


