<?php
/**
 * VoicemailOrganizationPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoicemailOrganizationPolicy Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoicemailOrganizationPolicy implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoicemailOrganizationPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'enabled' => 'bool',
        'retention_time_days' => 'int',
        'alert_timeout_seconds' => 'int',
        'minimum_recording_time_seconds' => 'int',
        'maximum_recording_time_seconds' => 'int',
        'unavailable_message_uri' => 'string',
        'name_prompt_message_uri' => 'string',
        'full_message_uri' => 'string',
        'compress_silence' => 'bool',
        'pin_configuration' => '\PureCloudSDK\PINConfiguration',
        'quota_size_bytes' => 'int',
        'created_date' => '\DateTime',
        'modified_date' => '\DateTime',
        'voicemail_extension' => 'string',
        'pin_required' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'enabled' => 'enabled',
        'retention_time_days' => 'retentionTimeDays',
        'alert_timeout_seconds' => 'alertTimeoutSeconds',
        'minimum_recording_time_seconds' => 'minimumRecordingTimeSeconds',
        'maximum_recording_time_seconds' => 'maximumRecordingTimeSeconds',
        'unavailable_message_uri' => 'unavailableMessageUri',
        'name_prompt_message_uri' => 'namePromptMessageUri',
        'full_message_uri' => 'fullMessageUri',
        'compress_silence' => 'compressSilence',
        'pin_configuration' => 'pinConfiguration',
        'quota_size_bytes' => 'quotaSizeBytes',
        'created_date' => 'createdDate',
        'modified_date' => 'modifiedDate',
        'voicemail_extension' => 'voicemailExtension',
        'pin_required' => 'pinRequired'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'enabled' => 'setEnabled',
        'retention_time_days' => 'setRetentionTimeDays',
        'alert_timeout_seconds' => 'setAlertTimeoutSeconds',
        'minimum_recording_time_seconds' => 'setMinimumRecordingTimeSeconds',
        'maximum_recording_time_seconds' => 'setMaximumRecordingTimeSeconds',
        'unavailable_message_uri' => 'setUnavailableMessageUri',
        'name_prompt_message_uri' => 'setNamePromptMessageUri',
        'full_message_uri' => 'setFullMessageUri',
        'compress_silence' => 'setCompressSilence',
        'pin_configuration' => 'setPinConfiguration',
        'quota_size_bytes' => 'setQuotaSizeBytes',
        'created_date' => 'setCreatedDate',
        'modified_date' => 'setModifiedDate',
        'voicemail_extension' => 'setVoicemailExtension',
        'pin_required' => 'setPinRequired'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'enabled' => 'getEnabled',
        'retention_time_days' => 'getRetentionTimeDays',
        'alert_timeout_seconds' => 'getAlertTimeoutSeconds',
        'minimum_recording_time_seconds' => 'getMinimumRecordingTimeSeconds',
        'maximum_recording_time_seconds' => 'getMaximumRecordingTimeSeconds',
        'unavailable_message_uri' => 'getUnavailableMessageUri',
        'name_prompt_message_uri' => 'getNamePromptMessageUri',
        'full_message_uri' => 'getFullMessageUri',
        'compress_silence' => 'getCompressSilence',
        'pin_configuration' => 'getPinConfiguration',
        'quota_size_bytes' => 'getQuotaSizeBytes',
        'created_date' => 'getCreatedDate',
        'modified_date' => 'getModifiedDate',
        'voicemail_extension' => 'getVoicemailExtension',
        'pin_required' => 'getPinRequired'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['retention_time_days'] = isset($data['retention_time_days']) ? $data['retention_time_days'] : null;
        $this->container['alert_timeout_seconds'] = isset($data['alert_timeout_seconds']) ? $data['alert_timeout_seconds'] : null;
        $this->container['minimum_recording_time_seconds'] = isset($data['minimum_recording_time_seconds']) ? $data['minimum_recording_time_seconds'] : null;
        $this->container['maximum_recording_time_seconds'] = isset($data['maximum_recording_time_seconds']) ? $data['maximum_recording_time_seconds'] : null;
        $this->container['unavailable_message_uri'] = isset($data['unavailable_message_uri']) ? $data['unavailable_message_uri'] : null;
        $this->container['name_prompt_message_uri'] = isset($data['name_prompt_message_uri']) ? $data['name_prompt_message_uri'] : null;
        $this->container['full_message_uri'] = isset($data['full_message_uri']) ? $data['full_message_uri'] : null;
        $this->container['compress_silence'] = isset($data['compress_silence']) ? $data['compress_silence'] : false;
        $this->container['pin_configuration'] = isset($data['pin_configuration']) ? $data['pin_configuration'] : null;
        $this->container['quota_size_bytes'] = isset($data['quota_size_bytes']) ? $data['quota_size_bytes'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['voicemail_extension'] = isset($data['voicemail_extension']) ? $data['voicemail_extension'] : null;
        $this->container['pin_required'] = isset($data['pin_required']) ? $data['pin_required'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets retention_time_days
     * @return int
     */
    public function getRetentionTimeDays()
    {
        return $this->container['retention_time_days'];
    }

    /**
     * Sets retention_time_days
     * @param int $retention_time_days
     * @return $this
     */
    public function setRetentionTimeDays($retention_time_days)
    {
        $this->container['retention_time_days'] = $retention_time_days;

        return $this;
    }

    /**
     * Gets alert_timeout_seconds
     * @return int
     */
    public function getAlertTimeoutSeconds()
    {
        return $this->container['alert_timeout_seconds'];
    }

    /**
     * Sets alert_timeout_seconds
     * @param int $alert_timeout_seconds
     * @return $this
     */
    public function setAlertTimeoutSeconds($alert_timeout_seconds)
    {
        $this->container['alert_timeout_seconds'] = $alert_timeout_seconds;

        return $this;
    }

    /**
     * Gets minimum_recording_time_seconds
     * @return int
     */
    public function getMinimumRecordingTimeSeconds()
    {
        return $this->container['minimum_recording_time_seconds'];
    }

    /**
     * Sets minimum_recording_time_seconds
     * @param int $minimum_recording_time_seconds
     * @return $this
     */
    public function setMinimumRecordingTimeSeconds($minimum_recording_time_seconds)
    {
        $this->container['minimum_recording_time_seconds'] = $minimum_recording_time_seconds;

        return $this;
    }

    /**
     * Gets maximum_recording_time_seconds
     * @return int
     */
    public function getMaximumRecordingTimeSeconds()
    {
        return $this->container['maximum_recording_time_seconds'];
    }

    /**
     * Sets maximum_recording_time_seconds
     * @param int $maximum_recording_time_seconds
     * @return $this
     */
    public function setMaximumRecordingTimeSeconds($maximum_recording_time_seconds)
    {
        $this->container['maximum_recording_time_seconds'] = $maximum_recording_time_seconds;

        return $this;
    }

    /**
     * Gets unavailable_message_uri
     * @return string
     */
    public function getUnavailableMessageUri()
    {
        return $this->container['unavailable_message_uri'];
    }

    /**
     * Sets unavailable_message_uri
     * @param string $unavailable_message_uri
     * @return $this
     */
    public function setUnavailableMessageUri($unavailable_message_uri)
    {
        $this->container['unavailable_message_uri'] = $unavailable_message_uri;

        return $this;
    }

    /**
     * Gets name_prompt_message_uri
     * @return string
     */
    public function getNamePromptMessageUri()
    {
        return $this->container['name_prompt_message_uri'];
    }

    /**
     * Sets name_prompt_message_uri
     * @param string $name_prompt_message_uri
     * @return $this
     */
    public function setNamePromptMessageUri($name_prompt_message_uri)
    {
        $this->container['name_prompt_message_uri'] = $name_prompt_message_uri;

        return $this;
    }

    /**
     * Gets full_message_uri
     * @return string
     */
    public function getFullMessageUri()
    {
        return $this->container['full_message_uri'];
    }

    /**
     * Sets full_message_uri
     * @param string $full_message_uri
     * @return $this
     */
    public function setFullMessageUri($full_message_uri)
    {
        $this->container['full_message_uri'] = $full_message_uri;

        return $this;
    }

    /**
     * Gets compress_silence
     * @return bool
     */
    public function getCompressSilence()
    {
        return $this->container['compress_silence'];
    }

    /**
     * Sets compress_silence
     * @param bool $compress_silence
     * @return $this
     */
    public function setCompressSilence($compress_silence)
    {
        $this->container['compress_silence'] = $compress_silence;

        return $this;
    }

    /**
     * Gets pin_configuration
     * @return \PureCloudSDK\PINConfiguration
     */
    public function getPinConfiguration()
    {
        return $this->container['pin_configuration'];
    }

    /**
     * Sets pin_configuration
     * @param \PureCloudSDK\PINConfiguration $pin_configuration
     * @return $this
     */
    public function setPinConfiguration($pin_configuration)
    {
        $this->container['pin_configuration'] = $pin_configuration;

        return $this;
    }

    /**
     * Gets quota_size_bytes
     * @return int
     */
    public function getQuotaSizeBytes()
    {
        return $this->container['quota_size_bytes'];
    }

    /**
     * Sets quota_size_bytes
     * @param int $quota_size_bytes
     * @return $this
     */
    public function setQuotaSizeBytes($quota_size_bytes)
    {
        $this->container['quota_size_bytes'] = $quota_size_bytes;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets voicemail_extension
     * @return string
     */
    public function getVoicemailExtension()
    {
        return $this->container['voicemail_extension'];
    }

    /**
     * Sets voicemail_extension
     * @param string $voicemail_extension The extension for voicemail retrieval.  The default value is *86.
     * @return $this
     */
    public function setVoicemailExtension($voicemail_extension)
    {
        $this->container['voicemail_extension'] = $voicemail_extension;

        return $this;
    }

    /**
     * Gets pin_required
     * @return bool
     */
    public function getPinRequired()
    {
        return $this->container['pin_required'];
    }

    /**
     * Sets pin_required
     * @param bool $pin_required If this is true, a PIN is required when accessing a user's voicemail from a phone.
     * @return $this
     */
    public function setPinRequired($pin_required)
    {
        $this->container['pin_required'] = $pin_required;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


