<?php
/**
 * VoicemailUserPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoicemailUserPolicy Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoicemailUserPolicy implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoicemailUserPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'enabled' => 'bool',
        'alert_timeout_seconds' => 'int',
        'minimum_recording_time_seconds' => 'int',
        'maximum_recording_time_seconds' => 'int',
        'unavailable_message_uri' => 'string',
        'name_prompt_message_uri' => 'string',
        'full_message_uri' => 'string',
        'pin' => 'string',
        'quota_size_bytes' => 'int',
        'created_date' => '\DateTime',
        'modified_date' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'enabled' => 'enabled',
        'alert_timeout_seconds' => 'alertTimeoutSeconds',
        'minimum_recording_time_seconds' => 'minimumRecordingTimeSeconds',
        'maximum_recording_time_seconds' => 'maximumRecordingTimeSeconds',
        'unavailable_message_uri' => 'unavailableMessageUri',
        'name_prompt_message_uri' => 'namePromptMessageUri',
        'full_message_uri' => 'fullMessageUri',
        'pin' => 'pin',
        'quota_size_bytes' => 'quotaSizeBytes',
        'created_date' => 'createdDate',
        'modified_date' => 'modifiedDate'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'enabled' => 'setEnabled',
        'alert_timeout_seconds' => 'setAlertTimeoutSeconds',
        'minimum_recording_time_seconds' => 'setMinimumRecordingTimeSeconds',
        'maximum_recording_time_seconds' => 'setMaximumRecordingTimeSeconds',
        'unavailable_message_uri' => 'setUnavailableMessageUri',
        'name_prompt_message_uri' => 'setNamePromptMessageUri',
        'full_message_uri' => 'setFullMessageUri',
        'pin' => 'setPin',
        'quota_size_bytes' => 'setQuotaSizeBytes',
        'created_date' => 'setCreatedDate',
        'modified_date' => 'setModifiedDate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'enabled' => 'getEnabled',
        'alert_timeout_seconds' => 'getAlertTimeoutSeconds',
        'minimum_recording_time_seconds' => 'getMinimumRecordingTimeSeconds',
        'maximum_recording_time_seconds' => 'getMaximumRecordingTimeSeconds',
        'unavailable_message_uri' => 'getUnavailableMessageUri',
        'name_prompt_message_uri' => 'getNamePromptMessageUri',
        'full_message_uri' => 'getFullMessageUri',
        'pin' => 'getPin',
        'quota_size_bytes' => 'getQuotaSizeBytes',
        'created_date' => 'getCreatedDate',
        'modified_date' => 'getModifiedDate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['alert_timeout_seconds'] = isset($data['alert_timeout_seconds']) ? $data['alert_timeout_seconds'] : null;
        $this->container['minimum_recording_time_seconds'] = isset($data['minimum_recording_time_seconds']) ? $data['minimum_recording_time_seconds'] : null;
        $this->container['maximum_recording_time_seconds'] = isset($data['maximum_recording_time_seconds']) ? $data['maximum_recording_time_seconds'] : null;
        $this->container['unavailable_message_uri'] = isset($data['unavailable_message_uri']) ? $data['unavailable_message_uri'] : null;
        $this->container['name_prompt_message_uri'] = isset($data['name_prompt_message_uri']) ? $data['name_prompt_message_uri'] : null;
        $this->container['full_message_uri'] = isset($data['full_message_uri']) ? $data['full_message_uri'] : null;
        $this->container['pin'] = isset($data['pin']) ? $data['pin'] : null;
        $this->container['quota_size_bytes'] = isset($data['quota_size_bytes']) ? $data['quota_size_bytes'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets alert_timeout_seconds
     * @return int
     */
    public function getAlertTimeoutSeconds()
    {
        return $this->container['alert_timeout_seconds'];
    }

    /**
     * Sets alert_timeout_seconds
     * @param int $alert_timeout_seconds
     * @return $this
     */
    public function setAlertTimeoutSeconds($alert_timeout_seconds)
    {
        $this->container['alert_timeout_seconds'] = $alert_timeout_seconds;

        return $this;
    }

    /**
     * Gets minimum_recording_time_seconds
     * @return int
     */
    public function getMinimumRecordingTimeSeconds()
    {
        return $this->container['minimum_recording_time_seconds'];
    }

    /**
     * Sets minimum_recording_time_seconds
     * @param int $minimum_recording_time_seconds
     * @return $this
     */
    public function setMinimumRecordingTimeSeconds($minimum_recording_time_seconds)
    {
        $this->container['minimum_recording_time_seconds'] = $minimum_recording_time_seconds;

        return $this;
    }

    /**
     * Gets maximum_recording_time_seconds
     * @return int
     */
    public function getMaximumRecordingTimeSeconds()
    {
        return $this->container['maximum_recording_time_seconds'];
    }

    /**
     * Sets maximum_recording_time_seconds
     * @param int $maximum_recording_time_seconds
     * @return $this
     */
    public function setMaximumRecordingTimeSeconds($maximum_recording_time_seconds)
    {
        $this->container['maximum_recording_time_seconds'] = $maximum_recording_time_seconds;

        return $this;
    }

    /**
     * Gets unavailable_message_uri
     * @return string
     */
    public function getUnavailableMessageUri()
    {
        return $this->container['unavailable_message_uri'];
    }

    /**
     * Sets unavailable_message_uri
     * @param string $unavailable_message_uri
     * @return $this
     */
    public function setUnavailableMessageUri($unavailable_message_uri)
    {
        $this->container['unavailable_message_uri'] = $unavailable_message_uri;

        return $this;
    }

    /**
     * Gets name_prompt_message_uri
     * @return string
     */
    public function getNamePromptMessageUri()
    {
        return $this->container['name_prompt_message_uri'];
    }

    /**
     * Sets name_prompt_message_uri
     * @param string $name_prompt_message_uri
     * @return $this
     */
    public function setNamePromptMessageUri($name_prompt_message_uri)
    {
        $this->container['name_prompt_message_uri'] = $name_prompt_message_uri;

        return $this;
    }

    /**
     * Gets full_message_uri
     * @return string
     */
    public function getFullMessageUri()
    {
        return $this->container['full_message_uri'];
    }

    /**
     * Sets full_message_uri
     * @param string $full_message_uri
     * @return $this
     */
    public function setFullMessageUri($full_message_uri)
    {
        $this->container['full_message_uri'] = $full_message_uri;

        return $this;
    }

    /**
     * Gets pin
     * @return string
     */
    public function getPin()
    {
        return $this->container['pin'];
    }

    /**
     * Sets pin
     * @param string $pin
     * @return $this
     */
    public function setPin($pin)
    {
        $this->container['pin'] = $pin;

        return $this;
    }

    /**
     * Gets quota_size_bytes
     * @return int
     */
    public function getQuotaSizeBytes()
    {
        return $this->container['quota_size_bytes'];
    }

    /**
     * Sets quota_size_bytes
     * @param int $quota_size_bytes
     * @return $this
     */
    public function setQuotaSizeBytes($quota_size_bytes)
    {
        $this->container['quota_size_bytes'] = $quota_size_bytes;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


