# PureCloudSDK\AnalyticsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteReportingSchedulesScheduleId**](AnalyticsApi.md#deleteReportingSchedulesScheduleId) | **DELETE** /api/v2/analytics/reporting/schedules/{scheduleId} | Delete a scheduled report job.
[**getConversationsConversationIdDetails**](AnalyticsApi.md#getConversationsConversationIdDetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
[**getReportingMetadata**](AnalyticsApi.md#getReportingMetadata) | **GET** /api/v2/analytics/reporting/metadata | Get list of reporting metadata.
[**getReportingReportIdMetadata**](AnalyticsApi.md#getReportingReportIdMetadata) | **GET** /api/v2/analytics/reporting/{reportId}/metadata | Get a reporting metadata.
[**getReportingReportformats**](AnalyticsApi.md#getReportingReportformats) | **GET** /api/v2/analytics/reporting/reportformats | Get a list of report formats
[**getReportingSchedules**](AnalyticsApi.md#getReportingSchedules) | **GET** /api/v2/analytics/reporting/schedules | Get a list of scheduled report jobs
[**getReportingSchedulesScheduleId**](AnalyticsApi.md#getReportingSchedulesScheduleId) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId} | Get a scheduled report job.
[**getReportingSchedulesScheduleIdHistory**](AnalyticsApi.md#getReportingSchedulesScheduleIdHistory) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history | Get list of completed scheduled report jobs.
[**getReportingSchedulesScheduleIdHistoryLatest**](AnalyticsApi.md#getReportingSchedulesScheduleIdHistoryLatest) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/latest | Get most recently completed scheduled report job.
[**getReportingSchedulesScheduleIdHistoryRunId**](AnalyticsApi.md#getReportingSchedulesScheduleIdHistoryRunId) | **GET** /api/v2/analytics/reporting/schedules/{scheduleId}/history/{runId} | A completed scheduled report job
[**getReportingTimeperiods**](AnalyticsApi.md#getReportingTimeperiods) | **GET** /api/v2/analytics/reporting/timeperiods | Get a list of report time periods.
[**postConversationsAggregatesQuery**](AnalyticsApi.md#postConversationsAggregatesQuery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
[**postConversationsConversationIdDetailsProperties**](AnalyticsApi.md#postConversationsConversationIdDetailsProperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
[**postConversationsDetailsQuery**](AnalyticsApi.md#postConversationsDetailsQuery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
[**postEvaluationsAggregatesQuery**](AnalyticsApi.md#postEvaluationsAggregatesQuery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
[**postQueuesObservationsQuery**](AnalyticsApi.md#postQueuesObservationsQuery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
[**postReportingSchedules**](AnalyticsApi.md#postReportingSchedules) | **POST** /api/v2/analytics/reporting/schedules | Create a scheduled report job
[**postReportingSchedulesScheduleIdRunreport**](AnalyticsApi.md#postReportingSchedulesScheduleIdRunreport) | **POST** /api/v2/analytics/reporting/schedules/{scheduleId}/runreport | Place a scheduled report immediately into the reporting queue
[**postUsersAggregatesQuery**](AnalyticsApi.md#postUsersAggregatesQuery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
[**postUsersObservationsQuery**](AnalyticsApi.md#postUsersObservationsQuery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
[**putReportingSchedulesScheduleId**](AnalyticsApi.md#putReportingSchedulesScheduleId) | **PUT** /api/v2/analytics/reporting/schedules/{scheduleId} | Update a scheduled report job.


# **deleteReportingSchedulesScheduleId**
> string deleteReportingSchedulesScheduleId($schedule_id)

Delete a scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$schedule_id = "schedule_id_example"; // string | Schedule ID

try {
    $result = $api_instance->deleteReportingSchedulesScheduleId($schedule_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->deleteReportingSchedulesScheduleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **string**| Schedule ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdDetails**
> \PureCloudSDK\AnalyticsConversation getConversationsConversationIdDetails($conversation_id)

Get a conversation by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$conversation_id = "conversation_id_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsConversationIdDetails($conversation_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getConversationsConversationIdDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversation_id** | **string**| conversationId |

### Return type

[**\PureCloudSDK\AnalyticsConversation**](../Model/AnalyticsConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingMetadata**
> \PureCloudSDK\ReportMetaDataEntityListing getReportingMetadata($page_number, $page_size, $locale)

Get list of reporting metadata.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size
$locale = "locale_example"; // string | Locale

try {
    $result = $api_instance->getReportingMetadata($page_number, $page_size, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingMetadata: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **locale** | **string**| Locale | [optional]

### Return type

[**\PureCloudSDK\ReportMetaDataEntityListing**](../Model/ReportMetaDataEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingReportIdMetadata**
> \PureCloudSDK\ReportMetaData getReportingReportIdMetadata($report_id, $locale)

Get a reporting metadata.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$report_id = "report_id_example"; // string | Report ID
$locale = "locale_example"; // string | Locale

try {
    $result = $api_instance->getReportingReportIdMetadata($report_id, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingReportIdMetadata: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **report_id** | **string**| Report ID |
 **locale** | **string**| Locale | [optional]

### Return type

[**\PureCloudSDK\ReportMetaData**](../Model/ReportMetaData.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingReportformats**
> string[] getReportingReportformats()

Get a list of report formats

Get a list of report formats.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();

try {
    $result = $api_instance->getReportingReportformats();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingReportformats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingSchedules**
> \PureCloudSDK\ReportScheduleEntityListing getReportingSchedules($page_number, $page_size)

Get a list of scheduled report jobs

Get a list of scheduled report jobs.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size

try {
    $result = $api_instance->getReportingSchedules($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingSchedules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ReportScheduleEntityListing**](../Model/ReportScheduleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingSchedulesScheduleId**
> \PureCloudSDK\ReportSchedule getReportingSchedulesScheduleId($schedule_id)

Get a scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$schedule_id = "schedule_id_example"; // string | Schedule ID

try {
    $result = $api_instance->getReportingSchedulesScheduleId($schedule_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingSchedulesScheduleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\ReportSchedule**](../Model/ReportSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingSchedulesScheduleIdHistory**
> \PureCloudSDK\ReportRunEntryEntityDomainListing getReportingSchedulesScheduleIdHistory($schedule_id, $page_number, $page_size)

Get list of completed scheduled report jobs.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$schedule_id = "schedule_id_example"; // string | Schedule ID
$page_number = 1; // int | 
$page_size = 25; // int | 

try {
    $result = $api_instance->getReportingSchedulesScheduleIdHistory($schedule_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingSchedulesScheduleIdHistory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **string**| Schedule ID |
 **page_number** | **int**|  | [optional] [default to 1]
 **page_size** | **int**|  | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ReportRunEntryEntityDomainListing**](../Model/ReportRunEntryEntityDomainListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingSchedulesScheduleIdHistoryLatest**
> \PureCloudSDK\ReportRunEntry getReportingSchedulesScheduleIdHistoryLatest($schedule_id)

Get most recently completed scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$schedule_id = "schedule_id_example"; // string | Schedule ID

try {
    $result = $api_instance->getReportingSchedulesScheduleIdHistoryLatest($schedule_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingSchedulesScheduleIdHistoryLatest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\ReportRunEntry**](../Model/ReportRunEntry.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingSchedulesScheduleIdHistoryRunId**
> \PureCloudSDK\ReportRunEntry getReportingSchedulesScheduleIdHistoryRunId($run_id, $schedule_id)

A completed scheduled report job

A completed scheduled report job.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$run_id = "run_id_example"; // string | Run ID
$schedule_id = "schedule_id_example"; // string | Schedule ID

try {
    $result = $api_instance->getReportingSchedulesScheduleIdHistoryRunId($run_id, $schedule_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingSchedulesScheduleIdHistoryRunId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **run_id** | **string**| Run ID |
 **schedule_id** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\ReportRunEntry**](../Model/ReportRunEntry.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReportingTimeperiods**
> string[] getReportingTimeperiods()

Get a list of report time periods.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();

try {
    $result = $api_instance->getReportingTimeperiods();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->getReportingTimeperiods: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postConversationsAggregatesQuery($body)

Query for conversation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postConversationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postConversationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdDetailsProperties**
> \PureCloudSDK\PropertyIndexRequest postConversationsConversationIdDetailsProperties($conversation_id, $body)

Index conversation properties



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$conversation_id = "conversation_id_example"; // string | conversationId
$body = new \PureCloudSDK\PropertyIndexRequest(); // \PureCloudSDK\PropertyIndexRequest | request

try {
    $result = $api_instance->postConversationsConversationIdDetailsProperties($conversation_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postConversationsConversationIdDetailsProperties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversation_id** | **string**| conversationId |
 **body** | [**\PureCloudSDK\PropertyIndexRequest**](../Model/\PureCloudSDK\PropertyIndexRequest.md)| request |

### Return type

[**\PureCloudSDK\PropertyIndexRequest**](../Model/PropertyIndexRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsDetailsQuery**
> \PureCloudSDK\AnalyticsConversationQueryResponse postConversationsDetailsQuery($body)

Query for conversation details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ConversationQuery(); // \PureCloudSDK\ConversationQuery | query

try {
    $result = $api_instance->postConversationsDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postConversationsDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ConversationQuery**](../Model/\PureCloudSDK\ConversationQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsConversationQueryResponse**](../Model/AnalyticsConversationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEvaluationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postEvaluationsAggregatesQuery($body)

Query for evaluation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postEvaluationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postEvaluationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQueuesObservationsQuery**
> \PureCloudSDK\QualifierMappingObservationQueryResponse postQueuesObservationsQuery($body)

Query for queue observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postQueuesObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postQueuesObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\QualifierMappingObservationQueryResponse**](../Model/QualifierMappingObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postReportingSchedules**
> \PureCloudSDK\ReportSchedule postReportingSchedules($body)

Create a scheduled report job

Create a scheduled report job.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ReportSchedule(); // \PureCloudSDK\ReportSchedule | ReportSchedule

try {
    $result = $api_instance->postReportingSchedules($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postReportingSchedules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ReportSchedule**](../Model/\PureCloudSDK\ReportSchedule.md)| ReportSchedule |

### Return type

[**\PureCloudSDK\ReportSchedule**](../Model/ReportSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postReportingSchedulesScheduleIdRunreport**
> \PureCloudSDK\RunNowResponse postReportingSchedulesScheduleIdRunreport($schedule_id)

Place a scheduled report immediately into the reporting queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$schedule_id = "schedule_id_example"; // string | Schedule ID

try {
    $result = $api_instance->postReportingSchedulesScheduleIdRunreport($schedule_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postReportingSchedulesScheduleIdRunreport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **string**| Schedule ID |

### Return type

[**\PureCloudSDK\RunNowResponse**](../Model/RunNowResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersAggregatesQuery**
> \PureCloudSDK\PresenceQueryResponse postUsersAggregatesQuery($body)

Query for user aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postUsersAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postUsersAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\PresenceQueryResponse**](../Model/PresenceQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersObservationsQuery**
> \PureCloudSDK\ObservationQueryResponse postUsersObservationsQuery($body)

Query for user observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postUsersObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->postUsersObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\ObservationQueryResponse**](../Model/ObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putReportingSchedulesScheduleId**
> \PureCloudSDK\ReportSchedule putReportingSchedulesScheduleId($schedule_id, $body)

Update a scheduled report job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AnalyticsApi();
$schedule_id = "schedule_id_example"; // string | Schedule ID
$body = new \PureCloudSDK\ReportSchedule(); // \PureCloudSDK\ReportSchedule | ReportSchedule

try {
    $result = $api_instance->putReportingSchedulesScheduleId($schedule_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AnalyticsApi->putReportingSchedulesScheduleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schedule_id** | **string**| Schedule ID |
 **body** | [**\PureCloudSDK\ReportSchedule**](../Model/\PureCloudSDK\ReportSchedule.md)| ReportSchedule |

### Return type

[**\PureCloudSDK\ReportSchedule**](../Model/ReportSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

