# PureCloudSDK\AttributesApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAttributeId**](AttributesApi.md#deleteAttributeId) | **DELETE** /api/v2/attributes/{attributeId} | Delete an existing Attribute.
[**getAttributeId**](AttributesApi.md#getAttributeId) | **GET** /api/v2/attributes/{attributeId} | Get details about an existing attribute.
[**getAttributes**](AttributesApi.md#getAttributes) | **GET** /api/v2/attributes | Gets a list of existing attributes.
[**postAttributes**](AttributesApi.md#postAttributes) | **POST** /api/v2/attributes | Create an attribute.
[**postQuery**](AttributesApi.md#postQuery) | **POST** /api/v2/attributes/query | Query attributes
[**putAttributeId**](AttributesApi.md#putAttributeId) | **PUT** /api/v2/attributes/{attributeId} | Update an existing attribute.


# **deleteAttributeId**
> deleteAttributeId($attribute_id)

Delete an existing Attribute.

This will remove attribute.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attribute_id = "attribute_id_example"; // string | Attribute ID

try {
    $api_instance->deleteAttributeId($attribute_id);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->deleteAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_id** | **string**| Attribute ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttributeId**
> \PureCloudSDK\Attribute getAttributeId($attribute_id)

Get details about an existing attribute.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attribute_id = "attribute_id_example"; // string | Attribute ID

try {
    $result = $api_instance->getAttributeId($attribute_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->getAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_id** | **string**| Attribute ID |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttributes**
> \PureCloudSDK\AttributeEntityListing getAttributes($page_number, $page_size)

Gets a list of existing attributes.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size

try {
    $result = $api_instance->getAttributes($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->getAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\AttributeEntityListing**](../Model/AttributeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAttributes**
> \PureCloudSDK\Attribute postAttributes($body)

Create an attribute.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$body = new \PureCloudSDK\Attribute(); // \PureCloudSDK\Attribute | Attribute

try {
    $result = $api_instance->postAttributes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->postAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Attribute**](../Model/\PureCloudSDK\Attribute.md)| Attribute |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQuery**
> \PureCloudSDK\AttributeEntityListing postQuery($body)

Query attributes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$body = new \PureCloudSDK\AttributeQueryRequest(); // \PureCloudSDK\AttributeQueryRequest | query

try {
    $result = $api_instance->postQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->postQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AttributeQueryRequest**](../Model/\PureCloudSDK\AttributeQueryRequest.md)| query |

### Return type

[**\PureCloudSDK\AttributeEntityListing**](../Model/AttributeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAttributeId**
> \PureCloudSDK\Attribute putAttributeId($attribute_id, $body)

Update an existing attribute.

Fields that can be updated: name, description. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AttributesApi();
$attribute_id = "attribute_id_example"; // string | Attribute ID
$body = new \PureCloudSDK\Attribute(); // \PureCloudSDK\Attribute | Attribute

try {
    $result = $api_instance->putAttributeId($attribute_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributesApi->putAttributeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_id** | **string**| Attribute ID |
 **body** | [**\PureCloudSDK\Attribute**](../Model/\PureCloudSDK\Attribute.md)| Attribute |

### Return type

[**\PureCloudSDK\Attribute**](../Model/Attribute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

