# PureCloudSDK\ContentManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteDocumentsDocumentId**](ContentManagementApi.md#deleteDocumentsDocumentId) | **DELETE** /api/v2/contentmanagement/documents/{documentId} | Delete a document.
[**deleteSharesShareId**](ContentManagementApi.md#deleteSharesShareId) | **DELETE** /api/v2/contentmanagement/shares/{shareId} | Deletes an existing share.
[**deleteStatusStatusId**](ContentManagementApi.md#deleteStatusStatusId) | **DELETE** /api/v2/contentmanagement/status/{statusId} | Cancel the command for this status
[**deleteWorkspacesWorkspaceId**](ContentManagementApi.md#deleteWorkspacesWorkspaceId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId} | Delete a workspace
[**deleteWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#deleteWorkspacesWorkspaceIdMembersMemberId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Delete a member from a workspace
[**deleteWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#deleteWorkspacesWorkspaceIdTagvaluesTagId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Delete workspace tag
[**getDocuments**](ContentManagementApi.md#getDocuments) | **GET** /api/v2/contentmanagement/documents | Get a list of documents.
[**getDocumentsDocumentId**](ContentManagementApi.md#getDocumentsDocumentId) | **GET** /api/v2/contentmanagement/documents/{documentId} | Get a document.
[**getDocumentsDocumentIdAudits**](ContentManagementApi.md#getDocumentsDocumentIdAudits) | **GET** /api/v2/contentmanagement/documents/{documentId}/audits | Get a list of audits for a document.
[**getDocumentsDocumentIdContent**](ContentManagementApi.md#getDocumentsDocumentIdContent) | **GET** /api/v2/contentmanagement/documents/{documentId}/content | Download a document.
[**getQuery**](ContentManagementApi.md#getQuery) | **GET** /api/v2/contentmanagement/query | Query content
[**getSecurityprofiles**](ContentManagementApi.md#getSecurityprofiles) | **GET** /api/v2/contentmanagement/securityprofiles | Get a List of Security Profiles
[**getSecurityprofilesSecurityprofileId**](ContentManagementApi.md#getSecurityprofilesSecurityprofileId) | **GET** /api/v2/contentmanagement/securityprofiles/{securityProfileId} | Get a Security Profile
[**getSharedSharedId**](ContentManagementApi.md#getSharedSharedId) | **GET** /api/v2/contentmanagement/shared/{sharedId} | Get shared documents. Securely download a shared document.
[**getShares**](ContentManagementApi.md#getShares) | **GET** /api/v2/contentmanagement/shares | Gets a list of shares.  You must specify at least one filter (e.g. entityId).
[**getSharesShareId**](ContentManagementApi.md#getSharesShareId) | **GET** /api/v2/contentmanagement/shares/{shareId} | Retrieve details about an existing share.
[**getStatus**](ContentManagementApi.md#getStatus) | **GET** /api/v2/contentmanagement/status | Get a list of statuses for pending operations
[**getStatusStatusId**](ContentManagementApi.md#getStatusStatusId) | **GET** /api/v2/contentmanagement/status/{statusId} | Get a status.
[**getUsage**](ContentManagementApi.md#getUsage) | **GET** /api/v2/contentmanagement/usage | Get usage details.
[**getWorkspaces**](ContentManagementApi.md#getWorkspaces) | **GET** /api/v2/contentmanagement/workspaces | Get a list of workspaces.
[**getWorkspacesWorkspaceId**](ContentManagementApi.md#getWorkspacesWorkspaceId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId} | Get a workspace.
[**getWorkspacesWorkspaceIdMembers**](ContentManagementApi.md#getWorkspacesWorkspaceIdMembers) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members | Get a list workspace members
[**getWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#getWorkspacesWorkspaceIdMembersMemberId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Get a workspace member
[**getWorkspacesWorkspaceIdTagvalues**](ContentManagementApi.md#getWorkspacesWorkspaceIdTagvalues) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Get a list of workspace tags
[**getWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#getWorkspacesWorkspaceIdTagvaluesTagId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Get a workspace tag
[**postAuditquery**](ContentManagementApi.md#postAuditquery) | **POST** /api/v2/contentmanagement/auditquery | Query audits
[**postDocuments**](ContentManagementApi.md#postDocuments) | **POST** /api/v2/contentmanagement/documents | Add a document.
[**postDocumentsDocumentId**](ContentManagementApi.md#postDocumentsDocumentId) | **POST** /api/v2/contentmanagement/documents/{documentId} | Update a document.
[**postDocumentsDocumentIdContent**](ContentManagementApi.md#postDocumentsDocumentIdContent) | **POST** /api/v2/contentmanagement/documents/{documentId}/content | Replace the contents of a document.
[**postQuery**](ContentManagementApi.md#postQuery) | **POST** /api/v2/contentmanagement/query | Query content
[**postShares**](ContentManagementApi.md#postShares) | **POST** /api/v2/contentmanagement/shares | Creates a new share or updates an existing share if the entity has already been shared
[**postWorkspaces**](ContentManagementApi.md#postWorkspaces) | **POST** /api/v2/contentmanagement/workspaces | Create a group workspace
[**postWorkspacesWorkspaceIdTagvalues**](ContentManagementApi.md#postWorkspacesWorkspaceIdTagvalues) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Create a workspace tag
[**postWorkspacesWorkspaceIdTagvaluesQuery**](ContentManagementApi.md#postWorkspacesWorkspaceIdTagvaluesQuery) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query | Perform a prefix query on tags in the workspace
[**putWorkspacesWorkspaceId**](ContentManagementApi.md#putWorkspacesWorkspaceId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId} | Update a workspace
[**putWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#putWorkspacesWorkspaceIdMembersMemberId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Add a member to a workspace
[**putWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#putWorkspacesWorkspaceIdTagvaluesTagId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Update a workspace tag. Will update all documents with the new tag value.


# **deleteDocumentsDocumentId**
> deleteDocumentsDocumentId($document_id, $override)

Delete a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$document_id = "document_id_example"; // string | Document ID
$override = true; // bool | Override any lock on the document

try {
    $api_instance->deleteDocumentsDocumentId($document_id, $override);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document_id** | **string**| Document ID |
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSharesShareId**
> deleteSharesShareId($share_id)

Deletes an existing share.

This revokes sharing rights specified in the share record

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$share_id = "share_id_example"; // string | Share ID

try {
    $api_instance->deleteSharesShareId($share_id);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteSharesShareId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **share_id** | **string**| Share ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteStatusStatusId**
> deleteStatusStatusId($status_id)

Cancel the command for this status



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$status_id = "status_id_example"; // string | Status ID

try {
    $api_instance->deleteStatusStatusId($status_id);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteStatusStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **status_id** | **string**| Status ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWorkspacesWorkspaceId**
> deleteWorkspacesWorkspaceId($workspace_id, $move_children_to_workspace_id)

Delete a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$move_children_to_workspace_id = "move_children_to_workspace_id_example"; // string | New location for objects in deleted workspace.

try {
    $api_instance->deleteWorkspacesWorkspaceId($workspace_id, $move_children_to_workspace_id);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **move_children_to_workspace_id** | **string**| New location for objects in deleted workspace. | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWorkspacesWorkspaceIdMembersMemberId**
> deleteWorkspacesWorkspaceIdMembersMemberId($workspace_id, $member_id)

Delete a member from a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$member_id = "member_id_example"; // string | Member ID

try {
    $api_instance->deleteWorkspacesWorkspaceIdMembersMemberId($workspace_id, $member_id);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **member_id** | **string**| Member ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWorkspacesWorkspaceIdTagvaluesTagId**
> deleteWorkspacesWorkspaceIdTagvaluesTagId($workspace_id, $tag_id)

Delete workspace tag

Delete a tag from a workspace. Will remove this tag from all documents.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$tag_id = "tag_id_example"; // string | Tag ID

try {
    $api_instance->deleteWorkspacesWorkspaceIdTagvaluesTagId($workspace_id, $tag_id);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **tag_id** | **string**| Tag ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocuments**
> \PureCloudSDK\DocumentEntityListing getDocuments($workspace_id, $name, $expand, $page_size, $page_number, $sort_by, $sort_order)

Get a list of documents.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$name = "name_example"; // string | Name
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "sort_by_example"; // string | name or dateCreated
$sort_order = "ascending"; // string | ascending or descending

try {
    $result = $api_instance->getDocuments($workspace_id, $name, $expand, $page_size, $page_number, $sort_by, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **name** | **string**| Name | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| name or dateCreated | [optional]
 **sort_order** | **string**| ascending or descending | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentEntityListing**](../Model/DocumentEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentId**
> \PureCloudSDK\Document getDocumentsDocumentId($document_id, $expand)

Get a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$document_id = "document_id_example"; // string | Document ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getDocumentsDocumentId($document_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document_id** | **string**| Document ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentIdAudits**
> \PureCloudSDK\DocumentAuditEntityListing getDocumentsDocumentIdAudits($document_id, $page_size, $page_number, $transaction_filter, $level, $sort_by, $sort_order)

Get a list of audits for a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$document_id = "document_id_example"; // string | Document ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$transaction_filter = "transaction_filter_example"; // string | Transaction filter
$level = "USER"; // string | level
$sort_by = "sort_by_example"; // string | Sort by
$sort_order = "ascending"; // string | Sort order

try {
    $result = $api_instance->getDocumentsDocumentIdAudits($document_id, $page_size, $page_number, $transaction_filter, $level, $sort_by, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocumentsDocumentIdAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document_id** | **string**| Document ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **transaction_filter** | **string**| Transaction filter | [optional]
 **level** | **string**| level | [optional] [default to USER]
 **sort_by** | **string**| Sort by | [optional]
 **sort_order** | **string**| Sort order | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentAuditEntityListing**](../Model/DocumentAuditEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentIdContent**
> \PureCloudSDK\DownloadResponse getDocumentsDocumentIdContent($document_id, $disposition, $content_type)

Download a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$document_id = "document_id_example"; // string | Document ID
$disposition = "disposition_example"; // string | Request how the content will be downloaded: a file attachment or inline. Default is attachment.
$content_type = "content_type_example"; // string | The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav

try {
    $result = $api_instance->getDocumentsDocumentIdContent($document_id, $disposition, $content_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document_id** | **string**| Document ID |
 **disposition** | **string**| Request how the content will be downloaded: a file attachment or inline. Default is attachment. | [optional]
 **content_type** | **string**| The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav | [optional]

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQuery**
> \PureCloudSDK\QueryResults getQuery($query_phrase, $page_size, $page_number, $sort_by, $sort_order, $expand)

Query content



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$query_phrase = "query_phrase_example"; // string | Phrase tokens are ANDed together over all searchable fields
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "name"; // string | name or dateCreated
$sort_order = "ascending"; // string | ascending or descending
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getQuery($query_phrase, $page_size, $page_number, $sort_by, $sort_order, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **query_phrase** | **string**| Phrase tokens are ANDed together over all searchable fields |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| name or dateCreated | [optional] [default to name]
 **sort_order** | **string**| ascending or descending | [optional] [default to ascending]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSecurityprofiles**
> \PureCloudSDK\SecurityProfileEntityListing getSecurityprofiles()

Get a List of Security Profiles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();

try {
    $result = $api_instance->getSecurityprofiles();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSecurityprofiles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\SecurityProfileEntityListing**](../Model/SecurityProfileEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSecurityprofilesSecurityprofileId**
> \PureCloudSDK\SecurityProfile getSecurityprofilesSecurityprofileId($security_profile_id)

Get a Security Profile



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$security_profile_id = "security_profile_id_example"; // string | Security Profile Id

try {
    $result = $api_instance->getSecurityprofilesSecurityprofileId($security_profile_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSecurityprofilesSecurityprofileId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **security_profile_id** | **string**| Security Profile Id |

### Return type

[**\PureCloudSDK\SecurityProfile**](../Model/SecurityProfile.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSharedSharedId**
> getSharedSharedId($shared_id, $redirect, $disposition, $content_type, $expand)

Get shared documents. Securely download a shared document.

This method requires the download sharing URI obtained in the get document response (downloadSharingUri). Documents may be shared between users in the same workspace. Documents may also be shared between any user by creating a content management share.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$shared_id = "shared_id_example"; // string | Shared ID
$redirect = true; // bool | Turn on or off redirect
$disposition = "attachment"; // string | Request how the share content will be downloaded: attached as a file or inline. Default is attachment.
$content_type = "content_type_example"; // string | The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
$expand = "expand_example"; // string | Expand some document fields

try {
    $api_instance->getSharedSharedId($shared_id, $redirect, $disposition, $content_type, $expand);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSharedSharedId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shared_id** | **string**| Shared ID |
 **redirect** | **bool**| Turn on or off redirect | [optional] [default to true]
 **disposition** | **string**| Request how the share content will be downloaded: attached as a file or inline. Default is attachment. | [optional] [default to attachment]
 **content_type** | **string**| The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav | [optional]
 **expand** | **string**| Expand some document fields | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getShares**
> \PureCloudSDK\ShareEntityListing getShares($entity_id, $expand, $page_size, $page_number)

Gets a list of shares.  You must specify at least one filter (e.g. entityId).

Failing to specify a filter will return 400.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$entity_id = "entity_id_example"; // string | Filters the shares returned to only the entity specified by the value of this parameter.
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getShares($entity_id, $expand, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getShares: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **entity_id** | **string**| Filters the shares returned to only the entity specified by the value of this parameter. | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ShareEntityListing**](../Model/ShareEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSharesShareId**
> \PureCloudSDK\Share getSharesShareId($share_id, $expand)

Retrieve details about an existing share.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$share_id = "share_id_example"; // string | Share ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getSharesShareId($share_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSharesShareId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **share_id** | **string**| Share ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Share**](../Model/Share.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStatus**
> \PureCloudSDK\CommandStatusEntityListing getStatus($page_size, $page_number)

Get a list of statuses for pending operations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getStatus($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getStatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\CommandStatusEntityListing**](../Model/CommandStatusEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStatusStatusId**
> \PureCloudSDK\CommandStatus getStatusStatusId($status_id)

Get a status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$status_id = "status_id_example"; // string | Status ID

try {
    $result = $api_instance->getStatusStatusId($status_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getStatusStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **status_id** | **string**| Status ID |

### Return type

[**\PureCloudSDK\CommandStatus**](../Model/CommandStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsage**
> \PureCloudSDK\Usage getUsage()

Get usage details.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();

try {
    $result = $api_instance->getUsage();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Usage**](../Model/Usage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspaces**
> \PureCloudSDK\WorkspaceEntityListing getWorkspaces($page_size, $page_number, $access, $expand)

Get a list of workspaces.

Specifying 'content' access will return all workspaces the user has document access to, while 'admin' access will return all group workspaces the user has administrative rights to.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$access = array("access_example"); // string[] | Requested access level.
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspaces($page_size, $page_number, $access, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **access** | [**string[]**](../Model/string.md)| Requested access level. | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceEntityListing**](../Model/WorkspaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceId**
> \PureCloudSDK\Workspace getWorkspacesWorkspaceId($workspace_id, $expand)

Get a workspace.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceId($workspace_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdMembers**
> \PureCloudSDK\WorkspaceMemberEntityListing getWorkspacesWorkspaceIdMembers($workspace_id, $page_size, $page_number, $expand)

Get a list workspace members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdMembers($workspace_id, $page_size, $page_number, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceMemberEntityListing**](../Model/WorkspaceMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdMembersMemberId**
> \PureCloudSDK\WorkspaceMember getWorkspacesWorkspaceIdMembersMemberId($workspace_id, $member_id, $expand)

Get a workspace member



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$member_id = "member_id_example"; // string | Member ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdMembersMemberId($workspace_id, $member_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **member_id** | **string**| Member ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceMember**](../Model/WorkspaceMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdTagvalues**
> \PureCloudSDK\TagValueEntityListing getWorkspacesWorkspaceIdTagvalues($workspace_id, $value, $page_size, $page_number, $expand)

Get a list of workspace tags



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$value = "value_example"; // string | filter the list of tags returned
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdTagvalues($workspace_id, $value, $page_size, $page_number, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdTagvalues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **value** | **string**| filter the list of tags returned | [optional]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValueEntityListing**](../Model/TagValueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdTagvaluesTagId**
> \PureCloudSDK\TagValue getWorkspacesWorkspaceIdTagvaluesTagId($workspace_id, $tag_id, $expand)

Get a workspace tag



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$tag_id = "tag_id_example"; // string | Tag ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdTagvaluesTagId($workspace_id, $tag_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **tag_id** | **string**| Tag ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAuditquery**
> \PureCloudSDK\QueryResults postAuditquery($body)

Query audits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\ContentQueryRequest(); // \PureCloudSDK\ContentQueryRequest | Allows for a filtered query returning facet information

try {
    $result = $api_instance->postAuditquery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postAuditquery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ContentQueryRequest**](../Model/\PureCloudSDK\ContentQueryRequest.md)| Allows for a filtered query returning facet information |

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocuments**
> \PureCloudSDK\Document postDocuments($body, $copy_source, $move_source, $override)

Add a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\DocumentUpload(); // \PureCloudSDK\DocumentUpload | Document
$copy_source = "copy_source_example"; // string | Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source.
$move_source = "move_source_example"; // string | Move a document to a new workspace. Provide a document ID as the move source.
$override = true; // bool | Override any lock on the source document

try {
    $result = $api_instance->postDocuments($body, $copy_source, $move_source, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DocumentUpload**](../Model/\PureCloudSDK\DocumentUpload.md)| Document |
 **copy_source** | **string**| Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source. | [optional]
 **move_source** | **string**| Move a document to a new workspace. Provide a document ID as the move source. | [optional]
 **override** | **bool**| Override any lock on the source document | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocumentsDocumentId**
> \PureCloudSDK\Document postDocumentsDocumentId($document_id, $body, $expand, $override)

Update a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$document_id = "document_id_example"; // string | Document ID
$body = new \PureCloudSDK\DocumentUpdate(); // \PureCloudSDK\DocumentUpdate | Document
$expand = "expand_example"; // string | Expand some document fields
$override = true; // bool | Override any lock on the document

try {
    $result = $api_instance->postDocumentsDocumentId($document_id, $body, $expand, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document_id** | **string**| Document ID |
 **body** | [**\PureCloudSDK\DocumentUpdate**](../Model/\PureCloudSDK\DocumentUpdate.md)| Document |
 **expand** | **string**| Expand some document fields | [optional]
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocumentsDocumentIdContent**
> \PureCloudSDK\ReplaceResponse postDocumentsDocumentIdContent($document_id, $body, $override)

Replace the contents of a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$document_id = "document_id_example"; // string | Document ID
$body = new \PureCloudSDK\ReplaceRequest(); // \PureCloudSDK\ReplaceRequest | Replace Request
$override = true; // bool | Override any lock on the document

try {
    $result = $api_instance->postDocumentsDocumentIdContent($document_id, $body, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document_id** | **string**| Document ID |
 **body** | [**\PureCloudSDK\ReplaceRequest**](../Model/\PureCloudSDK\ReplaceRequest.md)| Replace Request |
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

[**\PureCloudSDK\ReplaceResponse**](../Model/ReplaceResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQuery**
> \PureCloudSDK\QueryResults postQuery($body, $expand)

Query content



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\QueryRequest(); // \PureCloudSDK\QueryRequest | Allows for a filtered query returning facet information
$expand = "expand_example"; // string | Expand some document fields

try {
    $result = $api_instance->postQuery($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\QueryRequest**](../Model/\PureCloudSDK\QueryRequest.md)| Allows for a filtered query returning facet information |
 **expand** | **string**| Expand some document fields | [optional]

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postShares**
> \PureCloudSDK\CreateShareResponse postShares($body)

Creates a new share or updates an existing share if the entity has already been shared



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\CreateShareRequest(); // \PureCloudSDK\CreateShareRequest | CreateShareRequest - entity id and type and a single member or list of members are required

try {
    $result = $api_instance->postShares($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postShares: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateShareRequest**](../Model/\PureCloudSDK\CreateShareRequest.md)| CreateShareRequest - entity id and type and a single member or list of members are required |

### Return type

[**\PureCloudSDK\CreateShareResponse**](../Model/CreateShareResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkspaces**
> \PureCloudSDK\Workspace postWorkspaces($body)

Create a group workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\WorkspaceCreate(); // \PureCloudSDK\WorkspaceCreate | Workspace

try {
    $result = $api_instance->postWorkspaces($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postWorkspaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WorkspaceCreate**](../Model/\PureCloudSDK\WorkspaceCreate.md)| Workspace |

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkspacesWorkspaceIdTagvalues**
> \PureCloudSDK\TagValue postWorkspacesWorkspaceIdTagvalues($workspace_id, $body)

Create a workspace tag



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$body = new \PureCloudSDK\TagValue(); // \PureCloudSDK\TagValue | tag

try {
    $result = $api_instance->postWorkspacesWorkspaceIdTagvalues($workspace_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postWorkspacesWorkspaceIdTagvalues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\TagValue**](../Model/\PureCloudSDK\TagValue.md)| tag |

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkspacesWorkspaceIdTagvaluesQuery**
> \PureCloudSDK\TagValueEntityListing postWorkspacesWorkspaceIdTagvaluesQuery($workspace_id, $body, $expand)

Perform a prefix query on tags in the workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$body = new \PureCloudSDK\TagQueryRequest(); // \PureCloudSDK\TagQueryRequest | query
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->postWorkspacesWorkspaceIdTagvaluesQuery($workspace_id, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postWorkspacesWorkspaceIdTagvaluesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\TagQueryRequest**](../Model/\PureCloudSDK\TagQueryRequest.md)| query |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValueEntityListing**](../Model/TagValueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWorkspacesWorkspaceId**
> \PureCloudSDK\Workspace putWorkspacesWorkspaceId($workspace_id, $body)

Update a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$body = new \PureCloudSDK\Workspace(); // \PureCloudSDK\Workspace | Workspace

try {
    $result = $api_instance->putWorkspacesWorkspaceId($workspace_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\Workspace**](../Model/\PureCloudSDK\Workspace.md)| Workspace |

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWorkspacesWorkspaceIdMembersMemberId**
> \PureCloudSDK\WorkspaceMember putWorkspacesWorkspaceIdMembersMemberId($workspace_id, $member_id, $body)

Add a member to a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$member_id = "member_id_example"; // string | Member ID
$body = new \PureCloudSDK\WorkspaceMember(); // \PureCloudSDK\WorkspaceMember | Workspace Member

try {
    $result = $api_instance->putWorkspacesWorkspaceIdMembersMemberId($workspace_id, $member_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **member_id** | **string**| Member ID |
 **body** | [**\PureCloudSDK\WorkspaceMember**](../Model/\PureCloudSDK\WorkspaceMember.md)| Workspace Member |

### Return type

[**\PureCloudSDK\WorkspaceMember**](../Model/WorkspaceMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWorkspacesWorkspaceIdTagvaluesTagId**
> \PureCloudSDK\TagValue putWorkspacesWorkspaceIdTagvaluesTagId($workspace_id, $tag_id, $body)

Update a workspace tag. Will update all documents with the new tag value.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspace_id = "workspace_id_example"; // string | Workspace ID
$tag_id = "tag_id_example"; // string | Tag ID
$body = new \PureCloudSDK\TagValue(); // \PureCloudSDK\TagValue | Workspace

try {
    $result = $api_instance->putWorkspacesWorkspaceIdTagvaluesTagId($workspace_id, $tag_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspace_id** | **string**| Workspace ID |
 **tag_id** | **string**| Tag ID |
 **body** | [**\PureCloudSDK\TagValue**](../Model/\PureCloudSDK\TagValue.md)| Workspace |

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

