# PureCloudSDK\GreetingsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteGreetingId**](GreetingsApi.md#deleteGreetingId) | **DELETE** /api/v2/greetings/{greetingId} | Deletes a Greeting with the given GreetingId
[**getDefaults**](GreetingsApi.md#getDefaults) | **GET** /api/v2/greetings/defaults | Get an Organization&#39;s DefaultGreetingList
[**getGreetingId**](GreetingsApi.md#getGreetingId) | **GET** /api/v2/greetings/{greetingId} | Get a Greeting with the given GreetingId
[**getGreetingIdMedia**](GreetingsApi.md#getGreetingIdMedia) | **GET** /api/v2/greetings/{greetingId}/media | Get media playback URI for this greeting
[**getGreetings**](GreetingsApi.md#getGreetings) | **GET** /api/v2/greetings | Gets an Organization&#39;s Greetings
[**getUserIdGreetings**](GreetingsApi.md#getUserIdGreetings) | **GET** /api/v2/users/{userId}/greetings | Get a list of the User&#39;s Greetings
[**getUserIdGreetingsDefaults**](GreetingsApi.md#getUserIdGreetingsDefaults) | **GET** /api/v2/users/{userId}/greetings/defaults | Grabs the list of Default Greetings given a User&#39;s ID
[**postGreetings**](GreetingsApi.md#postGreetings) | **POST** /api/v2/greetings | Create a Greeting for an Organization
[**postUserIdGreetings**](GreetingsApi.md#postUserIdGreetings) | **POST** /api/v2/users/{userId}/greetings | Creates a Greeting for a User
[**putDefaults**](GreetingsApi.md#putDefaults) | **PUT** /api/v2/greetings/defaults | Update an Organization&#39;s DefaultGreetingList
[**putGreetingId**](GreetingsApi.md#putGreetingId) | **PUT** /api/v2/greetings/{greetingId} | Updates the Greeting with the given GreetingId
[**putUserIdGreetingsDefaults**](GreetingsApi.md#putUserIdGreetingsDefaults) | **PUT** /api/v2/users/{userId}/greetings/defaults | Updates the DefaultGreetingList of the specified User


# **deleteGreetingId**
> \PureCloudSDK\Greeting deleteGreetingId($greeting_id)

Deletes a Greeting with the given GreetingId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greeting_id = "greeting_id_example"; // string | Greeting ID

try {
    $result = $api_instance->deleteGreetingId($greeting_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->deleteGreetingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greeting_id** | **string**| Greeting ID |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDefaults**
> \PureCloudSDK\DefaultGreetingList getDefaults()

Get an Organization's DefaultGreetingList



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();

try {
    $result = $api_instance->getDefaults();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetingId**
> \PureCloudSDK\Greeting getGreetingId($greeting_id)

Get a Greeting with the given GreetingId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greeting_id = "greeting_id_example"; // string | Greeting ID

try {
    $result = $api_instance->getGreetingId($greeting_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greeting_id** | **string**| Greeting ID |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetingIdMedia**
> \PureCloudSDK\GreetingMediaInfo getGreetingIdMedia($greeting_id, $format_id)

Get media playback URI for this greeting



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greeting_id = "greeting_id_example"; // string | Greeting ID
$format_id = "WAV"; // string | The desired media format.

try {
    $result = $api_instance->getGreetingIdMedia($greeting_id, $format_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetingIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greeting_id** | **string**| Greeting ID |
 **format_id** | **string**| The desired media format. | [optional] [default to WAV]

### Return type

[**\PureCloudSDK\GreetingMediaInfo**](../Model/GreetingMediaInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGreetings**
> \PureCloudSDK\DomainEntityListing getGreetings($page_size, $page_number)

Gets an Organization's Greetings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getGreetings($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\DomainEntityListing**](../Model/DomainEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdGreetings**
> \PureCloudSDK\DomainEntityListing getUserIdGreetings($user_id, $page_size, $page_number)

Get a list of the User's Greetings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$user_id = "user_id_example"; // string | User ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getUserIdGreetings($user_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getUserIdGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\DomainEntityListing**](../Model/DomainEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdGreetingsDefaults**
> \PureCloudSDK\DefaultGreetingList getUserIdGreetingsDefaults($user_id)

Grabs the list of Default Greetings given a User's ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdGreetingsDefaults($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->getUserIdGreetingsDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGreetings**
> \PureCloudSDK\DefaultGreetingList postGreetings($body)

Create a Greeting for an Organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$body = new \PureCloudSDK\Greeting(); // \PureCloudSDK\Greeting | The Greeting to create

try {
    $result = $api_instance->postGreetings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->postGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Greeting**](../Model/\PureCloudSDK\Greeting.md)| The Greeting to create |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUserIdGreetings**
> \PureCloudSDK\Greeting postUserIdGreetings($user_id, $body)

Creates a Greeting for a User



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\Greeting(); // \PureCloudSDK\Greeting | The Greeting to create

try {
    $result = $api_instance->postUserIdGreetings($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->postUserIdGreetings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\Greeting**](../Model/\PureCloudSDK\Greeting.md)| The Greeting to create |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putDefaults**
> \PureCloudSDK\DefaultGreetingList putDefaults($body)

Update an Organization's DefaultGreetingList



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$body = new \PureCloudSDK\DefaultGreetingList(); // \PureCloudSDK\DefaultGreetingList | The updated defaultGreetingList

try {
    $result = $api_instance->putDefaults($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->putDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DefaultGreetingList**](../Model/\PureCloudSDK\DefaultGreetingList.md)| The updated defaultGreetingList |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putGreetingId**
> \PureCloudSDK\Greeting putGreetingId($greeting_id, $body)

Updates the Greeting with the given GreetingId



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$greeting_id = "greeting_id_example"; // string | Greeting ID
$body = new \PureCloudSDK\Greeting(); // \PureCloudSDK\Greeting | The updated Greeting

try {
    $result = $api_instance->putGreetingId($greeting_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->putGreetingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **greeting_id** | **string**| Greeting ID |
 **body** | [**\PureCloudSDK\Greeting**](../Model/\PureCloudSDK\Greeting.md)| The updated Greeting |

### Return type

[**\PureCloudSDK\Greeting**](../Model/Greeting.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdGreetingsDefaults**
> \PureCloudSDK\DefaultGreetingList putUserIdGreetingsDefaults($user_id, $body)

Updates the DefaultGreetingList of the specified User



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GreetingsApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\DefaultGreetingList(); // \PureCloudSDK\DefaultGreetingList | The updated defaultGreetingList

try {
    $result = $api_instance->putUserIdGreetingsDefaults($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GreetingsApi->putUserIdGreetingsDefaults: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\DefaultGreetingList**](../Model/\PureCloudSDK\DefaultGreetingList.md)| The updated defaultGreetingList |

### Return type

[**\PureCloudSDK\DefaultGreetingList**](../Model/DefaultGreetingList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

