# PureCloudSDK\LocationsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLocationId**](LocationsApi.md#getLocationId) | **GET** /api/v2/locations/{locationId} | Get Location by ID.
[**getLocations**](LocationsApi.md#getLocations) | **GET** /api/v2/locations | Get a list of all locations.
[**getSearch**](LocationsApi.md#getSearch) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
[**postSearch**](LocationsApi.md#postSearch) | **POST** /api/v2/locations/search | Search locations


# **getLocationId**
> \PureCloudSDK\Location getLocationId($location_id)

Get Location by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$location_id = "location_id_example"; // string | Location ID

try {
    $result = $api_instance->getLocationId($location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->getLocationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **location_id** | **string**| Location ID |

### Return type

[**\PureCloudSDK\Location**](../Model/Location.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocations**
> \PureCloudSDK\Location[] getLocations($page_size, $page_number, $sort_order)

Get a list of all locations.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_order = "sort_order_example"; // string | Sort order

try {
    $result = $api_instance->getLocations($page_size, $page_number, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->getLocations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_order** | **string**| Sort order | [optional]

### Return type

[**\PureCloudSDK\Location[]**](../Model/Location.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch**
> \PureCloudSDK\LocationsSearchResponse getSearch($q64, $expand)

Search locations using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\LocationsSearchResponse postSearch($body)

Search locations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LocationsApi();
$body = new \PureCloudSDK\LocationSearchRequest(); // \PureCloudSDK\LocationSearchRequest | Search request options

try {
    $result = $api_instance->postSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocationSearchRequest**](../Model/\PureCloudSDK\LocationSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

