# PureCloudSDK\ResponseManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteLibrariesLibraryId**](ResponseManagementApi.md#deleteLibrariesLibraryId) | **DELETE** /api/v2/responsemanagement/libraries/{libraryId} | Delete an existing response library.
[**deleteResponsesResponseId**](ResponseManagementApi.md#deleteResponsesResponseId) | **DELETE** /api/v2/responsemanagement/responses/{responseId} | Delete an existing response.
[**getLibraries**](ResponseManagementApi.md#getLibraries) | **GET** /api/v2/responsemanagement/libraries | Gets a list of existing response libraries.
[**getLibrariesLibraryId**](ResponseManagementApi.md#getLibrariesLibraryId) | **GET** /api/v2/responsemanagement/libraries/{libraryId} | Get details about an existing response library.
[**getResponses**](ResponseManagementApi.md#getResponses) | **GET** /api/v2/responsemanagement/responses | Gets a list of existing responses.
[**getResponsesResponseId**](ResponseManagementApi.md#getResponsesResponseId) | **GET** /api/v2/responsemanagement/responses/{responseId} | Get details about an existing response.
[**postLibraries**](ResponseManagementApi.md#postLibraries) | **POST** /api/v2/responsemanagement/libraries | Create a response library.
[**postResponses**](ResponseManagementApi.md#postResponses) | **POST** /api/v2/responsemanagement/responses | Create a response.
[**postResponsesQuery**](ResponseManagementApi.md#postResponsesQuery) | **POST** /api/v2/responsemanagement/responses/query | Query responses
[**putLibrariesLibraryId**](ResponseManagementApi.md#putLibrariesLibraryId) | **PUT** /api/v2/responsemanagement/libraries/{libraryId} | Update an existing response library.
[**putResponsesResponseId**](ResponseManagementApi.md#putResponsesResponseId) | **PUT** /api/v2/responsemanagement/responses/{responseId} | Update an existing response.


# **deleteLibrariesLibraryId**
> deleteLibrariesLibraryId($library_id)

Delete an existing response library.

This will remove any responses associated with the library.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$library_id = "library_id_example"; // string | Library ID

try {
    $api_instance->deleteLibrariesLibraryId($library_id);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->deleteLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **library_id** | **string**| Library ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteResponsesResponseId**
> deleteResponsesResponseId($response_id)

Delete an existing response.

This will remove the response from any libraries associated with it.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$response_id = "response_id_example"; // string | Response ID

try {
    $api_instance->deleteResponsesResponseId($response_id);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->deleteResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **response_id** | **string**| Response ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLibraries**
> \PureCloudSDK\LibraryEntityListing getLibraries($page_number, $page_size)

Gets a list of existing response libraries.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size

try {
    $result = $api_instance->getLibraries($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getLibraries: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\LibraryEntityListing**](../Model/LibraryEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLibrariesLibraryId**
> \PureCloudSDK\Library getLibrariesLibraryId($library_id)

Get details about an existing response library.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$library_id = "library_id_example"; // string | Library ID

try {
    $result = $api_instance->getLibrariesLibraryId($library_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **library_id** | **string**| Library ID |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponses**
> \PureCloudSDK\ResponseEntityListing getResponses($library_id, $page_number, $page_size)

Gets a list of existing responses.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$library_id = "library_id_example"; // string | Library ID
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size

try {
    $result = $api_instance->getResponses($library_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **library_id** | **string**| Library ID |
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ResponseEntityListing**](../Model/ResponseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponsesResponseId**
> \PureCloudSDK\Response getResponsesResponseId($response_id)

Get details about an existing response.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$response_id = "response_id_example"; // string | Response ID

try {
    $result = $api_instance->getResponsesResponseId($response_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **response_id** | **string**| Response ID |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLibraries**
> \PureCloudSDK\Library postLibraries($body)

Create a response library.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\Library(); // \PureCloudSDK\Library | Library

try {
    $result = $api_instance->postLibraries($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postLibraries: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Library**](../Model/\PureCloudSDK\Library.md)| Library |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponses**
> \PureCloudSDK\Response postResponses($body)

Create a response.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\Response(); // \PureCloudSDK\Response | Response

try {
    $result = $api_instance->postResponses($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Response**](../Model/\PureCloudSDK\Response.md)| Response |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponsesQuery**
> \PureCloudSDK\ResponseQueryResults postResponsesQuery($body)

Query responses



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\ResponseQueryRequest(); // \PureCloudSDK\ResponseQueryRequest | Response

try {
    $result = $api_instance->postResponsesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponsesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ResponseQueryRequest**](../Model/\PureCloudSDK\ResponseQueryRequest.md)| Response |

### Return type

[**\PureCloudSDK\ResponseQueryResults**](../Model/ResponseQueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putLibrariesLibraryId**
> \PureCloudSDK\Library putLibrariesLibraryId($library_id, $body)

Update an existing response library.

Fields that can be updated: name. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$library_id = "library_id_example"; // string | Library ID
$body = new \PureCloudSDK\Library(); // \PureCloudSDK\Library | Library

try {
    $result = $api_instance->putLibrariesLibraryId($library_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->putLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **library_id** | **string**| Library ID |
 **body** | [**\PureCloudSDK\Library**](../Model/\PureCloudSDK\Library.md)| Library |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putResponsesResponseId**
> \PureCloudSDK\Response putResponsesResponseId($response_id, $body)

Update an existing response.

Fields that can be updated: name, libraries, and texts. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$response_id = "response_id_example"; // string | Response ID
$body = new \PureCloudSDK\Response(); // \PureCloudSDK\Response | Response

try {
    $result = $api_instance->putResponsesResponseId($response_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->putResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **response_id** | **string**| Response ID |
 **body** | [**\PureCloudSDK\Response**](../Model/\PureCloudSDK\Response.md)| Response |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

