# PureCloudSDK\RoutingApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteEmailDomainsDomainId**](RoutingApi.md#deleteEmailDomainsDomainId) | **DELETE** /api/v2/routing/email/domains/{domainId} | Delete a domain
[**deleteEmailDomainsDomainnameRoutesRouteId**](RoutingApi.md#deleteEmailDomainsDomainnameRoutesRouteId) | **DELETE** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Delete a route
[**deleteQueuesQueueId**](RoutingApi.md#deleteQueuesQueueId) | **DELETE** /api/v2/routing/queues/{queueId} | Delete a queue
[**deleteQueuesQueueIdUsersMemberId**](RoutingApi.md#deleteQueuesQueueIdUsersMemberId) | **DELETE** /api/v2/routing/queues/{queueId}/users/{memberId} | Delete queue member
[**deleteQueuesQueueIdWrapupcodesCodeId**](RoutingApi.md#deleteQueuesQueueIdWrapupcodesCodeId) | **DELETE** /api/v2/routing/queues/{queueId}/wrapupcodes/{codeId} | Delete a wrap-up code from a queue
[**deleteSkillsSkillId**](RoutingApi.md#deleteSkillsSkillId) | **DELETE** /api/v2/routing/skills/{skillId} | Delete Routing Skill
[**deleteUserIdRoutingskillsSkillId**](RoutingApi.md#deleteUserIdRoutingskillsSkillId) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
[**deleteUtilization**](RoutingApi.md#deleteUtilization) | **DELETE** /api/v2/routing/utilization | Delete utilization settings and revert to system defaults.
[**deleteWrapupcodesCodeId**](RoutingApi.md#deleteWrapupcodesCodeId) | **DELETE** /api/v2/routing/wrapupcodes/{codeId} | Delete wrap-up code
[**getEmailDomains**](RoutingApi.md#getEmailDomains) | **GET** /api/v2/routing/email/domains | Get domains
[**getEmailDomainsDomainId**](RoutingApi.md#getEmailDomainsDomainId) | **GET** /api/v2/routing/email/domains/{domainId} | Get domain
[**getEmailDomainsDomainnameRoutes**](RoutingApi.md#getEmailDomainsDomainnameRoutes) | **GET** /api/v2/routing/email/domains/{domainName}/routes | Get routes
[**getEmailDomainsDomainnameRoutesRouteId**](RoutingApi.md#getEmailDomainsDomainnameRoutesRouteId) | **GET** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Get a route
[**getEmailSetup**](RoutingApi.md#getEmailSetup) | **GET** /api/v2/routing/email/setup | Get email setup
[**getQueues**](RoutingApi.md#getQueues) | **GET** /api/v2/routing/queues | Get list of queues.
[**getQueuesQueueId**](RoutingApi.md#getQueuesQueueId) | **GET** /api/v2/routing/queues/{queueId} | Get details about this queue.
[**getQueuesQueueIdConversations**](RoutingApi.md#getQueuesQueueIdConversations) | **GET** /api/v2/routing/queues/{queueId}/conversations | Get recent conversations that are still active
[**getQueuesQueueIdConversationsCallbacks**](RoutingApi.md#getQueuesQueueIdConversationsCallbacks) | **GET** /api/v2/routing/queues/{queueId}/conversations/callbacks | Get recent callback conversations that are still active
[**getQueuesQueueIdConversationsCalls**](RoutingApi.md#getQueuesQueueIdConversationsCalls) | **GET** /api/v2/routing/queues/{queueId}/conversations/calls | Get recent call conversations that are still active
[**getQueuesQueueIdConversationsChats**](RoutingApi.md#getQueuesQueueIdConversationsChats) | **GET** /api/v2/routing/queues/{queueId}/conversations/chats | Get recent chat conversations that are still active
[**getQueuesQueueIdConversationsEmails**](RoutingApi.md#getQueuesQueueIdConversationsEmails) | **GET** /api/v2/routing/queues/{queueId}/conversations/emails | Get recent email conversations that are still active
[**getQueuesQueueIdEstimatedwaittime**](RoutingApi.md#getQueuesQueueIdEstimatedwaittime) | **GET** /api/v2/routing/queues/{queueId}/estimatedwaittime | Get Estimated Wait Time
[**getQueuesQueueIdUsers**](RoutingApi.md#getQueuesQueueIdUsers) | **GET** /api/v2/routing/queues/{queueId}/users | Get the members of this queue
[**getQueuesQueueIdWrapupcodes**](RoutingApi.md#getQueuesQueueIdWrapupcodes) | **GET** /api/v2/routing/queues/{queueId}/wrapupcodes | Get the wrap-up codes for a queue
[**getSkills**](RoutingApi.md#getSkills) | **GET** /api/v2/routing/skills | Get the list of routing skills.
[**getSkillsSkillId**](RoutingApi.md#getSkillsSkillId) | **GET** /api/v2/routing/skills/{skillId} | Get Routing Skill
[**getUserIdRoutingskills**](RoutingApi.md#getUserIdRoutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
[**getUtilization**](RoutingApi.md#getUtilization) | **GET** /api/v2/routing/utilization | Get the utilization settings.
[**getWrapupcodes**](RoutingApi.md#getWrapupcodes) | **GET** /api/v2/routing/wrapupcodes | Get list of wrapup codes.
[**getWrapupcodesCodeId**](RoutingApi.md#getWrapupcodesCodeId) | **GET** /api/v2/routing/wrapupcodes/{codeId} | Get details about this wrap-up code.
[**patchQueuesQueueIdUsers**](RoutingApi.md#patchQueuesQueueIdUsers) | **PATCH** /api/v2/routing/queues/{queueId}/users | Join or unjoin a set of users for a queue
[**patchQueuesQueueIdUsersMemberId**](RoutingApi.md#patchQueuesQueueIdUsersMemberId) | **PATCH** /api/v2/routing/queues/{queueId}/users/{memberId} | Update the ring number of joined status for a User in a Queue
[**postEmailDomains**](RoutingApi.md#postEmailDomains) | **POST** /api/v2/routing/email/domains | Create a domain
[**postEmailDomainsDomainnameRoutes**](RoutingApi.md#postEmailDomainsDomainnameRoutes) | **POST** /api/v2/routing/email/domains/{domainName}/routes | Create a route
[**postQueues**](RoutingApi.md#postQueues) | **POST** /api/v2/routing/queues | Create queue
[**postQueuesObservationsQuery**](RoutingApi.md#postQueuesObservationsQuery) | **POST** /api/v2/analytics/queues/observations/query | Query for queue observations
[**postQueuesQueueIdUsers**](RoutingApi.md#postQueuesQueueIdUsers) | **POST** /api/v2/routing/queues/{queueId}/users | Bulk add or delete up to 100 queue members
[**postQueuesQueueIdWrapupcodes**](RoutingApi.md#postQueuesQueueIdWrapupcodes) | **POST** /api/v2/routing/queues/{queueId}/wrapupcodes | Add up to 100 wrap-up codes to a queue
[**postSkills**](RoutingApi.md#postSkills) | **POST** /api/v2/routing/skills | Create Skill
[**postUserIdRoutingskills**](RoutingApi.md#postUserIdRoutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
[**postWrapupcodes**](RoutingApi.md#postWrapupcodes) | **POST** /api/v2/routing/wrapupcodes | Create a wrap-up code
[**putEmailDomainsDomainnameRoutesRouteId**](RoutingApi.md#putEmailDomainsDomainnameRoutesRouteId) | **PUT** /api/v2/routing/email/domains/{domainName}/routes/{routeId} | Update a route
[**putQueuesQueueId**](RoutingApi.md#putQueuesQueueId) | **PUT** /api/v2/routing/queues/{queueId} | Update a queue
[**putUserIdRoutingskillsSkillId**](RoutingApi.md#putUserIdRoutingskillsSkillId) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
[**putUtilization**](RoutingApi.md#putUtilization) | **PUT** /api/v2/routing/utilization | Update the utilization settings.
[**putWrapupcodesCodeId**](RoutingApi.md#putWrapupcodesCodeId) | **PUT** /api/v2/routing/wrapupcodes/{codeId} | Update wrap-up code


# **deleteEmailDomainsDomainId**
> string deleteEmailDomainsDomainId($domain_id)

Delete a domain



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_id = "domain_id_example"; // string | domain ID

try {
    $result = $api_instance->deleteEmailDomainsDomainId($domain_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteEmailDomainsDomainId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_id** | **string**| domain ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteEmailDomainsDomainnameRoutesRouteId**
> string deleteEmailDomainsDomainnameRoutesRouteId($domain_name, $route_id)

Delete a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_name = "domain_name_example"; // string | email domain
$route_id = "route_id_example"; // string | route ID

try {
    $result = $api_instance->deleteEmailDomainsDomainnameRoutesRouteId($domain_name, $route_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteEmailDomainsDomainnameRoutesRouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_name** | **string**| email domain |
 **route_id** | **string**| route ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQueuesQueueId**
> string deleteQueuesQueueId($queue_id, $force_delete)

Delete a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$force_delete = true; // bool | forceDelete

try {
    $result = $api_instance->deleteQueuesQueueId($queue_id, $force_delete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **force_delete** | **bool**| forceDelete | [optional]

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQueuesQueueIdUsersMemberId**
> string deleteQueuesQueueIdUsersMemberId($queue_id, $member_id)

Delete queue member



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$member_id = "member_id_example"; // string | Member ID

try {
    $result = $api_instance->deleteQueuesQueueIdUsersMemberId($queue_id, $member_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteQueuesQueueIdUsersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **member_id** | **string**| Member ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteQueuesQueueIdWrapupcodesCodeId**
> string deleteQueuesQueueIdWrapupcodesCodeId($queue_id, $code_id)

Delete a wrap-up code from a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$code_id = "code_id_example"; // string | Code ID

try {
    $result = $api_instance->deleteQueuesQueueIdWrapupcodesCodeId($queue_id, $code_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteQueuesQueueIdWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **code_id** | **string**| Code ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSkillsSkillId**
> string deleteSkillsSkillId($skill_id)

Delete Routing Skill



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$skill_id = "skill_id_example"; // string | Skill ID

try {
    $result = $api_instance->deleteSkillsSkillId($skill_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteSkillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skill_id** | **string**| Skill ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserIdRoutingskillsSkillId**
> string deleteUserIdRoutingskillsSkillId($user_id, $skill_id)

Remove routing skill from user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$user_id = "user_id_example"; // string | User ID
$skill_id = "skill_id_example"; // string | skillId

try {
    $result = $api_instance->deleteUserIdRoutingskillsSkillId($user_id, $skill_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **skill_id** | **string**| skillId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUtilization**
> string deleteUtilization()

Delete utilization settings and revert to system defaults.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->deleteUtilization();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteUtilization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWrapupcodesCodeId**
> string deleteWrapupcodesCodeId($code_id)

Delete wrap-up code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$code_id = "code_id_example"; // string | Wrapup Code ID

try {
    $result = $api_instance->deleteWrapupcodesCodeId($code_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->deleteWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **code_id** | **string**| Wrapup Code ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailDomains**
> \PureCloudSDK\InboundDomainEntityListing getEmailDomains()

Get domains



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->getEmailDomains();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getEmailDomains: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\InboundDomainEntityListing**](../Model/InboundDomainEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailDomainsDomainId**
> \PureCloudSDK\InboundDomain getEmailDomainsDomainId($domain_id)

Get domain



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_id = "domain_id_example"; // string | domain ID

try {
    $result = $api_instance->getEmailDomainsDomainId($domain_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getEmailDomainsDomainId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_id** | **string**| domain ID |

### Return type

[**\PureCloudSDK\InboundDomain**](../Model/InboundDomain.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailDomainsDomainnameRoutes**
> \PureCloudSDK\InboundRouteEntityListing getEmailDomainsDomainnameRoutes($domain_name)

Get routes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_name = "domain_name_example"; // string | email domain

try {
    $result = $api_instance->getEmailDomainsDomainnameRoutes($domain_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getEmailDomainsDomainnameRoutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_name** | **string**| email domain |

### Return type

[**\PureCloudSDK\InboundRouteEntityListing**](../Model/InboundRouteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailDomainsDomainnameRoutesRouteId**
> \PureCloudSDK\InboundRoute getEmailDomainsDomainnameRoutesRouteId($domain_name, $route_id)

Get a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_name = "domain_name_example"; // string | email domain
$route_id = "route_id_example"; // string | route ID

try {
    $result = $api_instance->getEmailDomainsDomainnameRoutesRouteId($domain_name, $route_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getEmailDomainsDomainnameRoutesRouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_name** | **string**| email domain |
 **route_id** | **string**| route ID |

### Return type

[**\PureCloudSDK\InboundRoute**](../Model/InboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailSetup**
> \PureCloudSDK\EmailSetup getEmailSetup()

Get email setup



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->getEmailSetup();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getEmailSetup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EmailSetup**](../Model/EmailSetup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueues**
> \PureCloudSDK\QueueEntityListing getQueues($page_size, $page_number, $sort_by, $name, $active)

Get list of queues.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "name"; // string | Sort by
$name = "name_example"; // string | Name
$active = true; // bool | Active

try {
    $result = $api_instance->getQueues($page_size, $page_number, $sort_by, $name, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to name]
 **name** | **string**| Name | [optional]
 **active** | **bool**| Active | [optional]

### Return type

[**\PureCloudSDK\QueueEntityListing**](../Model/QueueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueId**
> \PureCloudSDK\Queue getQueuesQueueId($queue_id)

Get details about this queue.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID

try {
    $result = $api_instance->getQueuesQueueId($queue_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |

### Return type

[**\PureCloudSDK\Queue**](../Model/Queue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdConversations**
> \PureCloudSDK\ConversationEntityListing getQueuesQueueIdConversations($queue_id, $page_size, $page_number)

Get recent conversations that are still active



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getQueuesQueueIdConversations($queue_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdConversations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ConversationEntityListing**](../Model/ConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdConversationsCallbacks**
> \PureCloudSDK\CallbackConversationEntityListing getQueuesQueueIdConversationsCallbacks($queue_id, $page_size, $page_number)

Get recent callback conversations that are still active



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getQueuesQueueIdConversationsCallbacks($queue_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdConversationsCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\CallbackConversationEntityListing**](../Model/CallbackConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdConversationsCalls**
> \PureCloudSDK\CallConversationEntityListing getQueuesQueueIdConversationsCalls($queue_id, $page_size, $page_number)

Get recent call conversations that are still active



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getQueuesQueueIdConversationsCalls($queue_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdConversationsCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdConversationsChats**
> \PureCloudSDK\ChatConversationEntityListing getQueuesQueueIdConversationsChats($queue_id, $page_size, $page_number)

Get recent chat conversations that are still active



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getQueuesQueueIdConversationsChats($queue_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdConversationsChats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ChatConversationEntityListing**](../Model/ChatConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdConversationsEmails**
> \PureCloudSDK\EmailConversationEntityListing getQueuesQueueIdConversationsEmails($queue_id, $page_size, $page_number)

Get recent email conversations that are still active



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getQueuesQueueIdConversationsEmails($queue_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdConversationsEmails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EmailConversationEntityListing**](../Model/EmailConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdEstimatedwaittime**
> \PureCloudSDK\EstimatedWaitTimePredictions getQueuesQueueIdEstimatedwaittime($queue_id, $conversation_id)

Get Estimated Wait Time



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | queueId
$conversation_id = "conversation_id_example"; // string | conversationId

try {
    $result = $api_instance->getQueuesQueueIdEstimatedwaittime($queue_id, $conversation_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdEstimatedwaittime: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| queueId |
 **conversation_id** | **string**| conversationId | [optional]

### Return type

[**\PureCloudSDK\EstimatedWaitTimePredictions**](../Model/EstimatedWaitTimePredictions.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdUsers**
> \PureCloudSDK\QueueMemberEntityListing getQueuesQueueIdUsers($queue_id, $page_size, $page_number, $sort_by, $expand, $joined, $name, $profile_skills, $skills, $languages, $routing_status, $presence)

Get the members of this queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "name"; // string | Sort by
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$joined = true; // bool | Filter by joined status
$name = "name_example"; // string | Filter by queue member name
$profile_skills = array("profile_skills_example"); // string[] | Filter by profile skill
$skills = array("skills_example"); // string[] | Filter by skill
$languages = array("languages_example"); // string[] | Filter by language
$routing_status = array("routing_status_example"); // string[] | Filter by routing status
$presence = array("presence_example"); // string[] | Filter by presence

try {
    $result = $api_instance->getQueuesQueueIdUsers($queue_id, $page_size, $page_number, $sort_by, $expand, $joined, $name, $profile_skills, $skills, $languages, $routing_status, $presence);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to name]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **joined** | **bool**| Filter by joined status | [optional]
 **name** | **string**| Filter by queue member name | [optional]
 **profile_skills** | [**string[]**](../Model/string.md)| Filter by profile skill | [optional]
 **skills** | [**string[]**](../Model/string.md)| Filter by skill | [optional]
 **languages** | [**string[]**](../Model/string.md)| Filter by language | [optional]
 **routing_status** | [**string[]**](../Model/string.md)| Filter by routing status | [optional]
 **presence** | [**string[]**](../Model/string.md)| Filter by presence | [optional]

### Return type

[**\PureCloudSDK\QueueMemberEntityListing**](../Model/QueueMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQueuesQueueIdWrapupcodes**
> \PureCloudSDK\WrapupCodeEntityListing getQueuesQueueIdWrapupcodes($queue_id)

Get the wrap-up codes for a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID

try {
    $result = $api_instance->getQueuesQueueIdWrapupcodes($queue_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getQueuesQueueIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |

### Return type

[**\PureCloudSDK\WrapupCodeEntityListing**](../Model/WrapupCodeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSkills**
> \PureCloudSDK\SkillEntityListing getSkills($page_size, $page_number)

Get the list of routing skills.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getSkills($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getSkills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SkillEntityListing**](../Model/SkillEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSkillsSkillId**
> \PureCloudSDK\RoutingSkill getSkillsSkillId($skill_id)

Get Routing Skill



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$skill_id = "skill_id_example"; // string | Skill ID

try {
    $result = $api_instance->getSkillsSkillId($skill_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getSkillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skill_id** | **string**| Skill ID |

### Return type

[**\PureCloudSDK\RoutingSkill**](../Model/RoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdRoutingskills**
> \PureCloudSDK\UserSkillEntityListing getUserIdRoutingskills($user_id, $page_size, $page_number, $sort_order)

List routing skills for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$user_id = "user_id_example"; // string | User ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_order = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getUserIdRoutingskills($user_id, $page_size, $page_number, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_order** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\UserSkillEntityListing**](../Model/UserSkillEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUtilization**
> \PureCloudSDK\Utilization getUtilization()

Get the utilization settings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();

try {
    $result = $api_instance->getUtilization();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getUtilization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Utilization**](../Model/Utilization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWrapupcodes**
> \PureCloudSDK\WrapupCodeEntityListing getWrapupcodes($page_size, $page_number, $sort_by)

Get list of wrapup codes.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "name"; // string | Sort by

try {
    $result = $api_instance->getWrapupcodes($page_size, $page_number, $sort_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\WrapupCodeEntityListing**](../Model/WrapupCodeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWrapupcodesCodeId**
> \PureCloudSDK\WrapupCode getWrapupcodesCodeId($code_id)

Get details about this wrap-up code.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$code_id = "code_id_example"; // string | Wrapup Code ID

try {
    $result = $api_instance->getWrapupcodesCodeId($code_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->getWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **code_id** | **string**| Wrapup Code ID |

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchQueuesQueueIdUsers**
> \PureCloudSDK\QueueMemberEntityListing patchQueuesQueueIdUsers($queue_id, $body)

Join or unjoin a set of users for a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$body = array(new QueueMember()); // \PureCloudSDK\QueueMember[] | Queue Members

try {
    $result = $api_instance->patchQueuesQueueIdUsers($queue_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->patchQueuesQueueIdUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\QueueMember[]**](../Model/QueueMember.md)| Queue Members |

### Return type

[**\PureCloudSDK\QueueMemberEntityListing**](../Model/QueueMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchQueuesQueueIdUsersMemberId**
> \PureCloudSDK\QueueMember patchQueuesQueueIdUsersMemberId($queue_id, $member_id, $body)

Update the ring number of joined status for a User in a Queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$member_id = "member_id_example"; // string | Member ID
$body = new \PureCloudSDK\QueueMember(); // \PureCloudSDK\QueueMember | Queue Member

try {
    $result = $api_instance->patchQueuesQueueIdUsersMemberId($queue_id, $member_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->patchQueuesQueueIdUsersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **member_id** | **string**| Member ID |
 **body** | [**\PureCloudSDK\QueueMember**](../Model/\PureCloudSDK\QueueMember.md)| Queue Member |

### Return type

[**\PureCloudSDK\QueueMember**](../Model/QueueMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEmailDomains**
> \PureCloudSDK\InboundDomain postEmailDomains($body)

Create a domain



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\InboundDomain(); // \PureCloudSDK\InboundDomain | Domain

try {
    $result = $api_instance->postEmailDomains($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postEmailDomains: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\InboundDomain**](../Model/\PureCloudSDK\InboundDomain.md)| Domain |

### Return type

[**\PureCloudSDK\InboundDomain**](../Model/InboundDomain.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEmailDomainsDomainnameRoutes**
> \PureCloudSDK\InboundRoute postEmailDomainsDomainnameRoutes($domain_name, $body)

Create a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_name = "domain_name_example"; // string | email domain
$body = new \PureCloudSDK\InboundRoute(); // \PureCloudSDK\InboundRoute | Route

try {
    $result = $api_instance->postEmailDomainsDomainnameRoutes($domain_name, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postEmailDomainsDomainnameRoutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_name** | **string**| email domain |
 **body** | [**\PureCloudSDK\InboundRoute**](../Model/\PureCloudSDK\InboundRoute.md)| Route |

### Return type

[**\PureCloudSDK\InboundRoute**](../Model/InboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQueues**
> \PureCloudSDK\Queue postQueues($body)

Create queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\CreateQueueRequest(); // \PureCloudSDK\CreateQueueRequest | Queue

try {
    $result = $api_instance->postQueues($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateQueueRequest**](../Model/\PureCloudSDK\CreateQueueRequest.md)| Queue |

### Return type

[**\PureCloudSDK\Queue**](../Model/Queue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQueuesObservationsQuery**
> \PureCloudSDK\QualifierMappingObservationQueryResponse postQueuesObservationsQuery($body)

Query for queue observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postQueuesObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postQueuesObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\QualifierMappingObservationQueryResponse**](../Model/QualifierMappingObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQueuesQueueIdUsers**
> string postQueuesQueueIdUsers($queue_id, $body, $delete)

Bulk add or delete up to 100 queue members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$body = array(new QueueMember()); // \PureCloudSDK\QueueMember[] | Queue Members
$delete = false; // bool | True to delete queue members

try {
    $result = $api_instance->postQueuesQueueIdUsers($queue_id, $body, $delete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postQueuesQueueIdUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\QueueMember[]**](../Model/QueueMember.md)| Queue Members |
 **delete** | **bool**| True to delete queue members | [optional] [default to false]

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQueuesQueueIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] postQueuesQueueIdWrapupcodes($queue_id, $body)

Add up to 100 wrap-up codes to a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$body = array(new WrapupCode()); // \PureCloudSDK\WrapupCode[] | List of wrapup codes

try {
    $result = $api_instance->postQueuesQueueIdWrapupcodes($queue_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postQueuesQueueIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)| List of wrapup codes |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSkills**
> \PureCloudSDK\RoutingSkill postSkills($body)

Create Skill



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\RoutingSkill(); // \PureCloudSDK\RoutingSkill | Skill

try {
    $result = $api_instance->postSkills($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postSkills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RoutingSkill**](../Model/\PureCloudSDK\RoutingSkill.md)| Skill |

### Return type

[**\PureCloudSDK\RoutingSkill**](../Model/RoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUserIdRoutingskills**
> \PureCloudSDK\UserRoutingSkill postUserIdRoutingskills($user_id, $body)

Add routing skill to user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\UserRoutingSkillPost(); // \PureCloudSDK\UserRoutingSkillPost | Skill

try {
    $result = $api_instance->postUserIdRoutingskills($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserRoutingSkillPost**](../Model/\PureCloudSDK\UserRoutingSkillPost.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWrapupcodes**
> \PureCloudSDK\CallableTimeSet postWrapupcodes($body)

Create a wrap-up code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\WrapupCode(); // \PureCloudSDK\WrapupCode | WrapupCode

try {
    $result = $api_instance->postWrapupcodes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->postWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WrapupCode**](../Model/\PureCloudSDK\WrapupCode.md)| WrapupCode |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putEmailDomainsDomainnameRoutesRouteId**
> \PureCloudSDK\InboundRoute putEmailDomainsDomainnameRoutesRouteId($domain_name, $route_id, $body)

Update a route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$domain_name = "domain_name_example"; // string | email domain
$route_id = "route_id_example"; // string | route ID
$body = new \PureCloudSDK\InboundRoute(); // \PureCloudSDK\InboundRoute | Route

try {
    $result = $api_instance->putEmailDomainsDomainnameRoutesRouteId($domain_name, $route_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putEmailDomainsDomainnameRoutesRouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **domain_name** | **string**| email domain |
 **route_id** | **string**| route ID |
 **body** | [**\PureCloudSDK\InboundRoute**](../Model/\PureCloudSDK\InboundRoute.md)| Route |

### Return type

[**\PureCloudSDK\InboundRoute**](../Model/InboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putQueuesQueueId**
> \PureCloudSDK\Queue putQueuesQueueId($queue_id, $body)

Update a queue



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$queue_id = "queue_id_example"; // string | Queue ID
$body = new \PureCloudSDK\Queue(); // \PureCloudSDK\Queue | Queue

try {
    $result = $api_instance->putQueuesQueueId($queue_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **body** | [**\PureCloudSDK\Queue**](../Model/\PureCloudSDK\Queue.md)| Queue |

### Return type

[**\PureCloudSDK\Queue**](../Model/Queue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdRoutingskillsSkillId**
> \PureCloudSDK\UserRoutingSkill putUserIdRoutingskillsSkillId($user_id, $skill_id, $body)

Update routing skill proficiency or state.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$user_id = "user_id_example"; // string | User ID
$skill_id = "skill_id_example"; // string | skillId
$body = new \PureCloudSDK\UserRoutingSkill(); // \PureCloudSDK\UserRoutingSkill | Skill

try {
    $result = $api_instance->putUserIdRoutingskillsSkillId($user_id, $skill_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **skill_id** | **string**| skillId |
 **body** | [**\PureCloudSDK\UserRoutingSkill**](../Model/\PureCloudSDK\UserRoutingSkill.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUtilization**
> \PureCloudSDK\Utilization putUtilization($body)

Update the utilization settings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$body = new \PureCloudSDK\Utilization(); // \PureCloudSDK\Utilization | utilization

try {
    $result = $api_instance->putUtilization($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putUtilization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Utilization**](../Model/\PureCloudSDK\Utilization.md)| utilization |

### Return type

[**\PureCloudSDK\Utilization**](../Model/Utilization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWrapupcodesCodeId**
> \PureCloudSDK\WrapupCode putWrapupcodesCodeId($code_id, $body)

Update wrap-up code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RoutingApi();
$code_id = "code_id_example"; // string | Wrapup Code ID
$body = new \PureCloudSDK\WrapupCode(); // \PureCloudSDK\WrapupCode | WrapupCode

try {
    $result = $api_instance->putWrapupcodesCodeId($code_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RoutingApi->putWrapupcodesCodeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **code_id** | **string**| Wrapup Code ID |
 **body** | [**\PureCloudSDK\WrapupCode**](../Model/\PureCloudSDK\WrapupCode.md)| WrapupCode |

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

