# PureCloudSDK\StationsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteStationIdAssociateduser**](StationsApi.md#deleteStationIdAssociateduser) | **DELETE** /api/v2/stations/{stationId}/associateduser | Unassigns the user assigned to this station
[**getStationId**](StationsApi.md#getStationId) | **GET** /api/v2/stations/{stationId} | Get station.
[**getStations**](StationsApi.md#getStations) | **GET** /api/v2/stations | Get the list of available stations.


# **deleteStationIdAssociateduser**
> string deleteStationIdAssociateduser($station_id)

Unassigns the user assigned to this station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\StationsApi();
$station_id = "station_id_example"; // string | Station ID

try {
    $result = $api_instance->deleteStationIdAssociateduser($station_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StationsApi->deleteStationIdAssociateduser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **station_id** | **string**| Station ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStationId**
> \PureCloudSDK\Station getStationId($station_id)

Get station.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\StationsApi();
$station_id = "station_id_example"; // string | Station ID

try {
    $result = $api_instance->getStationId($station_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StationsApi->getStationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **station_id** | **string**| Station ID |

### Return type

[**\PureCloudSDK\Station**](../Model/Station.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStations**
> \PureCloudSDK\StationEntityListing getStations($page_size, $page_number, $sort_by, $name, $line_appearance_id)

Get the list of available stations.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\StationsApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "name"; // string | Sort by
$name = "name_example"; // string | Name
$line_appearance_id = "line_appearance_id_example"; // string | lineAppearanceId

try {
    $result = $api_instance->getStations($page_size, $page_number, $sort_by, $name, $line_appearance_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StationsApi->getStations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to name]
 **name** | **string**| Name | [optional]
 **line_appearance_id** | **string**| lineAppearanceId | [optional]

### Return type

[**\PureCloudSDK\StationEntityListing**](../Model/StationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

