# PureCloudSDK\TelephonyProvidersEdgeApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesCertificateauthoritiesCertificateId) | **DELETE** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Delete a certificate authority.
[**deleteProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesDidpoolsDidpoolId) | **DELETE** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Delete a DID Pool by ID.
[**deleteProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgeId) | **DELETE** /api/v2/telephony/providers/edges/{edgeId} | Delete a edge.
[**deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Delete an edge logical interface
[**deleteProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgeIdSoftwareupdate) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Cancels any in-progress update for this edge.
[**deleteProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgegroupsEdgegroupId) | **DELETE** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Delete an edge group.
[**deleteProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEndpointsEndpointId) | **DELETE** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Delete endpoint
[**deleteProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesExtensionpoolsExtensionpoolId) | **DELETE** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Delete an extension pool by ID
[**deleteProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesOutboundroutesOutboundrouteId) | **DELETE** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Delete Outbound Route
[**deleteProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesPhonebasesettingsPhonebaseId) | **DELETE** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Delete a Phone Base Settings by ID
[**deleteProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesPhonesPhoneId) | **DELETE** /api/v2/telephony/providers/edges/phones/{phoneId} | Delete a Phone by ID
[**deleteProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesSitesSiteId) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId} | Delete a Site by ID
[**deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **DELETE** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Delete a Trunk Base Settings object by ID
[**getProvidersEdges**](TelephonyProvidersEdgeApi.md#getProvidersEdges) | **GET** /api/v2/telephony/providers/edges | Get the list of edges.
[**getProvidersEdgesAvailablelanguages**](TelephonyProvidersEdgeApi.md#getProvidersEdgesAvailablelanguages) | **GET** /api/v2/telephony/providers/edges/availablelanguages | Get the list of available languages.
[**getProvidersEdgesCertificateauthorities**](TelephonyProvidersEdgeApi.md#getProvidersEdgesCertificateauthorities) | **GET** /api/v2/telephony/providers/edges/certificateauthorities | Get the list of certificate authorities.
[**getProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesCertificateauthoritiesCertificateId) | **GET** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Get a certificate authority.
[**getProvidersEdgesDidpools**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDidpools) | **GET** /api/v2/telephony/providers/edges/didpools | Get a listing of DID Pools
[**getProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDidpoolsDidpoolId) | **GET** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Get a DID Pool by ID.
[**getProvidersEdgesDids**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDids) | **GET** /api/v2/telephony/providers/edges/dids | Get a listing of DIDs
[**getProvidersEdgesDidsDidId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDidsDidId) | **GET** /api/v2/telephony/providers/edges/dids/{didId} | Get a DID by ID.
[**getProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeId) | **GET** /api/v2/telephony/providers/edges/{edgeId} | Get edge.
[**getProvidersEdgesEdgeIdLines**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLines) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines | Get the list of lines.
[**getProvidersEdgesEdgeIdLinesLineId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLinesLineId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Get line
[**getProvidersEdgesEdgeIdLogicalinterfaces**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLogicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Get edge logical interfaces.
[**getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Get an edge logical interface
[**getProvidersEdgesEdgeIdLogsJobsJobId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLogsJobsJobId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId} | Get an Edge logs job.
[**getProvidersEdgesEdgeIdPhysicalinterfaces**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdPhysicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces | Retrieve a list of all configured physical interfaces from a specific edge.
[**getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces/{interfaceId} | Get edge physical interface.
[**getProvidersEdgesEdgeIdSetuppackage**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdSetuppackage) | **GET** /api/v2/telephony/providers/edges/{edgeId}/setuppackage | Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.
[**getProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdSoftwareupdate) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Gets software update status information about any edge.
[**getProvidersEdgesEdgeIdSoftwareversions**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdSoftwareversions) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareversions | Gets all the available software versions for this edge.
[**getProvidersEdgesEdgegroups**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgegroups) | **GET** /api/v2/telephony/providers/edges/edgegroups | Get the list of edge groups.
[**getProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgegroupsEdgegroupId) | **GET** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Get edge group.
[**getProvidersEdgesEdgeversionreport**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeversionreport) | **GET** /api/v2/telephony/providers/edges/edgeversionreport | Get the edge version report.
[**getProvidersEdgesEndpoints**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEndpoints) | **GET** /api/v2/telephony/providers/edges/endpoints | Get endpoints
[**getProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEndpointsEndpointId) | **GET** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Get endpoint
[**getProvidersEdgesExtensionpools**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensionpools) | **GET** /api/v2/telephony/providers/edges/extensionpools | Get a listing of extension pools
[**getProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensionpoolsExtensionpoolId) | **GET** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Get an extension pool by ID
[**getProvidersEdgesExtensions**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensions) | **GET** /api/v2/telephony/providers/edges/extensions | Get a listing of extensions
[**getProvidersEdgesExtensionsExtensionId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensionsExtensionId) | **GET** /api/v2/telephony/providers/edges/extensions/{extensionId} | Get an extension by ID.
[**getProvidersEdgesLinebasesettings**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinebasesettings) | **GET** /api/v2/telephony/providers/edges/linebasesettings | Get a listing of line base settings objects
[**getProvidersEdgesLinebasesettingsLinebaseId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinebasesettingsLinebaseId) | **GET** /api/v2/telephony/providers/edges/linebasesettings/{lineBaseId} | Get a line base settings object by ID
[**getProvidersEdgesLines**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLines) | **GET** /api/v2/telephony/providers/edges/lines | Get a list of Lines
[**getProvidersEdgesLinesLineId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinesLineId) | **GET** /api/v2/telephony/providers/edges/lines/{lineId} | Get a Line by ID
[**getProvidersEdgesLinesTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinesTemplate) | **GET** /api/v2/telephony/providers/edges/lines/template | Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance
[**getProvidersEdgesOutboundroutes**](TelephonyProvidersEdgeApi.md#getProvidersEdgesOutboundroutes) | **GET** /api/v2/telephony/providers/edges/outboundroutes | Get outbound routes
[**getProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesOutboundroutesOutboundrouteId) | **GET** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Get outbound route
[**getProvidersEdgesPhonebasesettings**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettings) | **GET** /api/v2/telephony/providers/edges/phonebasesettings | Get a list of Phone Base Settings objects
[**getProvidersEdgesPhonebasesettingsAvailablemetabases**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettingsAvailablemetabases) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/availablemetabases | Get a list of available makes and models to create a new Phone Base Settings
[**getProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettingsPhonebaseId) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Get a Phone Base Settings object by ID
[**getProvidersEdgesPhonebasesettingsTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettingsTemplate) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/template | Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance
[**getProvidersEdgesPhones**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhones) | **GET** /api/v2/telephony/providers/edges/phones | Get a list of Phone Instances
[**getProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonesPhoneId) | **GET** /api/v2/telephony/providers/edges/phones/{phoneId} | Get a Phone by ID
[**getProvidersEdgesPhonesTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonesTemplate) | **GET** /api/v2/telephony/providers/edges/phones/template | Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance
[**getProvidersEdgesSites**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSites) | **GET** /api/v2/telephony/providers/edges/sites | Get the list of Sites.
[**getProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId} | Get a Site by ID.
[**getProvidersEdgesSitesSiteIdNumberplans**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteIdNumberplans) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Get the list of Number Plans for this Site.
[**getProvidersEdgesSitesSiteIdNumberplansClassifications**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteIdNumberplansClassifications) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/classifications | Get a list of Classifications for this Site
[**getProvidersEdgesSitesSiteIdNumberplansNumberplanId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteIdNumberplansNumberplanId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/{numberPlanId} | Get a Number Plan by ID.
[**getProvidersEdgesTimezones**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTimezones) | **GET** /api/v2/telephony/providers/edges/timezones | Get a list of Edge-compatible time zones
[**getProvidersEdgesTrunkbasesettings**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettings) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings | Get Trunk Base Settings listing
[**getProvidersEdgesTrunkbasesettingsAvailablemetabases**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettingsAvailablemetabases) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/availablemetabases | Get a list of available makes and models to create a new Trunk Base Settings
[**getProvidersEdgesTrunkbasesettingsTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettingsTemplate) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/template | Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance
[**getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Get a Trunk Base Settings object by ID
[**getProvidersEdgesTrunks**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunks) | **GET** /api/v2/telephony/providers/edges/trunks | Get the list of available trunks.
[**getProvidersEdgesTrunksTrunkId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunksTrunkId) | **GET** /api/v2/telephony/providers/edges/trunks/{trunkId} | Get a Trunk by ID
[**getProvidersEdgesTrunkswithrecording**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkswithrecording) | **GET** /api/v2/telephony/providers/edges/trunkswithrecording | Get Counts of trunks that have recording disabled or enabled
[**getSchemasEdgesVnext**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnext) | **GET** /api/v2/configuration/schemas/edges/vnext | Lists available schema categories
[**getSchemasEdgesVnextSchemacategory**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategory) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory} | List schemas of a specific category
[**getSchemasEdgesVnextSchemacategorySchematype**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategorySchematype) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType} | List schemas of a specific category
[**getSchemasEdgesVnextSchemacategorySchematypeSchemaId**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategorySchematypeSchemaId) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId} | Get a json schema
[**getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}/{extensionType}/{metadataId} | Get metadata for a schema
[**postProvidersEdges**](TelephonyProvidersEdgeApi.md#postProvidersEdges) | **POST** /api/v2/telephony/providers/edges | Create an edge.
[**postProvidersEdgesAddressvalidation**](TelephonyProvidersEdgeApi.md#postProvidersEdgesAddressvalidation) | **POST** /api/v2/telephony/providers/edges/addressvalidation | Validates a street address
[**postProvidersEdgesCertificateauthorities**](TelephonyProvidersEdgeApi.md#postProvidersEdgesCertificateauthorities) | **POST** /api/v2/telephony/providers/edges/certificateauthorities | Create a certificate authority.
[**postProvidersEdgesDidpools**](TelephonyProvidersEdgeApi.md#postProvidersEdgesDidpools) | **POST** /api/v2/telephony/providers/edges/didpools | Create a new DID pool
[**postProvidersEdgesEdgeIdLogicalinterfaces**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdLogicalinterfaces) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Create an edge logical interface.
[**postProvidersEdgesEdgeIdLogsJobs**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdLogsJobs) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs | Create a job to upload a list of Edge logs.
[**postProvidersEdgesEdgeIdLogsJobsJobIdUpload**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdLogsJobsJobIdUpload) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}/upload | Request that the specified fileIds be uploaded from the Edge.
[**postProvidersEdgesEdgeIdReboot**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdReboot) | **POST** /api/v2/telephony/providers/edges/{edgeId}/reboot | Reboot an Edge
[**postProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdSoftwareupdate) | **POST** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Starts a software update for this edge.
[**postProvidersEdgesEdgeIdUnpair**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdUnpair) | **POST** /api/v2/telephony/providers/edges/{edgeId}/unpair | Unpair an Edge
[**postProvidersEdgesEdgegroups**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgegroups) | **POST** /api/v2/telephony/providers/edges/edgegroups | Create an edge group.
[**postProvidersEdgesEndpoints**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEndpoints) | **POST** /api/v2/telephony/providers/edges/endpoints | Create endpoint
[**postProvidersEdgesExtensionpools**](TelephonyProvidersEdgeApi.md#postProvidersEdgesExtensionpools) | **POST** /api/v2/telephony/providers/edges/extensionpools | Create a new extension pool
[**postProvidersEdgesOfflineconfiguration**](TelephonyProvidersEdgeApi.md#postProvidersEdgesOfflineconfiguration) | **POST** /api/v2/telephony/providers/edges/offlineconfiguration | Create a file that can be used to configure a hardware Edge&#39;s settings.
[**postProvidersEdgesOutboundroutes**](TelephonyProvidersEdgeApi.md#postProvidersEdgesOutboundroutes) | **POST** /api/v2/telephony/providers/edges/outboundroutes | Create outbound rule
[**postProvidersEdgesPhonebasesettings**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhonebasesettings) | **POST** /api/v2/telephony/providers/edges/phonebasesettings | Create a new Phone Base Settings object
[**postProvidersEdgesPhones**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhones) | **POST** /api/v2/telephony/providers/edges/phones | Create a new Phone
[**postProvidersEdgesPhonesPhoneIdReboot**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhonesPhoneIdReboot) | **POST** /api/v2/telephony/providers/edges/phones/{phoneId}/reboot | Reboot a Phone
[**postProvidersEdgesPhonesReboot**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhonesReboot) | **POST** /api/v2/telephony/providers/edges/phones/reboot | Reboot Multiple Phones
[**postProvidersEdgesSites**](TelephonyProvidersEdgeApi.md#postProvidersEdgesSites) | **POST** /api/v2/telephony/providers/edges/sites | Create a Site.
[**postProvidersEdgesSitesSiteIdRebalance**](TelephonyProvidersEdgeApi.md#postProvidersEdgesSitesSiteIdRebalance) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/rebalance | Triggers the rebalance operation.
[**postProvidersEdgesTrunkbasesettings**](TelephonyProvidersEdgeApi.md#postProvidersEdgesTrunkbasesettings) | **POST** /api/v2/telephony/providers/edges/trunkbasesettings | Create a Trunk Base Settings object
[**putProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesCertificateauthoritiesCertificateId) | **PUT** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Update a certificate authority.
[**putProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesDidpoolsDidpoolId) | **PUT** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Update a DID Pool by ID.
[**putProvidersEdgesDidsDidId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesDidsDidId) | **PUT** /api/v2/telephony/providers/edges/dids/{didId} | Update a DID by ID.
[**putProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgeId) | **PUT** /api/v2/telephony/providers/edges/{edgeId} | Update a edge.
[**putProvidersEdgesEdgeIdLinesLineId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgeIdLinesLineId) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Update a line.
[**putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Update an edge logical interface.
[**putProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgegroupsEdgegroupId) | **PUT** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Update an edge group.
[**putProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEndpointsEndpointId) | **PUT** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Update endpoint
[**putProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesExtensionpoolsExtensionpoolId) | **PUT** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Update an extension pool by ID
[**putProvidersEdgesExtensionsExtensionId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesExtensionsExtensionId) | **PUT** /api/v2/telephony/providers/edges/extensions/{extensionId} | Update an extension by ID.
[**putProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesOutboundroutesOutboundrouteId) | **PUT** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Update outbound route
[**putProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesPhonebasesettingsPhonebaseId) | **PUT** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Update a Phone Base Settings by ID
[**putProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesPhonesPhoneId) | **PUT** /api/v2/telephony/providers/edges/phones/{phoneId} | Update a Phone by ID
[**putProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesSitesSiteId) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId} | Update a Site by ID.
[**putProvidersEdgesSitesSiteIdNumberplans**](TelephonyProvidersEdgeApi.md#putProvidersEdgesSitesSiteIdNumberplans) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Update the list of Number Plans.
[**putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **PUT** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Update a Trunk Base Settings object by ID


# **deleteProvidersEdgesCertificateauthoritiesCertificateId**
> string deleteProvidersEdgesCertificateauthoritiesCertificateId($certificate_id)

Delete a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificate_id = "certificate_id_example"; // string | Certificate ID

try {
    $result = $api_instance->deleteProvidersEdgesCertificateauthoritiesCertificateId($certificate_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificate_id** | **string**| Certificate ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesDidpoolsDidpoolId**
> string deleteProvidersEdgesDidpoolsDidpoolId($did_pool_id)

Delete a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$did_pool_id = "did_pool_id_example"; // string | DID pool ID

try {
    $result = $api_instance->deleteProvidersEdgesDidpoolsDidpoolId($did_pool_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **did_pool_id** | **string**| DID pool ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgeId**
> string deleteProvidersEdgesEdgeId($edge_id)

Delete a edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->deleteProvidersEdgesEdgeId($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edge_id, $interface_id)

Delete an edge logical interface



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$interface_id = "interface_id_example"; // string | Interface ID

try {
    $api_instance->deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edge_id, $interface_id);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **interface_id** | **string**| Interface ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgeIdSoftwareupdate**
> string deleteProvidersEdgesEdgeIdSoftwareupdate($edge_id)

Cancels any in-progress update for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->deleteProvidersEdgesEdgeIdSoftwareupdate($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgegroupsEdgegroupId**
> string deleteProvidersEdgesEdgegroupsEdgegroupId($edge_group_id)

Delete an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_group_id = "edge_group_id_example"; // string | Edge group ID

try {
    $result = $api_instance->deleteProvidersEdgesEdgegroupsEdgegroupId($edge_group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_group_id** | **string**| Edge group ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEndpointsEndpointId**
> string deleteProvidersEdgesEndpointsEndpointId($endpoint_id)

Delete endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpoint_id = "endpoint_id_example"; // string | Endpoint ID

try {
    $result = $api_instance->deleteProvidersEdgesEndpointsEndpointId($endpoint_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpoint_id** | **string**| Endpoint ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesExtensionpoolsExtensionpoolId**
> string deleteProvidersEdgesExtensionpoolsExtensionpoolId($extension_pool_id)

Delete an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extension_pool_id = "extension_pool_id_example"; // string | Extension pool ID

try {
    $result = $api_instance->deleteProvidersEdgesExtensionpoolsExtensionpoolId($extension_pool_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extension_pool_id** | **string**| Extension pool ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesOutboundroutesOutboundrouteId**
> string deleteProvidersEdgesOutboundroutesOutboundrouteId($outbound_route_id)

Delete Outbound Route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outbound_route_id = "outbound_route_id_example"; // string | Outbound route ID

try {
    $result = $api_instance->deleteProvidersEdgesOutboundroutesOutboundrouteId($outbound_route_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outbound_route_id** | **string**| Outbound route ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesPhonebasesettingsPhonebaseId**
> string deleteProvidersEdgesPhonebasesettingsPhonebaseId($phone_base_id)

Delete a Phone Base Settings by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_base_id = "phone_base_id_example"; // string | Phone base ID

try {
    $result = $api_instance->deleteProvidersEdgesPhonebasesettingsPhonebaseId($phone_base_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_base_id** | **string**| Phone base ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesPhonesPhoneId**
> string deleteProvidersEdgesPhonesPhoneId($phone_id)

Delete a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_id = "phone_id_example"; // string | Phone ID

try {
    $result = $api_instance->deleteProvidersEdgesPhonesPhoneId($phone_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_id** | **string**| Phone ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesSitesSiteId**
> string deleteProvidersEdgesSitesSiteId($site_id)

Delete a Site by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID

try {
    $result = $api_instance->deleteProvidersEdgesSitesSiteId($site_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> string deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunk_base_settings_id)

Delete a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunk_base_settings_id = "trunk_base_settings_id_example"; // string | Trunk Base ID

try {
    $result = $api_instance->deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunk_base_settings_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunk_base_settings_id** | **string**| Trunk Base ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdges**
> \PureCloudSDK\EdgeEntityListing getProvidersEdges($page_size, $page_number, $name, $site_id, $edge_group_id, $sort_by)

Get the list of edges.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$name = "name_example"; // string | Name
$site_id = "site_id_example"; // string | Filter by site.id
$edge_group_id = "edge_group_id_example"; // string | Filter by edgeGroup.id
$sort_by = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdges($page_size, $page_number, $name, $site_id, $edge_group_id, $sort_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdges: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **site_id** | **string**| Filter by site.id | [optional]
 **edge_group_id** | **string**| Filter by edgeGroup.id | [optional]
 **sort_by** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EdgeEntityListing**](../Model/EdgeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesAvailablelanguages**
> \PureCloudSDK\AvailableLanguageList getProvidersEdgesAvailablelanguages()

Get the list of available languages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getProvidersEdgesAvailablelanguages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesAvailablelanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\AvailableLanguageList**](../Model/AvailableLanguageList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesCertificateauthorities**
> \PureCloudSDK\CertificateAuthorityEntityListing getProvidersEdgesCertificateauthorities()

Get the list of certificate authorities.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getProvidersEdgesCertificateauthorities();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesCertificateauthorities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CertificateAuthorityEntityListing**](../Model/CertificateAuthorityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesCertificateauthoritiesCertificateId**
> \PureCloudSDK\DomainCertificateAuthority getProvidersEdgesCertificateauthoritiesCertificateId($certificate_id)

Get a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificate_id = "certificate_id_example"; // string | Certificate ID

try {
    $result = $api_instance->getProvidersEdgesCertificateauthoritiesCertificateId($certificate_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificate_id** | **string**| Certificate ID |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDidpools**
> \PureCloudSDK\DIDPoolEntityListing getProvidersEdgesDidpools($page_size, $page_number, $sort_by)

Get a listing of DID Pools



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "number"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesDidpools($page_size, $page_number, $sort_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDidpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to number]

### Return type

[**\PureCloudSDK\DIDPoolEntityListing**](../Model/DIDPoolEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDidpoolsDidpoolId**
> \PureCloudSDK\DIDPool getProvidersEdgesDidpoolsDidpoolId($did_pool_id)

Get a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$did_pool_id = "did_pool_id_example"; // string | DID pool ID

try {
    $result = $api_instance->getProvidersEdgesDidpoolsDidpoolId($did_pool_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **did_pool_id** | **string**| DID pool ID |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDids**
> \PureCloudSDK\DIDEntityListing getProvidersEdgesDids($page_size, $page_number, $sort_by, $sort_order, $phone_number)

Get a listing of DIDs



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "number"; // string | Sort by
$sort_order = "ASC"; // string | Sort order
$phone_number = "phone_number_example"; // string | Filter by phoneNumber

try {
    $result = $api_instance->getProvidersEdgesDids($page_size, $page_number, $sort_by, $sort_order, $phone_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDids: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to number]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **phone_number** | **string**| Filter by phoneNumber | [optional]

### Return type

[**\PureCloudSDK\DIDEntityListing**](../Model/DIDEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDidsDidId**
> \PureCloudSDK\DID getProvidersEdgesDidsDidId($did_id)

Get a DID by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$did_id = "did_id_example"; // string | DID ID

try {
    $result = $api_instance->getProvidersEdgesDidsDidId($did_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDidsDidId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **did_id** | **string**| DID ID |

### Return type

[**\PureCloudSDK\DID**](../Model/DID.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeId**
> \PureCloudSDK\Edge getProvidersEdgesEdgeId($edge_id)

Get edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeId($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLines**
> \PureCloudSDK\EdgeLineEntityListing getProvidersEdgesEdgeIdLines($edge_id, $page_size, $page_number)

Get the list of lines.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLines($edge_id, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLines: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EdgeLineEntityListing**](../Model/EdgeLineEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLinesLineId**
> \PureCloudSDK\EdgeLine getProvidersEdgesEdgeIdLinesLineId($edge_id, $line_id)

Get line



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$line_id = "line_id_example"; // string | Line ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLinesLineId($edge_id, $line_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **line_id** | **string**| Line ID |

### Return type

[**\PureCloudSDK\EdgeLine**](../Model/EdgeLine.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLogicalinterfaces**
> \PureCloudSDK\LogicalInterfaceEntityListing getProvidersEdgesEdgeIdLogicalinterfaces($edge_id, $expand)

Get edge logical interfaces.

Retrieve a list of all configured logical interfaces from a specific edge.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLogicalinterfaces($edge_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\LogicalInterfaceEntityListing**](../Model/LogicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> \PureCloudSDK\DomainLogicalInterface getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edge_id, $interface_id, $expand)

Get an edge logical interface



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$interface_id = "interface_id_example"; // string | Interface ID
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edge_id, $interface_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **interface_id** | **string**| Interface ID |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLogsJobsJobId**
> \PureCloudSDK\EdgeLogsJob getProvidersEdgesEdgeIdLogsJobsJobId($edge_id, $job_id)

Get an Edge logs job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$job_id = "job_id_example"; // string | Job ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLogsJobsJobId($edge_id, $job_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLogsJobsJobId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **job_id** | **string**| Job ID |

### Return type

[**\PureCloudSDK\EdgeLogsJob**](../Model/EdgeLogsJob.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdPhysicalinterfaces**
> \PureCloudSDK\PhysicalInterfaceEntityListing getProvidersEdgesEdgeIdPhysicalinterfaces($edge_id)

Retrieve a list of all configured physical interfaces from a specific edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdPhysicalinterfaces($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdPhysicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\PhysicalInterfaceEntityListing**](../Model/PhysicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**
> \PureCloudSDK\DomainPhysicalInterface getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId($edge_id, $interface_id)

Get edge physical interface.

Retrieve a physical interface from a specific edge.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$interface_id = "interface_id_example"; // string | Interface ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId($edge_id, $interface_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **interface_id** | **string**| Interface ID |

### Return type

[**\PureCloudSDK\DomainPhysicalInterface**](../Model/DomainPhysicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdSetuppackage**
> \PureCloudSDK\VmPairingInfo getProvidersEdgesEdgeIdSetuppackage($edge_id)

Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdSetuppackage($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdSetuppackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\VmPairingInfo**](../Model/VmPairingInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdSoftwareupdate**
> \PureCloudSDK\DomainEdgeSoftwareUpdateDto getProvidersEdgesEdgeIdSoftwareupdate($edge_id)

Gets software update status information about any edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdSoftwareupdate($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/DomainEdgeSoftwareUpdateDto.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdSoftwareversions**
> \PureCloudSDK\DomainEdgeSoftwareVersionDtoEntityListing getProvidersEdgesEdgeIdSoftwareversions($edge_id)

Gets all the available software versions for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdSoftwareversions($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdSoftwareversions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareVersionDtoEntityListing**](../Model/DomainEdgeSoftwareVersionDtoEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgegroups**
> \PureCloudSDK\EdgeGroupEntityListing getProvidersEdgesEdgegroups($page_size, $page_number, $name, $sort_by)

Get the list of edge groups.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$name = "name_example"; // string | Name
$sort_by = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesEdgegroups($page_size, $page_number, $name, $sort_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgegroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sort_by** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EdgeGroupEntityListing**](../Model/EdgeGroupEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgegroupsEdgegroupId**
> \PureCloudSDK\EdgeGroup getProvidersEdgesEdgegroupsEdgegroupId($edge_group_id, $expand)

Get edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_group_id = "edge_group_id_example"; // string | Edge group ID
$expand = array("expand_example"); // string[] | Fields to expand in the response

try {
    $result = $api_instance->getProvidersEdgesEdgegroupsEdgegroupId($edge_group_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_group_id** | **string**| Edge group ID |
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response | [optional]

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeversionreport**
> \PureCloudSDK\EdgeVersionReport getProvidersEdgesEdgeversionreport()

Get the edge version report.

The report will not have consistent data about the edge version(s) until all edges have been reset.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getProvidersEdgesEdgeversionreport();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeversionreport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EdgeVersionReport**](../Model/EdgeVersionReport.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEndpoints**
> \PureCloudSDK\EndpointEntityListing getProvidersEdgesEndpoints($page_size, $page_number, $name, $sort_by)

Get endpoints



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$name = "name_example"; // string | Name
$sort_by = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesEndpoints($page_size, $page_number, $name, $sort_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEndpoints: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sort_by** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EndpointEntityListing**](../Model/EndpointEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEndpointsEndpointId**
> \PureCloudSDK\Endpoint getProvidersEdgesEndpointsEndpointId($endpoint_id)

Get endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpoint_id = "endpoint_id_example"; // string | Endpoint ID

try {
    $result = $api_instance->getProvidersEdgesEndpointsEndpointId($endpoint_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpoint_id** | **string**| Endpoint ID |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensionpools**
> \PureCloudSDK\ExtensionPoolEntityListing getProvidersEdgesExtensionpools($page_size, $page_number, $sort_by, $number)

Get a listing of extension pools



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "startNumber"; // string | Sort by
$number = "number_example"; // string | Number

try {
    $result = $api_instance->getProvidersEdgesExtensionpools($page_size, $page_number, $sort_by, $number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensionpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to startNumber]
 **number** | **string**| Number | [optional]

### Return type

[**\PureCloudSDK\ExtensionPoolEntityListing**](../Model/ExtensionPoolEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensionpoolsExtensionpoolId**
> \PureCloudSDK\ExtensionPool getProvidersEdgesExtensionpoolsExtensionpoolId($extension_pool_id)

Get an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extension_pool_id = "extension_pool_id_example"; // string | Extension pool ID

try {
    $result = $api_instance->getProvidersEdgesExtensionpoolsExtensionpoolId($extension_pool_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extension_pool_id** | **string**| Extension pool ID |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensions**
> \PureCloudSDK\ExtensionEntityListing getProvidersEdgesExtensions($page_size, $page_number, $sort_by, $sort_order, $number)

Get a listing of extensions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "number"; // string | Sort by
$sort_order = "ASC"; // string | Sort order
$number = "number_example"; // string | Filter by number

try {
    $result = $api_instance->getProvidersEdgesExtensions($page_size, $page_number, $sort_by, $sort_order, $number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to number]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **number** | **string**| Filter by number | [optional]

### Return type

[**\PureCloudSDK\ExtensionEntityListing**](../Model/ExtensionEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensionsExtensionId**
> \PureCloudSDK\Extension getProvidersEdgesExtensionsExtensionId($extension_id)

Get an extension by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extension_id = "extension_id_example"; // string | Extension ID

try {
    $result = $api_instance->getProvidersEdgesExtensionsExtensionId($extension_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensionsExtensionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extension_id** | **string**| Extension ID |

### Return type

[**\PureCloudSDK\Extension**](../Model/Extension.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinebasesettings**
> \PureCloudSDK\LineBaseEntityListing getProvidersEdgesLinebasesettings($page_number, $page_size, $sort_by, $sort_order)

Get a listing of line base settings objects



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size
$sort_by = "name"; // string | Value by which to sort
$sort_order = "ASC"; // string | Sort order

try {
    $result = $api_instance->getProvidersEdgesLinebasesettings($page_number, $page_size, $sort_by, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **sort_by** | **string**| Value by which to sort | [optional] [default to name]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\LineBaseEntityListing**](../Model/LineBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinebasesettingsLinebaseId**
> \PureCloudSDK\LineBase getProvidersEdgesLinebasesettingsLinebaseId($line_base_id)

Get a line base settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$line_base_id = "line_base_id_example"; // string | Line base ID

try {
    $result = $api_instance->getProvidersEdgesLinebasesettingsLinebaseId($line_base_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinebasesettingsLinebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **line_base_id** | **string**| Line base ID |

### Return type

[**\PureCloudSDK\LineBase**](../Model/LineBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLines**
> \PureCloudSDK\LineEntityListing getProvidersEdgesLines($page_size, $page_number, $name, $sort_by, $expand)

Get a list of Lines



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$name = "name_example"; // string | Name
$sort_by = "name"; // string | Value by which to sort
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated

try {
    $result = $api_instance->getProvidersEdgesLines($page_size, $page_number, $name, $sort_by, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLines: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sort_by** | **string**| Value by which to sort | [optional] [default to name]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]

### Return type

[**\PureCloudSDK\LineEntityListing**](../Model/LineEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinesLineId**
> \PureCloudSDK\Line getProvidersEdgesLinesLineId($line_id)

Get a Line by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$line_id = "line_id_example"; // string | Line ID

try {
    $result = $api_instance->getProvidersEdgesLinesLineId($line_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **line_id** | **string**| Line ID |

### Return type

[**\PureCloudSDK\Line**](../Model/Line.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinesTemplate**
> \PureCloudSDK\Line getProvidersEdgesLinesTemplate($line_base_settings_id)

Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$line_base_settings_id = "line_base_settings_id_example"; // string | The id of a Line Base Settings object upon which to base this Line

try {
    $result = $api_instance->getProvidersEdgesLinesTemplate($line_base_settings_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinesTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **line_base_settings_id** | **string**| The id of a Line Base Settings object upon which to base this Line |

### Return type

[**\PureCloudSDK\Line**](../Model/Line.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesOutboundroutes**
> \PureCloudSDK\OutboundRouteEntityListing getProvidersEdgesOutboundroutes($page_size, $page_number, $name, $site_id, $sort_by)

Get outbound routes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$name = "name_example"; // string | Name
$site_id = "site_id_example"; // string | Filter by site.id
$sort_by = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesOutboundroutes($page_size, $page_number, $name, $site_id, $sort_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **site_id** | **string**| Filter by site.id | [optional]
 **sort_by** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\OutboundRouteEntityListing**](../Model/OutboundRouteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRoute getProvidersEdgesOutboundroutesOutboundrouteId($outbound_route_id)

Get outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outbound_route_id = "outbound_route_id_example"; // string | Outbound route ID

try {
    $result = $api_instance->getProvidersEdgesOutboundroutesOutboundrouteId($outbound_route_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outbound_route_id** | **string**| Outbound route ID |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettings**
> \PureCloudSDK\PhoneBaseEntityListing getProvidersEdgesPhonebasesettings($page_number, $page_size, $sort_by, $sort_order)

Get a list of Phone Base Settings objects



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size
$sort_by = "name"; // string | Value by which to sort
$sort_order = "ASC"; // string | Sort order

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettings($page_number, $page_size, $sort_by, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **sort_by** | **string**| Value by which to sort | [optional] [default to name]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\PhoneBaseEntityListing**](../Model/PhoneBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettingsAvailablemetabases**
> \PureCloudSDK\PhoneMetaBaseEntityListing getProvidersEdgesPhonebasesettingsAvailablemetabases($page_size, $page_number)

Get a list of available makes and models to create a new Phone Base Settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettingsAvailablemetabases($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettingsAvailablemetabases: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\PhoneMetaBaseEntityListing**](../Model/PhoneMetaBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettingsPhonebaseId**
> \PureCloudSDK\PhoneBase getProvidersEdgesPhonebasesettingsPhonebaseId($phone_base_id)

Get a Phone Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_base_id = "phone_base_id_example"; // string | Phone base ID

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettingsPhonebaseId($phone_base_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_base_id** | **string**| Phone base ID |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettingsTemplate**
> \PureCloudSDK\PhoneBase getProvidersEdgesPhonebasesettingsTemplate($phone_metabase_id)

Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_metabase_id = "phone_metabase_id_example"; // string | The id of a metabase object upon which to base this Phone Base Settings

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettingsTemplate($phone_metabase_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettingsTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_metabase_id** | **string**| The id of a metabase object upon which to base this Phone Base Settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhones**
> \PureCloudSDK\PhoneEntityListing getProvidersEdgesPhones($page_number, $page_size, $sort_by, $sort_order, $site_id, $web_rtc_user_id, $phone_base_settings_id, $lines_logged_in_user_id, $lines_default_for_user_id, $phone_hardware_id, $lines_id, $lines_name, $expand, $fields)

Get a list of Phone Instances



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size
$sort_by = "name"; // string | Value by which to sort
$sort_order = "ASC"; // string | Sort order
$site_id = "site_id_example"; // string | Filter by site.id
$web_rtc_user_id = "web_rtc_user_id_example"; // string | Filter by webRtcUser.id
$phone_base_settings_id = "phone_base_settings_id_example"; // string | Filter by phoneBaseSettings.id
$lines_logged_in_user_id = "lines_logged_in_user_id_example"; // string | Filter by lines.loggedInUser.id
$lines_default_for_user_id = "lines_default_for_user_id_example"; // string | Filter by lines.defaultForUser.id
$phone_hardware_id = "phone_hardware_id_example"; // string | Filter by phone_hardwareId
$lines_id = "lines_id_example"; // string | Filter by lines.id
$lines_name = "lines_name_example"; // string | Filter by lines.name
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated
$fields = array("fields_example"); // string[] | Fields and properties to get, comma-separated

try {
    $result = $api_instance->getProvidersEdgesPhones($page_number, $page_size, $sort_by, $sort_order, $site_id, $web_rtc_user_id, $phone_base_settings_id, $lines_logged_in_user_id, $lines_default_for_user_id, $phone_hardware_id, $lines_id, $lines_name, $expand, $fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **sort_by** | **string**| Value by which to sort | [optional] [default to name]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **site_id** | **string**| Filter by site.id | [optional]
 **web_rtc_user_id** | **string**| Filter by webRtcUser.id | [optional]
 **phone_base_settings_id** | **string**| Filter by phoneBaseSettings.id | [optional]
 **lines_logged_in_user_id** | **string**| Filter by lines.loggedInUser.id | [optional]
 **lines_default_for_user_id** | **string**| Filter by lines.defaultForUser.id | [optional]
 **phone_hardware_id** | **string**| Filter by phone_hardwareId | [optional]
 **lines_id** | **string**| Filter by lines.id | [optional]
 **lines_name** | **string**| Filter by lines.name | [optional]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]
 **fields** | [**string[]**](../Model/string.md)| Fields and properties to get, comma-separated | [optional]

### Return type

[**\PureCloudSDK\PhoneEntityListing**](../Model/PhoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonesPhoneId**
> \PureCloudSDK\Phone getProvidersEdgesPhonesPhoneId($phone_id)

Get a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_id = "phone_id_example"; // string | Phone ID

try {
    $result = $api_instance->getProvidersEdgesPhonesPhoneId($phone_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_id** | **string**| Phone ID |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonesTemplate**
> \PureCloudSDK\Phone getProvidersEdgesPhonesTemplate($phone_base_settings_id)

Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_base_settings_id = "phone_base_settings_id_example"; // string | The id of a Phone Base Settings object upon which to base this Phone

try {
    $result = $api_instance->getProvidersEdgesPhonesTemplate($phone_base_settings_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonesTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_base_settings_id** | **string**| The id of a Phone Base Settings object upon which to base this Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSites**
> \PureCloudSDK\SiteEntityListing getProvidersEdgesSites($page_size, $page_number, $sort_by, $sort_order, $name, $location_id)

Get the list of Sites.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_by = "name"; // string | Sort by
$sort_order = "ASC"; // string | Sort order
$name = "name_example"; // string | Name
$location_id = "location_id_example"; // string | Location Id

try {
    $result = $api_instance->getProvidersEdgesSites($page_size, $page_number, $sort_by, $sort_order, $name, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_by** | **string**| Sort by | [optional] [default to name]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **name** | **string**| Name | [optional]
 **location_id** | **string**| Location Id | [optional]

### Return type

[**\PureCloudSDK\SiteEntityListing**](../Model/SiteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteId**
> \PureCloudSDK\Site getProvidersEdgesSitesSiteId($site_id)

Get a Site by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID

try {
    $result = $api_instance->getProvidersEdgesSitesSiteId($site_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteIdNumberplans**
> \PureCloudSDK\NumberPlan[] getProvidersEdgesSitesSiteIdNumberplans($site_id)

Get the list of Number Plans for this Site.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID

try {
    $result = $api_instance->getProvidersEdgesSitesSiteIdNumberplans($site_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteIdNumberplans: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |

### Return type

[**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteIdNumberplansClassifications**
> string[] getProvidersEdgesSitesSiteIdNumberplansClassifications($site_id, $classification)

Get a list of Classifications for this Site



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID
$classification = "classification_example"; // string | Classification

try {
    $result = $api_instance->getProvidersEdgesSitesSiteIdNumberplansClassifications($site_id, $classification);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteIdNumberplansClassifications: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |
 **classification** | **string**| Classification | [optional]

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteIdNumberplansNumberplanId**
> \PureCloudSDK\NumberPlan getProvidersEdgesSitesSiteIdNumberplansNumberplanId($site_id, $number_plan_id)

Get a Number Plan by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID
$number_plan_id = "number_plan_id_example"; // string | Number Plan ID

try {
    $result = $api_instance->getProvidersEdgesSitesSiteIdNumberplansNumberplanId($site_id, $number_plan_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteIdNumberplansNumberplanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |
 **number_plan_id** | **string**| Number Plan ID |

### Return type

[**\PureCloudSDK\NumberPlan**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTimezones**
> \PureCloudSDK\TimeZoneEntityListing getProvidersEdgesTimezones($page_size, $page_number)

Get a list of Edge-compatible time zones



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 1000; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getProvidersEdgesTimezones($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTimezones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 1000]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TimeZoneEntityListing**](../Model/TimeZoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettings**
> \PureCloudSDK\TrunkBaseEntityListing getProvidersEdgesTrunkbasesettings($page_number, $page_size, $sort_by, $sort_order, $recording_enabled)

Get Trunk Base Settings listing



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size
$sort_by = "name"; // string | Value by which to sort
$sort_order = "ASC"; // string | Sort order
$recording_enabled = true; // bool | Filter trunks by recording enabled

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettings($page_number, $page_size, $sort_by, $sort_order, $recording_enabled);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **sort_by** | **string**| Value by which to sort | [optional] [default to name]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **recording_enabled** | **bool**| Filter trunks by recording enabled | [optional]

### Return type

[**\PureCloudSDK\TrunkBaseEntityListing**](../Model/TrunkBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettingsAvailablemetabases**
> \PureCloudSDK\TrunkMetabaseEntityListing getProvidersEdgesTrunkbasesettingsAvailablemetabases($type, $page_size, $page_number)

Get a list of available makes and models to create a new Trunk Base Settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$type = "type_example"; // string | 
$page_size = 25; // int | 
$page_number = 1; // int | 

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettingsAvailablemetabases($type, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettingsAvailablemetabases: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**|  | [optional]
 **page_size** | **int**|  | [optional] [default to 25]
 **page_number** | **int**|  | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TrunkMetabaseEntityListing**](../Model/TrunkMetabaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettingsTemplate**
> \PureCloudSDK\TrunkBase getProvidersEdgesTrunkbasesettingsTemplate($trunk_metabase_id)

Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunk_metabase_id = "trunk_metabase_id_example"; // string | The id of a metabase object upon which to base this Trunk Base Settings

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettingsTemplate($trunk_metabase_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettingsTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunk_metabase_id** | **string**| The id of a metabase object upon which to base this Trunk Base Settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> \PureCloudSDK\TrunkBase getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunk_base_settings_id)

Get a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunk_base_settings_id = "trunk_base_settings_id_example"; // string | Trunk Base ID

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunk_base_settings_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunk_base_settings_id** | **string**| Trunk Base ID |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunks**
> \PureCloudSDK\TrunkEntityListing getProvidersEdgesTrunks($page_number, $page_size, $sort_by, $sort_order, $edge_id, $trunk_base_id, $trunk_type)

Get the list of available trunks.

Trunks are created by assigning trunk base settings to an Edge or Edge Group.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_number = 1; // int | Page number
$page_size = 25; // int | Page size
$sort_by = "name"; // string | Value by which to sort
$sort_order = "ASC"; // string | Sort order
$edge_id = "edge_id_example"; // string | Filter by Edge Ids
$trunk_base_id = "trunk_base_id_example"; // string | Filter by Trunk Base Ids
$trunk_type = "trunk_type_example"; // string | Filter by a Trunk type

try {
    $result = $api_instance->getProvidersEdgesTrunks($page_number, $page_size, $sort_by, $sort_order, $edge_id, $trunk_base_id, $trunk_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Page number | [optional] [default to 1]
 **page_size** | **int**| Page size | [optional] [default to 25]
 **sort_by** | **string**| Value by which to sort | [optional] [default to name]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **edge_id** | **string**| Filter by Edge Ids | [optional]
 **trunk_base_id** | **string**| Filter by Trunk Base Ids | [optional]
 **trunk_type** | **string**| Filter by a Trunk type | [optional]

### Return type

[**\PureCloudSDK\TrunkEntityListing**](../Model/TrunkEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunksTrunkId**
> \PureCloudSDK\Trunk getProvidersEdgesTrunksTrunkId($trunk_id)

Get a Trunk by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunk_id = "trunk_id_example"; // string | Trunk ID

try {
    $result = $api_instance->getProvidersEdgesTrunksTrunkId($trunk_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunksTrunkId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunk_id** | **string**| Trunk ID |

### Return type

[**\PureCloudSDK\Trunk**](../Model/Trunk.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkswithrecording**
> \PureCloudSDK\TrunkRecordingEnabledCount getProvidersEdgesTrunkswithrecording($trunk_type)

Get Counts of trunks that have recording disabled or enabled



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunk_type = "trunk_type_example"; // string | The type of this trunk base.

try {
    $result = $api_instance->getProvidersEdgesTrunkswithrecording($trunk_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkswithrecording: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunk_type** | **string**| The type of this trunk base. | [optional]

### Return type

[**\PureCloudSDK\TrunkRecordingEnabledCount**](../Model/TrunkRecordingEnabledCount.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnext**
> \PureCloudSDK\SchemaCategoryEntityListing getSchemasEdgesVnext($page_size, $page_number)

Lists available schema categories



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getSchemasEdgesVnext($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnext: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaCategoryEntityListing**](../Model/SchemaCategoryEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategory**
> \PureCloudSDK\SchemaReferenceEntityListing getSchemasEdgesVnextSchemacategory($schema_category, $page_size, $page_number)

List schemas of a specific category



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schema_category = "schema_category_example"; // string | Schema category
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategory($schema_category, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schema_category** | **string**| Schema category |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaReferenceEntityListing**](../Model/SchemaReferenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategorySchematype**
> \PureCloudSDK\SchemaReferenceEntityListing getSchemasEdgesVnextSchemacategorySchematype($schema_category, $schema_type, $page_size, $page_number)

List schemas of a specific category



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schema_category = "schema_category_example"; // string | Schema category
$schema_type = "schema_type_example"; // string | Schema type
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategorySchematype($schema_category, $schema_type, $page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategorySchematype: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schema_category** | **string**| Schema category |
 **schema_type** | **string**| Schema type |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaReferenceEntityListing**](../Model/SchemaReferenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategorySchematypeSchemaId**
> \PureCloudSDK\Organization getSchemasEdgesVnextSchemacategorySchematypeSchemaId($schema_category, $schema_type, $schema_id)

Get a json schema



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schema_category = "schema_category_example"; // string | Schema category
$schema_type = "schema_type_example"; // string | Schema type
$schema_id = "schema_id_example"; // string | Schema ID

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategorySchematypeSchemaId($schema_category, $schema_type, $schema_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategorySchematypeSchemaId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schema_category** | **string**| Schema category |
 **schema_type** | **string**| Schema type |
 **schema_id** | **string**| Schema ID |

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**
> \PureCloudSDK\Organization getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId($schema_category, $schema_type, $schema_id, $extension_type, $metadata_id, $type)

Get metadata for a schema



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schema_category = "schema_category_example"; // string | Schema category
$schema_type = "schema_type_example"; // string | Schema type
$schema_id = "schema_id_example"; // string | Schema ID
$extension_type = "extension_type_example"; // string | extension
$metadata_id = "metadata_id_example"; // string | Metadata ID
$type = "type_example"; // string | Type

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId($schema_category, $schema_type, $schema_id, $extension_type, $metadata_id, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schema_category** | **string**| Schema category |
 **schema_type** | **string**| Schema type |
 **schema_id** | **string**| Schema ID |
 **extension_type** | **string**| extension |
 **metadata_id** | **string**| Metadata ID |
 **type** | **string**| Type | [optional]

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdges**
> \PureCloudSDK\Edge postProvidersEdges($body)

Create an edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Edge(); // \PureCloudSDK\Edge | Edge

try {
    $result = $api_instance->postProvidersEdges($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdges: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Edge**](../Model/\PureCloudSDK\Edge.md)| Edge |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesAddressvalidation**
> \PureCloudSDK\ValidateAddressResponse postProvidersEdgesAddressvalidation($body)

Validates a street address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\ValidateAddressRequest(); // \PureCloudSDK\ValidateAddressRequest | Address

try {
    $result = $api_instance->postProvidersEdgesAddressvalidation($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesAddressvalidation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ValidateAddressRequest**](../Model/\PureCloudSDK\ValidateAddressRequest.md)| Address |

### Return type

[**\PureCloudSDK\ValidateAddressResponse**](../Model/ValidateAddressResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesCertificateauthorities**
> \PureCloudSDK\DomainCertificateAuthority postProvidersEdgesCertificateauthorities($body)

Create a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\DomainCertificateAuthority(); // \PureCloudSDK\DomainCertificateAuthority | CertificateAuthority

try {
    $result = $api_instance->postProvidersEdgesCertificateauthorities($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesCertificateauthorities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainCertificateAuthority**](../Model/\PureCloudSDK\DomainCertificateAuthority.md)| CertificateAuthority |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesDidpools**
> \PureCloudSDK\DIDPool postProvidersEdgesDidpools($body)

Create a new DID pool



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\DIDPool(); // \PureCloudSDK\DIDPool | DID pool

try {
    $result = $api_instance->postProvidersEdgesDidpools($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesDidpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DIDPool**](../Model/\PureCloudSDK\DIDPool.md)| DID pool |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdLogicalinterfaces**
> \PureCloudSDK\DomainLogicalInterface postProvidersEdgesEdgeIdLogicalinterfaces($edge_id, $body)

Create an edge logical interface.

Create

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$body = new \PureCloudSDK\DomainLogicalInterface(); // \PureCloudSDK\DomainLogicalInterface | Logical interface

try {
    $result = $api_instance->postProvidersEdgesEdgeIdLogicalinterfaces($edge_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\DomainLogicalInterface**](../Model/\PureCloudSDK\DomainLogicalInterface.md)| Logical interface |

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdLogsJobs**
> \PureCloudSDK\EdgeLogsJobResponse postProvidersEdgesEdgeIdLogsJobs($edge_id, $body)

Create a job to upload a list of Edge logs.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$body = new \PureCloudSDK\EdgeLogsJobRequest(); // \PureCloudSDK\EdgeLogsJobRequest | EdgeLogsJobRequest

try {
    $result = $api_instance->postProvidersEdgesEdgeIdLogsJobs($edge_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdLogsJobs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\EdgeLogsJobRequest**](../Model/\PureCloudSDK\EdgeLogsJobRequest.md)| EdgeLogsJobRequest |

### Return type

[**\PureCloudSDK\EdgeLogsJobResponse**](../Model/EdgeLogsJobResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdLogsJobsJobIdUpload**
> postProvidersEdgesEdgeIdLogsJobsJobIdUpload($edge_id, $job_id, $body)

Request that the specified fileIds be uploaded from the Edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$job_id = "job_id_example"; // string | Job ID
$body = new \PureCloudSDK\EdgeLogsJobUploadRequest(); // \PureCloudSDK\EdgeLogsJobUploadRequest | Log upload request

try {
    $api_instance->postProvidersEdgesEdgeIdLogsJobsJobIdUpload($edge_id, $job_id, $body);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdLogsJobsJobIdUpload: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **job_id** | **string**| Job ID |
 **body** | [**\PureCloudSDK\EdgeLogsJobUploadRequest**](../Model/\PureCloudSDK\EdgeLogsJobUploadRequest.md)| Log upload request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdReboot**
> string postProvidersEdgesEdgeIdReboot($edge_id)

Reboot an Edge



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID

try {
    $result = $api_instance->postProvidersEdgesEdgeIdReboot($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdSoftwareupdate**
> \PureCloudSDK\DomainEdgeSoftwareUpdateDto postProvidersEdgesEdgeIdSoftwareupdate($edge_id, $body)

Starts a software update for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$body = new \PureCloudSDK\DomainEdgeSoftwareUpdateDto(); // \PureCloudSDK\DomainEdgeSoftwareUpdateDto | Software update request

try {
    $result = $api_instance->postProvidersEdgesEdgeIdSoftwareupdate($edge_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/\PureCloudSDK\DomainEdgeSoftwareUpdateDto.md)| Software update request |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/DomainEdgeSoftwareUpdateDto.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdUnpair**
> string postProvidersEdgesEdgeIdUnpair($edge_id)

Unpair an Edge



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge Id

try {
    $result = $api_instance->postProvidersEdgesEdgeIdUnpair($edge_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdUnpair: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge Id |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgegroups**
> \PureCloudSDK\EdgeGroup postProvidersEdgesEdgegroups($body)

Create an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\EdgeGroup(); // \PureCloudSDK\EdgeGroup | EdgeGroup

try {
    $result = $api_instance->postProvidersEdgesEdgegroups($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgegroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EdgeGroup**](../Model/\PureCloudSDK\EdgeGroup.md)| EdgeGroup |

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEndpoints**
> \PureCloudSDK\Endpoint postProvidersEdgesEndpoints($body)

Create endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Endpoint(); // \PureCloudSDK\Endpoint | EndpointTemplate

try {
    $result = $api_instance->postProvidersEdgesEndpoints($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEndpoints: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Endpoint**](../Model/\PureCloudSDK\Endpoint.md)| EndpointTemplate |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesExtensionpools**
> \PureCloudSDK\ExtensionPool postProvidersEdgesExtensionpools($body)

Create a new extension pool



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\ExtensionPool(); // \PureCloudSDK\ExtensionPool | ExtensionPool

try {
    $result = $api_instance->postProvidersEdgesExtensionpools($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesExtensionpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ExtensionPool**](../Model/\PureCloudSDK\ExtensionPool.md)| ExtensionPool |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesOfflineconfiguration**
> \PureCloudSDK\EdgeOfflineConfigurationResponse postProvidersEdgesOfflineconfiguration($body)

Create a file that can be used to configure a hardware Edge's settings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\EdgeOfflineConfiguration(); // \PureCloudSDK\EdgeOfflineConfiguration | EdgeOfflineConfiguration

try {
    $result = $api_instance->postProvidersEdgesOfflineconfiguration($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesOfflineconfiguration: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EdgeOfflineConfiguration**](../Model/\PureCloudSDK\EdgeOfflineConfiguration.md)| EdgeOfflineConfiguration |

### Return type

[**\PureCloudSDK\EdgeOfflineConfigurationResponse**](../Model/EdgeOfflineConfigurationResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesOutboundroutes**
> \PureCloudSDK\OutboundRoute postProvidersEdgesOutboundroutes($body)

Create outbound rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\OutboundRoute(); // \PureCloudSDK\OutboundRoute | OutboundRoute

try {
    $result = $api_instance->postProvidersEdgesOutboundroutes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OutboundRoute**](../Model/\PureCloudSDK\OutboundRoute.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhonebasesettings**
> \PureCloudSDK\PhoneBase postProvidersEdgesPhonebasesettings($body)

Create a new Phone Base Settings object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\PhoneBase(); // \PureCloudSDK\PhoneBase | Phone base settings

try {
    $result = $api_instance->postProvidersEdgesPhonebasesettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhonebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PhoneBase**](../Model/\PureCloudSDK\PhoneBase.md)| Phone base settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhones**
> \PureCloudSDK\Phone postProvidersEdgesPhones($body)

Create a new Phone



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Phone(); // \PureCloudSDK\Phone | Phone

try {
    $result = $api_instance->postProvidersEdgesPhones($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Phone**](../Model/\PureCloudSDK\Phone.md)| Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhonesPhoneIdReboot**
> postProvidersEdgesPhonesPhoneIdReboot($phone_id)

Reboot a Phone



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_id = "phone_id_example"; // string | Phone Id

try {
    $api_instance->postProvidersEdgesPhonesPhoneIdReboot($phone_id);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhonesPhoneIdReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_id** | **string**| Phone Id |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhonesReboot**
> postProvidersEdgesPhonesReboot($body)

Reboot Multiple Phones



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\PhonesReboot(); // \PureCloudSDK\PhonesReboot | Phones

try {
    $api_instance->postProvidersEdgesPhonesReboot($body);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhonesReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PhonesReboot**](../Model/\PureCloudSDK\PhonesReboot.md)| Phones |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesSites**
> \PureCloudSDK\Site postProvidersEdgesSites($body)

Create a Site.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Site(); // \PureCloudSDK\Site | Site

try {
    $result = $api_instance->postProvidersEdgesSites($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesSites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Site**](../Model/\PureCloudSDK\Site.md)| Site |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesSitesSiteIdRebalance**
> postProvidersEdgesSitesSiteIdRebalance($site_id)

Triggers the rebalance operation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID

try {
    $api_instance->postProvidersEdgesSitesSiteIdRebalance($site_id);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesSitesSiteIdRebalance: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesTrunkbasesettings**
> \PureCloudSDK\TrunkBase postProvidersEdgesTrunkbasesettings($body)

Create a Trunk Base Settings object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\TrunkBase(); // \PureCloudSDK\TrunkBase | Trunk base settings

try {
    $result = $api_instance->postProvidersEdgesTrunkbasesettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesTrunkbasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\TrunkBase**](../Model/\PureCloudSDK\TrunkBase.md)| Trunk base settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesCertificateauthoritiesCertificateId**
> \PureCloudSDK\DomainCertificateAuthority putProvidersEdgesCertificateauthoritiesCertificateId($certificate_id, $body)

Update a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificate_id = "certificate_id_example"; // string | Certificate ID
$body = new \PureCloudSDK\DomainCertificateAuthority(); // \PureCloudSDK\DomainCertificateAuthority | Certificate authority

try {
    $result = $api_instance->putProvidersEdgesCertificateauthoritiesCertificateId($certificate_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificate_id** | **string**| Certificate ID |
 **body** | [**\PureCloudSDK\DomainCertificateAuthority**](../Model/\PureCloudSDK\DomainCertificateAuthority.md)| Certificate authority |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesDidpoolsDidpoolId**
> \PureCloudSDK\DIDPool putProvidersEdgesDidpoolsDidpoolId($did_pool_id, $body)

Update a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$did_pool_id = "did_pool_id_example"; // string | DID pool ID
$body = new \PureCloudSDK\DIDPool(); // \PureCloudSDK\DIDPool | DID pool

try {
    $result = $api_instance->putProvidersEdgesDidpoolsDidpoolId($did_pool_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **did_pool_id** | **string**| DID pool ID |
 **body** | [**\PureCloudSDK\DIDPool**](../Model/\PureCloudSDK\DIDPool.md)| DID pool |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesDidsDidId**
> \PureCloudSDK\DID putProvidersEdgesDidsDidId($did_id, $body)

Update a DID by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$did_id = "did_id_example"; // string | DID ID
$body = new \PureCloudSDK\DID(); // \PureCloudSDK\DID | DID

try {
    $result = $api_instance->putProvidersEdgesDidsDidId($did_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesDidsDidId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **did_id** | **string**| DID ID |
 **body** | [**\PureCloudSDK\DID**](../Model/\PureCloudSDK\DID.md)| DID |

### Return type

[**\PureCloudSDK\DID**](../Model/DID.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgeId**
> \PureCloudSDK\Edge putProvidersEdgesEdgeId($edge_id, $body)

Update a edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$body = new \PureCloudSDK\Edge(); // \PureCloudSDK\Edge | Edge

try {
    $result = $api_instance->putProvidersEdgesEdgeId($edge_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\Edge**](../Model/\PureCloudSDK\Edge.md)| Edge |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgeIdLinesLineId**
> \PureCloudSDK\EdgeLine putProvidersEdgesEdgeIdLinesLineId($edge_id, $line_id, $body)

Update a line.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$line_id = "line_id_example"; // string | Line ID
$body = new \PureCloudSDK\EdgeLine(); // \PureCloudSDK\EdgeLine | Line

try {
    $result = $api_instance->putProvidersEdgesEdgeIdLinesLineId($edge_id, $line_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgeIdLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **line_id** | **string**| Line ID |
 **body** | [**\PureCloudSDK\EdgeLine**](../Model/\PureCloudSDK\EdgeLine.md)| Line |

### Return type

[**\PureCloudSDK\EdgeLine**](../Model/EdgeLine.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> \PureCloudSDK\DomainLogicalInterface putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edge_id, $interface_id, $body)

Update an edge logical interface.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_id = "edge_id_example"; // string | Edge ID
$interface_id = "interface_id_example"; // string | Interface ID
$body = new \PureCloudSDK\DomainLogicalInterface(); // \PureCloudSDK\DomainLogicalInterface | Logical interface

try {
    $result = $api_instance->putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edge_id, $interface_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_id** | **string**| Edge ID |
 **interface_id** | **string**| Interface ID |
 **body** | [**\PureCloudSDK\DomainLogicalInterface**](../Model/\PureCloudSDK\DomainLogicalInterface.md)| Logical interface |

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgegroupsEdgegroupId**
> \PureCloudSDK\EdgeGroup putProvidersEdgesEdgegroupsEdgegroupId($edge_group_id, $body)

Update an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edge_group_id = "edge_group_id_example"; // string | Edge group ID
$body = new \PureCloudSDK\EdgeGroup(); // \PureCloudSDK\EdgeGroup | EdgeGroup

try {
    $result = $api_instance->putProvidersEdgesEdgegroupsEdgegroupId($edge_group_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edge_group_id** | **string**| Edge group ID |
 **body** | [**\PureCloudSDK\EdgeGroup**](../Model/\PureCloudSDK\EdgeGroup.md)| EdgeGroup |

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEndpointsEndpointId**
> \PureCloudSDK\Endpoint putProvidersEdgesEndpointsEndpointId($endpoint_id, $body)

Update endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpoint_id = "endpoint_id_example"; // string | Endpoint ID
$body = new \PureCloudSDK\Endpoint(); // \PureCloudSDK\Endpoint | EndpointTemplate

try {
    $result = $api_instance->putProvidersEdgesEndpointsEndpointId($endpoint_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpoint_id** | **string**| Endpoint ID |
 **body** | [**\PureCloudSDK\Endpoint**](../Model/\PureCloudSDK\Endpoint.md)| EndpointTemplate |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesExtensionpoolsExtensionpoolId**
> \PureCloudSDK\ExtensionPool putProvidersEdgesExtensionpoolsExtensionpoolId($extension_pool_id, $body)

Update an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extension_pool_id = "extension_pool_id_example"; // string | Extension pool ID
$body = new \PureCloudSDK\ExtensionPool(); // \PureCloudSDK\ExtensionPool | ExtensionPool

try {
    $result = $api_instance->putProvidersEdgesExtensionpoolsExtensionpoolId($extension_pool_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extension_pool_id** | **string**| Extension pool ID |
 **body** | [**\PureCloudSDK\ExtensionPool**](../Model/\PureCloudSDK\ExtensionPool.md)| ExtensionPool |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesExtensionsExtensionId**
> \PureCloudSDK\Extension putProvidersEdgesExtensionsExtensionId($extension_id, $body)

Update an extension by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extension_id = "extension_id_example"; // string | Extension ID
$body = new \PureCloudSDK\Extension(); // \PureCloudSDK\Extension | Extension

try {
    $result = $api_instance->putProvidersEdgesExtensionsExtensionId($extension_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesExtensionsExtensionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extension_id** | **string**| Extension ID |
 **body** | [**\PureCloudSDK\Extension**](../Model/\PureCloudSDK\Extension.md)| Extension |

### Return type

[**\PureCloudSDK\Extension**](../Model/Extension.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRoute putProvidersEdgesOutboundroutesOutboundrouteId($outbound_route_id, $body)

Update outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outbound_route_id = "outbound_route_id_example"; // string | Outbound route ID
$body = new \PureCloudSDK\OutboundRoute(); // \PureCloudSDK\OutboundRoute | OutboundRoute

try {
    $result = $api_instance->putProvidersEdgesOutboundroutesOutboundrouteId($outbound_route_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outbound_route_id** | **string**| Outbound route ID |
 **body** | [**\PureCloudSDK\OutboundRoute**](../Model/\PureCloudSDK\OutboundRoute.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesPhonebasesettingsPhonebaseId**
> \PureCloudSDK\PhoneBase putProvidersEdgesPhonebasesettingsPhonebaseId($phone_base_id, $body)

Update a Phone Base Settings by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_base_id = "phone_base_id_example"; // string | Phone base ID
$body = new \PureCloudSDK\PhoneBase(); // \PureCloudSDK\PhoneBase | Phone base settings

try {
    $result = $api_instance->putProvidersEdgesPhonebasesettingsPhonebaseId($phone_base_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_base_id** | **string**| Phone base ID |
 **body** | [**\PureCloudSDK\PhoneBase**](../Model/\PureCloudSDK\PhoneBase.md)| Phone base settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesPhonesPhoneId**
> \PureCloudSDK\Phone putProvidersEdgesPhonesPhoneId($phone_id, $body)

Update a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phone_id = "phone_id_example"; // string | Phone ID
$body = new \PureCloudSDK\Phone(); // \PureCloudSDK\Phone | Phone

try {
    $result = $api_instance->putProvidersEdgesPhonesPhoneId($phone_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phone_id** | **string**| Phone ID |
 **body** | [**\PureCloudSDK\Phone**](../Model/\PureCloudSDK\Phone.md)| Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesSitesSiteId**
> \PureCloudSDK\Site putProvidersEdgesSitesSiteId($site_id, $body)

Update a Site by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID
$body = new \PureCloudSDK\Site(); // \PureCloudSDK\Site | Site

try {
    $result = $api_instance->putProvidersEdgesSitesSiteId($site_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |
 **body** | [**\PureCloudSDK\Site**](../Model/\PureCloudSDK\Site.md)| Site |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesSitesSiteIdNumberplans**
> \PureCloudSDK\NumberPlan[] putProvidersEdgesSitesSiteIdNumberplans($site_id, $body)

Update the list of Number Plans.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$site_id = "site_id_example"; // string | Site ID
$body = array(new NumberPlan()); // \PureCloudSDK\NumberPlan[] | List of number plans

try {
    $result = $api_instance->putProvidersEdgesSitesSiteIdNumberplans($site_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesSitesSiteIdNumberplans: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **string**| Site ID |
 **body** | [**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)| List of number plans |

### Return type

[**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> \PureCloudSDK\TrunkBase putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunk_base_settings_id, $body)

Update a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunk_base_settings_id = "trunk_base_settings_id_example"; // string | Trunk Base ID
$body = new \PureCloudSDK\TrunkBase(); // \PureCloudSDK\TrunkBase | Trunk base settings

try {
    $result = $api_instance->putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunk_base_settings_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunk_base_settings_id** | **string**| Trunk Base ID |
 **body** | [**\PureCloudSDK\TrunkBase**](../Model/\PureCloudSDK\TrunkBase.md)| Trunk base settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

