# PureCloudSDK\UserRecordingsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteRecordingId**](UserRecordingsApi.md#deleteRecordingId) | **DELETE** /api/v2/userrecordings/{recordingId} | Delete a user recording.
[**getRecordingId**](UserRecordingsApi.md#getRecordingId) | **GET** /api/v2/userrecordings/{recordingId} | Get a user recording.
[**getRecordingIdMedia**](UserRecordingsApi.md#getRecordingIdMedia) | **GET** /api/v2/userrecordings/{recordingId}/media | Download a user recording.
[**getSummary**](UserRecordingsApi.md#getSummary) | **GET** /api/v2/userrecordings/summary | Get user recording summary
[**getUserrecordings**](UserRecordingsApi.md#getUserrecordings) | **GET** /api/v2/userrecordings | Get a list of user recordings.
[**putRecordingId**](UserRecordingsApi.md#putRecordingId) | **PUT** /api/v2/userrecordings/{recordingId} | Update a user recording.


# **deleteRecordingId**
> deleteRecordingId($recording_id)

Delete a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recording_id = "recording_id_example"; // string | User Recording ID

try {
    $api_instance->deleteRecordingId($recording_id);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->deleteRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recording_id** | **string**| User Recording ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingId**
> \PureCloudSDK\UserRecording getRecordingId($recording_id, $expand)

Get a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recording_id = "recording_id_example"; // string | User Recording ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getRecordingId($recording_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recording_id** | **string**| User Recording ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserRecording**](../Model/UserRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingIdMedia**
> \PureCloudSDK\DownloadResponse getRecordingIdMedia($recording_id, $format_id)

Download a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recording_id = "recording_id_example"; // string | User Recording ID
$format_id = "WEBM"; // string | The desired media format.

try {
    $result = $api_instance->getRecordingIdMedia($recording_id, $format_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getRecordingIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recording_id** | **string**| User Recording ID |
 **format_id** | **string**| The desired media format. | [optional] [default to WEBM]

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSummary**
> \PureCloudSDK\FaxSummary getSummary()

Get user recording summary



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();

try {
    $result = $api_instance->getSummary();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getSummary: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\FaxSummary**](../Model/FaxSummary.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserrecordings**
> \PureCloudSDK\UserRecordingEntityListing getUserrecordings($page_size, $page_number, $expand)

Get a list of user recordings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getUserrecordings($page_size, $page_number, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getUserrecordings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserRecordingEntityListing**](../Model/UserRecordingEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingId**
> \PureCloudSDK\UserRecording putRecordingId($recording_id, $body, $expand)

Update a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recording_id = "recording_id_example"; // string | User Recording ID
$body = new \PureCloudSDK\UserRecording(); // \PureCloudSDK\UserRecording | UserRecording
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->putRecordingId($recording_id, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->putRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recording_id** | **string**| User Recording ID |
 **body** | [**\PureCloudSDK\UserRecording**](../Model/\PureCloudSDK\UserRecording.md)| UserRecording |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserRecording**](../Model/UserRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

