# PureCloudSDK\UsersApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteUserId**](UsersApi.md#deleteUserId) | **DELETE** /api/v2/users/{userId} | Delete user
[**deleteUserIdRoles**](UsersApi.md#deleteUserIdRoles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
[**deleteUserIdRoutingskillsSkillId**](UsersApi.md#deleteUserIdRoutingskillsSkillId) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
[**deleteUserIdStationAssociatedstation**](UsersApi.md#deleteUserIdStationAssociatedstation) | **DELETE** /api/v2/users/{userId}/station/associatedstation | Clear associated station
[**deleteUserIdStationDefaultstation**](UsersApi.md#deleteUserIdStationDefaultstation) | **DELETE** /api/v2/users/{userId}/station/defaultstation | Clear default station
[**getFieldconfig**](UsersApi.md#getFieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
[**getMe**](UsersApi.md#getMe) | **GET** /api/v2/users/me | Get current user details.
[**getSearch**](UsersApi.md#getSearch) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
[**getUserId**](UsersApi.md#getUserId) | **GET** /api/v2/users/{userId} | Get user.
[**getUserIdAdjacents**](UsersApi.md#getUserIdAdjacents) | **GET** /api/v2/users/{userId}/adjacents | Get adjacents
[**getUserIdCallforwarding**](UsersApi.md#getUserIdCallforwarding) | **GET** /api/v2/users/{userId}/callforwarding | Get a user&#39;s CallForwarding
[**getUserIdDirectreports**](UsersApi.md#getUserIdDirectreports) | **GET** /api/v2/users/{userId}/directreports | Get direct reports
[**getUserIdFavorites**](UsersApi.md#getUserIdFavorites) | **GET** /api/v2/users/{userId}/favorites | Get favorites
[**getUserIdGeolocationsClientId**](UsersApi.md#getUserIdGeolocationsClientId) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
[**getUserIdOutofoffice**](UsersApi.md#getUserIdOutofoffice) | **GET** /api/v2/users/{userId}/outofoffice | Get a OutOfOffice
[**getUserIdProfileskills**](UsersApi.md#getUserIdProfileskills) | **GET** /api/v2/users/{userId}/profileskills | List profile skills for a user
[**getUserIdQueues**](UsersApi.md#getUserIdQueues) | **GET** /api/v2/users/{userId}/queues | Get queues for user
[**getUserIdRoles**](UsersApi.md#getUserIdRoles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
[**getUserIdRoutingskills**](UsersApi.md#getUserIdRoutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
[**getUserIdRoutingstatus**](UsersApi.md#getUserIdRoutingstatus) | **GET** /api/v2/users/{userId}/routingstatus | Fetch the routing status of a user
[**getUserIdStation**](UsersApi.md#getUserIdStation) | **GET** /api/v2/users/{userId}/station | Get station information for user
[**getUserIdSuperiors**](UsersApi.md#getUserIdSuperiors) | **GET** /api/v2/users/{userId}/superiors | Get superiors
[**getUsers**](UsersApi.md#getUsers) | **GET** /api/v2/users | Get the list of available users.
[**patchUserId**](UsersApi.md#patchUserId) | **PATCH** /api/v2/users/{userId} | Update user
[**patchUserIdCallforwarding**](UsersApi.md#patchUserIdCallforwarding) | **PATCH** /api/v2/users/{userId}/callforwarding | Patch a user&#39;s CallForwarding
[**patchUserIdGeolocationsClientId**](UsersApi.md#patchUserIdGeolocationsClientId) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation
[**patchUserIdQueues**](UsersApi.md#patchUserIdQueues) | **PATCH** /api/v2/users/{userId}/queues | Join or unjoin a set of queues for a user
[**patchUserIdQueuesQueueId**](UsersApi.md#patchUserIdQueuesQueueId) | **PATCH** /api/v2/users/{userId}/queues/{queueId} | Join or unjoin a queue for a user
[**postSearch**](UsersApi.md#postSearch) | **POST** /api/v2/users/search | Search users
[**postUserIdRoutingskills**](UsersApi.md#postUserIdRoutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
[**postUsers**](UsersApi.md#postUsers) | **POST** /api/v2/users | Create user
[**postUsersAggregatesQuery**](UsersApi.md#postUsersAggregatesQuery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
[**postUsersObservationsQuery**](UsersApi.md#postUsersObservationsQuery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
[**putUserIdCallforwarding**](UsersApi.md#putUserIdCallforwarding) | **PUT** /api/v2/users/{userId}/callforwarding | Update a user&#39;s CallForwarding
[**putUserIdOutofoffice**](UsersApi.md#putUserIdOutofoffice) | **PUT** /api/v2/users/{userId}/outofoffice | Update an OutOfOffice
[**putUserIdProfileskills**](UsersApi.md#putUserIdProfileskills) | **PUT** /api/v2/users/{userId}/profileskills | Update profile skills for a user
[**putUserIdRoles**](UsersApi.md#putUserIdRoles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles
[**putUserIdRoutingskillsSkillId**](UsersApi.md#putUserIdRoutingskillsSkillId) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
[**putUserIdRoutingstatus**](UsersApi.md#putUserIdRoutingstatus) | **PUT** /api/v2/users/{userId}/routingstatus | Update the routing status of a user
[**putUserIdStationAssociatedstationStationId**](UsersApi.md#putUserIdStationAssociatedstationStationId) | **PUT** /api/v2/users/{userId}/station/associatedstation/{stationId} | Set associated station
[**putUserIdStationDefaultstationStationId**](UsersApi.md#putUserIdStationDefaultstationStationId) | **PUT** /api/v2/users/{userId}/station/defaultstation/{stationId} | Set default station


# **deleteUserId**
> string deleteUserId($user_id)

Delete user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->deleteUserId($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserIdRoles**
> deleteUserIdRoles($user_id)

Removes all the roles from the user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $api_instance->deleteUserIdRoles($user_id);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserIdRoutingskillsSkillId**
> string deleteUserIdRoutingskillsSkillId($user_id, $skill_id)

Remove routing skill from user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$skill_id = "skill_id_example"; // string | skillId

try {
    $result = $api_instance->deleteUserIdRoutingskillsSkillId($user_id, $skill_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **skill_id** | **string**| skillId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserIdStationAssociatedstation**
> deleteUserIdStationAssociatedstation($user_id)

Clear associated station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $api_instance->deleteUserIdStationAssociatedstation($user_id);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUserIdStationAssociatedstation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserIdStationDefaultstation**
> deleteUserIdStationDefaultstation($user_id)

Clear default station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $api_instance->deleteUserIdStationDefaultstation($user_id);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUserIdStationDefaultstation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFieldconfig**
> \PureCloudSDK\FieldConfig getFieldconfig($type)

Fetch field config for an entity type



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$type = "type_example"; // string | Field type

try {
    $result = $api_instance->getFieldconfig($type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getFieldconfig: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Field type |

### Return type

[**\PureCloudSDK\FieldConfig**](../Model/FieldConfig.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMe**
> \PureCloudSDK\UserMe getMe($expand)

Get current user details.

This request is not valid when using the Client Credentials OAuth grant.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getMe($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getMe: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserMe**](../Model/UserMe.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch**
> \PureCloudSDK\UsersSearchResponse getSearch($q64, $expand)

Search users using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserId**
> \PureCloudSDK\User getUserId($user_id, $expand)

Get user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUserId($user_id, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\User**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdAdjacents**
> getUserIdAdjacents($user_id, $expand)

Get adjacents



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $api_instance->getUserIdAdjacents($user_id, $expand);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdAdjacents: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdCallforwarding**
> \PureCloudSDK\CallForwarding getUserIdCallforwarding($user_id)

Get a user's CallForwarding



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdCallforwarding($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdCallforwarding: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\CallForwarding**](../Model/CallForwarding.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdDirectreports**
> getUserIdDirectreports($user_id, $expand)

Get direct reports



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $api_instance->getUserIdDirectreports($user_id, $expand);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdDirectreports: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdFavorites**
> getUserIdFavorites($user_id, $page_size, $page_number, $sort_order, $expand)

Get favorites



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_order = "ASC"; // string | Sort order
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $api_instance->getUserIdFavorites($user_id, $page_size, $page_number, $sort_order, $expand);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdFavorites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_order** | **string**| Sort order | [optional] [default to ASC]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdGeolocationsClientId**
> \PureCloudSDK\Geolocation getUserIdGeolocationsClientId($user_id, $client_id)

Get a user's Geolocation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | user Id
$client_id = "client_id_example"; // string | client Id

try {
    $result = $api_instance->getUserIdGeolocationsClientId($user_id, $client_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdGeolocationsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| user Id |
 **client_id** | **string**| client Id |

### Return type

[**\PureCloudSDK\Geolocation**](../Model/Geolocation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdOutofoffice**
> \PureCloudSDK\OutOfOffice getUserIdOutofoffice($user_id)

Get a OutOfOffice



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdOutofoffice($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdOutofoffice: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\OutOfOffice**](../Model/OutOfOffice.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdProfileskills**
> string[] getUserIdProfileskills($user_id)

List profile skills for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdProfileskills($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdProfileskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdQueues**
> \PureCloudSDK\UserQueueEntityListing getUserIdQueues($user_id, $page_size, $page_number, $joined)

Get queues for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$joined = true; // bool | Is joined to the queue

try {
    $result = $api_instance->getUserIdQueues($user_id, $page_size, $page_number, $joined);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **joined** | **bool**| Is joined to the queue | [optional] [default to true]

### Return type

[**\PureCloudSDK\UserQueueEntityListing**](../Model/UserQueueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdRoles**
> \PureCloudSDK\UserAuthorization getUserIdRoles($user_id)

Returns a listing of roles and permissions for a user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdRoles($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdRoutingskills**
> \PureCloudSDK\UserSkillEntityListing getUserIdRoutingskills($user_id, $page_size, $page_number, $sort_order)

List routing skills for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$sort_order = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getUserIdRoutingskills($user_id, $page_size, $page_number, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **sort_order** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\UserSkillEntityListing**](../Model/UserSkillEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdRoutingstatus**
> \PureCloudSDK\RoutingStatus getUserIdRoutingstatus($user_id)

Fetch the routing status of a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdRoutingstatus($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdRoutingstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\RoutingStatus**](../Model/RoutingStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdStation**
> \PureCloudSDK\UserStations getUserIdStation($user_id)

Get station information for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserIdStation($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdStation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\UserStations**](../Model/UserStations.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdSuperiors**
> getUserIdSuperiors($user_id, $expand)

Get superiors



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $api_instance->getUserIdSuperiors($user_id, $expand);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUserIdSuperiors: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsers**
> \PureCloudSDK\UsersEntityListing getUsers($page_size, $page_number, $id, $sort_order, $expand)

Get the list of available users.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number
$id = array("id_example"); // string[] | id
$sort_order = "ASC"; // string | Ascending or descending sort order
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsers($page_size, $page_number, $id, $sort_order, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]
 **id** | [**string[]**](../Model/string.md)| id | [optional]
 **sort_order** | **string**| Ascending or descending sort order | [optional] [default to ASC]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UsersEntityListing**](../Model/UsersEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUserId**
> \PureCloudSDK\User patchUserId($user_id, $body)

Update user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\User(); // \PureCloudSDK\User | User

try {
    $result = $api_instance->patchUserId($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\User**](../Model/\PureCloudSDK\User.md)| User |

### Return type

[**\PureCloudSDK\User**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUserIdCallforwarding**
> \PureCloudSDK\CallForwarding patchUserIdCallforwarding($user_id, $body)

Patch a user's CallForwarding



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\CallForwarding(); // \PureCloudSDK\CallForwarding | Call forwarding

try {
    $result = $api_instance->patchUserIdCallforwarding($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUserIdCallforwarding: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\CallForwarding**](../Model/\PureCloudSDK\CallForwarding.md)| Call forwarding |

### Return type

[**\PureCloudSDK\CallForwarding**](../Model/CallForwarding.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUserIdGeolocationsClientId**
> \PureCloudSDK\Geolocation patchUserIdGeolocationsClientId($user_id, $client_id, $body)

Patch a user's Geolocation

The geolocation object can be patched one of three ways. Option 1: Set the 'primary' property to true. This will set the client as the user's primary geolocation source.  Option 2: Provide the 'latitude' and 'longitude' values.  This will enqueue an asynchronous update of the 'city', 'region', and 'country', generating a notification. A subsequent GET operation will include the new values for 'city', 'region' and 'country'.  Option 3:  Provide the 'city', 'region', 'country' values.  Option 1 can be combined with Option 2 or Option 3.  For example, update the client as primary and provide latitude and longitude values.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | user Id
$client_id = "client_id_example"; // string | client Id
$body = new \PureCloudSDK\Geolocation(); // \PureCloudSDK\Geolocation | Geolocation

try {
    $result = $api_instance->patchUserIdGeolocationsClientId($user_id, $client_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUserIdGeolocationsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| user Id |
 **client_id** | **string**| client Id |
 **body** | [**\PureCloudSDK\Geolocation**](../Model/\PureCloudSDK\Geolocation.md)| Geolocation |

### Return type

[**\PureCloudSDK\Geolocation**](../Model/Geolocation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUserIdQueues**
> \PureCloudSDK\UserQueue patchUserIdQueues($user_id, $body)

Join or unjoin a set of queues for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = array(new UserQueue()); // \PureCloudSDK\UserQueue[] | User Queues

try {
    $result = $api_instance->patchUserIdQueues($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUserIdQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserQueue[]**](../Model/UserQueue.md)| User Queues |

### Return type

[**\PureCloudSDK\UserQueue**](../Model/UserQueue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUserIdQueuesQueueId**
> \PureCloudSDK\UserQueue patchUserIdQueuesQueueId($queue_id, $user_id, $body)

Join or unjoin a queue for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$queue_id = "queue_id_example"; // string | Queue ID
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\UserQueue(); // \PureCloudSDK\UserQueue | Queue Member

try {
    $result = $api_instance->patchUserIdQueuesQueueId($queue_id, $user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUserIdQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queue_id** | **string**| Queue ID |
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserQueue**](../Model/\PureCloudSDK\UserQueue.md)| Queue Member |

### Return type

[**\PureCloudSDK\UserQueue**](../Model/UserQueue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\UsersSearchResponse postSearch($body)

Search users



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\UserSearchRequest(); // \PureCloudSDK\UserSearchRequest | Search request options

try {
    $result = $api_instance->postSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserSearchRequest**](../Model/\PureCloudSDK\UserSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUserIdRoutingskills**
> \PureCloudSDK\UserRoutingSkill postUserIdRoutingskills($user_id, $body)

Add routing skill to user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\UserRoutingSkillPost(); // \PureCloudSDK\UserRoutingSkillPost | Skill

try {
    $result = $api_instance->postUserIdRoutingskills($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserRoutingSkillPost**](../Model/\PureCloudSDK\UserRoutingSkillPost.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsers**
> \PureCloudSDK\User postUsers($body)

Create user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\CreateUser(); // \PureCloudSDK\CreateUser | User

try {
    $result = $api_instance->postUsers($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateUser**](../Model/\PureCloudSDK\CreateUser.md)| User |

### Return type

[**\PureCloudSDK\User**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersAggregatesQuery**
> \PureCloudSDK\PresenceQueryResponse postUsersAggregatesQuery($body)

Query for user aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postUsersAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUsersAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\PresenceQueryResponse**](../Model/PresenceQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersObservationsQuery**
> \PureCloudSDK\ObservationQueryResponse postUsersObservationsQuery($body)

Query for user observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postUsersObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUsersObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\ObservationQueryResponse**](../Model/ObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdCallforwarding**
> \PureCloudSDK\CallForwarding putUserIdCallforwarding($user_id, $body)

Update a user's CallForwarding



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\CallForwarding(); // \PureCloudSDK\CallForwarding | Call forwarding

try {
    $result = $api_instance->putUserIdCallforwarding($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdCallforwarding: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\CallForwarding**](../Model/\PureCloudSDK\CallForwarding.md)| Call forwarding |

### Return type

[**\PureCloudSDK\CallForwarding**](../Model/CallForwarding.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdOutofoffice**
> \PureCloudSDK\OutOfOffice putUserIdOutofoffice($user_id, $body)

Update an OutOfOffice



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\OutOfOffice(); // \PureCloudSDK\OutOfOffice | The updated UserPresence

try {
    $result = $api_instance->putUserIdOutofoffice($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdOutofoffice: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\OutOfOffice**](../Model/\PureCloudSDK\OutOfOffice.md)| The updated UserPresence |

### Return type

[**\PureCloudSDK\OutOfOffice**](../Model/OutOfOffice.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdProfileskills**
> string[] putUserIdProfileskills($user_id, $body)

Update profile skills for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = array(new string[]()); // string[] | Skills

try {
    $result = $api_instance->putUserIdProfileskills($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdProfileskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | **string[]**| Skills | [optional]

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdRoles**
> \PureCloudSDK\UserAuthorization putUserIdRoles($user_id, $body)

Sets the user's roles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = array(new string[]()); // string[] | List of roles

try {
    $result = $api_instance->putUserIdRoles($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | **string[]**| List of roles |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdRoutingskillsSkillId**
> \PureCloudSDK\UserRoutingSkill putUserIdRoutingskillsSkillId($user_id, $skill_id, $body)

Update routing skill proficiency or state.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$skill_id = "skill_id_example"; // string | skillId
$body = new \PureCloudSDK\UserRoutingSkill(); // \PureCloudSDK\UserRoutingSkill | Skill

try {
    $result = $api_instance->putUserIdRoutingskillsSkillId($user_id, $skill_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **skill_id** | **string**| skillId |
 **body** | [**\PureCloudSDK\UserRoutingSkill**](../Model/\PureCloudSDK\UserRoutingSkill.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdRoutingstatus**
> \PureCloudSDK\RoutingStatus putUserIdRoutingstatus($user_id, $body)

Update the routing status of a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\RoutingStatus(); // \PureCloudSDK\RoutingStatus | Routing Status

try {
    $result = $api_instance->putUserIdRoutingstatus($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdRoutingstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\RoutingStatus**](../Model/\PureCloudSDK\RoutingStatus.md)| Routing Status |

### Return type

[**\PureCloudSDK\RoutingStatus**](../Model/RoutingStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdStationAssociatedstationStationId**
> putUserIdStationAssociatedstationStationId($user_id, $station_id)

Set associated station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$station_id = "station_id_example"; // string | stationId

try {
    $api_instance->putUserIdStationAssociatedstationStationId($user_id, $station_id);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdStationAssociatedstationStationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **station_id** | **string**| stationId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdStationDefaultstationStationId**
> putUserIdStationDefaultstationStationId($user_id, $station_id)

Set default station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$user_id = "user_id_example"; // string | User ID
$station_id = "station_id_example"; // string | stationId

try {
    $api_instance->putUserIdStationDefaultstationStationId($user_id, $station_id);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUserIdStationDefaultstationStationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **station_id** | **string**| stationId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

