# PureCloudSDK\UtilitiesApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getDate**](UtilitiesApi.md#getDate) | **GET** /api/v2/date | Get the current system date/time
[**getTimezones**](UtilitiesApi.md#getTimezones) | **GET** /api/v2/timezones | Get time zones list
[**postDetails**](UtilitiesApi.md#postDetails) | **POST** /api/v2/certificate/details | Returns the information about an X509 PEM encoded certificate or certificate chain.


# **getDate**
> \PureCloudSDK\ServerDate getDate()

Get the current system date/time



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UtilitiesApi();

try {
    $result = $api_instance->getDate();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UtilitiesApi->getDate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ServerDate**](../Model/ServerDate.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTimezones**
> \PureCloudSDK\TimeZoneEntityListing getTimezones($page_size, $page_number)

Get time zones list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UtilitiesApi();
$page_size = 25; // int | Page size
$page_number = 1; // int | Page number

try {
    $result = $api_instance->getTimezones($page_size, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UtilitiesApi->getTimezones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| Page size | [optional] [default to 25]
 **page_number** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TimeZoneEntityListing**](../Model/TimeZoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDetails**
> \PureCloudSDK\ParsedCertificate postDetails($body)

Returns the information about an X509 PEM encoded certificate or certificate chain.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UtilitiesApi();
$body = new \PureCloudSDK\Certificate(); // \PureCloudSDK\Certificate | Certificate

try {
    $result = $api_instance->postDetails($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UtilitiesApi->postDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Certificate**](../Model/\PureCloudSDK\Certificate.md)| Certificate |

### Return type

[**\PureCloudSDK\ParsedCertificate**](../Model/ParsedCertificate.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

