# PureCloudSDK\VoicemailApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteMessages**](VoicemailApi.md#deleteMessages) | **DELETE** /api/v2/voicemail/messages | Delete all voicemail messages
[**deleteMessagesMessageId**](VoicemailApi.md#deleteMessagesMessageId) | **DELETE** /api/v2/voicemail/messages/{messageId} | Delete a message.
[**getMailbox**](VoicemailApi.md#getMailbox) | **GET** /api/v2/voicemail/mailbox | Get mailbox information
[**getMessages**](VoicemailApi.md#getMessages) | **GET** /api/v2/voicemail/messages | List voicemail messages
[**getMessagesMessageId**](VoicemailApi.md#getMessagesMessageId) | **GET** /api/v2/voicemail/messages/{messageId} | Get message.
[**getMessagesMessageIdMedia**](VoicemailApi.md#getMessagesMessageIdMedia) | **GET** /api/v2/voicemail/messages/{messageId}/media | Get media playback URI for this message
[**getPolicy**](VoicemailApi.md#getPolicy) | **GET** /api/v2/voicemail/policy | Get a policy
[**getUserpoliciesUserId**](VoicemailApi.md#getUserpoliciesUserId) | **GET** /api/v2/voicemail/userpolicies/{userId} | Get a user&#39;s voicemail policy
[**patchUserpoliciesUserId**](VoicemailApi.md#patchUserpoliciesUserId) | **PATCH** /api/v2/voicemail/userpolicies/{userId} | Update a user&#39;s voicemail policy
[**putMessagesMessageId**](VoicemailApi.md#putMessagesMessageId) | **PUT** /api/v2/voicemail/messages/{messageId} | Update a message.
[**putPolicy**](VoicemailApi.md#putPolicy) | **PUT** /api/v2/voicemail/policy | Update a policy


# **deleteMessages**
> string deleteMessages()

Delete all voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->deleteMessages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->deleteMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteMessagesMessageId**
> string deleteMessagesMessageId($message_id)

Delete a message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$message_id = "message_id_example"; // string | Message ID

try {
    $result = $api_instance->deleteMessagesMessageId($message_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->deleteMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **message_id** | **string**| Message ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMailbox**
> \PureCloudSDK\VoicemailMailboxInfo getMailbox()

Get mailbox information



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getMailbox();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getMailbox: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailMailboxInfo**](../Model/VoicemailMailboxInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMessages**
> \PureCloudSDK\VoicemailMessageEntityListing getMessages()

List voicemail messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getMessages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailMessageEntityListing**](../Model/VoicemailMessageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMessagesMessageId**
> \PureCloudSDK\VoicemailMessage getMessagesMessageId($message_id)

Get message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$message_id = "message_id_example"; // string | Message ID

try {
    $result = $api_instance->getMessagesMessageId($message_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **message_id** | **string**| Message ID |

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMessagesMessageIdMedia**
> \PureCloudSDK\VoicemailMediaInfo getMessagesMessageIdMedia($message_id, $format_id)

Get media playback URI for this message



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$message_id = "message_id_example"; // string | Message ID
$format_id = "WEBM"; // string | The desired media format.

try {
    $result = $api_instance->getMessagesMessageIdMedia($message_id, $format_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getMessagesMessageIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **message_id** | **string**| Message ID |
 **format_id** | **string**| The desired media format. | [optional] [default to WEBM]

### Return type

[**\PureCloudSDK\VoicemailMediaInfo**](../Model/VoicemailMediaInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPolicy**
> \PureCloudSDK\VoicemailOrganizationPolicy getPolicy()

Get a policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();

try {
    $result = $api_instance->getPolicy();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/VoicemailOrganizationPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserpoliciesUserId**
> \PureCloudSDK\VoicemailUserPolicy getUserpoliciesUserId($user_id)

Get a user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$user_id = "user_id_example"; // string | User ID

try {
    $result = $api_instance->getUserpoliciesUserId($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->getUserpoliciesUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUserpoliciesUserId**
> \PureCloudSDK\VoicemailUserPolicy patchUserpoliciesUserId($user_id, $body)

Update a user's voicemail policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$user_id = "user_id_example"; // string | User ID
$body = new \PureCloudSDK\VoicemailUserPolicy(); // \PureCloudSDK\VoicemailUserPolicy | The user's voicemail policy

try {
    $result = $api_instance->patchUserpoliciesUserId($user_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->patchUserpoliciesUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **string**| User ID |
 **body** | [**\PureCloudSDK\VoicemailUserPolicy**](../Model/\PureCloudSDK\VoicemailUserPolicy.md)| The user&#39;s voicemail policy |

### Return type

[**\PureCloudSDK\VoicemailUserPolicy**](../Model/VoicemailUserPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putMessagesMessageId**
> \PureCloudSDK\VoicemailMessage putMessagesMessageId($message_id, $body)

Update a message.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$message_id = "message_id_example"; // string | Message ID
$body = new \PureCloudSDK\VoicemailMessage(); // \PureCloudSDK\VoicemailMessage | VoicemailMessage

try {
    $result = $api_instance->putMessagesMessageId($message_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->putMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **message_id** | **string**| Message ID |
 **body** | [**\PureCloudSDK\VoicemailMessage**](../Model/\PureCloudSDK\VoicemailMessage.md)| VoicemailMessage |

### Return type

[**\PureCloudSDK\VoicemailMessage**](../Model/VoicemailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putPolicy**
> \PureCloudSDK\VoicemailOrganizationPolicy putPolicy($body)

Update a policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\VoicemailApi();
$body = new \PureCloudSDK\VoicemailOrganizationPolicy(); // \PureCloudSDK\VoicemailOrganizationPolicy | Policy

try {
    $result = $api_instance->putPolicy($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoicemailApi->putPolicy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/\PureCloudSDK\VoicemailOrganizationPolicy.md)| Policy |

### Return type

[**\PureCloudSDK\VoicemailOrganizationPolicy**](../Model/VoicemailOrganizationPolicy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

