# PureCloudSDK\WorkforceManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAdherence**](WorkforceManagementApi.md#getAdherence) | **GET** /api/v2/workforcemanagement/adherence | Get a list of UserScheduleAdherence records for the requested users
[**postLongtermforecasts**](WorkforceManagementApi.md#postLongtermforecasts) | **POST** /api/v2/workforcemanagement/longtermforecasts | Create a forecast


# **getAdherence**
> \PureCloudSDK\UserScheduleAdherence getAdherence($user_id)

Get a list of UserScheduleAdherence records for the requested users



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$user_id = array("user_id_example"); // string[] | User Id(s) for which to fetch current schedule adherence information.  Max of 100 userIds per request

try {
    $result = $api_instance->getAdherence($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->getAdherence: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | [**string[]**](../Model/string.md)| User Id(s) for which to fetch current schedule adherence information.  Max of 100 userIds per request |

### Return type

[**\PureCloudSDK\UserScheduleAdherence**](../Model/UserScheduleAdherence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLongtermforecasts**
> \PureCloudSDK\ForecastCreationCompletion postLongtermforecasts($body)

Create a forecast



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\WorkforceManagementApi();
$body = new \PureCloudSDK\ForecastCreation(); // \PureCloudSDK\ForecastCreation | The request body

try {
    $result = $api_instance->postLongtermforecasts($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WorkforceManagementApi->postLongtermforecasts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ForecastCreation**](../Model/\PureCloudSDK\ForecastCreation.md)| The request body |

### Return type

[**\PureCloudSDK\ForecastCreationCompletion**](../Model/ForecastCreationCompletion.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

