# Call

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**state** | **string** | The connection state of this communication. | [optional] 
**id** | **string** | A globally unique identifier for this communication. | [optional] 
**direction** | **string** | The direction of the call | [optional] 
**recording** | **bool** | True if this call is being recorded. | [optional] [default to false]
**recording_state** | **string** | State of recording on this call. | [optional] 
**muted** | **bool** | True if this call is muted so that remote participants can&#39;t hear any audio from this end. | [optional] [default to false]
**confined** | **bool** | True if this call is held and the person on this side hears hold music. | [optional] [default to false]
**held** | **bool** | True if this call is held and the person on this side hears silence. | [optional] [default to false]
**recording_id** | **string** | A globally unique identifier for the recording associated with this call. | [optional] 
**segments** | [**\PureCloudSDK\Segment[]**](Segment.md) | The time line of the participant&#39;s call, divided into activity segments. | [optional] 
**error_info** | [**\PureCloudSDK\ErrorBody**](ErrorBody.md) |  | [optional] 
**disconnect_type** | **string** | System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects. | [optional] 
**start_hold_time** | [**\DateTime**](\DateTime.md) | The timestamp the call was placed on hold in the cloud clock if the call is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**document_id** | **string** | If call is an outbound fax of a document from content management, then this is the id in content management. | [optional] 
**connected_time** | [**\DateTime**](\DateTime.md) | The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**disconnected_time** | [**\DateTime**](\DateTime.md) | The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**disconnect_reasons** | [**\PureCloudSDK\DisconnectReason[]**](DisconnectReason.md) | List of reasons that this call was disconnected. This will be set once the call disconnects. | [optional] 
**fax_status** | [**\PureCloudSDK\FaxStatus**](FaxStatus.md) | Extra information on fax transmission. | [optional] 
**provider** | **string** | The source provider for the call. | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


