# CallbackMediaParticipant

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The unique participant ID. | [optional] 
**name** | **string** | The display friendly name of the participant. | [optional] 
**address** | **string** | The participant address. | [optional] 
**start_time** | [**\DateTime**](\DateTime.md) | The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**connected_time** | [**\DateTime**](\DateTime.md) | The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**end_time** | [**\DateTime**](\DateTime.md) | The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**start_hold_time** | [**\DateTime**](\DateTime.md) | The time when this participant&#39;s hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**purpose** | **string** | The participant&#39;s purpose.  Values can be: &#39;agent&#39;, &#39;user&#39;, &#39;customer&#39;, &#39;external&#39;, &#39;acd&#39;, &#39;ivr | [optional] 
**state** | **string** | The participant&#39;s state.  Values can be: &#39;alerting&#39;, &#39;connected&#39;, &#39;disconnected&#39;, &#39;dialing&#39;, &#39;contacting | [optional] 
**direction** | **string** | The participant&#39;s direction.  Values can be: &#39;inbound&#39; or &#39;outbound&#39; | [optional] 
**disconnect_type** | **string** | The reason the participant was disconnected from the conversation. | [optional] 
**held** | **bool** | Value is true when the participant is on hold. | [optional] [default to false]
**wrapup_required** | **bool** | Value is true when the participant requires wrap-up. | [optional] [default to false]
**wrapup_prompt** | **string** | The wrap-up prompt indicating the type of wrap-up to be performed. | [optional] 
**user** | [**\PureCloudSDK\UriReference**](UriReference.md) | The PureCloud user for this participant. | [optional] 
**queue** | [**\PureCloudSDK\UriReference**](UriReference.md) | The PureCloud queue for this participant. | [optional] 
**attributes** | **map[string,string]** | A list of ad-hoc attributes for the participant. | [optional] 
**error_info** | [**\PureCloudSDK\ErrorBody**](ErrorBody.md) | If the conversation ends in error, contains additional error details. | [optional] 
**script** | [**\PureCloudSDK\UriReference**](UriReference.md) | The Engage script that should be used by this participant. | [optional] 
**wrapup_timeout_ms** | **int** | The amount of time the participant has to complete wrap-up. | [optional] 
**wrapup_skipped** | **bool** | Value is true when the participant has skipped wrap-up. | [optional] [default to false]
**provider** | **string** | The source provider for the communication. | [optional] 
**external_contact** | [**\PureCloudSDK\UriReference**](UriReference.md) | If this participant represents an external contact, then this will be the reference for the external contact. | [optional] 
**external_organization** | [**\PureCloudSDK\UriReference**](UriReference.md) | If this participant represents an external org, then this will be the reference for the external org. | [optional] 
**outbound_preview** | [**\PureCloudSDK\DialerPreview**](DialerPreview.md) | The outbound preview associated with this callback. | [optional] 
**callback_numbers** | **string[]** | The list of phone number to use for this callback. | [optional] 
**callback_user_name** | **string** | The name of the callback target. | [optional] 
**skip_enabled** | **bool** | If true, the callback can be skipped | [optional] [default to false]
**timeout_seconds** | **int** | Duration in seconds before the callback will be auto-dialed. | [optional] 
**callback_scheduled_time** | [**\DateTime**](\DateTime.md) | Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


