# Campaign

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**date_created** | [**\DateTime**](\DateTime.md) | Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**date_modified** | [**\DateTime**](\DateTime.md) | Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**version** | **int** | Required for updates, must match the version number of the most recent update | [optional] 
**contact_list** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the contact list for the campaign | 
**queue** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the agent assignment queue, required for all dialing modes other than agentless | 
**dialing_mode** | **string** | dialing mode of the campaign | 
**script** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the campaign script, required for all dialing modes other than agentless | 
**edge_group** | [**\PureCloudSDK\UriReference**](UriReference.md) | identifier of the edge group, required for all dialing modes other than preview | 
**campaign_status** | **string** | status of the campaign; can be set to &#39;on&#39; or &#39;off&#39; | 
**phone_columns** | [**\PureCloudSDK\PhoneColumn[]**](PhoneColumn.md) | the contact list phone columns to be called for the campaign | 
**abandon_rate** | **double** | the targeted abandon rate percentage | [optional] 
**dnc_lists** | [**\PureCloudSDK\UriReference[]**](UriReference.md) | identifiers of the do not call lists | [optional] 
**callable_time_set** | [**\PureCloudSDK\UriReference**](UriReference.md) | the identifier of the callable time set | [optional] 
**call_analysis_response_set** | [**\PureCloudSDK\UriReference**](UriReference.md) | the identifier of the call analysis response set, required for all dialing modes other than preview | 
**errors** | [**\PureCloudSDK\RestErrorDetail[]**](RestErrorDetail.md) | a list of current error conditions associated with the campaign | [optional] 
**caller_name** | **string** | caller id name to be displayed on the outbound call | [optional] 
**caller_address** | **string** | caller id phone number to be displayed on the outbound call | [optional] 
**outbound_line_count** | **int** | for agentless campaigns, the number of outbound lines to be concurrently dialed | [optional] 
**rule_sets** | [**\PureCloudSDK\UriReference[]**](UriReference.md) | identifiers of the rule sets | [optional] 
**skip_preview_disabled** | **bool** | for preview campaigns, indicator of whether the agent can skip a preview without placing a call | [optional] [default to false]
**preview_time_out_seconds** | **int** | for preview campaigns, number of seconds before a call will be automatically placed. A value of 0 indicates no automatic placement of calls | [optional] 
**contact_sort** | [**\PureCloudSDK\ContactSort**](ContactSort.md) | information determining the order in which the contacts will be dialed | [optional] 
**no_answer_timeout** | **int** | for non-preview campaigns, how long to wait before dispositioning as &#39;no-answer&#39;, default 30 seconds | [optional] 
**call_analysis_language** | **string** | The language the edge will use to analyse the call | [optional] 
**priority** | **int** | The priority of this campaign relative to other campaigns | [optional] 
**self_uri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


