# Recording

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**conversation_id** | **string** |  | [optional] 
**path** | **string** |  | [optional] 
**start_time** | **string** |  | [optional] 
**end_time** | **string** |  | [optional] 
**media** | **string** | The type of media that the recording is. At the moment that could be audio, chat, or email. | [optional] 
**annotations** | [**\PureCloudSDK\Annotation[]**](Annotation.md) | Annotations that belong to the recording. | [optional] 
**transcript** | [**\PureCloudSDK\ChatMessage[]**](ChatMessage.md) | Represents a chat transcript | [optional] 
**email_transcript** | [**\PureCloudSDK\RecordingEmailMessage[]**](RecordingEmailMessage.md) | Represents an email transcript | [optional] 
**file_state** | **string** | Represents the current file state for a recording. Examples: Uploading, Archived, etc | [optional] 
**restore_expiration_time** | [**\DateTime**](\DateTime.md) | The amount of time a restored recording will remain restored before being archived again. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**media_uris** | [**map[string,\PureCloudSDK\MediaResult]**](MediaResult.md) | The different mediaUris for the recording. | [optional] 
**estimated_transcode_time_ms** | **int** |  | [optional] 
**actual_transcode_time_ms** | **int** |  | [optional] 
**archive_date** | [**\DateTime**](\DateTime.md) | The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**archive_medium** | **string** | The type of archive medium used. Example: CloudArchive | [optional] 
**delete_date** | [**\DateTime**](\DateTime.md) | The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**max_allowed_restorations_for_org** | **int** | How many archive restorations the organization is allowed to have. | [optional] 
**remaining_restorations_allowed_for_org** | **int** | The remaining archive restorations the organization has. | [optional] 
**session_id** | **string** | The session id represents an external resource id, such as email, call, chat, etc | [optional] 
**self_uri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


