<?php

/**
 * CreateWorkPlanShift
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateWorkPlanShift Class Doc Comment
 *
 * @category    Class */
 // @description Shift in a work plan
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateWorkPlanShift implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateWorkPlanShift';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'days' => '\PureCloudSDK\SetWrapperDayOfWeek',
        'flexibleStartTime' => 'bool',
        'exactStartTimeMinutesFromMidnight' => 'int',
        'earliestStartTimeMinutesFromMidnight' => 'int',
        'latestStartTimeMinutesFromMidnight' => 'int',
        'constrainStopTime' => 'bool',
        'latestStopTimeMinutesFromMidnight' => 'int',
        'startIncrementMinutes' => 'int',
        'flexiblePaidTime' => 'bool',
        'exactPaidTimeMinutes' => 'int',
        'minimumPaidTimeMinutes' => 'int',
        'maximumPaidTimeMinutes' => 'int',
        'constrainContiguousWorkTime' => 'bool',
        'minimumContiguousWorkTimeMinutes' => 'int',
        'maximumContiguousWorkTimeMinutes' => 'int',
        'activities' => '\PureCloudSDK\CreateWorkPlanActivity[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'days' => 'days',
        'flexibleStartTime' => 'flexibleStartTime',
        'exactStartTimeMinutesFromMidnight' => 'exactStartTimeMinutesFromMidnight',
        'earliestStartTimeMinutesFromMidnight' => 'earliestStartTimeMinutesFromMidnight',
        'latestStartTimeMinutesFromMidnight' => 'latestStartTimeMinutesFromMidnight',
        'constrainStopTime' => 'constrainStopTime',
        'latestStopTimeMinutesFromMidnight' => 'latestStopTimeMinutesFromMidnight',
        'startIncrementMinutes' => 'startIncrementMinutes',
        'flexiblePaidTime' => 'flexiblePaidTime',
        'exactPaidTimeMinutes' => 'exactPaidTimeMinutes',
        'minimumPaidTimeMinutes' => 'minimumPaidTimeMinutes',
        'maximumPaidTimeMinutes' => 'maximumPaidTimeMinutes',
        'constrainContiguousWorkTime' => 'constrainContiguousWorkTime',
        'minimumContiguousWorkTimeMinutes' => 'minimumContiguousWorkTimeMinutes',
        'maximumContiguousWorkTimeMinutes' => 'maximumContiguousWorkTimeMinutes',
        'activities' => 'activities'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'days' => 'setDays',
        'flexibleStartTime' => 'setFlexibleStartTime',
        'exactStartTimeMinutesFromMidnight' => 'setExactStartTimeMinutesFromMidnight',
        'earliestStartTimeMinutesFromMidnight' => 'setEarliestStartTimeMinutesFromMidnight',
        'latestStartTimeMinutesFromMidnight' => 'setLatestStartTimeMinutesFromMidnight',
        'constrainStopTime' => 'setConstrainStopTime',
        'latestStopTimeMinutesFromMidnight' => 'setLatestStopTimeMinutesFromMidnight',
        'startIncrementMinutes' => 'setStartIncrementMinutes',
        'flexiblePaidTime' => 'setFlexiblePaidTime',
        'exactPaidTimeMinutes' => 'setExactPaidTimeMinutes',
        'minimumPaidTimeMinutes' => 'setMinimumPaidTimeMinutes',
        'maximumPaidTimeMinutes' => 'setMaximumPaidTimeMinutes',
        'constrainContiguousWorkTime' => 'setConstrainContiguousWorkTime',
        'minimumContiguousWorkTimeMinutes' => 'setMinimumContiguousWorkTimeMinutes',
        'maximumContiguousWorkTimeMinutes' => 'setMaximumContiguousWorkTimeMinutes',
        'activities' => 'setActivities'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'days' => 'getDays',
        'flexibleStartTime' => 'getFlexibleStartTime',
        'exactStartTimeMinutesFromMidnight' => 'getExactStartTimeMinutesFromMidnight',
        'earliestStartTimeMinutesFromMidnight' => 'getEarliestStartTimeMinutesFromMidnight',
        'latestStartTimeMinutesFromMidnight' => 'getLatestStartTimeMinutesFromMidnight',
        'constrainStopTime' => 'getConstrainStopTime',
        'latestStopTimeMinutesFromMidnight' => 'getLatestStopTimeMinutesFromMidnight',
        'startIncrementMinutes' => 'getStartIncrementMinutes',
        'flexiblePaidTime' => 'getFlexiblePaidTime',
        'exactPaidTimeMinutes' => 'getExactPaidTimeMinutes',
        'minimumPaidTimeMinutes' => 'getMinimumPaidTimeMinutes',
        'maximumPaidTimeMinutes' => 'getMaximumPaidTimeMinutes',
        'constrainContiguousWorkTime' => 'getConstrainContiguousWorkTime',
        'minimumContiguousWorkTimeMinutes' => 'getMinimumContiguousWorkTimeMinutes',
        'maximumContiguousWorkTimeMinutes' => 'getMaximumContiguousWorkTimeMinutes',
        'activities' => 'getActivities'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['days'] = isset($data['days']) ? $data['days'] : null;
        $this->container['flexibleStartTime'] = isset($data['flexibleStartTime']) ? $data['flexibleStartTime'] : null;
        $this->container['exactStartTimeMinutesFromMidnight'] = isset($data['exactStartTimeMinutesFromMidnight']) ? $data['exactStartTimeMinutesFromMidnight'] : null;
        $this->container['earliestStartTimeMinutesFromMidnight'] = isset($data['earliestStartTimeMinutesFromMidnight']) ? $data['earliestStartTimeMinutesFromMidnight'] : null;
        $this->container['latestStartTimeMinutesFromMidnight'] = isset($data['latestStartTimeMinutesFromMidnight']) ? $data['latestStartTimeMinutesFromMidnight'] : null;
        $this->container['constrainStopTime'] = isset($data['constrainStopTime']) ? $data['constrainStopTime'] : null;
        $this->container['latestStopTimeMinutesFromMidnight'] = isset($data['latestStopTimeMinutesFromMidnight']) ? $data['latestStopTimeMinutesFromMidnight'] : null;
        $this->container['startIncrementMinutes'] = isset($data['startIncrementMinutes']) ? $data['startIncrementMinutes'] : null;
        $this->container['flexiblePaidTime'] = isset($data['flexiblePaidTime']) ? $data['flexiblePaidTime'] : null;
        $this->container['exactPaidTimeMinutes'] = isset($data['exactPaidTimeMinutes']) ? $data['exactPaidTimeMinutes'] : null;
        $this->container['minimumPaidTimeMinutes'] = isset($data['minimumPaidTimeMinutes']) ? $data['minimumPaidTimeMinutes'] : null;
        $this->container['maximumPaidTimeMinutes'] = isset($data['maximumPaidTimeMinutes']) ? $data['maximumPaidTimeMinutes'] : null;
        $this->container['constrainContiguousWorkTime'] = isset($data['constrainContiguousWorkTime']) ? $data['constrainContiguousWorkTime'] : null;
        $this->container['minimumContiguousWorkTimeMinutes'] = isset($data['minimumContiguousWorkTimeMinutes']) ? $data['minimumContiguousWorkTimeMinutes'] : null;
        $this->container['maximumContiguousWorkTimeMinutes'] = isset($data['maximumContiguousWorkTimeMinutes']) ? $data['maximumContiguousWorkTimeMinutes'] : null;
        $this->container['activities'] = isset($data['activities']) ? $data['activities'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the shift
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets days
     * @return \PureCloudSDK\SetWrapperDayOfWeek
     */
    public function getDays()
    {
        return $this->container['days'];
    }

    /**
     * Sets days
     * @param \PureCloudSDK\SetWrapperDayOfWeek $days Days of the week applicable for this shift
     * @return $this
     */
    public function setDays($days)
    {
        $this->container['days'] = $days;

        return $this;
    }

    /**
     * Gets flexibleStartTime
     * @return bool
     */
    public function getFlexibleStartTime()
    {
        return $this->container['flexibleStartTime'];
    }

    /**
     * Sets flexibleStartTime
     * @param bool $flexibleStartTime Whether the start time of the shift is flexible
     * @return $this
     */
    public function setFlexibleStartTime($flexibleStartTime)
    {
        $this->container['flexibleStartTime'] = $flexibleStartTime;

        return $this;
    }

    /**
     * Gets exactStartTimeMinutesFromMidnight
     * @return int
     */
    public function getExactStartTimeMinutesFromMidnight()
    {
        return $this->container['exactStartTimeMinutesFromMidnight'];
    }

    /**
     * Sets exactStartTimeMinutesFromMidnight
     * @param int $exactStartTimeMinutesFromMidnight Exact start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == false
     * @return $this
     */
    public function setExactStartTimeMinutesFromMidnight($exactStartTimeMinutesFromMidnight)
    {
        $this->container['exactStartTimeMinutesFromMidnight'] = $exactStartTimeMinutesFromMidnight;

        return $this;
    }

    /**
     * Gets earliestStartTimeMinutesFromMidnight
     * @return int
     */
    public function getEarliestStartTimeMinutesFromMidnight()
    {
        return $this->container['earliestStartTimeMinutesFromMidnight'];
    }

    /**
     * Sets earliestStartTimeMinutesFromMidnight
     * @param int $earliestStartTimeMinutesFromMidnight Earliest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true
     * @return $this
     */
    public function setEarliestStartTimeMinutesFromMidnight($earliestStartTimeMinutesFromMidnight)
    {
        $this->container['earliestStartTimeMinutesFromMidnight'] = $earliestStartTimeMinutesFromMidnight;

        return $this;
    }

    /**
     * Gets latestStartTimeMinutesFromMidnight
     * @return int
     */
    public function getLatestStartTimeMinutesFromMidnight()
    {
        return $this->container['latestStartTimeMinutesFromMidnight'];
    }

    /**
     * Sets latestStartTimeMinutesFromMidnight
     * @param int $latestStartTimeMinutesFromMidnight Latest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true
     * @return $this
     */
    public function setLatestStartTimeMinutesFromMidnight($latestStartTimeMinutesFromMidnight)
    {
        $this->container['latestStartTimeMinutesFromMidnight'] = $latestStartTimeMinutesFromMidnight;

        return $this;
    }

    /**
     * Gets constrainStopTime
     * @return bool
     */
    public function getConstrainStopTime()
    {
        return $this->container['constrainStopTime'];
    }

    /**
     * Sets constrainStopTime
     * @param bool $constrainStopTime Whether the latest stop time constraint for the shift is enabled
     * @return $this
     */
    public function setConstrainStopTime($constrainStopTime)
    {
        $this->container['constrainStopTime'] = $constrainStopTime;

        return $this;
    }

    /**
     * Gets latestStopTimeMinutesFromMidnight
     * @return int
     */
    public function getLatestStopTimeMinutesFromMidnight()
    {
        return $this->container['latestStopTimeMinutesFromMidnight'];
    }

    /**
     * Sets latestStopTimeMinutesFromMidnight
     * @param int $latestStopTimeMinutesFromMidnight Latest stop time of the shift defined as offset minutes from midnight. Used if constrainStopTime == true
     * @return $this
     */
    public function setLatestStopTimeMinutesFromMidnight($latestStopTimeMinutesFromMidnight)
    {
        $this->container['latestStopTimeMinutesFromMidnight'] = $latestStopTimeMinutesFromMidnight;

        return $this;
    }

    /**
     * Gets startIncrementMinutes
     * @return int
     */
    public function getStartIncrementMinutes()
    {
        return $this->container['startIncrementMinutes'];
    }

    /**
     * Sets startIncrementMinutes
     * @param int $startIncrementMinutes Increment in offset minutes that would contribute to different possible start times for the shift. Used if flexibleStartTime == true
     * @return $this
     */
    public function setStartIncrementMinutes($startIncrementMinutes)
    {
        $this->container['startIncrementMinutes'] = $startIncrementMinutes;

        return $this;
    }

    /**
     * Gets flexiblePaidTime
     * @return bool
     */
    public function getFlexiblePaidTime()
    {
        return $this->container['flexiblePaidTime'];
    }

    /**
     * Sets flexiblePaidTime
     * @param bool $flexiblePaidTime Whether the paid time setting for the shift is flexible
     * @return $this
     */
    public function setFlexiblePaidTime($flexiblePaidTime)
    {
        $this->container['flexiblePaidTime'] = $flexiblePaidTime;

        return $this;
    }

    /**
     * Gets exactPaidTimeMinutes
     * @return int
     */
    public function getExactPaidTimeMinutes()
    {
        return $this->container['exactPaidTimeMinutes'];
    }

    /**
     * Sets exactPaidTimeMinutes
     * @param int $exactPaidTimeMinutes Exact paid time in minutes configured for the shift. Used if flexiblePaidTime == false
     * @return $this
     */
    public function setExactPaidTimeMinutes($exactPaidTimeMinutes)
    {
        $this->container['exactPaidTimeMinutes'] = $exactPaidTimeMinutes;

        return $this;
    }

    /**
     * Gets minimumPaidTimeMinutes
     * @return int
     */
    public function getMinimumPaidTimeMinutes()
    {
        return $this->container['minimumPaidTimeMinutes'];
    }

    /**
     * Sets minimumPaidTimeMinutes
     * @param int $minimumPaidTimeMinutes Minimum paid time in minutes configured for the shift. Used if flexiblePaidTime == true
     * @return $this
     */
    public function setMinimumPaidTimeMinutes($minimumPaidTimeMinutes)
    {
        $this->container['minimumPaidTimeMinutes'] = $minimumPaidTimeMinutes;

        return $this;
    }

    /**
     * Gets maximumPaidTimeMinutes
     * @return int
     */
    public function getMaximumPaidTimeMinutes()
    {
        return $this->container['maximumPaidTimeMinutes'];
    }

    /**
     * Sets maximumPaidTimeMinutes
     * @param int $maximumPaidTimeMinutes Maximum paid time in minutes configured for the shift. Used if flexiblePaidTime == true
     * @return $this
     */
    public function setMaximumPaidTimeMinutes($maximumPaidTimeMinutes)
    {
        $this->container['maximumPaidTimeMinutes'] = $maximumPaidTimeMinutes;

        return $this;
    }

    /**
     * Gets constrainContiguousWorkTime
     * @return bool
     */
    public function getConstrainContiguousWorkTime()
    {
        return $this->container['constrainContiguousWorkTime'];
    }

    /**
     * Sets constrainContiguousWorkTime
     * @param bool $constrainContiguousWorkTime Whether the contiguous time constraint for the shift is enabled
     * @return $this
     */
    public function setConstrainContiguousWorkTime($constrainContiguousWorkTime)
    {
        $this->container['constrainContiguousWorkTime'] = $constrainContiguousWorkTime;

        return $this;
    }

    /**
     * Gets minimumContiguousWorkTimeMinutes
     * @return int
     */
    public function getMinimumContiguousWorkTimeMinutes()
    {
        return $this->container['minimumContiguousWorkTimeMinutes'];
    }

    /**
     * Sets minimumContiguousWorkTimeMinutes
     * @param int $minimumContiguousWorkTimeMinutes Minimum contiguous time in minutes configured for the shift. Used if constrainContiguousWorkTime == true
     * @return $this
     */
    public function setMinimumContiguousWorkTimeMinutes($minimumContiguousWorkTimeMinutes)
    {
        $this->container['minimumContiguousWorkTimeMinutes'] = $minimumContiguousWorkTimeMinutes;

        return $this;
    }

    /**
     * Gets maximumContiguousWorkTimeMinutes
     * @return int
     */
    public function getMaximumContiguousWorkTimeMinutes()
    {
        return $this->container['maximumContiguousWorkTimeMinutes'];
    }

    /**
     * Sets maximumContiguousWorkTimeMinutes
     * @param int $maximumContiguousWorkTimeMinutes Maximum contiguous time in minutes configured for the shift. Used if constrainContiguousWorkTime == true
     * @return $this
     */
    public function setMaximumContiguousWorkTimeMinutes($maximumContiguousWorkTimeMinutes)
    {
        $this->container['maximumContiguousWorkTimeMinutes'] = $maximumContiguousWorkTimeMinutes;

        return $this;
    }

    /**
     * Gets activities
     * @return \PureCloudSDK\CreateWorkPlanActivity[]
     */
    public function getActivities()
    {
        return $this->container['activities'];
    }

    /**
     * Sets activities
     * @param \PureCloudSDK\CreateWorkPlanActivity[] $activities Activities configured for this shift
     * @return $this
     */
    public function setActivities($activities)
    {
        $this->container['activities'] = $activities;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


