<?php

/**
 * SurveyForm
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SurveyForm Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SurveyForm implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SurveyForm';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'modifiedDate' => '\DateTime',
        'published' => 'bool',
        'disabled' => 'bool',
        'contextId' => 'string',
        'language' => 'string',
        'headerImageId' => 'string',
        'headerImageUrl' => 'string',
        'header' => 'string',
        'footer' => 'string',
        'questionGroups' => '\PureCloudSDK\SurveyQuestionGroup[]',
        'publishedVersions' => '\PureCloudSDK\DomainEntityListingSurveyForm',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'modifiedDate' => 'modifiedDate',
        'published' => 'published',
        'disabled' => 'disabled',
        'contextId' => 'contextId',
        'language' => 'language',
        'headerImageId' => 'headerImageId',
        'headerImageUrl' => 'headerImageUrl',
        'header' => 'header',
        'footer' => 'footer',
        'questionGroups' => 'questionGroups',
        'publishedVersions' => 'publishedVersions',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'modifiedDate' => 'setModifiedDate',
        'published' => 'setPublished',
        'disabled' => 'setDisabled',
        'contextId' => 'setContextId',
        'language' => 'setLanguage',
        'headerImageId' => 'setHeaderImageId',
        'headerImageUrl' => 'setHeaderImageUrl',
        'header' => 'setHeader',
        'footer' => 'setFooter',
        'questionGroups' => 'setQuestionGroups',
        'publishedVersions' => 'setPublishedVersions',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'modifiedDate' => 'getModifiedDate',
        'published' => 'getPublished',
        'disabled' => 'getDisabled',
        'contextId' => 'getContextId',
        'language' => 'getLanguage',
        'headerImageId' => 'getHeaderImageId',
        'headerImageUrl' => 'getHeaderImageUrl',
        'header' => 'getHeader',
        'footer' => 'getFooter',
        'questionGroups' => 'getQuestionGroups',
        'publishedVersions' => 'getPublishedVersions',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['modifiedDate'] = isset($data['modifiedDate']) ? $data['modifiedDate'] : null;
        $this->container['published'] = isset($data['published']) ? $data['published'] : null;
        $this->container['disabled'] = isset($data['disabled']) ? $data['disabled'] : null;
        $this->container['contextId'] = isset($data['contextId']) ? $data['contextId'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['headerImageId'] = isset($data['headerImageId']) ? $data['headerImageId'] : null;
        $this->container['headerImageUrl'] = isset($data['headerImageUrl']) ? $data['headerImageUrl'] : null;
        $this->container['header'] = isset($data['header']) ? $data['header'] : null;
        $this->container['footer'] = isset($data['footer']) ? $data['footer'] : null;
        $this->container['questionGroups'] = isset($data['questionGroups']) ? $data['questionGroups'] : null;
        $this->container['publishedVersions'] = isset($data['publishedVersions']) ? $data['publishedVersions'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['contextId'] === null) {
            $invalid_properties[] = "'contextId' can't be null";
        }
        if ($this->container['language'] === null) {
            $invalid_properties[] = "'language' can't be null";
        }
        if ($this->container['questionGroups'] === null) {
            $invalid_properties[] = "'questionGroups' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['contextId'] === null) {
            return false;
        }
        if ($this->container['language'] === null) {
            return false;
        }
        if ($this->container['questionGroups'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The survey form name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets modifiedDate
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     * @param \DateTime $modifiedDate Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modifiedDate)
    {
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets published
     * @return bool
     */
    public function getPublished()
    {
        return $this->container['published'];
    }

    /**
     * Sets published
     * @param bool $published Is this form published
     * @return $this
     */
    public function setPublished($published)
    {
        $this->container['published'] = $published;

        return $this;
    }

    /**
     * Gets disabled
     * @return bool
     */
    public function getDisabled()
    {
        return $this->container['disabled'];
    }

    /**
     * Sets disabled
     * @param bool $disabled Is this form disabled
     * @return $this
     */
    public function setDisabled($disabled)
    {
        $this->container['disabled'] = $disabled;

        return $this;
    }

    /**
     * Gets contextId
     * @return string
     */
    public function getContextId()
    {
        return $this->container['contextId'];
    }

    /**
     * Sets contextId
     * @param string $contextId Unique Id for all versions of this form
     * @return $this
     */
    public function setContextId($contextId)
    {
        $this->container['contextId'] = $contextId;

        return $this;
    }

    /**
     * Gets language
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     * @param string $language Language for survey viewer localization. Currently localized languages: da, de, en-US, es, fi, fr, it, ja, ko, nl, no, pl, pt-BR, sv, th, tr, zh-CH, zh-TW
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets headerImageId
     * @return string
     */
    public function getHeaderImageId()
    {
        return $this->container['headerImageId'];
    }

    /**
     * Sets headerImageId
     * @param string $headerImageId Id of the header image appearing at the top of the form.
     * @return $this
     */
    public function setHeaderImageId($headerImageId)
    {
        $this->container['headerImageId'] = $headerImageId;

        return $this;
    }

    /**
     * Gets headerImageUrl
     * @return string
     */
    public function getHeaderImageUrl()
    {
        return $this->container['headerImageUrl'];
    }

    /**
     * Sets headerImageUrl
     * @param string $headerImageUrl Temporary URL for accessing header image
     * @return $this
     */
    public function setHeaderImageUrl($headerImageUrl)
    {
        $this->container['headerImageUrl'] = $headerImageUrl;

        return $this;
    }

    /**
     * Gets header
     * @return string
     */
    public function getHeader()
    {
        return $this->container['header'];
    }

    /**
     * Sets header
     * @param string $header Markdown text for the top of the form.
     * @return $this
     */
    public function setHeader($header)
    {
        $this->container['header'] = $header;

        return $this;
    }

    /**
     * Gets footer
     * @return string
     */
    public function getFooter()
    {
        return $this->container['footer'];
    }

    /**
     * Sets footer
     * @param string $footer Markdown text for the bottom of the form.
     * @return $this
     */
    public function setFooter($footer)
    {
        $this->container['footer'] = $footer;

        return $this;
    }

    /**
     * Gets questionGroups
     * @return \PureCloudSDK\SurveyQuestionGroup[]
     */
    public function getQuestionGroups()
    {
        return $this->container['questionGroups'];
    }

    /**
     * Sets questionGroups
     * @param \PureCloudSDK\SurveyQuestionGroup[] $questionGroups A list of question groups
     * @return $this
     */
    public function setQuestionGroups($questionGroups)
    {
        $this->container['questionGroups'] = $questionGroups;

        return $this;
    }

    /**
     * Gets publishedVersions
     * @return \PureCloudSDK\DomainEntityListingSurveyForm
     */
    public function getPublishedVersions()
    {
        return $this->container['publishedVersions'];
    }

    /**
     * Sets publishedVersions
     * @param \PureCloudSDK\DomainEntityListingSurveyForm $publishedVersions List of published version of this form
     * @return $this
     */
    public function setPublishedVersions($publishedVersions)
    {
        $this->container['publishedVersions'] = $publishedVersions;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


