<?php

/**
 * UpdateWeekScheduleRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UpdateWeekScheduleRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UpdateWeekScheduleRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UpdateWeekScheduleRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'description' => 'string',
        'published' => 'bool',
        'userSchedules' => 'map[string,\PureCloudSDK\UserSchedule]',
        'partialUploadIds' => 'string[]',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'agentSchedulesVersion' => 'int',
        'shortTermForecast' => '\PureCloudSDK\ShortTermForecastReference',
        'headcountForecast' => '\PureCloudSDK\HeadcountForecast',
        'agentUpdateFilter' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'description' => 'description',
        'published' => 'published',
        'userSchedules' => 'userSchedules',
        'partialUploadIds' => 'partialUploadIds',
        'metadata' => 'metadata',
        'agentSchedulesVersion' => 'agentSchedulesVersion',
        'shortTermForecast' => 'shortTermForecast',
        'headcountForecast' => 'headcountForecast',
        'agentUpdateFilter' => 'agentUpdateFilter'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'description' => 'setDescription',
        'published' => 'setPublished',
        'userSchedules' => 'setUserSchedules',
        'partialUploadIds' => 'setPartialUploadIds',
        'metadata' => 'setMetadata',
        'agentSchedulesVersion' => 'setAgentSchedulesVersion',
        'shortTermForecast' => 'setShortTermForecast',
        'headcountForecast' => 'setHeadcountForecast',
        'agentUpdateFilter' => 'setAgentUpdateFilter'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'description' => 'getDescription',
        'published' => 'getPublished',
        'userSchedules' => 'getUserSchedules',
        'partialUploadIds' => 'getPartialUploadIds',
        'metadata' => 'getMetadata',
        'agentSchedulesVersion' => 'getAgentSchedulesVersion',
        'shortTermForecast' => 'getShortTermForecast',
        'headcountForecast' => 'getHeadcountForecast',
        'agentUpdateFilter' => 'getAgentUpdateFilter'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const AGENT_UPDATE_FILTER_ALL = 'All';
    public const AGENT_UPDATE_FILTER_SHIFT_TIME_CHANGE = 'ShiftTimeChange';
    public const AGENT_UPDATE_FILTER_NONE = 'None';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAgentUpdateFilterAllowableValues()
    {
        return [
            self::AGENT_UPDATE_FILTER_ALL,
            self::AGENT_UPDATE_FILTER_SHIFT_TIME_CHANGE,
            self::AGENT_UPDATE_FILTER_NONE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['published'] = isset($data['published']) ? $data['published'] : null;
        $this->container['userSchedules'] = isset($data['userSchedules']) ? $data['userSchedules'] : null;
        $this->container['partialUploadIds'] = isset($data['partialUploadIds']) ? $data['partialUploadIds'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['agentSchedulesVersion'] = isset($data['agentSchedulesVersion']) ? $data['agentSchedulesVersion'] : null;
        $this->container['shortTermForecast'] = isset($data['shortTermForecast']) ? $data['shortTermForecast'] : null;
        $this->container['headcountForecast'] = isset($data['headcountForecast']) ? $data['headcountForecast'] : null;
        $this->container['agentUpdateFilter'] = isset($data['agentUpdateFilter']) ? $data['agentUpdateFilter'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['metadata'] === null) {
            $invalid_properties[] = "'metadata' can't be null";
        }
        if ($this->container['agentSchedulesVersion'] === null) {
            $invalid_properties[] = "'agentSchedulesVersion' can't be null";
        }
        $allowed_values = array("All", "ShiftTimeChange", "None");
        if (!in_array($this->container['agentUpdateFilter'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'agentUpdateFilter', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['metadata'] === null) {
            return false;
        }
        if ($this->container['agentSchedulesVersion'] === null) {
            return false;
        }
        $allowed_values = array("All", "ShiftTimeChange", "None");
        if (!in_array($this->container['agentUpdateFilter'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Description of the week schedule
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets published
     * @return bool
     */
    public function getPublished()
    {
        return $this->container['published'];
    }

    /**
     * Sets published
     * @param bool $published Whether the week schedule is published
     * @return $this
     */
    public function setPublished($published)
    {
        $this->container['published'] = $published;

        return $this;
    }

    /**
     * Gets userSchedules
     * @return map[string,\PureCloudSDK\UserSchedule]
     */
    public function getUserSchedules()
    {
        return $this->container['userSchedules'];
    }

    /**
     * Sets userSchedules
     * @param map[string,\PureCloudSDK\UserSchedule] $userSchedules User schedules in the week
     * @return $this
     */
    public function setUserSchedules($userSchedules)
    {
        $this->container['userSchedules'] = $userSchedules;

        return $this;
    }

    /**
     * Gets partialUploadIds
     * @return string[]
     */
    public function getPartialUploadIds()
    {
        return $this->container['partialUploadIds'];
    }

    /**
     * Sets partialUploadIds
     * @param string[] $partialUploadIds IDs of partial uploads to include in this imported schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500
     * @return $this
     */
    public function setPartialUploadIds($partialUploadIds)
    {
        $this->container['partialUploadIds'] = $partialUploadIds;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Version metadata for this work plan
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets agentSchedulesVersion
     * @return int
     */
    public function getAgentSchedulesVersion()
    {
        return $this->container['agentSchedulesVersion'];
    }

    /**
     * Sets agentSchedulesVersion
     * @param int $agentSchedulesVersion Version of agent schedules in the week schedule
     * @return $this
     */
    public function setAgentSchedulesVersion($agentSchedulesVersion)
    {
        $this->container['agentSchedulesVersion'] = $agentSchedulesVersion;

        return $this;
    }

    /**
     * Gets shortTermForecast
     * @return \PureCloudSDK\ShortTermForecastReference
     */
    public function getShortTermForecast()
    {
        return $this->container['shortTermForecast'];
    }

    /**
     * Sets shortTermForecast
     * @param \PureCloudSDK\ShortTermForecastReference $shortTermForecast Reference to optionally point the schedule at a new short term forecast
     * @return $this
     */
    public function setShortTermForecast($shortTermForecast)
    {
        $this->container['shortTermForecast'] = $shortTermForecast;

        return $this;
    }

    /**
     * Gets headcountForecast
     * @return \PureCloudSDK\HeadcountForecast
     */
    public function getHeadcountForecast()
    {
        return $this->container['headcountForecast'];
    }

    /**
     * Sets headcountForecast
     * @param \PureCloudSDK\HeadcountForecast $headcountForecast The headcount forecast associated with the schedule.  If not null, existing values will be irrecoverably replaced
     * @return $this
     */
    public function setHeadcountForecast($headcountForecast)
    {
        $this->container['headcountForecast'] = $headcountForecast;

        return $this;
    }

    /**
     * Gets agentUpdateFilter
     * @return string
     */
    public function getAgentUpdateFilter()
    {
        return $this->container['agentUpdateFilter'];
    }

    /**
     * Sets agentUpdateFilter
     * @param string $agentUpdateFilter For a published schedule, this determines whether a notification will be shown to agents in the default PureCloud user interface.  The CPC notification will always be sent and the value specified here affects what data is returned in the 'updates' property.  In the default PureCloud UI, \"None\" means that agents will not be notified, \"ShiftTimesOnly\" means agents will only be notified for changes to shift start and end times,  and \"All\" means that agents will be notified for any change to a shift or activity (except for full day off activities).  When building a custom client, use this property to specify the level of detail you need. Defaults to \"ShiftTimesOnly\".
     * @return $this
     */
    public function setAgentUpdateFilter($agentUpdateFilter)
    {
        $allowed_values = array('All', 'ShiftTimeChange', 'None');
        if (!in_array($agentUpdateFilter, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'agentUpdateFilter', must be one of 'All', 'ShiftTimeChange', 'None'");
        }
        $this->container['agentUpdateFilter'] = $agentUpdateFilter;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


