<?php

/**
 * WebChatRoutingTarget
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WebChatRoutingTarget Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WebChatRoutingTarget implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WebChatRoutingTarget';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'targetType' => 'string',
        'targetAddress' => 'string',
        'skills' => 'string[]',
        'language' => 'string',
        'priority' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'targetType' => 'targetType',
        'targetAddress' => 'targetAddress',
        'skills' => 'skills',
        'language' => 'language',
        'priority' => 'priority'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'targetType' => 'setTargetType',
        'targetAddress' => 'setTargetAddress',
        'skills' => 'setSkills',
        'language' => 'setLanguage',
        'priority' => 'setPriority'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'targetType' => 'getTargetType',
        'targetAddress' => 'getTargetAddress',
        'skills' => 'getSkills',
        'language' => 'getLanguage',
        'priority' => 'getPriority'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TARGET_TYPE_QUEUE = 'QUEUE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTargetTypeAllowableValues()
    {
        return [
            self::TARGET_TYPE_QUEUE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['targetType'] = isset($data['targetType']) ? $data['targetType'] : null;
        $this->container['targetAddress'] = isset($data['targetAddress']) ? $data['targetAddress'] : null;
        $this->container['skills'] = isset($data['skills']) ? $data['skills'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['targetType'] === null) {
            $invalid_properties[] = "'targetType' can't be null";
        }
        $allowed_values = array("QUEUE");
        if (!in_array($this->container['targetType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'targetType', must be one of #{allowed_values}.";
        }

        if ($this->container['targetAddress'] === null) {
            $invalid_properties[] = "'targetAddress' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['targetType'] === null) {
            return false;
        }
        $allowed_values = array("QUEUE");
        if (!in_array($this->container['targetType'], $allowed_values)) {
            return false;
        }
        if ($this->container['targetAddress'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets targetType
     * @return string
     */
    public function getTargetType()
    {
        return $this->container['targetType'];
    }

    /**
     * Sets targetType
     * @param string $targetType The target type of the routing target, such as 'QUEUE'.
     * @return $this
     */
    public function setTargetType($targetType)
    {
        $allowed_values = array('QUEUE');
        if (!in_array($targetType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'targetType', must be one of 'QUEUE'");
        }
        $this->container['targetType'] = $targetType;

        return $this;
    }

    /**
     * Gets targetAddress
     * @return string
     */
    public function getTargetAddress()
    {
        return $this->container['targetAddress'];
    }

    /**
     * Sets targetAddress
     * @param string $targetAddress The target of the route, in the format appropriate given the 'targetType'.
     * @return $this
     */
    public function setTargetAddress($targetAddress)
    {
        $this->container['targetAddress'] = $targetAddress;

        return $this;
    }

    /**
     * Gets skills
     * @return string[]
     */
    public function getSkills()
    {
        return $this->container['skills'];
    }

    /**
     * Sets skills
     * @param string[] $skills The list of skill names to use for routing.
     * @return $this
     */
    public function setSkills($skills)
    {
        $this->container['skills'] = $skills;

        return $this;
    }

    /**
     * Gets language
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     * @param string $language The language name to use for routing.
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority to assign to the conversation for routing.
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


